/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.api;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.ArrayListMultimap;

/**
 * @title OrgStudentCourseService
 * @desc TODO
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
public interface OrgStudentCourseService {

    /**
     * 获取当前报班
     * 
     * @param studentInfoDtos
     * @param orgId
     * @return
     */
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(
        StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    /**
     * 获取历史报班
     * 
     * @param studentInfoDtos
     * @param orgId
     * @return
     */
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(
        StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    /**
     * 获取学生消费信息
     * 
     * @param studentInfoDtos
     * @param orgId
     * @return
     */
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto,
        Long orgId);
    
    /**
     * 查询学生已报班级数
     * @param po
     * @param orgNumber
     * @return
     */
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber);
    
    /**
     * 分页获取所读班级
     * @param orgId 机构id
     * @param studentId 学员档案id
     * @param page 分页对象
     * @return
     */
    public List<StudentCourseInfoReponseDto> getCurrentClassInfos(Long orgId, Long StudentId, PageDto page);
    
    /**
     * 分页获取报班记录
     * @param orgId 机构id
     * @param studentId 学员档案id
     * @param page 分页对象
     * @return
     */
    public List<StudentCourseInfoReponseDto> getHistoryClassInfos(Long orgId, Long StudentId, PageDto page);
    
    
    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId);
    
    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse);

    /**
     * @param orgStudentCourse
     */
        
    void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse);

    /**
     * 根据课程ID拆分为班课ID和1v1课程ID
     * @param allIds
     * @param oneToOneCourseIds
     * @param classCourseIds
     */
    void splitCourseIdsByType(Collection<Long> allIds,Set<Long> oneToOneCourseIds,Set<Long> classCourseIds);

    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds);
}
