package com.baijia.tianxiao.sal.student.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import com.fasterxml.jackson.databind.ObjectMapper;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@Slf4j
public class JsonUtil {

    public static String write2JsonObject(Object ols) {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter w = new StringWriter();
        try {
            objectMapper.writeValue(w, ols);
        } catch (Exception e) {
            log.error("", e);
        }
        return w.toString();
    }

    @SuppressWarnings("unused")
    public static <T> List<Object> serializeEnumTypes(Class<T> clazz) {
        List<Object> result = new ArrayList<Object>();
        Method[] methods = clazz.getMethods();
        Method mValues = null;
        Method mName = null;
        Method mGetValue = null;

        try {
            mValues = clazz.getMethod("values", (Class<?>[]) null);
            mName = clazz.getMethod("name", (Class<?>[]) null);
            mGetValue = clazz.getMethod("getValue", (Class<?>[]) null);
            @SuppressWarnings("unchecked")
            T[] types = (T[]) mValues.invoke(null, (Object[]) null);
            for (T t : types) {
                Map<String, Object> map = new HashMap<String, Object>();
                map.put("value", mName.invoke(t, (Object[]) null));
                map.put("name", mGetValue.invoke(t, (Object[]) null));
                result.add(map);
            }
        } catch (Exception e) {
            log.warn("JsonUtil.serializeTypes exception");
            return result;
        }
        return result;
    }

    public static List<Map<String, Object>> parseJSON2List(String jsonStr) {
        JSONArray jsonArr = JSONArray.fromObject(jsonStr);
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        @SuppressWarnings("unchecked")
        Iterator<JSONObject> it = jsonArr.iterator();
        while (it.hasNext()) {
            JSONObject json2 = it.next();
            list.add(parseJSON2Map(json2.toString()));
        }
        return list;
    }

    @SuppressWarnings("unchecked")
    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        Map<String, Object> map = new HashMap<String, Object>();
        // 最外层解析
        JSONObject json = JSONObject.fromObject(jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            // 如果内层还是数组的话，继续解析
            if (v instanceof JSONArray) {
                List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                Iterator<JSONObject> it = ((JSONArray) v).iterator();
                while (it.hasNext()) {
                    JSONObject json2 = it.next();
                    list.add(parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
            } else {
                map.put(k.toString(), v);
            }
        }
        return map;
    }

    public static Map<String, Object> jsonToMap(String jsonStr) {
        // 最外层解析
        JSONObject json = JSONObject.fromObject(jsonStr);
        return parserJSONObj(json);

    }

    private static Map<String, Object> parserJSONObj(JSONObject jsonObject) {
        Map<String, Object> map = new HashMap<String, Object>();
        for (Object k : jsonObject.keySet()) {
            Object v = jsonObject.get(k);
            // 如果内层还是数组的话，继续解析
            if (v instanceof JSONArray) {
                map.put(k.toString(), parserJSONArray((JSONArray) v));
            } else if (v instanceof JSONObject) {
                map.put(k.toString(), parserJSONObj((JSONObject) v));
            } else {
                map.put(k.toString(), v.toString());
            }
        }
        return map;
    }

    @SuppressWarnings("unchecked")
    public static List<?> parserJSONArray(JSONArray jsonArray) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Iterator<JSONObject> it = ((JSONArray) jsonArray).iterator();
        while (it.hasNext()) {
            JSONObject json2 = it.next();
            list.add(parseJSON2Map(json2.toString()));
        }
        return list;
    }

    public static List<Map<String, Object>> getListByUrl(String url) {
        try {
            // 通过HTTP获取JSON数据
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return parseJSON2List(sb.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, Object> getMapByUrl(String url) {
        try {
            // 通过HTTP获取JSON数据
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return parseJSON2Map(sb.toString());
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Test
    public void test() throws UnsupportedEncodingException {
        String str =
            "%7B%22type%22%3A0%2C%22content%22%3A%22%5Cu6731%5Cu6731%5Cu5df2%5Cu52a0%5Cu5165%5Cu7fa4%5Cu7ec4%22%7D";
        String str1 = URLDecoder.decode(str, "utf-8");
        System.out.println(str1);
    }

    public static void main(String args[]) {

        // System.out.println("=======");
        // String json = "{'url':'http://test-img.gsxservice.com/377566_lgznsz24.jpeg','width':400,'height':250} ";
        // WebResponse<Object> webResponse = new WebResponse<Object>();
        // webResponse.setData(null);
        // write2JsonResponse(webResponse, null, JsonHeaderType.APPLICATION_JSON);
        // Map map = jsonToMap(json);
        // System.out.println(map.get("url"));
        //
        // int index = json.indexOf("url':");
        // int index2 = json.indexOf("','width", index);
        // String temp = json.substring(index + 6, index2);
        // System.out.println(temp);
        //
        // String str = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
        // System.out.println(str);

        String json = "{'code':0,'date':{'list':[{'id':1,'name':'rezar'},{'id':1,'name':'waba'}]}}";
        Map map = jsonToMap(json);

        System.out.println(map);
    }

}
