/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @title OrgStudentCourseService
 * @desc TODO
 * @author shanyu
 * @date 2015年12月11日
 * @version 1.0
 */
@Slf4j
@Service
public class OrgStudentCourseServiceImpl implements OrgStudentCourseService {
    @Autowired
    private OrgStudentDao orgStudentsDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;

    @Autowired
    private OrgClassLessonDao orgClassLessonDao;

    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired(required = false)
    private CrmStudentQuery crmStudentQuery;

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(
        StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }

       // List<StudentCourseInfoReponseDto> result = Lists.newArrayList();

        List<OrgStudentCourse> courseList =
            this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(),
                StudentCourseStatus.NORMAL.getCode(), null);

        List<StudentClassHour> classHourList = null;
        try {
            classHourList = crmStudentQuery.queryStudentClassHourList(orgStudent.getUserId(), orgId);
        } catch (Exception e) {
            log.error("[Solr] Query exception.", e);
        }

        Map<Long, StudentCourseInfoReponseDto> map = reviseClassHourCount(courseList, classHourList);

        Map<Long, StudentClassHour> studentClassHourMap = new HashMap<>();
        if (classHourList != null) {
            for (StudentClassHour studentClassHour : classHourList) {
                studentClassHourMap.put(studentClassHour.getCourseId(), studentClassHour);
            }
        }
        List<StudentCourseInfoReponseDto> retList = new ArrayList<>();
        for (Map.Entry<Long, StudentCourseInfoReponseDto> entry : map.entrySet()) {
            Long courseId = entry.getKey();
            StudentClassHour sch = studentClassHourMap.get(courseId);
            log.info("find a studentClassHour instance : {} and studentCourseInfoResponseDto is : {} ", sch,
                entry.getValue());
            if (sch != null) {
                if (sch.getTotalCount() > sch.getFinishCount()) {
                    setClassHour(entry.getValue(), sch);
                    retList.add(entry.getValue());
                }
            } else {// 未排课
                retList.add(entry.getValue());
            }
        }
        return retList;
    }

    private Map<Long, StudentCourseInfoReponseDto> reviseClassHourCount(List<OrgStudentCourse> courseList,
        List<StudentClassHour> classHourList) {
        Map<Long, StudentCourseInfoReponseDto> map = new LinkedHashMap<>();
        Map<Long, OrgStudentCourse> studentCourseMap = new HashMap<>();
        if (courseList == null || courseList.size() < 1) {
            return map;
        } else {
            for (OrgStudentCourse course : courseList) {
                studentCourseMap.put(course.getCourseId(), course);
            }
        }

        log.info("find all courseIds is : {} ", studentCourseMap.keySet());

        List<OrgCourse> courses = orgCourseDao.getByIds(studentCourseMap.keySet());
        Set<Long> parentCourseIds = Sets.newHashSet();
        for(OrgCourse orgCourse:courses){
            if(orgCourse.getParentId()>0){
                parentCourseIds.add(orgCourse.getParentId());
            }
        }
        Map<Long,OrgCourse> parentCourseMap = Maps.newHashMap();
        if(parentCourseIds.size()>0){
            parentCourseMap = orgCourseDao.getOrgCourseMap(parentCourseIds);
        }
        
        Set<Long> oneToOneCourseIds = new HashSet<>();
        if (courses != null) {
            for (OrgCourse course : courses) {
                StudentCourseInfoReponseDto dto = StudentCourseInfoReponseDto.getInstance(course);

                if(dto.getParentId()>0){
                    OrgCourse parentCourse = parentCourseMap.get(dto.getParentId());
                    if(parentCourse!=null){
                        dto.setCourseNumber(parentCourse.getNumber());
                    }

                }
                OrgStudentCourse studentCourse = studentCourseMap.get(course.getId());
                dto.setStatus(studentCourse.getStatus());

                // 退班或转班的学生
                if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
                    oneToOneCourseIds.add(course.getId());
                    if (studentCourse.getStatus() == StudentCourseStatus.NORMAL.getCode()) {
                        dto.setTotalClassTimes(studentCourse.getLessonCount());
                        dto.setLeftClassTimes(studentCourse.getLessonCount());
                    } else {
                        log.info("[StudentCourse] studentCourse={}", studentCourse);
                    }
                }
                map.put(course.getId(), dto);
            }
        }
        

        for (StudentClassHour classHour : classHourList) {
            log.info("[StudentCourse] oneToOneCourseIds={},classHourCourseId={},keySet={}", oneToOneCourseIds,
                classHour.getCourseId(),studentCourseMap.keySet());
            OrgStudentCourse studentCourse = studentCourseMap.get(classHour.getCourseId());
            log.info("[StudentCourse] studentCourse={},courseId={}",studentCourse,classHour.getCourseId());
            if (oneToOneCourseIds.contains(classHour.getCourseId())) {
                if (studentCourse != null) {
                    classHour.setTotalCount(Math.max(studentCourse.getLessonCount(), classHour.getTotalCount()));
                }
            }
            if (studentCourse!=null && studentCourse.getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                classHour.setTotalCount(classHour.getFinishCount());
                log.info("[StudentCourse] studentCourse={}", classHour);
            }
        }
        return map;
    }

    public static void main(String[] args) {
        Set<Long> oneToOneCourseIds = new HashSet<>();
        Long a = new Long(100000);
        oneToOneCourseIds.add(a);

        System.out.println(oneToOneCourseIds.contains(100000l));

    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(
        StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }

        List<OrgStudentCourse> courseList =
            this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), null, null);

        List<StudentClassHour> classHourList = null;
        try {
            classHourList = crmStudentQuery.queryStudentClassHourList(orgStudent.getUserId(), orgId);
        } catch (Exception e) {
            log.error("[Solr] Query exception.", e);
        }

        Map<Long, StudentCourseInfoReponseDto> map = reviseClassHourCount(courseList, classHourList);

        Map<Long, StudentClassHour> studentClassHourMap = new HashMap<>();
        if (classHourList != null) {
            for (StudentClassHour studentClassHour : classHourList) {
                studentClassHourMap.put(studentClassHour.getCourseId(), studentClassHour);
            }
        }
        List<StudentCourseInfoReponseDto> retList = new ArrayList<>();
        for (Map.Entry<Long, StudentCourseInfoReponseDto> entry : map.entrySet()) {
            Long courseId = entry.getKey();
            StudentClassHour sch = studentClassHourMap.get(courseId);
            log.info("find a studentClassHour instance : {} and studentCourseInfoResponseDto is : {} ", sch,
                entry.getValue());
            if (sch != null) {
                if ((sch.getLeftCount() <= 0 && sch.getFinishCount() != 0)
                    || entry.getValue().getStatus() != StudentCourseStatus.NORMAL.getCode()) {
                    setClassHour(entry.getValue(), sch);
                    retList.add(entry.getValue());
                }
            } else if (entry.getValue().getStatus() != StudentCourseStatus.NORMAL.getCode()) {// 转班或退班
                retList.add(entry.getValue());
            }
        }
        map.clear();
        return retList;
    }

    private StudentCourseInfoReponseDto setClassHour(StudentCourseInfoReponseDto dto, StudentClassHour classHour) {
        dto.setFinishClassTimes(classHour.getFinishCount());
        dto.setTotalClassTimes(classHour.getTotalCount());
        dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
        dto.setCourseType(CourseType.ORG_COURSE.getCode());
        return dto;
    }

    @Override
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto,
        Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        return getStudentSignupInfos(orgStudent, account.getNumber().longValue());
    }

    /**
     * 查询学生已报班级数
     */
    @Override
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> result = this.getCourseInfoes(po, orgNumber);

        return (result != null && !result.isEmpty()) ? result.size() : 0;
    }

    /**
     * 获取学员课次信息（3810课程）
     *
     * @param po
     * @param orgNumber
     * @return
     */
    private List<StudentCourseInfoReponseDto> getCourseInfoes(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> courseDtos = Lists.newArrayList();
        List<OrgSignupInfo> cashpurchase =
            this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, PayStatus.SUCESS.getCode(),
                "totalPrices", "signupPurchaseId"); // 报名订单

        List<CoursePurchase> mPurchase =
            this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), 0l,
                CourseType.ORG_COURSE.getCode(), PayStatus.SUCESS.getCode());// m站订单

        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> purchaseIds = Sets.newHashSet(); // 报名订单编号
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        List<OrgSignupCourse> sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map<Long, String> nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
        // 机构课程总课时
        Map<Long, Integer> lessonTimeMap =
            this.orgClassLessonDao.getLessonTimemap(courseIds, null, po.getOrgId(), DeleteStatus.NORMAL.getValue());

        // 机构课程已上课次
        Map<Long, Integer> finishLessonTimeMap =
            this.orgClassLessonDao.getLessonTimemap(courseIds, new Date(), po.getOrgId(),
                DeleteStatus.NORMAL.getValue());
        for (OrgSignupCourse purchase : sinupCourses) {
            StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getOrgCourseId());
            dto.setCourseNumber(purchase.getOrgCourseNumber().longValue());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName(nameMap.get(purchase.getOrgCourseId()));
            if (lessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setTotalClassTimes(lessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setFinishClassTimes(finishLessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }

        for (CoursePurchase purchase : mPurchase) {
            StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getCourseId());
            dto.setCourseNumber(purchase.getCourseNumber().longValue());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName(nameMap.get(purchase.getCourseId()));
            if (lessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setTotalClassTimes(lessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setFinishClassTimes(finishLessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        log.debug("course list={}", courseDtos);
        return courseDtos;
    }

    /**
     * 获取学员报名课程信息（3810课程）
     *
     * @param po
     * @param orgNumber
     * @return
     */
    private List<OrgStudentPurchaseReponseDto> getStudentSignupInfos(OrgStudent po, Long orgNumber) {
        List<OrgStudentPurchaseReponseDto> courseDtos = Lists.newArrayList();
        List<OrgSignupInfo> cashpurchase =
            this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null, PayStatus.SUCESS.getCode(),
                "totalPrices", "signupPurchaseId"); // 报名订单
        List<CoursePurchase> mPurchase =
            this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), 0l,
                CourseType.ORG_COURSE.getCode(), PayStatus.SUCESS.getCode());// m站订单

        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> purchaseIds = Sets.newHashSet(); // 报名订单编号
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map<Long, String> nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
        if (CollectionUtils.isNotEmpty(purchaseIds)) {
            List<OrgSignupCourse> sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
            for (OrgSignupCourse purchase : sinupCourses) {
                OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
                dto.setCourseNumber(purchase.getOrgCourseNumber().longValue());
                dto.setCourseName(nameMap.get(purchase.getOrgCourseId()));
                dto.setPayMoney(purchase.getPayPrice().doubleValue() / 100);
                courseDtos.add(dto);
            }
        }
        for (CoursePurchase purchase : mPurchase) {
            OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
            dto.setCourseNumber(purchase.getCourseNumber().longValue());
            dto.setCourseName(nameMap.get(purchase.getCourseId()));
            dto.setPayMoney(purchase.getPayMoney().doubleValue());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryClassInfos(Long orgId, Long StudentId, PageDto page) {
        return null;
    }

    @Override
    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId) {

        return orgStudentCourseDao.getStudentCourse(orgId, courseId, studentId);

    }

    @Override
    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        orgStudentCourseDao.save(orgStudentCourse);
    }

    @Override
    public void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        orgStudentCourseDao.update(orgStudentCourse);
    }

    @Override
    public void splitCourseIdsByType(Collection<Long> allIds, Set<Long> oneToOneCourseIds, Set<Long> classCourseIds) {
        List<OrgCourse> courseList = orgCourseDao.getByIds(allIds, "courseType", "id");
        for (OrgCourse course : courseList) {
            if (CourseTypeEnum.isOneToOne(course.getCourseType())) {
                oneToOneCourseIds.add(course.getId());
            } else {
                classCourseIds.add(course.getId());
            }
        }
    }

    @Override
    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds) {
        ArrayListMultimap<Long, Long> data = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty(classIds)) {
            List<OrgStudentCourse> orgStudentCourses = orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId, classIds);
            if (CollectionUtils.isNotEmpty(orgStudentCourses)) {
                for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
                    data.put(orgStudentCourse.getCourseId(), orgStudentCourse.getUserId());
                }
            }
        }
        return data;
    }
}
