
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */

public enum SexEnum {

    BOY(0, "男"), 
    GIRL(1, "女");

    public Integer id;
    public String label;

    private SexEnum(Integer id, String label) {
        this.id = id;
        this.label = label;
    }

    public static final Map<Integer,SexEnum> keyMap = Maps.newHashMap();
    public static final Map<String,SexEnum> enumMap = Maps.newHashMap();
    

    static {
        for (SexEnum sexEnum : SexEnum.values()) {
            keyMap.put(sexEnum.id, sexEnum);
            enumMap.put(sexEnum.label, sexEnum);
        }
    }
    
    public static SexEnum getSexWithId(Integer id ){
        return keyMap.get(id);
    }
    
    public static SexEnum getSexWithLabel(String label){
        return enumMap.get(label);
    }

    public Integer getId() {
        return id;
    }

    public String getLabel() {
        return label;
    }
}
