/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年8月4日
 * @desc
 */
public enum DateTypeEnum {
    NULL(0, "基本信息"), 
    DAY_0(1, "当天日期"),
    DAY_7(2, "7天以后日期");
    
    private Integer type;
    private String desc;
    
    private DateTypeEnum(Integer type, String desc){
        this.type=type;
        this.desc = desc;
    }
    
    private static Map<Integer, DateTypeEnum> map = new HashMap<>();
    
    static{
        for(DateTypeEnum typeEnum : DateTypeEnum.values()){
            map.put(typeEnum.getType(), typeEnum);
        }
    }
    public static DateTypeEnum getDateTypeEnum(Integer type){
        return map.get(type);
    }
    
    public  Integer getType(){
        return type;
    }
    
    public String getDesc(){
        return desc;
    }
    
}
