/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.request;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

import com.google.common.collect.Lists;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @title StudentListRequestDto
 * @desc TODO
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */
@Data
@Slf4j
public class StudentListRequestDto implements Serializable {

    private static final long serialVersionUID = 547521844640451760L;

    private Long courseNumber;
    @ExcludeCheck
    private Integer courseType;

    private String searchKey;

    @ExcludeCheck
    private Integer studentStatus;
    @ExcludeCheck
    private String initial;

    private Integer opType;// 最近操作类型: 1：最近7天需要跟进，2：最近7天报班，3：最近7天创建的

    private Integer isSchedule;// 是否已排课 1:已排课，2：未排课

    private Integer leftMinClassHour;// 剩余最小课时

    private Integer leftMaxClassHour;// 剩余最大课时

    private Integer followDate;// 跟进日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer createDate;// 创建日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer enrollDate;// 报班日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    @ExcludeCheck
    private Integer pageNum = 1;

    @ExcludeCheck
    private Integer pageSize = 20;

    private Integer sex;// 性别

    private String queryStr;

    private String queryValue;

    @ExcludeCheck
    private Integer cascadeId;

    // 排序规则,默认升序0:升序,1:降序
    @ExcludeCheck
    private Integer orderType = 0;
    // 排序字段
    private String orderName;

    @ExcludeCheck
    private boolean needAvatar = true; // 展示数据是否需要头像
    @ExcludeCheck
    private boolean needClassInfo = true;// 展示是否需要学员课消数据(针对APP端学员列表展示),老接口需要

    private static List<PropertyDescriptor> fieldReaders = Lists.newArrayList();
    static {
        List<String> fields = Lists.newArrayList();
        Field[] declaredFields = StudentListRequestDto.class.getDeclaredFields();
        for (Field field : declaredFields) {
            if (field.isAnnotationPresent(ExcludeCheck.class)) {
                continue;
            }
            fields.add(field.getName());
        }
        try {
            PropertyDescriptor[] propertys =
                Introspector.getBeanInfo(StudentListRequestDto.class).getPropertyDescriptors();
            for (PropertyDescriptor pd : propertys) {
                String name = pd.getName();
                if (fields.contains(name)) {
                    fieldReaders.add(pd);
                }
            }
        } catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    public void setSex(Integer sex) {
        if (sex == null) {
            return;
        }
        this.sex = (sex - 1); // Infos:APP参数传递的时候,将性别 man -->1(实际数据库存储的为0) ,women --->2(实际数据库为1),该转变过程不规范，调用接口请注意
    }

    public static final Object[] EMPTY_ARGUS = new Object[] {};

    public boolean needFilter() {
        for (PropertyDescriptor pd : fieldReaders) {
            try {
                Object value = pd.getReadMethod().invoke(this, EMPTY_ARGUS);
                log.info("name :  {} and fieldVlaue : {} ", pd.getName(), value);
                if (value != null) {
                    return true;
                }
            } catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void main(String[] args) {
        fieldReaders.size();
        for (PropertyDescriptor pd : fieldReaders) {
            System.out.println(pd.getName());
        }

        StudentListRequestDto sl = new StudentListRequestDto();
        // sl.setLeftMaxClassHour(3);
        // sl.setLeftMinClassHour(0);
        boolean needFilter = sl.needFilter();
        System.out.println(needFilter);

    }
}
