
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import org.springframework.stereotype.Component;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Component
public class SingleChoiceFieldType extends AbstractCustomFieldType<SingleChoiceFieldType> {

    private Integer id;
    private String value;

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#objToJson(java.lang.Object)
     */

    @Override
    public String objToJson(SingleChoiceFieldType obj) {
        return super.toJson(obj);

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#jsonToObj(java.lang.String)
     */

    @Override
    public SingleChoiceFieldType jsonToObj(String json) {
        SingleChoiceFieldType type = super.fromJson(json);
        return type;

    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#matchFieldType()
     */

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.SINGLE_CHOICE;

    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<SingleChoiceFieldType> instance() {
        return new SingleChoiceFieldType();
    }
    
    public SingleChoiceFieldType(Integer id, String value){
        this.id = id ;
        this.value = value;
    }
    
    public SingleChoiceFieldType(){
        
    }

}
