
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import org.springframework.stereotype.Component;

import lombok.Getter;
import lombok.Setter;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Component
public class IntegerFieldType extends AbstractCustomFieldType<IntegerFieldType> {

    @Getter
    @Setter
    private Long content;

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#objToJson(java.lang.Object)
     */

    @Override
    public String objToJson(IntegerFieldType obj) {
        return super.toJson(obj);
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#jsonToObj(java.lang.String)
     */

    @Override
    public IntegerFieldType jsonToObj(String json) {
        return super.fromJson(json);
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#matchFieldType()
     */

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.INTEGER;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<IntegerFieldType> instance() {
        return new IntegerFieldType();
            
    }

}
