/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.DateTypeEnum;
import com.baijia.tianxiao.util.GenericsUtils;

import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author gaodan
 * @createdate 2016年8月4日
 * @desc
 */
@Data
@Slf4j
public class FieldTypeContentFactory {
    public static CustomFieldTypeInterface getContent(CustomField customField, List<TXCustomOption> customOptions){
        log.info("CustomField Type = {}, customField {}", customField.getType(), customField);
        CustomFieldType fieldType = CustomFieldType.getCustomFieldType(customField.getType());
        switch (fieldType){
            case TEXT:
                TextCustomFieldType textCustomFieldType = new TextCustomFieldType();
                textCustomFieldType.setContent(customField.getDefaultValue());
                return textCustomFieldType;
            case SINGLE_CHOICE:
                SingleChoiceFieldType singleChoiceFieldType = null;
                if(GenericsUtils.notNullAndEmpty(customOptions)){
                    singleChoiceFieldType = new SingleChoiceFieldType();
                    TXCustomOption option = customOptions.get(0);
                    singleChoiceFieldType.setId(option.getId().intValue());
                    singleChoiceFieldType.setValue(option.getLabel());
                }
                return singleChoiceFieldType;
            case MULTI_CHOICE:
                MultiChoiceFieldTypeWrapper multiChoice = null;
                if(GenericsUtils.notNullAndEmpty(customOptions)){
                    multiChoice = new MultiChoiceFieldTypeWrapper();
                    List<MultiChoiceFieldType> options = new ArrayList<>();
                    for(TXCustomOption option : customOptions){
                        MultiChoiceFieldType fieldOption =  new MultiChoiceFieldType();
                        fieldOption.setId(option.getId());
                        fieldOption.setValue(option.getLabel());
                        log.info("multiChoice param:{}, fieldOption param:{}", multiChoice, fieldOption);
                        options.add(fieldOption);
                    }
                    multiChoice.setOptions(options);
                }
                return multiChoice;
            case DAY_DATE:
                DateFieldType dateType = null;
                if(StringUtils.isNotBlank(customField.getDefaultValue())){
                    dateType= new DateFieldType();
                    Integer type = Integer.parseInt(customField.getDefaultValue());
                    DateTypeEnum dateTypeEnum = DateTypeEnum.getDateTypeEnum(type);
                    dateType.setContent(getDateTime(dateTypeEnum, CustomFieldType.DAY_DATE));
                }
                return dateType;
            case DAY_TIME_DATE:
                DateTimeFieldType dateTimeType = null;
                if(StringUtils.isNotBlank(customField.getDefaultValue())){
                    dateTimeType= new DateTimeFieldType();
                    Integer type = Integer.parseInt(customField.getDefaultValue());
                    log.info("[Custom] dateType:{}", customField.getDefaultValue());
                    DateTypeEnum dateTypeEnum = DateTypeEnum.getDateTypeEnum(type);
                    dateTimeType.setContent(getDateTime(dateTypeEnum, CustomFieldType.DAY_TIME_DATE));
                }
                return dateTimeType;
            case INTEGER:
                IntegerFieldType integerType = null;
                if(StringUtils.isNotBlank(customField.getDefaultValue())){
                    integerType = new IntegerFieldType();
                    integerType.setContent(Long.parseLong(customField.getDefaultValue()));
                }
                return integerType;
            case FLOAT:
                FloatFieldType floatFieldTyep = null;
                if(StringUtils.isNotBlank(customField.getDefaultValue())){
                    floatFieldTyep = new FloatFieldType();
                    floatFieldTyep.setContent(Float.parseFloat(customField.getDefaultValue()));
                }
                return floatFieldTyep;
        }
        return null;
        
    }
    
    private static Long getDateTime(DateTypeEnum dateTypeEnum, CustomFieldType fieldType){
        SimpleDateFormat format =  new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if(fieldType == CustomFieldType.DAY_DATE){
            format = new SimpleDateFormat("yyyy-MM-dd");
        }
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        switch (dateTypeEnum) {
            case NULL:
                return null;
            case DAY_0:
                return date.getTime();
            case DAY_7: 
                c.add(Calendar.DAY_OF_MONTH, 7);
                date = c.getTime();
                return date.getTime();
        }
        return null;
    }
    
}
