/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.api.customFields;

import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sal.student.dto.customFieldValues.OrgUserBaseInfo;

/**
 * @author gaodan
 * @createdate 2016年7月29日
 * @desc
 */
public interface CustomFieldValueService {
    /**
     * 
     * @param orgUserBaseInfo
     * @param orgId
     * @param isStudent
     * @param studentIdOrConsultId 学员是传studentId, 线索传consutlId
     */
    public void setCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long orgId, boolean isStudent, Long studentIdOrConsultId);
    
    /**
     * 保存自定义字段
     * 返回参数为 首次添加学员时，保存自定义字段id list
     */
    public List<Long> saveOrUpdateCustomFieldValues(OrgUserBaseInfo orgUserBaseInfo, Long studentIdOrConsultId, Long orgId);

    
    /**
     * @Description  : 返回所有‘自定义字段’ 及其赋值
     * @Author       : zhenyujian
     * @Date         : 2016年8月4日 下午2:04:15 
     *
     * @Return       : Map<Long,CustomFieldValue>
     */
    public Map<Long, CustomFieldValue> mapFieldValues(Long orgId, boolean isStudent, Long studentIdOrConsultId);
    
    
    /**
     * @Description  : 为指定 consultId 的数据 批量赋值studentId
     * @Author       : zhenyujian
     * @Date         : 2016年8月6日 上午10:39:56 
     *
     * @Return       : void
     */
    public void updateStudentId(Long orgId, Long consultId, Long studentId);

    /**
     * @param orgStudentInfo
     * @param orgId
     * @param b
     * @param studentId
     * @param systemOnly
     */
        
    public void setCustomFieldValues(OrgUserBaseInfo orgStudentInfo, Long orgId, boolean b, Long studentId,
        boolean systemOnly);
}
