/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgStudentLessonCounter;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.redis.AbstractBaseRedisDao;
import com.baijia.tianxiao.sal.student.api.StudentLessonService;
import com.baijia.tianxiao.sal.student.enums.LessonStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StudentLessonServiceImpl
extends AbstractBaseRedisDao<String, Object>
implements StudentLessonService {
    private static final Logger log = LoggerFactory.getLogger(StudentLessonServiceImpl.class);
    private static final int PAGE_SIZE = 1000;
    private static final int UPDATE_TIME_TYPE = 1;
    private static final int START_TIME_TYPE = 2;
    private static final String TX_ORG_STU_LESSON_UPDATE_HSET = "#tx_org_stu_lesson_update_hset";
    @Autowired
    private OrgStudentDao studentDao;
    @Autowired
    private OrgClassLessonDao classLessonDao;
    @Autowired
    private OrgStudentLessonDao studentLessonDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private CrmStudentQuery studentQuery;
    @Autowired
    private OrgSubAccountDao subAccountDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    private static final Semaphore updateTimeStuLessonStatusSemaphore = new Semaphore(1);
    private static final Semaphore startTimeStuLessonStatusSemaphore = new Semaphore(1);
    private static final Semaphore updateSolrSemaphore = new Semaphore(1);
    private static final BigDecimal TO_CHARGE_VALUE = new BigDecimal("0.2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void syncClassLessonStatus(int beforeMinutes, int type) {
        log.info("[ClassLessonStatus] Start===============");
        long begin = System.currentTimeMillis();
        if (type == 1) {
            boolean isUpdateTimeAllowed = updateTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isUpdateTimeAllowed) {
                log.info("[StudentLesson] Other thread is execute.");
                return;
            }
        } else {
            boolean isStartTimeAllowed = startTimeStuLessonStatusSemaphore.tryAcquire();
            if (!isStartTimeAllowed) {
                log.info("[StudentLesson] Other thread is execute.");
                return;
            }
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.add(12, -1 * beforeMinutes);
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(1000));
            Date now = new Date();
            List lessons = null;
            lessons = type == 1 ? this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto) : this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            while (lessons != null && lessons.size() > 0) {
                log.info("[ClassLessonStatus]Executing===============");
                this.updateClassLessonStatus(lessons);
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                if (type == 1) {
                    lessons = this.classLessonDao.getOrgClassLessonsByUpdateTime(calendar.getTime(), now, pageDto);
                    continue;
                }
                lessons = this.classLessonDao.getOrgClassLessonsByStartTime(calendar.getTime(), now, pageDto);
            }
        }
        finally {
            if (type == 1) {
                updateTimeStuLessonStatusSemaphore.release();
            } else {
                startTimeStuLessonStatusSemaphore.release();
            }
        }
        log.info("[ClassLessonStatus] cost={}", (Object)(System.currentTimeMillis() - begin));
    }

    private void updateClassLessonStatus(List<OrgClassLesson> lessons) {
        Date now = new Date();
        HashSet<Long> unStartIds = new HashSet<Long>();
        HashSet<Long> finishedIds = new HashSet<Long>();
        for (OrgClassLesson lesson : lessons) {
            if (lesson.getStartTime().compareTo(now) <= 0) {
                finishedIds.add(lesson.getId());
                continue;
            }
            unStartIds.add(lesson.getId());
        }
        if (unStartIds.size() > 0) {
            this.studentLessonDao.batchUpdateStatus(unStartIds, LessonStatus.UN_START.getStatus());
        }
        if (finishedIds.size() > 0) {
            this.studentLessonDao.batchUpdateStatus(finishedIds, LessonStatus.FINISHED.getStatus());
        }
    }

    @Override
    @Transactional
    public void syncStudentStatus(long orgId) {
        log.info("[SyncStudentStatus] Start===============");
        long begin = System.currentTimeMillis();
        PageDto pageDto = new PageDto();
        pageDto.setPageSize(Integer.valueOf(1000));
        List list = this.studentLessonDao.getStudentLessonCounterList(orgId, pageDto);
        if (list == null || list.size() < 1) {
            this.studentDao.updateStudentStatusByOrgId(Long.valueOf(orgId), StudentLessonStatus.STUDYING.getStatus());
        }
        Long lastId = null;
        StudentLessonCount lastStuLessonCount = null;
        boolean isToCharge = false;
        while (list.size() > 0) {
            StudentLessonCount count;
            log.info("[StudentLesson] sync data size={},orgId={}", (Object)list.size(), (Object)orgId);
            HashSet<Long> toChargeIds = new HashSet<Long>();
            HashSet<Long> pastIds = new HashSet<Long>();
            HashSet<Long> unLessonIds = new HashSet<Long>();
            Set<Object> studyingIds = new HashSet();
            HashMap<Long, StudentLessonCount> countMap = new HashMap<Long, StudentLessonCount>();
            if (lastId != null) {
                countMap.put(lastId, lastStuLessonCount);
            }
            isToCharge = false;
            for (OrgStudentLessonCounter counter : list) {
                count = (StudentLessonCount)countMap.get(counter.getUserId());
                if (count == null) {
                    count = new StudentLessonCount();
                    countMap.put(counter.getUserId(), count);
                }
                count.add(counter);
                if (counter.getLeftCount() > 0L && counter.getLeftCountRatio().compareTo(TO_CHARGE_VALUE) < 0) {
                    toChargeIds.add(counter.getUserId());
                    isToCharge = true;
                }
                lastId = counter.getUserId();
                lastStuLessonCount = count;
            }
            toChargeIds.remove(lastId);
            countMap.remove(lastId);
            for (Long uerId : countMap.keySet()) {
                count = (StudentLessonCount)countMap.get(uerId);
                if (count.getFinish() != count.getTotal() || count.getTotal() <= 0) continue;
                pastIds.add(uerId);
            }
            studyingIds = countMap.keySet();
            Map<Long, List<Long>> stuLessonMap = this.getStuCourseId(pastIds, orgId);
            log.info("[StudentLesson] pass studentId enroll map={}", stuLessonMap);
            for (Long uerId : pastIds) {
                List courses;
                Set<Long> lessonCourseIds = ((StudentLessonCount)countMap.get(uerId)).getCourseIds();
                List<Long> enrollCourseId = stuLessonMap.get(uerId);
                if (enrollCourseId == null) {
                    log.warn("[StudentLesson] uerId {} no enroll record", (Object)uerId);
                    continue;
                }
                enrollCourseId.removeAll(lessonCourseIds);
                if (enrollCourseId.size() <= 0 || (courses = this.orgCourseDao.getNormalCourseList(enrollCourseId, new String[0])) == null || courses.size() <= 0) continue;
                unLessonIds.add(uerId);
            }
            pastIds.removeAll(unLessonIds);
            studyingIds.removeAll(pastIds);
            studyingIds.removeAll(toChargeIds);
            log.info("[StudentLesson] toChargeIds={},pastIds={},studyingIds={},lastId={}", new Object[]{toChargeIds, pastIds, studyingIds, lastId});
            if (toChargeIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(toChargeIds, StudentLessonStatus.TO_CHARGE.getStatus());
            }
            if (pastIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(pastIds, StudentLessonStatus.PAST.getStatus());
            }
            if (studyingIds.size() > 0) {
                this.studentDao.batchUpdateStudentStatus(studyingIds, StudentLessonStatus.STUDYING.getStatus());
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            list = this.studentLessonDao.getStudentLessonCounterList(orgId, pageDto);
        }
        if (lastId != null) {
            StudentLessonStatus status = null;
            if (isToCharge) {
                status = StudentLessonStatus.TO_CHARGE;
            } else if (lastStuLessonCount.getTotal() == lastStuLessonCount.getFinish()) {
                List courseIds = this.orgStudentCourseDao.getStudentCourseIds(Long.valueOf(orgId), lastId, null);
                courseIds.removeAll(lastStuLessonCount.getCourseIds());
                status = courseIds.size() == 0 ? StudentLessonStatus.PAST : StudentLessonStatus.STUDYING;
            } else {
                status = StudentLessonStatus.STUDYING;
            }
            this.studentDao.batchUpdateStudentStatus(Arrays.asList(lastId), status.getStatus());
        }
        log.info("[ClassLessonStatus] Org({}) Update finished.cost={}", (Object)orgId, (Object)(System.currentTimeMillis() - begin));
    }

    private Map<Long, List<Long>> getStuCourseId(Collection<Long> stuIds, Long orgId) {
        if (stuIds == null || stuIds.size() < 1) {
            return Collections.EMPTY_MAP;
        }
        return this.orgStudentCourseDao.getCourseIdMapByStuIds(stuIds, orgId);
    }

    @Override
    public List<Integer> getAllTxOrgIds() {
        List accounts = this.subAccountDao.getAll(new String[]{"orgId"});
        List list = ListUtil.toKeyList((Collection)accounts, (String)"orgId", OrgSubAccount.class);
        return list;
    }

    public void setUpdateTime(final String updateTime) {
        this.redisTemplate.execute((RedisCallback)new RedisCallback<Integer>(){

            public Integer doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentLessonServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)StudentLessonServiceImpl.TX_ORG_STU_LESSON_UPDATE_HSET);
                byte[] value = serializer.serialize((Object)updateTime);
                connection.set(keyBytes, value);
                log.info("[Redis] Set student lesson updateTime={}", (Object)updateTime);
                return null;
            }
        });
    }

    public Date getUpdateTime() {
        String dateStr = (String)this.redisTemplate.execute((RedisCallback)new RedisCallback<String>(){

            public String doInRedis(RedisConnection connection) throws DataAccessException {
                connection.select(6);
                RedisSerializer serializer = StudentLessonServiceImpl.this.getRedisSerializer();
                byte[] keyBytes = serializer.serialize((Object)StudentLessonServiceImpl.TX_ORG_STU_LESSON_UPDATE_HSET);
                byte[] value = connection.get(keyBytes);
                String updateTime = (String)serializer.deserialize(value);
                log.info("[Redis] Get student lesson updateTime={}", (Object)updateTime);
                return updateTime;
            }
        });
        if (StringUtils.isNotBlank((String)dateStr)) {
            return new Date(Long.parseLong(dateStr));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateStudentLesson() {
        boolean isAllowed = updateSolrSemaphore.tryAcquire();
        if (!isAllowed) {
            log.info("[Solr] Other thread is execute.");
            return;
        }
        try {
            Date date = this.getUpdateTime();
            long currentTime = new Date().getTime();
            if (date == null) {
                Calendar calendar = Calendar.getInstance();
                calendar.add(12, -30);
                date = calendar.getTime();
            }
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(100));
            List studentLessons = this.studentLessonDao.getStudentLessonsByPage(date, pageDto);
            while (studentLessons != null && studentLessons.size() > 0) {
                HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
                for (OrgStudentLesson lesson : studentLessons) {
                    ArrayList<Long> userIds = (ArrayList<Long>)map.get(lesson.getLessonId());
                    if (userIds == null) {
                        userIds = new ArrayList<Long>();
                        map.put(lesson.getLessonId(), userIds);
                    }
                    userIds.add(lesson.getUserId());
                }
                log.info("[Solr] update lesson and userId={}", map);
                List classLessons = this.classLessonDao.getByIds(map.keySet(), new String[0]);
                if (classLessons != null) {
                    for (OrgClassLesson classLesson : classLessons) {
                        List userIds = (List)map.get(classLesson.getId());
                        if (userIds == null || userIds.size() <= 0) continue;
                        for (Long userId : userIds) {
                            OrgStudentLessonCounter counter = this.studentLessonDao.getStudentLessonCounter(classLesson.getOrgId().longValue(), userId.longValue(), classLesson.getCourseId().longValue());
                            if (counter == null) continue;
                            try {
                                this.studentQuery.add("crm_students", this.toMap(counter));
                            }
                            catch (SolrServerException e) {
                                log.error("[Solr] SolrServerException", (Throwable)e);
                            }
                            catch (IOException e) {
                                log.error("[Solr] IOException", (Throwable)e);
                            }
                        }
                    }
                }
                pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
                studentLessons = this.studentLessonDao.getStudentLessonsByPage(date, pageDto);
            }
            this.setUpdateTime(String.valueOf(currentTime));
        }
        finally {
            updateSolrSemaphore.release();
        }
    }

    private Map<String, Object> toMap(OrgStudentLessonCounter counter) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", counter.getId());
        map.put("org_id", counter.getOrgId());
        map.put("student_id", counter.getUserId());
        map.put("course_id", counter.getCourseId());
        map.put("total", counter.getTotalCount());
        map.put("finished", counter.getFinishedCount());
        map.put("left_count", counter.getLeftCount());
        return map;
    }

    private class StudentLessonCount {
        private int finish = 0;
        private int total = 0;
        private Set<Long> courseIds = new HashSet<Long>();

        public void add(OrgStudentLessonCounter counter) {
            this.finish = (int)((long)this.finish + counter.getFinishedCount());
            this.total = (int)((long)this.total + counter.getTotalCount());
            this.courseIds.add(counter.getCourseId());
        }

        public int getFinish() {
            return this.finish;
        }

        public int getTotal() {
            return this.total;
        }

        public Set<Long> getCourseIds() {
            return this.courseIds;
        }

        public void setFinish(int finish) {
            this.finish = finish;
        }

        public void setTotal(int total) {
            this.total = total;
        }

        public void setCourseIds(Set<Long> courseIds) {
            this.courseIds = courseIds;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StudentLessonCount)) {
                return false;
            }
            StudentLessonCount other = (StudentLessonCount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFinish() != other.getFinish()) {
                return false;
            }
            if (this.getTotal() != other.getTotal()) {
                return false;
            }
            Set<Long> this$courseIds = this.getCourseIds();
            Set<Long> other$courseIds = other.getCourseIds();
            return !(this$courseIds == null ? other$courseIds != null : !((Object)this$courseIds).equals(other$courseIds));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StudentLessonCount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFinish();
            result = result * 59 + this.getTotal();
            Set<Long> $courseIds = this.getCourseIds();
            result = result * 59 + ($courseIds == null ? 43 : ((Object)$courseIds).hashCode());
            return result;
        }

        public String toString() {
            return "StudentLessonServiceImpl.StudentLessonCount(finish=" + this.getFinish() + ", total=" + this.getTotal() + ", courseIds=" + this.getCourseIds() + ")";
        }
    }
}

