/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.dto.customFieldValues;

import com.baijia.tianxiao.sal.organization.org.dto.addressbook.TXAddressBookDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldSection;
import com.baijia.tianxiao.sal.student.enums.CustomFieldSections;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年7月28日
 * @desc 线索和学员基本信息
 */
@Data
public class OrgUserBaseInfo {
    
    private String name;     //姓名
    
    private String mobile;    //手机
    
    private String parentName;    //父母姓名
   
    private String parentMobile;    //父母手机号
    
    private Long nextRemindTime;    //下次提醒时间
    
    private Integer sex;    //性别
    
    private String school;     //学校
    
    private String qq;     //qq
    
    private String mail;     //邮箱
    
    private Long birthday;     //生日
    
    private String address;    //地址
    
    private String degreeClass;   //班级
    
    private String fatherOccupation;     //父职业
    
    private String matherOccupation;    //母职业
    
    private Integer origin;       // 学生来源0=跟谁学,1=非跟谁学
    
    private Double latitude;  //纬度
    
    private Double longitude;  //经度
    
    private Long areaId;  //地域id
    
    private Boolean isStudent; // 默认是作为学员数据处理的，设置为false 作为线索
    
    private static final long serialVersionUID = 1L;
    
    private String avatarUrl; //头像
    
    private Long storageId;  //头像id
    
    private Integer relationship;   //亲属关系
    
    private List<TagInfoDto> tagsResp; //json格式tagsStr

    private String addressDetail;//地址
    
    /**
     * 微信
     */
    private String weixin;
    
    private List<CustomFieldSection> sections;
    private List<CustomFieldDto> fields = new ArrayList<>();

    public void initSections() {
        List<CustomFieldSection> listAllSections = CustomFieldSections.listAllSections();
        this.sections = listAllSections;
    }
    
    public void setIsStudent(boolean isStudent){
        this.isStudent = isStudent;
    }

}
