package com.baijia.tianxiao.sal.student.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.lang3.StringUtils;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import lombok.Data;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 03/08/2017 1:53 PM
 */
@Data
public class TxCustomRecordDto {
    private Long templateId;
    private String name;
    private Integer sort;
    private Integer type;
    private List<RecordField> fields;

    @Data
    public static class RecordField {
        private Long keyId;
        private String keyName;
        private Integer sort;
        private Integer disable;// boolean
        private Long valueId;
        private String value;

        @JsonIgnore
        public boolean isRequestValid() {
            return null != keyId && StringUtils.isNotBlank(value);
        }
    }

    public void sort() {
        Collections.sort(fields, Comparator.comparingInt(RecordField::getSort));
    }
}
