/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseListResponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.collect.ArrayListMultimap;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgStudentCourseService
 * @desc TODO
 * @date 2015年12月4日
 */
public interface OrgStudentCourseService {

    /**
     * 获取当前报班
     *
     * @param studentCommenRequestDto
     * @param orgId
     * @return
     */
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(
            StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    public StudentCourseListResponse getCurrentStudentCourseList(Long orgId, StudentCommenRequestDto request);

    /**
     * 获取历史报班
     *
     * @param studentCommenRequestDto
     * @param orgId
     * @return
     */
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(
            StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    public StudentCourseListResponse getHistoryStudentCourseList(Long orgId, StudentCommenRequestDto request);

    /**
     * 获取学生消费信息
     *
     * @param studentCommenRequestDto
     * @param orgId
     * @return
     */
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto,
                                                                  Long orgId);

    /**
     * 查询学生已报班级数
     *
     * @param po
     * @param orgNumber
     * @return
     */
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber);

    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId);

    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse);

    /**
     * @param orgStudentCourse
     */

    void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse);


    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds);


    int changeNoRealCourseId();

    Map<CourseTypeEnum,Set<Long>> splitCourseIdsByCourseType(Collection<Long> allIds);

}
