package com.baijia.tianxiao.sal.student.pc.impl;

import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

import javax.annotation.Resource;

import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.points.po.PointsStudentDto;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.sal.student.dto.StudentCourseStatisticsDetail;
import com.baijia.tianxiao.sal.student.dto.StudentCourseStatisticsDetail.StudentCourseTime;
import com.baijia.tianxiao.sal.student.dto.request.PointsStudentRequest;
import com.baijia.tianxiao.sal.student.pc.StudentListExcelDto;
import com.baijia.tianxiao.util.*;

import com.baijia.tianxiao.util.storage.StorageUtil;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.field.FieldOption;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultStudentField;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.SignupStudentListDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author wangsixia
 * @version 1.0
 * @title StudentUserServiceImpl
 * @desc 学员档案
 * @date 2016年3月17日
 */
@Service
@Slf4j
public class StudentUserServiceImpl implements StudentUserService {

    // 班主任
    private static final String CASCADE_ID_STR = "cascadeIdStr";
    // 课程顾问
    private static final String ADD_CASCADE_ID_STR = "addCascadeIdStr";
    // 来源
    private static final String SOURCES_TR = "sourceStr";
    // 标签
    private static final String TAGS_STR = "tagsStr";

    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CrmStudentQuery crmStudentQuery;
    @Autowired
    private FieldShowInfoService fieldShowInfoService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private OrgStudentTagService orgStudentTagService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    @Autowired(required = false)
    private CrmStudentQuery solrStudentQuery;
    @Autowired
    private AccountApiService accountApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private TxAccountHelpService txAccountHelpService;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;

    @Override
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(CrmErrorCode.ORG_NOT_EXIST);
        }
        OrgStudent orgStudent = this.orgStudentDao.getById(studentId);
        if (null == orgStudent || orgStudent.getDelStatus() == DeleteStatus.DELETED.getValue()
                || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        StudentInfoResponseDto baseInfoDto = new StudentInfoResponseDto();
        this.studentPo2Dto(orgStudent, baseInfoDto);
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile(baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile(baseInfoDto.getParentMobile()));
        }

        log.info("getBaseInfo---------baseInfoDto={}", baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        this.doSaveBefore(orgId, studentInfo);

        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
        Long userId = userInfoMap.get("id");

        OrgStudent orgStudent = new OrgStudent();
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        orgStudent.setAddCascadeId(cascadeId == null ? 0 : cascadeId);
        this.orgStudentDao.save(orgStudent, false);
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        // 更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat)
            throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", orgId, studentInfo, updateRepeat);
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent =
                    this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal(orgStudent);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save(orgStudent, false);
        }
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        if (StringUtils.isNotBlank(studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            List<TxStudentTag> tagList = new ArrayList<>();
            for (String tagStr : tags) {
                if (StringUtils.isNotBlank("tagStr")) {
                    TxStudentTag tag = new TxStudentTag();
                    tag.setOrgId(orgStudent.getOrgId());
                    tag.setUserId(orgStudent.getUserId());
                    tag.setContent(tagStr);
                    tagList.add(tag);
                }
            }
            this.txStudentTagDao.saveAll(tagList, "consultUserId", "userId", "orgId", "content");
        }

        // 更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo || null == studentInfo.getId()
                || studentInfo.getId() <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgStudent orgStudent = this.orgStudentDao.getById(studentInfo.getId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
                || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
        }

        this.doSaveBefore(orgId, studentInfo);

        this.checkAndCreateComment(studentInfo, orgStudent);

        this.cascadeUpdateTxConsulter(orgId, orgStudent, studentInfo);

        if (studentInfo.getMobile().contains("****")) {
            studentInfo.setMobile(orgStudent.getMobile());
        }
        if (studentInfo.getParentMobile().contains("****")) {
            studentInfo.setParentMobile(orgStudent.getParentMobile());
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, null);
        this.orgStudentDao.update(orgStudent, false);
        log.info("editStudentInfo---------orgStudent={}", orgStudent);

        // 更新solr
        updateSolr(orgStudent);
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public void BatchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        List<OrgStudent> list = this.orgStudentDao.getStudentByIds(orgId, studentIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for (OrgStudent orgStudent : list) {
                if (orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                    List<TxConsultUser> consultUserList = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
                    log.info("delStudent--------consultUserList={}", consultUserList);

                    if (null != consultUserList && !consultUserList.isEmpty()) {
                        this.delSysBacklog(orgId, orgStudent, consultUserList.get(0));

                        for (TxConsultUser consulterUser : consultUserList) {
                            consulterUser.setStudentId(0L);
                            this.txConsultUserDao.update(consulterUser, "studentId");
                        }
                    } else {
                        this.delSysBacklog(orgId, orgStudent, null);
                    }

                    orgStudent.setDelStatus(DeleteStatus.DELETED.getValue());
                    TxStudentComment comment = new TxStudentComment();
                    comment.setContent("机构删除学员");
                    comment.setUserId(orgStudent.getUserId());
                    comment.setOrgId(orgStudent.getOrgId());
                    comment.setIsSystem(AddType.SYSTEM.getCode());
                    this.txStudentCommentDao.save(comment);
                    this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
                    this.orgStudentDao.update(orgStudent, "delStatus");

                    // 更新solr
                    updateSolr(orgStudent);
                }
            }
        }
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoResponseDto dto)
            throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(dto, po);
        log.info("StudentPo2Dto---------po={},dto={}", ToStringBuilder.reflectionToString(po), dto);
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }

        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }

        if (dto.getGender() == null || dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(po.getGender() == 1 ? "女" : "男");
        }
        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));

        if (null != po.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }
    }

    private void studentDto2Po(StudentListResponseDto dto, OrgStudent po, Long orgId, Long userId)
            throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(po, dto);
        log.info("studentDto2Po---------dto={},po:{}", dto, ToStringBuilder.reflectionToString(po));

        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }

        if (null == po.getId() || 0 == po.getId()) {
            // 新增
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
            po.setUserId(userId);
        }

        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    private void doSaveBefore(Long orgId, StudentListResponseDto studentInfo) {
        OrgStudent student = null;
        if (studentInfo.getId() != null && studentInfo.getId() > 0) {
            student = this.orgStudentDao.getById(studentInfo.getId());
            if (student != null && student.getOrgId() == orgId.longValue()
                    && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                String mobile = student.getMobile();
                String name = student.getName();
                log.debug("mobile={},stMobile={},name={},stuName={}", mobile, studentInfo.getMobile(), name,
                        studentInfo.getName());
                if (mobile.equals(studentInfo.getMobile()) && studentInfo.getName().equals(name)) {
                    return;
                } else {
                    procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
                }
            } else {
                throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
            }
        } else {
            procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
        }
    }

    /**
     * 处理学员手机号、姓名相同的情况
     *
     * @param orgId
     * @param mobile
     * @param name
     */
    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException(CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    /**
     * 学员档案分页查询、排序、搜索
     */
    @Override
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId, Integer cascadeId,
                                                                    CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentListRequestDto={},orgId={},pagedto={},solrStudnets = {}", studentListRequestDto, orgId,
                pageDto, solrStudents == null ? 0 : solrStudents.size());
        if (solrStudents.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        final List<Long> userIds = new ArrayList<>(pageDto.getPageSize());
        Map<Long, StudentDto> studentDtoMap = CollectorUtil.collectMap(solrStudents, new Function<StudentDto, Long>() {
            @Override
            public Long apply(StudentDto studentDto) {
                userIds.add(studentDto.getUserId());
                return studentDto.getStudentId();
            }
        });
        Map<Long, String> searchTeacherNames = searchTeacherNames(new HashSet<>(userIds), orgId, cascadeId);

        log.info("headTeacherNames {} ", searchTeacherNames);

        List<OrgStudent> students = this.orgStudentDao.getByIds(studentDtoMap.keySet());

        Map<Long, OrgStudent> orgStudentMap = CollectorUtil.collectMap(students, new Function<OrgStudent, Long>() {
            @Override
            public Long apply(OrgStudent student) {
                return student.getId();
            }
        });

        // 是否显示手机号
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);

        List<TxStudentTag> studentTags = txStudentTagDao.getTags(userIds, orgId, StudentType.ORG_STUDENTS.getCode());
        Map<Long, List<TxStudentTag>> tagMap = new HashMap<>();
        if (studentTags != null && studentTags.size() > 0) {
            for (TxStudentTag tag : studentTags) {
                List<TxStudentTag> tagList = tagMap.get(tag.getUserId());
                if (tagList == null) {
                    tagList = new ArrayList<>();
                    tagMap.put(tag.getUserId(), tagList);
                }
                tagList.add(tag);
            }
        }

        List<StudentListResponseDto> result = Lists.newArrayList();
        for (StudentDto sd : solrStudents) {
            OrgStudent student = orgStudentMap.get(sd.getStudentId());
            if (student == null) {
                continue;
            }
            List<TxStudentTag> tags = tagMap.get(student.getUserId());
            StudentListResponseDto dto = StudentListResponseDto.convertToDto(student, tags);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            StudentDto studentDto = studentDtoMap.get(student.getId());
            dto.setHasLesson(studentDto.isHasLesson() ? "是" : "否");
            dto.setCascadeIdStr(searchTeacherNames.get(student.getUserId()));
            dto.setLessonNum(studentDto.getFinishClassHour() + "/"
                    + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
            dto.setLessonTime(studentDto.getFinishClassHour() + "/"
                    + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
            result.add(dto);
        }

        return result;
    }

    @Override
    public StudentListExcelDto getPcStudentList(Long orgId, Integer cascadeId, CommonSearchRequestDto request,
                                                PageDto pageDto) {
        List<FieldOption> header = this.fieldShowInfoService.getHeader(orgId, DataProcType.ORG_STUDENT, null);
        if (CollectionUtils.isEmpty(header)) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取列表显示属性失败");
        }

        StudentListExcelDto ret = new StudentListExcelDto();

        List<StudentDto> solrStudents = searchStudentList(orgId, cascadeId, request, pageDto);

        List<Map<String, Object>> result = new ArrayList<>();
        Map<String, Object> data = new HashMap<>();
        data.put("header", header);
        data.put("result", result);
        ret.setTotalMap(data);
        if (CollectionUtils.isEmpty(solrStudents)) {
            return ret;
        }
        // 是否显示手机号
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());

        Set<Long> studentIds = new HashSet<>();
        Set<Long> userIds = new HashSet<>();
        for (StudentDto studentDto : solrStudents) {
            studentIds.add(studentDto.getStudentId());
            userIds.add(studentDto.getUserId());
        }

        Map<Long, String> addCasCadeMaps = new HashMap<>(); // map<课程顾问id, 课程顾问姓名>
        Map<Long, ConsultCustomSourceDto> sourceMap = new HashMap<>(); // map<来源id, 来源信息>
        Map<Long, String> tagsMap = new HashMap<>(); // map<学员userId, "标签1,标签2...">
        Map<Long, Map<Long, String>> studentFieldMap = new HashMap<>(); // map <学员id, <自定义id, 自定义值>> :
        // 自定义值为文本、单选值、多选值等类型
        Map<Long, String> searchTeacherNames = new HashMap<>();// map<学员userId, 班主任姓名>

        // 系统字段属性名
        Set<String> sysNames = new HashSet<>();
        // 自定义字段id
        Set<Long> customIds = new HashSet<>();
        for (FieldOption option : header) {
            if (option.getCustomId() != null && option.getCustomId() > 0) {
                customIds.add(option.getCustomId());
            } else {
                sysNames.add(option.getName());
            }
        }

        // 如果需要展示班主任,则缓存班主任信息
        if (sysNames.contains(CASCADE_ID_STR)) {
            searchTeacherNames = searchTeacherNames(new HashSet<>(userIds), orgId, cascadeId);
        }
        // 如果需要展示课程顾问,则缓存课程顾问信息
        if (sysNames.contains(ADD_CASCADE_ID_STR)) {
            addCasCadeMaps = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        }
        // 如果需要展示来源,则缓存来源信息
        if (sysNames.contains(SOURCES_TR)) {
            sourceMap = consultSourceService.mapConsultSourceDto(orgId, null);
        }
        // 如果需要展示标签,则缓存标签信息
        if (sysNames.contains(TAGS_STR)) {
            tagsMap = this.orgStudentTagService.getTagsMap(orgId, userIds, StudentType.ORG_STUDENTS);
        }
        // 如果需要展示自定义字段,则缓存自定义字段信息
        if (CollectionUtils.isNotEmpty(customIds)) {
            studentFieldMap = this.customFieldValueService.batchGetFieldValue(orgId, true, studentIds, customIds);
        }

        List<OrgStudent> students = this.orgStudentDao.getByIds(studentIds);
        Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(students, "id");
        List<StudentCourseStatisticsDetail> details = getStuCourseStatisticsDetailList(orgId, cascadeId, request, pageDto);
        ret.setDetails(details);

        Map<Long, StudentCourseStatisticsDetail> detailMap = CollectionHelper.toKeyMap(details, "userId");
        for (StudentDto studentDto : solrStudents) {
            log.info("studentDto is :{} ", studentDto);
            Long userId = studentDto.getUserId();
            OrgStudent orgStudent = studentMap.get(studentDto.getStudentId());
            DefaultStudentField dto = this.getFromStudentInfo(studentDto, orgStudent);
            log.info("DefaultStudentField is :{} ", dto);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            if (searchTeacherNames.containsKey(userId)) {
                dto.setCascadeIdStr(searchTeacherNames.get(userId));
            } else {
                dto.setCascadeIdStr("");
            }
            if (tagsMap.containsKey(userId)) {
                dto.setTagsStr(tagsMap.get(userId));
            } else {
                dto.setTagsStr("");
            }
            if (addCasCadeMaps.containsKey(orgStudent.getAddCascadeId().longValue())) {
                dto.setAddCascadeIdStr(addCasCadeMaps.get(orgStudent.getAddCascadeId().longValue()));
            } else {
                dto.setAddCascadeIdStr("");
            }
            if (sourceMap.containsKey(orgStudent.getSource().longValue())) {
                ConsultCustomSourceDto sourceDto = sourceMap.get(orgStudent.getSource().longValue());
                dto.setSourceStr(sourceDto != null ? sourceDto.getLabel() : "");
            } else {
                dto.setSourceStr("");
            }

            StudentCourseStatisticsDetail detail = detailMap.get(studentDto.getUserId());
            if (detail != null) {
                dto.setHasLesson(detail.isHasLesson() ? "是" : "否");
                if(detail.isComplete()){
                    if (detail.getTotalHour() >= 0) {
                        dto.setLessonTime(NumberUtil.convertMinToHour(detail.getFinishedHour())
                                + "/" + NumberUtil.convertMinToHour(detail.getTotalHour()));
                    }
                    if (detail.getTotalTimes() >= 0) {
                        dto.setLessonNum(detail.getFinishedTimes() + "/" + detail.getTotalTimes());
                    }
                }else {
                    dto.setLessonTime("--");
                    dto.setLessonNum("--");
                }
            }else {
                dto.setLessonTime("0/0");
                dto.setLessonNum("0/0");
            }

            Map<String, Object> item = this.getItemMap(header, dto, studentFieldMap.get(dto.getId()));
            result.add(item);
        }
        return ret;
    }


    private List<StudentDto> searchStudentList(Long orgId, Integer cascadeId, CommonSearchRequestDto request, PageDto pageDto) {
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);
        studentListRequestDto.setNeedClassInfo(true);
        studentListRequestDto.setDateFieldKey(request.getDateFieldKey());
        studentListRequestDto.setScheduleStatus(request.getScheduleStatus());
        studentListRequestDto.setRefundClassStatus(request.getRefundClassStatus());
        studentListRequestDto.setStuCenterBindStatus(request.getStuCenterBindStatus());
        studentListRequestDto.setBirthYear(request.getBirthYear());
        studentListRequestDto.setBirthMonth(request.getBirthMonth());
        studentListRequestDto.setBirthDayOfMonth(request.getBirthDayOfMonth());
        studentListRequestDto.setClassId(request.getClassId());
        studentListRequestDto.setSelectFieldKey(request.getSelectFieldKey());
        studentListRequestDto.setSource(request.getSource());
        studentListRequestDto.setLessonStatType(request.getLessonStatType());
        studentListRequestDto.setMinNum(request.getMinNum());
        studentListRequestDto.setMaxNum(request.getMaxNum());

        if(request.getSelectFieldValue()!=null) {
            studentListRequestDto.setSelectFieldValue(String.valueOf(request.getSelectFieldValue()));
        }
        if (request.getStart() != null) {
            studentListRequestDto.setStart(new Date(request.getStart()));
        }
        if (request.getEnd() != null) {
            studentListRequestDto.setEnd(new Date(request.getEnd()));
        }

        if (request.getCascadeId() != null) {
            studentListRequestDto.setCascadeIds(request.getCascadeId().toString());
        }

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }

        if(request.getClassId()!=null && request.getClassId()>0){
            OrgCourse course = orgCourseDao.getByCourseId(request.getClassId());
            if(course==null){
                log.error("[OrgCourse] course id is not exist.id={}",request.getClassId());
            }else {
                studentListRequestDto.setCourseNumber(course.getNumber());
            }
        }

        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);
        return solrStudents;
    }

    @Override
    public List<StudentCourseStatisticsDetail> getStuCourseStatisticsDetailList(Long orgId, Integer cascadeId, CommonSearchRequestDto request, PageDto pageDto) {
        log.info("[StudentCourse] orgId={},cascadeId={},request1={},pageDto={}", orgId, cascadeId, request, pageDto);
        List<StudentCourseStatisticsDetail> details = new ArrayList<>();
        List<StudentDto> solrStudents = searchStudentList(orgId, cascadeId, request, pageDto);
        log.info("[StudentCourse] solrStudents={}", solrStudents);
        if (solrStudents == null || solrStudents.size() < 1) {
            return details;
        }
        Map<Long, StudentDto> studentMap = CollectionHelper.toKeyMap(solrStudents, "userId");

        PageDto page = new PageDto();
        page.setPageSize(10000);
        List<StudentClassHour> studentClassHourList = solrStudentQuery.queryStudentClassCount(orgId, studentMap.keySet(), page);


        Set<Long> courseIds = new HashSet<>();
        Map<Long, Set<StudentClassHour>> userIdMap = new HashMap<>();
        for (StudentClassHour classHour : studentClassHourList) {
            courseIds.add(classHour.getCourseId());
            if (userIdMap.get(classHour.getUserId()) == null) {
                userIdMap.put(classHour.getUserId(), new LinkedHashSet<StudentClassHour>());
            }
            userIdMap.get(classHour.getUserId()).add(classHour);
        }

        Set<Long> keySet = new HashSet<>();
        for (StudentDto dto:solrStudents){
            keySet.add(dto.getUserId());
        }

        List<OrgStudentCourse> studentCourseList = orgStudentCourseDao.getOrgStudentCourseByUserIds(orgId, keySet,
                "courseId", "userId", "lessonCount", "status", "chargeUnit");
        Map<String, OrgStudentCourse> studentCourseMap = new HashMap<>();
        //添加没有排课的报名记录
        for (OrgStudentCourse studentCourse : studentCourseList) {
            studentCourseMap.put(getKey(studentCourse), studentCourse);
            Set<StudentClassHour> set = userIdMap.get(studentCourse.getUserId());
            if (set == null) {
                set = new LinkedHashSet<StudentClassHour>();
                userIdMap.put(studentCourse.getUserId(), set);
            }
            StudentClassHour classHour = StudentClassHour.getInstance(studentCourse);
            if (!set.contains(classHour)) {
                courseIds.add(classHour.getCourseId());
                set.add(classHour);
            }
        }

        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds, "id", "name", "cascadeId", "chargeUnit");
        Map<Long, OrgCourse> courseMap = new HashMap<>();
        Set<Integer> cascadeIds = new HashSet<>();
        for (OrgCourse course : courseList) {
            courseMap.put(course.getId(), course);
            cascadeIds.add(course.getCascadeId());
        }
        Map<Long, String> nameMap = accountApiService.getAccountNameMap(orgId, cascadeIds);

        Map<String, KexiaoStatistics> statMap = kexiaoApiService.queryClassKexiaoStatByUserIds(orgId, keySet);
        for (Long key : keySet) {
            StudentCourseStatisticsDetail detail = new StudentCourseStatisticsDetail();
            StudentDto student = studentMap.get(key);
            if (student != null) {
                detail.setUserId(student.getUserId());
                detail.setMobile(student.getMobile());
                detail.setUsername(student.getName());
                Set<StudentClassHour> classHourList = userIdMap.get(key);
                if(classHourList!=null) {
                    for (StudentClassHour classHour : classHourList) {
                        StudentCourseStatisticsDetail.StudentCourseTime courseTime =
                                new StudentCourseStatisticsDetail.StudentCourseTime();
                        OrgCourse orgCourse = courseMap.get(classHour.getCourseId());
                        if (orgCourse != null) {
                            String name = nameMap.get(orgCourse.getCascadeId().longValue());
                            courseTime.setClassName(orgCourse.getName());
                            courseTime.setTeacherName(name);
                            courseTime.setClassHeader(name);
                            String existedKey = classHour.getUserId() + "_" + orgCourse.getId();
                            KexiaoStatistics statistics = statMap.get(existedKey);
                            long total = 0;
                            long finishNumber = 0;
                            if (statistics != null) {
                                total = statistics.getTotalNumber();
                                finishNumber = statistics.getKexiaoNumber();
                                if (statistics.getArrangeNumber() > 0) {
                                    detail.setHasLesson(true);
                                }
                                if(statistics.getCompleteStatus()==1){
                                    detail.setComplete(false);
                                }
                            }
                            if (ChargeUnit.isByTime(orgCourse.getChargeUnit())) {
                                courseTime.setTotalHour(total);
                                courseTime.setFinishedHour(finishNumber);
                                detail.setTotalHour(courseTime.getTotalHour() + detail.getTotalHour());
                                detail.setFinishedHour(courseTime.getFinishedHour() + detail.getFinishedHour());
                            } else {
                                courseTime.setFinishedTimes(finishNumber);
                                courseTime.setTotalTimes((int) total);
                                detail.setTotalTimes(courseTime.getTotalTimes() + detail.getTotalTimes());
                                detail.setFinishedTimes(courseTime.getFinishedTimes() + detail.getFinishedTimes());
                            }
                            detail.getCourseTimeList().add(courseTime);
                        }
                    }
                }
                details.add(detail);
            }
        }
        log.info("[StudentCourse] ret={}", details);

        return details;
    }

    private String getKey(OrgStudentCourse studentCourse) {
        return studentCourse.getUserId() + "_" + studentCourse.getCourseId();
    }

    @Override
    public void excelStudentsAndSignUpDetail(Map<String, Object> students, List<StudentCourseStatisticsDetail> details, OutputStream os) {

        List<FieldOption> stuHeader = (List<FieldOption>) students.get("header");//见getPcStudentList方法 耦合
        List<Map<String, Object>> stuData = (List<Map<String, Object>>) students.get("result");

        //头部处理
        if (CollectionUtils.isNotEmpty(stuHeader)) {
            List<FieldOption> tempStuHeader = new ArrayList<FieldOption>();
            for (FieldOption option : stuHeader) {
                if (!option.isHidden()) {
                    tempStuHeader.add(option);
                }
            }
            stuHeader = tempStuHeader;
        }

        try {
            XSSFWorkbook workbook = new XSSFWorkbook();
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment(XSSFCellStyle.ALIGN_LEFT);

            //1. 学员列表
            XSSFSheet sheet1 = workbook.createSheet("学员列表");
            sheet1.setDefaultColumnWidth(20);
            int rowIndex = 0;
            int cellIndex = 0;

            //填充头部
            for (FieldOption header : stuHeader) {
                ExcelUtils.fillTheXSSFCellWithStringValue(sheet1, rowIndex, cellIndex++, cellStyle, header.getShowName());
            }

            //填充数据
            if (CollectionUtils.isNotEmpty(stuData)) {
                for (Map<String, Object> kvMap : stuData) {
                    rowIndex++;
                    cellIndex = 0;
                    for (FieldOption header : stuHeader) {
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet1, rowIndex, cellIndex++, cellStyle, MapUtils.getString(kvMap, header.getName(), ""));
                    }
                }
            }

            //2. 报班明细
            XSSFSheet sheet2 = workbook.createSheet("报班明细");
            sheet2.setDefaultColumnWidth(20);
            rowIndex = 0;
            cellIndex = 0;

            //填充数据
            if (CollectionUtils.isNotEmpty(details)) {
                for (StudentCourseStatisticsDetail detail : details) {
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 0, cellStyle, "学生姓名");
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle, detail.getUsername());
                    rowIndex++;

                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 0, cellStyle, "手机");
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle, detail.getMobile());
                    rowIndex++;

                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 0, cellStyle, "已上课次/总课次");
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle, String.format("%s/%s", detail.getFinishedTimes(), detail.getTotalTimes()));
                    rowIndex++;

                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 0, cellStyle, "已上课时/总课时");
                    ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle,
                            String.format("%s/%s", NumberUtil.convertMinToHour(detail.getFinishedHour()),
                                    NumberUtil.convertMinToHour(detail.getTotalHour())));
                    rowIndex++;

                    if (CollectionUtils.isNotEmpty(detail.getCourseTimeList())) {
                        rowIndex++;//换行
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 0, cellStyle, "序号");
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle, "班级明细");
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 2, cellStyle, "已上课次/总课次");
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 3, cellStyle, "已上课时/总课时");
                        ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 4, cellStyle, "班主任");

                        int tempNo = 1;
                        for (StudentCourseTime sct : detail.getCourseTimeList()) {
                            rowIndex++;
                            ExcelUtils.fillTheXSSFCellWithIntValue(sheet2, rowIndex, 0, cellStyle, tempNo++);
                            ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 1, cellStyle, sct.getClassName());
                            ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 2, cellStyle, String.format("%s/%s", sct.getFinishedTimes(), sct.getTotalTimes()));
                            ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 3, cellStyle, String.format("%s/%s",
                                    NumberUtil.convertMinToHour(sct.getFinishedHour()), NumberUtil.convertMinToHour(sct.getTotalHour())));
                            ExcelUtils.fillTheXSSFCellWithStringValue(sheet2, rowIndex, 4, cellStyle, sct.getTeacherName());
                        }
                    }

                    rowIndex += 4;//换3行
                }
            }

            workbook.write(os);

        } catch (Exception e) {
            log.error("", e);
        } finally {
            IOUtils.closeQuietly(os);
        }

    }

    private <T> Map<String, Object> getItemMap(List<FieldOption> header, T t, Map<Long, String> customMap) {
        Map<String, Object> map = new HashMap<>();
        // 系统字段
        Field[] fields = t.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Map<String, Field> sysFieldMap = BaseUtils.listToMap(Lists.newArrayList(fields), "name");
            for (FieldOption option : header) {
                if (option.getCustomId() != null && option.getCustomId() > 0) {
                    if (customMap != null && customMap.containsKey(option.getCustomId())) {
                        map.put(option.getName(), customMap.get(option.getCustomId()));
                    }
                } else {
                    Field field = sysFieldMap.get(option.getName());
                    if (field != null) {
                        Object ret = null;
                        try {
                            field.setAccessible(true);
                            ret = field.get(t);
                        } catch (Exception e) {
                            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                        }
                        map.put(option.getName(), ret);
                    }
                }
            }
        }
        return map;
    }

    private DefaultStudentField getFromStudentInfo(StudentDto studentDto, OrgStudent orgStudent) {
        DefaultStudentField dto = new DefaultStudentField();
        try {
            BeanUtils.copyProperties(dto, orgStudent);
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "copy properties failed!");
        }
        dto.setRemainTuition(studentDto.getRemainTuition());

        if (orgStudent.getBirthday() != null) {
            dto.setBirthdayStr(DateUtil.getStrByDate(orgStudent.getBirthday()));
        }

        if (dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1 ? "女" : "男");
        }

        if(StringUtils.isNotBlank(orgStudent.getWeixin())){
            dto.setStuCenterBindStatus(1);
            dto.setStuCenterBindStatusStr("已绑定");
        }else{
            dto.setStuCenterBindStatus(2);
            dto.setStuCenterBindStatusStr("未绑定");
        }

        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));
        dto.setHasLesson(studentDto.isHasLesson() ? "是" : "否");
        dto.setCreateTimeStr(DateUtil.getStrByDate(orgStudent.getCreateTime()));
        if (orgStudent.getLastRemindTime() != null) {
            dto.setLastRemindTimeStr(DateUtil.getStrByDate(orgStudent.getLastRemindTime()));
        }
        if (orgStudent.getLastFollowTime() != null) {
            dto.setLastFollowTimeStr(DateUtil.getStrByDate(orgStudent.getLastFollowTime()));
        }
        return dto;
    }

    /**
     * @param userIds
     * @param orgId
     * @param cascadeId
     * @return
     */
    private Map<Long, String> searchTeacherNames(Set<Long> userIds, Long orgId, Integer cascadeId) {

        boolean isStaffAccount = false;
        if (cascadeId != null) {
            boolean hasPermission = this.txAccountPermissionService.hasPermission(cascadeId.longValue(),
                    ApplicationType.PC, TXPermissionConst.SEE_ALL_ORG_STUDENTS);
            if (!hasPermission) {
                isStaffAccount = true;
            }
        }

        log.info("isStaffAccount : {} , cascadeId : {} , orgId : {} ", isStaffAccount, cascadeId, orgId);

        Map<Long, String> byTxCasCadeIds = Maps.newHashMap();
        // 如果当前用户为子账号，说明只能看属于自己的班级
        if (isStaffAccount) {
            TxCascadeCredentialDto byTxCasCade = this.txCascadeCredentialService.getByTxCasCade(orgId, cascadeId);
            if (byTxCasCade != null) {
                byTxCasCadeIds.put(cascadeId.longValue(), byTxCasCade.getName());
            }
        } else {
            byTxCasCadeIds.putAll(this.txCascadeCredentialService.getByTxCasCadeIds(orgId));
        }

        Map<Long, String> headTeacherNameMap = Maps.newHashMap();
        Map<Long, List<Long>> orgStudentCourseIds = this.orgStudentCourseDao.getOrgCourseIdMap(orgId, userIds);
        Set<Long> courseIdSet = Sets.newHashSet();
        for (List<Long> courses : orgStudentCourseIds.values()) {
            courseIdSet.addAll(courses);
        }

        List<OrgCourse> allCourse = this.orgCourseDao.getByIds(courseIdSet, "id", "cascadeId");

        Map<Long, String> courseCascadeNameMap = Maps.newHashMap();
        for (OrgCourse orgCourse : allCourse) {
            Long courseId = orgCourse.getId();
            Integer courseCascadeId = orgCourse.getCascadeId();
            String headTeacherName = byTxCasCadeIds.get(courseCascadeId.longValue());
            if (GenericsUtils.notNullAndEmpty(headTeacherName)) {
                courseCascadeNameMap.put(courseId, headTeacherName);
            }
        }

        for (Long userId : userIds) {
            Set<String> names = new HashSet<>();
            List<Long> courseIds = orgStudentCourseIds.get(userId);
            if (GenericsUtils.isNullOrEmpty(courseIds)) {
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (Long courseId : courseIds) {
                String headTeacherName = courseCascadeNameMap.get(courseId);
                if (GenericsUtils.notNullAndEmpty(headTeacherName) && !names.contains(headTeacherName)) {
                    sb.append(headTeacherName).append("、");
                }
                names.add(headTeacherName);
            }
            String headTeacherNames = GenericsUtils.deleteLastCharToString(sb);
            headTeacherNameMap.put(userId, headTeacherNames);
        }
        return headTeacherNameMap;
    }

    /**
     * 添加系统待办事项(正式学员)
     * <p>
     * <<<<<<< HEAD
     *
     * @param orgId         机构id
     * @param orgId         机构id =======
     * @param orgId         机构id >>>>>>> yingxiao_1_6
     * @param consultUserId 线索id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("addSysBacklog---------orgId={}, student={}, consultUserId={}", orgId, student, consultUserId);
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
                && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(studentId, orgId, false, "id");
            if (CollectionUtils.isNotEmpty(list)) {
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "已存在未过期的学员档案系统待办事项");
            }
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            txBacklog.setContent("跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            if (null != consultUserId && consultUserId > 0) {
                txBacklog.setConsultUserId(consultUserId);
            }
            this.txBacklogDao.save(txBacklog, false);
            log.info("addSysBacklog--------txBacklog={}", txBacklog);
        }
    }

    /**
     * 更新系统待办事项:编辑正式学员
     * <p/>
     * <<<<<<< HEAD
     * <p>
     * <<<<<<< HEAD
     *
     * @param orgId     机构id ======= <<<<<<< HEAD <<<<<<< HEAD
     * @param orgId     机构id =======
     * @param orgId     机构id >>>>>>> a9ef5790d09369978d27d492ee8c236e0a9057de =======
     * @param orgId     机构id >>>>>>> yingxiao_1_6 =======
     * @param orgId     机构id <<<<<<< HEAD >>>>>>> dev ======= >>>>>>> refs/remotes/origin/caoliang >>>>>>> dev <<<<<<< HEAD
     *                  ======= >>>>>>> push_lxp >>>>>>> yingxiao_1_6
     * @param studentId 正式学员id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSysBacklog(Long orgId, Long studentId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("updateSysBacklog---------orgId={}, student={}", orgId, student);

        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
                && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, false);
            if (CollectionUtils.isNotEmpty(list)) {
                TxBacklog txBacklog = list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    // 正式学员下次跟进时间改变
                    txBacklog.setContent(
                            "跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update(txBacklog, false);
                }
            } else {
                // 系统待办事项已过期需要新建，若同时还是咨询学员，则在此处添加consulterId
                Long consulterId = null;
                List<TxConsultUser> consultUserList =
                        this.txConsultUserDao.lookByStudentId(orgId, student.getId(), "id");
                if (CollectionUtils.isNotEmpty(consultUserList)) {
                    consulterId = consultUserList.get(0).getId();
                }
                this.addSysBacklog(orgId, student.getId(), consulterId);
            }
        }
    }

    /**
     * 删除系统待办事项: 若同时还是咨询学员，则重置studentId为0; 若仅是正式学员，则直接删除
     *
     * @param orgId         机构id
     * @param consulterUser 咨询学员
     * @return
     */
    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        log.info("delSysBacklog-------orgId={},student={},consulterUser={}", orgId, student, consulterUser);
        List<TxBacklog> list = null;
        if (null != consulterUser) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog && txBacklog.getStudentId().longValue() == student.getId().longValue()) {
                        txBacklog.setStudentId(0l);
                        if (!txBacklog.getEndTime().before(new Date())) {
                            // 未过期系统待办事项才作同步
                            txBacklog.setContent("跟进客户: "
                                    + (StringUtils.isNotBlank(consulterUser.getName()) ? consulterUser.getName() : "匿名学生"));
                            txBacklog.setEndTime(consulterUser.getNextRemindTime());
                            txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                        }
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog) {
                        txBacklog.setStudentId(0l);
                        txBacklog.setDelStatus(BizConf.TRUE.intValue());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        }
    }

    /**
     * 机构修改了手机号码和姓名都会生成一条跟进记录
     *
     * @param dto
     * @param po
     */
    private void checkAndCreateComment(StudentListResponseDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();

        String destName = dto.getName();
        String destMobile = dto.getMobile();

        List<TxStudentComment> comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate("yyyy-MM-dd HH:mm", 0, Calendar.DAY_OF_MONTH);
        if (!destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将姓名【").append(sourceName).append("】").append("修改为【").append(destName)
                    .append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!destMobile.equals(sourceMobile)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将手机号【").append(sourceMobile).append("】").append("修改为【")
                    .append(destMobile).append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll(comments);
        }
    }

    /**
     * 生成跟进记录
     *
     * @param orgId
     * @param content
     * @param userId
     * @return
     */
    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(orgId);
        comment.setOrigin(0);
        comment.setUserId(userId);
        return comment;
    }

    /**
     * 学员名字与招生线索同步
     *
     * @param orgId
     * @param orgStudent
     * @param studentInfo
     * @return
     */
    private void cascadeUpdateTxConsulter(long orgId, OrgStudent orgStudent, StudentListResponseDto studentInfo) {
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if (updateName || updateMobile) {
            List<TxConsultUser> consultUsers = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
            if (consultUsers != null && !consultUsers.isEmpty()) {
                for (TxConsultUser consultUser : consultUsers) {
                    consultUser.setName(updateName ? studentInfo.getName() : null);
                    consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                    consultUser.setUpdateTime(new Date());
                    txConsultUserDao.update(consultUser, false);
                }
            }
        }
    }

    void updateSolr(OrgStudent orgStudent) {
        if (orgStudent == null) {
            return;
        }
        try {
            crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", orgStudent);
        } catch (Exception e) {
            log.error("solr - student - update - exception", e);
        }
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BussinessException.class})
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat,
                               List<CustomFieldValue> valueList) throws Exception {

        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", orgId, studentInfo, updateRepeat);
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent =
                    this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal(orgStudent);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save(orgStudent, false);
        }
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        if (StringUtils.isNotBlank(studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            List<TxStudentTag> tagList = new ArrayList<>();
            for (String tagStr : tags) {
                if (StringUtils.isNotBlank("tagStr")) {
                    TxStudentTag tag = new TxStudentTag();
                    tag.setOrgId(orgStudent.getOrgId());
                    tag.setUserId(orgStudent.getUserId());
                    tag.setContent(tagStr);
                    tagList.add(tag);
                }
            }
            this.txStudentTagDao.saveAll(tagList, "consultUserId", "userId", "orgId", "content");
        }
        Long studentId = orgStudent.getId();

        String customSearchValue = this.buildCustomSearchValue(valueList, true, true, orgId, studentId, true);
        if (StringUtils.isBlank(customSearchValue)) {
            customSearchValue = null;
        }
        orgStudent.setCustomSearchValue(customSearchValue);
        this.orgStudentDao.update(orgStudent, true, "customSearchValue");

        // 更新solr
        updateSolr(orgStudent);
        return studentId;
    }

    /**
     * 自定义属性的搜索苏醒冗余处理逻辑，累加获取学员的所有自定义属性的组装的搜索值
     *
     * @param fieldValueList
     * @param needBuildSearchValue 为true，会重新计算,false不从新计算，只累加
     * @param saveSearchValue      为true，会更新自定义属性的searchValue，则需要后面几个参数
     * @param orgId                机构id
     * @param studentId            学员id
     * @param isStudent            是否是学员，false表示是个线索
     * @return 组装好的自定义搜索对象
     */

    public String buildCustomSearchValue(List<CustomFieldValue> fieldValueList, boolean needBuildSearchValue,
                                         boolean saveSearchValue, Long orgId, Long studentId, Boolean isStudent) {

        List<String> searchValueList = Lists.newArrayList();
        for (CustomFieldValue fieldValue : fieldValueList) {
            if (needBuildSearchValue) {
                try {
                    CustomFieldType.buildSearchValue(fieldValue);
                } catch (Exception e) {
                    log.warn("CustomFieldType.buildSearchValue error,fileValue={},error={}", fieldValue, e);
                }
            }

            if (StringUtils.isNotBlank(fieldValue.getSearchValue())) {
                searchValueList.add(fieldValue.getSearchValue());
            }

        }
        String customSearchValue = null;
        if (searchValueList.size() > 0) {
            customSearchValue = Joiner.on(" ").join(searchValueList);
        }

        if (!saveSearchValue) {
            return customSearchValue;
        }

        List<Long> customFieldIds = Lists.newArrayList();
        for (CustomFieldValue value : fieldValueList) {
            customFieldIds.add(value.getFieldId());
        }
        List<CustomFieldValue> exitFieldValueList = Lists.newArrayList();
        if (!customFieldIds.isEmpty()) {
            if (isStudent == null) {
                isStudent = true;
            }
            exitFieldValueList = customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentId, customFieldIds);
        }

        Map<Long, CustomFieldValue> exitFieldValueMap = Maps.newHashMap();
        for (CustomFieldValue value : exitFieldValueList) {
            exitFieldValueMap.put(value.getFieldId(), value);
        }

        for (CustomFieldValue value : fieldValueList) {
            CustomFieldValue exitValue = exitFieldValueMap.get(value.getFieldId());
            Date now = new Date();
            if (exitValue != null) {
                exitValue.setUpdateTime(now);
                exitValue.setValue(value.getValue());
                exitValue.setFieldType(value.getFieldType());
                customFieldValueDao.update(exitValue, true, "fieldType", "value", "searchValue", "updateTime");

            } else {
                if (isStudent) {
                    value.setConsultUserId(0L);
                    value.setStudentId(studentId);
                } else {
                    value.setConsultUserId(studentId);
                    value.setStudentId(0L);
                }

                value.setCreateTime(now);
                value.setUpdateTime(now);
                customFieldValueDao.save(value, true);
            }

        }
        return customSearchValue;
    }

    @Override
    public List<SignupStudentListDto> getStudentListForSignup(Long orgId, String query, PageDto pageDto) {
        List<OrgStudent> list = orgStudentDao.getStudentsUserIdsSortedByPinyin(orgId, query, DeleteStatus.NORMAL.getValue(), pageDto);

        Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(list, "userId");

        Map<Long, List<TxStudentTag>> tagMap = new HashMap<>();
        if (!studentMap.keySet().isEmpty()) {
            List<TxStudentTag> studentTags = txStudentTagDao.getTags(studentMap.keySet(), orgId, StudentType.ORG_STUDENTS.getCode());
            if (studentTags != null && studentTags.size() > 0) {
                for (TxStudentTag tag : studentTags) {
                    List<TxStudentTag> tagList = tagMap.get(tag.getUserId());
                    if (tagList == null) {
                        tagList = new ArrayList<>();
                        tagMap.put(tag.getUserId(), tagList);
                    }
                    tagList.add(tag);
                }
            }
        }

        List<SignupStudentListDto> result = Lists.newArrayList();
        for (OrgStudent student : list) {
            List<TxStudentTag> tags = tagMap.get(student.getUserId());

            result.add(SignupStudentListDto.convertToDto(student, tags));
        }
        return result;
    }


    @Override
    public List<PointsStudentDto> listStudentByCascade(Long orgId, Integer cascadeId, CommonSearchRequestDto request, PageDto pageDto) {
        log.info("[listStudentByCascade] orgId={},cascadeId={},request={},pageDto={}", orgId, cascadeId, request, pageDto);

        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(true);
        studentListRequestDto.setNeedClassInfo(false);
        studentListRequestDto.setDateFieldKey(request.getDateFieldKey());

        if (request.getCascadeId() != null) {
            studentListRequestDto.setCascadeIds(request.getCascadeId().toString());
        }

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);

        if (CollectionUtils.isEmpty(solrStudents)) {
            return Collections.EMPTY_LIST;
        }
        List<PointsStudentDto> integralStudentDtoList = Lists.newArrayList();
        for (StudentDto studentDto : solrStudents) {
            PointsStudentDto integralStudentDto = new PointsStudentDto();
            integralStudentDto.setId(studentDto.getStudentId());
            integralStudentDto.setName(studentDto.getName());
            integralStudentDto.setCover(studentDto.getAvatarUrl());
            integralStudentDto.setMobile(studentDto.getMobile());
            integralStudentDto.setDisplayMobile(studentDto.getMobile());
            integralStudentDtoList.add(integralStudentDto);
        }

        return integralStudentDtoList;
    }

    @Override
    public List<PointsStudentDto> searchPointsWithStudent(Long orgId, Integer cascadeId, PointsStudentRequest request, PageDto pageDto) {
        log.info("[listStudentByCascade] orgId={},cascadeId={},request={},pageDto={},result={}", orgId, cascadeId, request, pageDto);

        AccountRoleType roleType =
                txAccountHelpService.findAccountRoleType(orgId, cascadeId);
        final boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, cascadeId);
        log.info("show mark mobile : {}  for orgId :{} and cascadeId :{},roleType={}", isShowMobile, orgId, cascadeId,roleType);

        if (roleType != null && roleType.needDataAuthority()) {
            log.info("当前角色 orgId : {} , cascadeId : {}没有获取学员列表的权限，进行数据控制", orgId, roleType.getCascadeId());
            List<Long> ownCourseIds =
                    orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, null, null);
            // 班主任是当前用户的学生
            Set<Long> ids = this.studentCourseDao.listStudentUserIdsByCourseIds(orgId, ownCourseIds, 0);// solrStudentQuery.queryCourseStudentUserIds(ownCourseIds,
            // (当前用户是老师) 的学生 TODO
            Set<Long> isTeacherIds = orgStudentService.getTeacherUserIds(orgId, cascadeId);
            // 添加人是当前的学生
            List<Long> addedUserIds =
                    orgStudentDao.getStudentIdsByAdder(cascadeId, orgId);
            ids.addAll(isTeacherIds);
            ids.addAll(addedUserIds);
            if (ids.isEmpty()) {
                log.info("[OrgStudentList] no users!,orgId={},cascadeId={}", orgId, cascadeId);
                return Collections.emptyList();
            }
            List<Long> preStudentIds = request.getStudentIds();
            if (GenericsUtils.notNullAndEmpty(preStudentIds)) {
                ids.retainAll(preStudentIds);
            }
            List<Long> studentIdList = Lists.newArrayList();
            studentIdList.addAll(ids);
            request.setStudentIds(studentIdList);
        }

        List<PointsStudentDto> studentList = orgStudentDao.searchPointStudent(orgId, request.getStudentIds(), request.getQuery(), request.getMinPoints(), request.getMaxPoints(), request.getOrderName(), request.getOrderType(), pageDto);
        log.info("[listStudentByCascade] orgId={},cascadeId={},request={},pageDto={},result={}", orgId, cascadeId, request, pageDto, studentList);
        if (CollectionUtils.isEmpty(studentList)) {
            return Collections.EMPTY_LIST;
        }

        List<PointsStudentDto> pointsStudentDtoList = Lists.newArrayList();
        for (PointsStudentDto pointsStudentDto : studentList) {
            if (pointsStudentDto.getAvatar() != null && pointsStudentDto.getAvatar() > 0) {
                Storage storage = this.storageDao.getStorageById(pointsStudentDto.getAvatar().longValue());
                if (storage != null) {
                    pointsStudentDto.setCover(StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
                }
            }
            if (!isShowMobile) {
                pointsStudentDto.setDisplayMobile(MaskUtil.maskMobile(pointsStudentDto.getMobile()));
            }else {
                pointsStudentDto.setDisplayMobile(pointsStudentDto.getMobile());
            }
            pointsStudentDtoList.add(pointsStudentDto);
        }
        return pointsStudentDtoList;
    }
}
