package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordKeyDao;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordTemplateDao;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordKey;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordTemplate;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordValue;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.sal.student.api.TxCustomRecordService;
import com.baijia.tianxiao.sal.student.dto.TxCustomRecordDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;

import com.google.common.collect.Lists;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import lombok.extern.slf4j.Slf4j;

/**
 * @author weihongyan
 * @implNote <(▰˘◡˘▰)>
 * @since 03/08/2017 11:50 AM
 */
@Slf4j
@Service
@Transactional
public class TxCustomRecordServiceImpl implements TxCustomRecordService {

    @Autowired
    private TxCustomRecordTemplateDao txCustomRecordTemplateDao;
    @Autowired
    private TxCustomRecordKeyDao txCustomRecordKeyDao;
    @Autowired
    private TxCustomRecordValueDao txCustomRecordValueDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    public TxCustomRecordDto getRecord(Long orgId, Long templateId, Long commentId) {
        // prepare data
        TxCustomRecordTemplate template = txCustomRecordTemplateDao.getById(templateId);
        List<TxCustomRecordKey> keyList = txCustomRecordKeyDao.getKeysByOrgId(orgId, templateId, null);
        Map<Long, TxCustomRecordValue> keyValues = CollectorUtil.collectMap(
            txCustomRecordValueDao.listByOrgCommentKeyIds(orgId, commentId,
                keyList.stream().map(txCustomRecordKey -> txCustomRecordKey.getId()).collect(Collectors.toList())),
            input -> input.getKeyId());

        // assemble data
        TxCustomRecordDto recordDto = new TxCustomRecordDto();
        recordDto.setTemplateId(template.getId());
        recordDto.setName(template.getName());
        recordDto.setSort(template.getSort());
        recordDto.setType(template.getType());

        List<TxCustomRecordDto.RecordField> fields = Lists.newArrayList();
        for (TxCustomRecordKey key : keyList) {
            TxCustomRecordDto.RecordField field = new TxCustomRecordDto.RecordField();
            field.setKeyId(key.getId());
            field.setKeyName(key.getKeyName());
            field.setDisable(key.getDisable());
            field.setSort(key.getSort());
            TxCustomRecordValue value = keyValues.get(key.getId());
            field.setValueId(null == value ? null : value.getId());
            field.setValue(null == value ? null : value.getValue());
            if (field.getDisable() == Flag.TRUE.getInt() && StringUtils.isBlank(field.getValue())) {
                continue;
            }
            fields.add(field);
        }
        recordDto.setFields(fields);
        recordDto.sort();
        return recordDto;
    }

    public TxCustomRecordDto getEmptyRecord(Long orgId, Long templateId) {
        // prepare data
        TxCustomRecordTemplate template = txCustomRecordTemplateDao.getById(templateId);
        List<TxCustomRecordKey> keyList = txCustomRecordKeyDao.getKeysByOrgId(orgId, templateId, Flag.FALSE.getInt());

        // assemble data
        TxCustomRecordDto recordDto = new TxCustomRecordDto();
        recordDto.setTemplateId(template.getId());
        recordDto.setName(template.getName());
        recordDto.setSort(template.getSort());
        recordDto.setType(template.getType());

        List<TxCustomRecordDto.RecordField> fields = Lists.newArrayList();
        for (TxCustomRecordKey key : keyList) {
            TxCustomRecordDto.RecordField field = new TxCustomRecordDto.RecordField();
            field.setKeyId(key.getId());
            field.setKeyName(key.getKeyName());
            field.setDisable(key.getDisable());
            field.setSort(key.getSort());
            field.setValueId(null);
            field.setValue(null);
            fields.add(field);
        }
        recordDto.setFields(fields);
        recordDto.sort();
        return recordDto;
    }

    @Override
    public void saveNewRecord(Long orgId, Long commentId, TxCustomRecordDto txCustomRecordDto) {
        log.debug("txCustomRecordDto:{}", txCustomRecordDto);
        TxCustomRecordTemplate template = txCustomRecordTemplateDao.getByTemplateId(txCustomRecordDto.getTemplateId());
        BussinessPreconditions.checkArgument(null != template && template.getDisable() == Flag.FALSE.getInt()
            && template.getOrgId() == orgId.longValue(), "模板信息已经改变，请退出当前页面重试");
        TxStudentComment studentComment = txStudentCommentDao.getById(commentId);
        BussinessPreconditions.checkArgument(null != studentComment && studentComment.getOrgId() == orgId.longValue(),
            "can not find studentComment!");
        
        if (CollectionUtils.isEmpty(txCustomRecordDto.getFields())) {
            return;
        }

        List<TxCustomRecordValue> saveList = Lists.newArrayList();
        for (TxCustomRecordDto.RecordField field : txCustomRecordDto.getFields()) {
            TxCustomRecordValue value = new TxCustomRecordValue();
            value.setOrgId(orgId);
            value.setCommentId(commentId);
            value.setKeyId(field.getKeyId());
            value.setValue(field.getValue());
            if (StringUtils.isBlank(value.getValue()) || null == value.getKeyId()) {
                continue;
            }
            saveList.add(value);
        }

        txCustomRecordValueDao.saveAll(saveList, false);
    }
}
