/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.request;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baijia.tianxiao.beanCopy.BeanInvokeUtils;
import com.baijia.tianxiao.beanCopy.BeanMethodInvoke;
import com.baijia.tianxiao.beanCopy.InvokeExclude;
import com.baijia.tianxiao.beanCopy.Invoker;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentListRequestDto
 * @desc TODO
 * @date 2015年12月4日
 */
@Data
@Slf4j
public class StudentListRequestDto implements Serializable {

    private static final long serialVersionUID = 547521844640451760L;

    @InvokeExclude
    private Long courseNumber;
    @InvokeExclude
    private Integer courseType;

    private String searchKey;

    @InvokeExclude
    private Integer studentStatus;
    @InvokeExclude
    private String initial;

    private Integer opType;// 最近操作类型: 1：最近7天需要跟进，2：最近7天报班，3：最近7天创建的

    private Integer isSchedule;// 是否已排课 1:已排课，2：未排课

    private Integer leftMinClassHour;// 剩余最小课时

    private Integer leftMaxClassHour;// 剩余最大课时

    private Integer followDate;// 跟进日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer createDate;// 创建日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    private Integer enrollDate;// 报班日期 1：今天，2：昨天，3：本周，4：上周，5：本月，6：上月，7：本季度，8：上季度

    @InvokeExclude
    private Integer pageNum = 1;

    @InvokeExclude
    private Integer pageSize = 20;

    private Integer sex;// 性别

    @InvokeExclude
    private String queryStr;
    @InvokeExclude
    private String queryValue;

    private String cascadeIds; // 学员个跟进人

    @InvokeExclude
    private Integer signupQuery = 0;//是否报名查询

    @InvokeExclude
    private Integer cascadeId;

    // 排序规则,默认升序0:升序,1:降序
    @InvokeExclude
    private Integer orderType = 0;
    // 排序字段
    private String orderName;

    @InvokeExclude
    private boolean needAvatar = true; // 展示数据是否需要头像
    @InvokeExclude
    private boolean needClassInfo = true;// 展示是否需要学员课消数据(针对APP端学员列表展示),老接口需要
    @InvokeExclude
    private Integer infoFillStatus = 1;

    @InvokeExclude
    private Date createTime;
    @InvokeExclude
    private Date lastRemindTime;

    @InvokeExclude
    private String dateFieldKey;
    @InvokeExclude
    private Date start;
    @InvokeExclude
    private Date end;

    @InvokeExclude
    private String selectFieldKey;
    @InvokeExclude
    private String selectFieldValue;

    private Integer source;//来源

    @InvokeExclude
    private Integer scheduleStatus;//是否排课
    @InvokeExclude
    private Integer refundClassStatus;//是否退班
    @InvokeExclude
    private Integer stuCenterBindStatus;//是否绑定个人中心

    @InvokeExclude
    private Long classId;//所在班级

    private Integer birthYear;
    private Integer birthMonth;
    private Integer birthDayOfMonth;

    @InvokeExclude
    private Integer lessonStatType;
    @InvokeExclude
    private Integer maxNum;
    @InvokeExclude
    private Integer minNum;

    public void setSex(Integer sex) {
        if (sex == null) {
            return;
        }
        this.sex = (sex - 1); // Infos:APP参数传递的时候,将性别 man -->1(实际数据库存储的为0) ,women --->2(实际数据库为1),该转变过程不规范，调用接口请注意
    }

    public static final Object[] EMPTY_ARGUS = new Object[]{};

    @SuppressWarnings("unchecked")
    public boolean needFilter() {

        log.info("[ES] param={}",this);

        if(lessonStatType!=null && lessonStatType>0){
            if(maxNum!=null || (minNum!=null && minNum>0)){
                return true;
            }
        }

        if(gtZero(scheduleStatus) || gtZero(refundClassStatus) || gtZero(stuCenterBindStatus)){
            return true;
        }

        if(StringUtils.isNotBlank(selectFieldKey) && StringUtils.isNotBlank(selectFieldValue)){
            return true;
        }

        if(StringUtils.isNotBlank(queryStr) && StringUtils.isNotBlank(queryValue)){
            return true;
        }

        if(StringUtils.isNotBlank(dateFieldKey) && (start!=null || end!=null)){
            return true;
        }

        BeanMethodInvoke<StudentListRequestDto> findBeanMethodInovker =
                (BeanMethodInvoke<StudentListRequestDto>) BeanInvokeUtils.findBeanMethodInovker(this.getClass());
        List<String> fieldNames = findBeanMethodInovker.getFieldNames();
        if (GenericsUtils.notNullAndEmpty(fieldNames)) {
            for (String fieldName : fieldNames) {
                Invoker<StudentListRequestDto> fieldReader = findBeanMethodInovker.getFieldReader(fieldName);
                Object value = null;
                if (fieldReader != null && (value = fieldReader.invoke(this)) != null) {
                    if (fieldName.equals("opType") && value.equals(0)) {
                        continue;
                    }

                    if(value instanceof String && StringUtils.isBlank((String)value)){
                        continue;
                    }

                    log.info("find field:{} has value :{} ", fieldName, value);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean gtZero(Integer value){
        if(value!=null && value>0){
            return true;
        }else {
            return false;
        }
    }

}
