
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;


import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @title little Boy
 * @desc 告诉我，你梦去哪里?
 * @author Rezar
 * @date Jul 23, 2016
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Component
@Slf4j
public class MultiChoiceFieldType extends AbstractCustomFieldType<MultiChoiceFieldTypeWrapper> {

    /**
     * { options:[ { "id": 0, "value":"男" } ] }
     */

    private Long id;
    private String value;

    @Override
    public String objToJson(MultiChoiceFieldTypeWrapper wrapper) {
        return super.toJson(wrapper);
    }

    @Override
    public MultiChoiceFieldTypeWrapper jsonToObj(String json) {
        JSONObject jsonObj = JSONObject.fromObject(json);
        
        JSONArray jsonArray = JSONArray.fromObject(jsonObj.get("options"));
        List<MultiChoiceFieldType> retLists = new ArrayList<MultiChoiceFieldType>(jsonArray.size());
        for (Iterator<?> iter = jsonArray.iterator(); iter.hasNext();) {
            retLists.add(super.<MultiChoiceFieldType> fromJson(iter.next().toString()));
        }
        log.info("MultiChoiceFieldType json param:{}， jsonArray param:{}", json, jsonArray);
        MultiChoiceFieldTypeWrapper wrapper = new MultiChoiceFieldTypeWrapper();
        wrapper.setOptions(retLists);
        return wrapper;
    }

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.MULTI_CHOICE;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<MultiChoiceFieldTypeWrapper> instance() {
        return new MultiChoiceFieldType();
    }

}
