/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.dto.response.pc;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignupStudentListDto {
    private static final Logger log = LoggerFactory.getLogger(SignupStudentListDto.class);
    private Long id;
    private String name;
    private String mobile;
    private Long gender;
    private String genderStr;
    private String parentName;
    private String parentMobile;
    private Long birthday;
    private Date birthdayStr;
    private String mail;
    private String qq;
    private String studentRemark;
    private String pinyin;
    private String studentTags;
    private String tagsStr;

    public static SignupStudentListDto convertToDto(OrgStudent student, List<TxStudentTag> tagList) {
        SignupStudentListDto dto = new SignupStudentListDto();
        dto.setId(student.getId());
        dto.setName(student.getName());
        dto.setMobile(student.getMobile());
        dto.setParentName(student.getParentName());
        dto.setParentMobile(student.getParentMobile());
        dto.setQq(student.getQq());
        dto.setGender(student.getGender().longValue());
        if (dto.getGender() == null || dto.getGender() == -1L) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1L ? "\u5973" : "\u7537");
        }
        StringBuilder tagStr = new StringBuilder("");
        if (tagList != null) {
            for (int i = 0; i < tagList.size(); ++i) {
                TxStudentTag txStudentTag = tagList.get(i);
                if (i >= 5) continue;
                tagStr.append(txStudentTag.getContent()).append(" ");
            }
        }
        dto.setStudentTags(tagStr.toString());
        if (student.getBirthday() != null) {
            dto.setBirthday(student.getBirthday().getTime());
            dto.setBirthdayStr(student.getBirthday());
        }
        dto.setMail(student.getMail());
        dto.setStudentRemark(student.getRemark());
        String pinyin = student.getPinyin();
        if (StringUtils.isBlank((CharSequence)pinyin) || pinyin.charAt(0) <= '9' && pinyin.charAt(0) >= '0') {
            dto.setPinyin("#");
        } else {
            dto.setPinyin(student.getPinyin());
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Long getGender() {
        return this.gender;
    }

    public String getGenderStr() {
        return this.genderStr;
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getParentMobile() {
        return this.parentMobile;
    }

    public Long getBirthday() {
        return this.birthday;
    }

    public Date getBirthdayStr() {
        return this.birthdayStr;
    }

    public String getMail() {
        return this.mail;
    }

    public String getQq() {
        return this.qq;
    }

    public String getStudentRemark() {
        return this.studentRemark;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    public String getStudentTags() {
        return this.studentTags;
    }

    public String getTagsStr() {
        return this.tagsStr;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setGender(Long gender) {
        this.gender = gender;
    }

    public void setGenderStr(String genderStr) {
        this.genderStr = genderStr;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public void setParentMobile(String parentMobile) {
        this.parentMobile = parentMobile;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public void setBirthdayStr(Date birthdayStr) {
        this.birthdayStr = birthdayStr;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    public void setQq(String qq) {
        this.qq = qq;
    }

    public void setStudentRemark(String studentRemark) {
        this.studentRemark = studentRemark;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public void setStudentTags(String studentTags) {
        this.studentTags = studentTags;
    }

    public void setTagsStr(String tagsStr) {
        this.tagsStr = tagsStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignupStudentListDto)) {
            return false;
        }
        SignupStudentListDto other = (SignupStudentListDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Long this$gender = this.getGender();
        Long other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)this$gender).equals(other$gender)) {
            return false;
        }
        String this$genderStr = this.getGenderStr();
        String other$genderStr = other.getGenderStr();
        if (this$genderStr == null ? other$genderStr != null : !this$genderStr.equals(other$genderStr)) {
            return false;
        }
        String this$parentName = this.getParentName();
        String other$parentName = other.getParentName();
        if (this$parentName == null ? other$parentName != null : !this$parentName.equals(other$parentName)) {
            return false;
        }
        String this$parentMobile = this.getParentMobile();
        String other$parentMobile = other.getParentMobile();
        if (this$parentMobile == null ? other$parentMobile != null : !this$parentMobile.equals(other$parentMobile)) {
            return false;
        }
        Long this$birthday = this.getBirthday();
        Long other$birthday = other.getBirthday();
        if (this$birthday == null ? other$birthday != null : !((Object)this$birthday).equals(other$birthday)) {
            return false;
        }
        Date this$birthdayStr = this.getBirthdayStr();
        Date other$birthdayStr = other.getBirthdayStr();
        if (this$birthdayStr == null ? other$birthdayStr != null : !((Object)this$birthdayStr).equals(other$birthdayStr)) {
            return false;
        }
        String this$mail = this.getMail();
        String other$mail = other.getMail();
        if (this$mail == null ? other$mail != null : !this$mail.equals(other$mail)) {
            return false;
        }
        String this$qq = this.getQq();
        String other$qq = other.getQq();
        if (this$qq == null ? other$qq != null : !this$qq.equals(other$qq)) {
            return false;
        }
        String this$studentRemark = this.getStudentRemark();
        String other$studentRemark = other.getStudentRemark();
        if (this$studentRemark == null ? other$studentRemark != null : !this$studentRemark.equals(other$studentRemark)) {
            return false;
        }
        String this$pinyin = this.getPinyin();
        String other$pinyin = other.getPinyin();
        if (this$pinyin == null ? other$pinyin != null : !this$pinyin.equals(other$pinyin)) {
            return false;
        }
        String this$studentTags = this.getStudentTags();
        String other$studentTags = other.getStudentTags();
        if (this$studentTags == null ? other$studentTags != null : !this$studentTags.equals(other$studentTags)) {
            return false;
        }
        String this$tagsStr = this.getTagsStr();
        String other$tagsStr = other.getTagsStr();
        return !(this$tagsStr == null ? other$tagsStr != null : !this$tagsStr.equals(other$tagsStr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignupStudentListDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Long $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)$gender).hashCode());
        String $genderStr = this.getGenderStr();
        result = result * 59 + ($genderStr == null ? 43 : $genderStr.hashCode());
        String $parentName = this.getParentName();
        result = result * 59 + ($parentName == null ? 43 : $parentName.hashCode());
        String $parentMobile = this.getParentMobile();
        result = result * 59 + ($parentMobile == null ? 43 : $parentMobile.hashCode());
        Long $birthday = this.getBirthday();
        result = result * 59 + ($birthday == null ? 43 : ((Object)$birthday).hashCode());
        Date $birthdayStr = this.getBirthdayStr();
        result = result * 59 + ($birthdayStr == null ? 43 : ((Object)$birthdayStr).hashCode());
        String $mail = this.getMail();
        result = result * 59 + ($mail == null ? 43 : $mail.hashCode());
        String $qq = this.getQq();
        result = result * 59 + ($qq == null ? 43 : $qq.hashCode());
        String $studentRemark = this.getStudentRemark();
        result = result * 59 + ($studentRemark == null ? 43 : $studentRemark.hashCode());
        String $pinyin = this.getPinyin();
        result = result * 59 + ($pinyin == null ? 43 : $pinyin.hashCode());
        String $studentTags = this.getStudentTags();
        result = result * 59 + ($studentTags == null ? 43 : $studentTags.hashCode());
        String $tagsStr = this.getTagsStr();
        result = result * 59 + ($tagsStr == null ? 43 : $tagsStr.hashCode());
        return result;
    }

    public String toString() {
        return "SignupStudentListDto(id=" + this.getId() + ", name=" + this.getName() + ", mobile=" + this.getMobile() + ", gender=" + this.getGender() + ", genderStr=" + this.getGenderStr() + ", parentName=" + this.getParentName() + ", parentMobile=" + this.getParentMobile() + ", birthday=" + this.getBirthday() + ", birthdayStr=" + this.getBirthdayStr() + ", mail=" + this.getMail() + ", qq=" + this.getQq() + ", studentRemark=" + this.getStudentRemark() + ", pinyin=" + this.getPinyin() + ", studentTags=" + this.getStudentTags() + ", tagsStr=" + this.getTagsStr() + ")";
    }
}

