/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static String write2JsonObject(Object ols) {
        ObjectMapper objectMapper = new ObjectMapper();
        StringWriter w = new StringWriter();
        try {
            objectMapper.writeValue((Writer)w, ols);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return w.toString();
    }

    public static <T> List<Object> serializeEnumTypes(Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        Method[] methods = clazz.getMethods();
        Method mValues = null;
        Method mName = null;
        Method mGetValue = null;
        try {
            Object[] types;
            mValues = clazz.getMethod("values", null);
            mName = clazz.getMethod("name", null);
            mGetValue = clazz.getMethod("getValue", null);
            for (Object t : types = (Object[])mValues.invoke(null, (Object[])null)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", mName.invoke(t, (Object[])null));
                map.put("name", mGetValue.invoke(t, (Object[])null));
                result.add(map);
            }
        }
        catch (Exception e) {
            log.warn("JsonUtil.serializeTypes exception");
            return result;
        }
        return result;
    }

    public static List<Map<String, Object>> parseJSON2List(String jsonStr) {
        JSONArray jsonArr = JSONArray.fromObject((Object)jsonStr);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (JSONObject json2 : jsonArr) {
            list.add(JsonUtil.parseJSON2Map(json2.toString()));
        }
        return list;
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JSONObject json2 : (JSONArray)v) {
                    list.add(JsonUtil.parseJSON2Map(json2.toString()));
                }
                map.put(k.toString(), list);
                continue;
            }
            map.put(k.toString(), v);
        }
        return map;
    }

    public static Map<String, Object> jsonToMap(String jsonStr) {
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        return JsonUtil.parserJSONObj(json);
    }

    private static Map<String, Object> parserJSONObj(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object k : jsonObject.keySet()) {
            Object v = jsonObject.get(k);
            if (v instanceof JSONArray) {
                map.put(k.toString(), JsonUtil.parserJSONArray((JSONArray)v));
                continue;
            }
            if (v instanceof JSONObject) {
                map.put(k.toString(), JsonUtil.parserJSONObj((JSONObject)v));
                continue;
            }
            map.put(k.toString(), v.toString());
        }
        return map;
    }

    public static List<?> parserJSONArray(JSONArray jsonArray) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (JSONObject json2 : jsonArray) {
            list.add(JsonUtil.parseJSON2Map(json2.toString()));
        }
        return list;
    }

    public static List<Map<String, Object>> getListByUrl(String url) {
        try {
            String line;
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return JsonUtil.parseJSON2List(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getMapByUrl(String url) {
        try {
            String line;
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return JsonUtil.parseJSON2Map(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        String json = "{'code':0,'date':{'list':[{'id':1,'name':'rezar'},{'id':1,'name':'waba'}]}}";
        Map<String, Object> map = JsonUtil.jsonToMap(json);
        System.out.println(map);
    }
}

