/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.constant.RecordTemplateType;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordTemplateDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordTemplate;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountModuleAuthService;
import com.baijia.tianxiao.sal.student.api.TxCustomRecordTemplateService;
import com.baijia.tianxiao.sal.student.dto.TxCustomRecordTemplateDto;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TxCustomRecordTemplateServiceImpl
implements TxCustomRecordTemplateService {
    private static final Logger log = LoggerFactory.getLogger(TxCustomRecordTemplateServiceImpl.class);
    @Autowired
    private TxCustomRecordTemplateDao txCustomRecordTemplateDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxAccountModuleAuthService txAccountModuleAuthService;

    @Override
    public List<TxCustomRecordTemplateDto> listTemplates(Long orgId, Integer disable) {
        ArrayList result = Lists.newArrayList();
        if (!this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE)) {
            return result;
        }
        List templates = this.txCustomRecordTemplateDao.getTemplatesByOrgId(orgId, disable);
        for (TxCustomRecordTemplate template : templates) {
            result.add(this.transform(template));
        }
        return result;
    }

    private TxCustomRecordTemplateDto transform(TxCustomRecordTemplate template) {
        TxCustomRecordTemplateDto dto = new TxCustomRecordTemplateDto();
        dto.setTemplateId(template.getId());
        dto.setName(template.getName());
        dto.setType(template.getType());
        dto.setDisable(template.getDisable());
        dto.setSort(template.getSort());
        return dto;
    }

    @Override
    public TxCustomRecordTemplateDto addTemplate(Long orgId, String name, Integer type) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)name) && name.length() <= 16 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc716\u4e2a\u5b57\u7b26");
        String numStr = this.txAccountModuleAuthService.getModuleAuthValueStr(orgId, ClientType.CUSTOM_RECORD_TEMPLATE);
        Integer num = Integer.valueOf(numStr);
        BussinessPreconditions.checkArgument((this.txCustomRecordTemplateDao.countByOrgId(orgId) < num ? 1 : 0) != 0, (String)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u4e0d\u80fd\u8d85\u8fc7%s\u4e2a, \u8bf7\u5220\u9664\u4e00\u4e9b\u8bb0\u5f55\u9879\u540e\u518d\u6dfb\u52a0", (Object[])new Object[]{num});
        BussinessPreconditions.checkArgument((RecordTemplateType.getByCode((Integer)type) != null ? 1 : 0) != 0, (Object)"type error!");
        TxCustomRecordTemplate template = new TxCustomRecordTemplate();
        template.setName(name);
        template.setOrgId(orgId);
        template.setType(type);
        template.setSort(Integer.valueOf(this.txCustomRecordTemplateDao.getMaxSortByOrgId(orgId) + 1));
        template.setDisable(Integer.valueOf(Flag.FALSE.getInt()));
        template.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        template.setCreateTime(new Date());
        template.setUpdateTime(template.getCreateTime());
        this.txCustomRecordTemplateDao.save((Object)template, new String[0]);
        return this.transform(template);
    }

    @Override
    public TxCustomRecordTemplateDto editTemplate(Long orgId, Long templateId, String name, Integer disable, Integer type) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        TxCustomRecordTemplate template = (TxCustomRecordTemplate)this.txCustomRecordTemplateDao.getById((Serializable)templateId, new String[0]);
        BussinessPreconditions.checkArgument((null != template && orgId.longValue() == template.getOrgId().longValue() ? 1 : 0) != 0, (Object)"\u6a21\u677f\u4fe1\u606f\u5df2\u7ecf\u6539\u53d8\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
        if (null != name) {
            BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)name) && name.length() <= 16 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc716\u4e2a\u5b57\u7b26");
            template.setName(name);
        }
        if (null != disable) {
            BussinessPreconditions.checkArgument((disable.intValue() == Flag.FALSE.getInt() || disable.intValue() == Flag.TRUE.getInt() ? 1 : 0) != 0, (Object)"disable value error!");
            template.setDisable(disable);
            template.setSort(Integer.valueOf(this.txCustomRecordTemplateDao.getMaxSortByOrgId(orgId) + 1));
        }
        if (null != type) {
            BussinessPreconditions.checkArgument((RecordTemplateType.getByCode((Integer)type) != null ? 1 : 0) != 0, (Object)"type error!");
            template.setType(type);
        }
        template.setUpdateTime(new Date());
        this.txCustomRecordTemplateDao.update((Object)template, new String[]{"name", "updateTime", "disable", "type", "sort"});
        return this.transform(template);
    }

    @Override
    public void deleteByTemplateId(Long orgId, Long templateId) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        TxCustomRecordTemplate template = (TxCustomRecordTemplate)this.txCustomRecordTemplateDao.getById((Serializable)templateId, new String[0]);
        BussinessPreconditions.checkArgument((null != template && orgId.longValue() == template.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find comment!");
        template.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        template.setUpdateTime(new Date());
        this.txCustomRecordTemplateDao.update((Object)template, new String[]{"isdel", "updateTime"});
        log.info("delete template by id:{}, template:{}", (Object)templateId, (Object)template);
        List commentList = this.txStudentCommentDao.getTemplateCommentHistory(orgId, templateId, null, null, null);
        commentList.parallelStream().forEach(txStudentComment -> {
            txStudentComment.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
            txStudentComment.setUpdateTime(new Date());
            this.txStudentCommentDao.update(txStudentComment, new String[]{"isdel", "updateTime"});
        });
        log.info("delete comments by templateId:{}, size:{}", (Object)templateId, (Object)commentList.size());
    }

    @Override
    public void batchSetSort(Long orgId, Map<Long, Integer> map) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        if (MapUtils.isEmpty(map)) {
            return;
        }
        BussinessPreconditions.checkArgument((map.size() == Sets.newHashSet(map.values()).size() ? 1 : 0) != 0, (Object)"map contains duplicated values!");
        List list = this.txCustomRecordTemplateDao.getByIds(map.keySet(), new String[]{"id", "sort"});
        Date updateTime = new Date();
        for (TxCustomRecordTemplate template : list) {
            Integer sort = map.get(template.getId());
            BussinessPreconditions.checkArgument((null != sort ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"sort value can not be null!");
            if (sort.intValue() == template.getSort().intValue()) continue;
            template.setSort(sort);
            template.setUpdateTime(updateTime);
            this.txCustomRecordTemplateDao.update((Object)template, new String[]{"sort", "updateTime"});
        }
    }

    @Override
    public TxCustomRecordTemplateDto getTemplate(Long orgId, Long templateId) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        TxCustomRecordTemplate template = this.txCustomRecordTemplateDao.getByTemplateId(templateId);
        BussinessPreconditions.checkArgument((null != template ? 1 : 0) != 0, (Object)"\u6a21\u677f\u4fe1\u606f\u5df2\u7ecf\u6539\u53d8\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\u9762\u91cd\u8bd5");
        return this.transform(template);
    }
}

