/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.dao.TxCustomRecordKeyDao;
import com.baijia.tianxiao.dal.roster.po.TxCustomRecordKey;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.sal.organization.constant.ClientType;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountModuleAuthService;
import com.baijia.tianxiao.sal.student.api.TxCustomRecordKeyService;
import com.baijia.tianxiao.sal.student.dto.TxCustomRecordKeyDto;
import com.baijia.tianxiao.util.exception.BussinessPreconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;

@Controller
@Transactional
public class TxCustomRecordKeyServiceImpl
implements TxCustomRecordKeyService {
    private static final Logger log = LoggerFactory.getLogger(TxCustomRecordKeyServiceImpl.class);
    @Autowired
    private TxCustomRecordKeyDao txCustomRecordKeyDao;
    @Autowired
    private TxAccountModuleAuthService txAccountModuleAuthService;

    @Override
    public List<TxCustomRecordKeyDto> listKeys(Long orgId, Long templateId, Integer disable) {
        ArrayList result = Lists.newArrayList();
        if (!this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE)) {
            return result;
        }
        List keys = this.txCustomRecordKeyDao.getKeysByOrgId(orgId, templateId, disable);
        for (TxCustomRecordKey key : keys) {
            result.add(this.transform(key));
        }
        return result;
    }

    private TxCustomRecordKeyDto transform(TxCustomRecordKey key) {
        TxCustomRecordKeyDto dto = new TxCustomRecordKeyDto();
        dto.setKeyId(key.getId());
        dto.setKeyName(key.getKeyName());
        dto.setDisable(key.getDisable());
        dto.setSort(key.getSort());
        return dto;
    }

    @Override
    public TxCustomRecordKeyDto addKey(Long orgId, Long templateId, String keyName) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)keyName) && keyName.length() <= 20 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        BussinessPreconditions.checkArgument((this.txCustomRecordKeyDao.countByOrgId(orgId, templateId) < 50 ? 1 : 0) != 0, (Object)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc750\u4e2a, \u8bf7\u5220\u9664\u4e00\u4e9b\u5b57\u6bb5\u9879\u540e\u518d\u6dfb\u52a0");
        TxCustomRecordKey key = new TxCustomRecordKey();
        key.setTemplateId(templateId);
        key.setKeyName(keyName);
        key.setOrgId(orgId);
        key.setSort(Integer.valueOf(this.txCustomRecordKeyDao.getMaxSortByOrgId(orgId, templateId) + 1));
        key.setDisable(Integer.valueOf(Flag.FALSE.getInt()));
        key.setIsdel(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        key.setCreateTime(new Date());
        key.setUpdateTime(key.getCreateTime());
        this.txCustomRecordKeyDao.save((Object)key, new String[0]);
        return this.transform(key);
    }

    @Override
    public TxCustomRecordKeyDto editKey(Long orgId, Long keyId, String keyName, Integer disable) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        TxCustomRecordKey key = (TxCustomRecordKey)this.txCustomRecordKeyDao.getById((Serializable)keyId, new String[0]);
        BussinessPreconditions.checkArgument((null != key && orgId.longValue() == key.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find key!");
        if (null != keyName) {
            BussinessPreconditions.checkArgument((StringUtils.isNotBlank((CharSequence)keyName) && keyName.length() <= 20 ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"\u81ea\u5b9a\u4e49\u8bb0\u5f55\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u8d85\u8fc720\u4e2a\u5b57\u7b26");
            key.setKeyName(keyName);
        }
        if (null != disable) {
            BussinessPreconditions.checkArgument((disable.intValue() == Flag.FALSE.getInt() || disable.intValue() == Flag.TRUE.getInt() ? 1 : 0) != 0, (Object)"disable value error!");
            key.setDisable(disable);
            if (disable.intValue() == Flag.FALSE.getInt() && disable.intValue() != key.getDisable().intValue()) {
                key.setSort(Integer.valueOf(this.txCustomRecordKeyDao.getMaxSortByOrgId(orgId, key.getTemplateId()) + 1));
            }
        }
        key.setUpdateTime(new Date());
        this.txCustomRecordKeyDao.update((Object)key, new String[]{"keyName", "updateTime", "disable", "sort"});
        return this.transform(key);
    }

    @Override
    public void deleteByKeyId(Long orgId, Long keyId) {
        TxCustomRecordKey key = (TxCustomRecordKey)this.txCustomRecordKeyDao.getById((Serializable)keyId, new String[0]);
        BussinessPreconditions.checkArgument((null != key && orgId.longValue() == key.getOrgId().longValue() ? 1 : 0) != 0, (Object)"can not find key!");
        key.setIsdel(Integer.valueOf(DeleteStatus.DELETED.getValue()));
        key.setUpdateTime(new Date());
        this.txCustomRecordKeyDao.update((Object)key, new String[]{"isdel", "updateTime"});
    }

    @Override
    public void batchSetSort(Long orgId, Map<Long, Integer> map) {
        BussinessPreconditions.checkArgument((boolean)this.txAccountModuleAuthService.hasClientType(orgId, ClientType.CUSTOM_RECORD_TEMPLATE), (Object)"\u65e0\u81ea\u5b9a\u4e49\u8bb0\u5f55\u6a21\u677f\u6743\u9650");
        if (MapUtils.isEmpty(map)) {
            return;
        }
        BussinessPreconditions.checkArgument((map.size() == Sets.newHashSet(map.values()).size() ? 1 : 0) != 0, (Object)"map contains duplicated values!");
        List list = this.txCustomRecordKeyDao.getByIds(map.keySet(), new String[]{"id", "sort"});
        Date updateTime = new Date();
        for (TxCustomRecordKey key : list) {
            Integer sort = map.get(key.getId());
            BussinessPreconditions.checkArgument((null != sort ? 1 : 0) != 0, (CommonErrorCode)CommonErrorCode.PARAM_ERROR, (Object)"sort value can not be null!");
            if (sort.intValue() == key.getSort().intValue()) continue;
            key.setSort(sort);
            key.setUpdateTime(updateTime);
            this.txCustomRecordKeyDao.update((Object)key, new String[]{"sort", "updateTime"});
        }
    }
}

