/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.impl;

import java.math.BigDecimal;
import java.util.*;

import com.baijia.tianxiao.constants.CommonConstants;
import com.baijia.tianxiao.dal.activity.constants.CommonConstant;
import com.baijia.tianxiao.sal.common.api.KexiaoApiService;
import com.baijia.tianxiao.sal.common.dto.kexiao.KexiaoStatistics;
import com.baijia.tianxiao.sal.common.utils.KexiaoUtil;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseListResponse;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.StringUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentKexiaoRecordDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dto.KexiaoStatisticss;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentPurchaseReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentCourseInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @author shanyu
 * @version 1.0
 * @title OrgStudentCourseService
 * @date 2015年12月11日
 */
@Slf4j
@Service
public class OrgStudentCourseServiceImpl implements OrgStudentCourseService {
    private static final String TIP_INFO = "学员在该班级的剩余学费及课次信息不完整，无法核算课消，可至电脑端进行补充。";
    private static final String TIP_INFO_URL = "http://www.baidu.com";

    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;
    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgClassLessonDao orgClassLessonDao;
    @Autowired
    private CoursePurchaseDao coursePurchaseDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgStudentKexiaoRecordDao orgStudentKexiaoRecordDao;
    @Autowired
    private StudentKexiaoStatisticsApiService studSentKexiaoStatisticsApiService;
    @Autowired
    private KexiaoApiService kexiaoApiService;
    @Autowired
    private TxAccountPermissionService permissionService;

    @Override
    public List<StudentCourseInfoReponseDto> getCurrentStudnetCourseInfos(
            StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
                || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        List<OrgStudentCourse> courseList = this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(),
                StudentCourseStatus.NORMAL.getCode(), null);
        Map<Long, StudentCourseInfoReponseDto> map =
                reviseStudentCourseInfoDto(courseList, orgId, orgStudent.getId(), orgStudent.getUserId());
        List<StudentCourseInfoReponseDto> retList = new ArrayList<>();
        for (StudentCourseInfoReponseDto dto : map.values()) {
            if (dto.getStatus() == StudentCourseStatus.NORMAL.getCode()) {
                retList.add(dto);
            }
        }
        this.studSentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, retList, 2);
        log.info("retList is:{}", retList);

        Iterator<StudentCourseInfoReponseDto> iterator = retList.iterator();
        boolean hasPermission = permissionService.checkPermission(orgId,studentCommenRequestDto.getCasCadeId(), DeviceType.APP, TXPermissionConst.REMAINNING_FEE.getpCode());
        while (iterator.hasNext()) {
            StudentCourseInfoReponseDto dto = iterator.next();
            KexiaoStatistics statistics =kexiaoApiService.queryKexiaoStatByStudentClass(orgId,orgStudent.getUserId(),dto.getCourseId());
            kexiaoApiService.fillKexiaoData(dto,statistics);

            if (statistics.getLeftNumber()<=0 && statistics.getTotalNumber()>0) {
                iterator.remove();
                continue;
            }
            if(statistics.getLeftNumber()<=0 && statistics.getTransferNumber()>0){
                iterator.remove();
                continue;
            }
            fillPresentAndTipInfo(dto);
            if(!hasPermission){
                dto.setRemainTuition(CommonConstants.NO_PERMISSION_SHOW);
            }
        }
        return retList;
    }

    @Override
    public StudentCourseListResponse getCurrentStudentCourseList(Long orgId,StudentCommenRequestDto request) {
        return wrapperStudentCourseList(getCurrentStudnetCourseInfos(request,orgId));
    }

    @Override
    public StudentCourseListResponse getHistoryStudentCourseList(Long orgId, StudentCommenRequestDto request) {
        return wrapperStudentCourseList(getHistoryStudnetCourseInfos(request,orgId));
    }

    private StudentCourseListResponse wrapperStudentCourseList(List<StudentCourseInfoReponseDto> dtoList){
        StudentCourseListResponse response = new StudentCourseListResponse();
        long sumTotalTimes = 0;
        long sumFinishedTimes = 0;
        long sumLeftTimes = 0;
        long sumTotalHour = 0;
        long sumFinishedHour = 0;
        long sumLeftHour = 0;
        for (StudentCourseInfoReponseDto dto:dtoList){
            ChargeUnit unit = ChargeUnit.getByCode(dto.getChargeUnit());
            switch (unit){
                case BY_TIMES:
                    response.getTimesCourses().add(dto);
                    sumTotalTimes += dto.getTotalClassTimesForKexiaoValue();
                    sumFinishedTimes += dto.getFinishClassTimesForKexiaoValue();
                    sumLeftTimes += dto.getLeftClassTimesForKexiaoValue();
                    break;
                case BY_HOUR:
                case BY_HALF_HOUR:
                    response.getHourCourses().add(dto);
                    sumTotalHour += dto.getTotalClassTimesForKexiaoValue();
                    sumFinishedHour += dto.getFinishClassTimesForKexiaoValue();
                    sumLeftHour += dto.getLeftClassTimesForKexiaoValue();
                    break;
                default:
                    log.info("[StudentCourse] chargeType error.type="+dto.getChargeUnit());
            }
        }
        response.setSumTotalTimes(String.valueOf(sumTotalTimes));
        response.setSumFinishedTimes(String.valueOf(sumFinishedTimes));
        response.setSumLeftTimes(String.valueOf(sumLeftTimes));
        response.setSumTotalHour(KexiaoUtil.classHourFormat(sumTotalHour));
        response.setSumFinishedHour(KexiaoUtil.classHourFormat(sumFinishedHour));
        response.setSumLeftHour(KexiaoUtil.classHourFormat(sumLeftHour));
        return response;
    }


    /**
     * @param dto
     */
    private void fillPresentAndTipInfo(StudentCourseInfoReponseDto dto) {
        boolean currentCourseCanSetInfo = dto.isCurrentCourseCanSetInfo();
        if (currentCourseCanSetInfo) {
            Integer totalCount = dto.getTotalClassTimesForKexiaoValue();
            Integer finishCount = dto.getFinishClassTimesForKexiaoValue();
            int finishPercent = countClassHour(totalCount, finishCount);
            dto.setFinishPercent(finishPercent);
        }
        if (!currentCourseCanSetInfo) { // !dto.isCanShowKexiaoInfo() ||
            dto.setTipInfo(TIP_INFO);
            dto.setTipInfoUrl(TIP_INFO_URL);
        }
    }

    public static int countClassHour(int totalCount, int finishCount) {
        if (totalCount == 0) {
            return 0;
        }
        BigDecimal b1 = new BigDecimal(finishCount * 100);
        BigDecimal b2 = new BigDecimal(totalCount);
        return b1.divide(b2, 0, BigDecimal.ROUND_HALF_UP).intValue();
    }

    /**
     * List<StudentClassHour> classHourList,
     *
     * @param orgStudentCourseList
     * @param orgId
     * @return
     */
    private Map<Long, StudentCourseInfoReponseDto> reviseStudentCourseInfoDto(
            List<OrgStudentCourse> orgStudentCourseList, Long orgId, Long studentId, Long userId) {
        Map<Long, StudentCourseInfoReponseDto> map = new LinkedHashMap<>();
        Map<Long, OrgStudentCourse> studentCourseMap = new HashMap<>();
        if (orgStudentCourseList == null || orgStudentCourseList.size() < 1) {
            return map;
        } else {
            for (OrgStudentCourse course : orgStudentCourseList) {
                studentCourseMap.put(course.getCourseId(), course);
            }
        }
        log.info("find all courseIds is : {} ", studentCourseMap.keySet());

        List<OrgCourse> courses = orgCourseDao.getByIds(studentCourseMap.keySet());
        Set<Long> parentCourseIds = Sets.newHashSet();
        for (OrgCourse orgCourse : courses) {
            if (orgCourse.getParentId() > 0) {
                parentCourseIds.add(orgCourse.getParentId());
            }
        }

        Set<Integer> casCadeIds = Sets.newHashSet();
        List<Integer> retCascadeIds = GenericsUtils.toFieldList(courses, "cascadeId");
        casCadeIds.addAll(retCascadeIds);

        log.info("all casCadeIds are :{} ", casCadeIds);
        Map<Long, String> txCascadCredentialListByCascdeIds =
                this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(casCadeIds);
        if (casCadeIds.contains(0)) {
            OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
            txCascadCredentialListByCascdeIds.put(0l, orginfo.getContacts());
        }
        log.info("txCascadCredentialListByCascdeIds are :{} ", txCascadCredentialListByCascdeIds);

        Map<Long, OrgCourse> parentCourseMap = Maps.newHashMap();
        if (parentCourseIds.size() > 0) {
            parentCourseMap = orgCourseDao.getOrgCourseMap(parentCourseIds);
        }

        if (courses != null) {
            for (OrgCourse course : courses) {
                StudentCourseInfoReponseDto dto = StudentCourseInfoReponseDto.getInstance(course);
                if (course.getCascadeId() != null) {
                    dto.setHeadTeacher(txCascadCredentialListByCascdeIds.get(course.getCascadeId().longValue()));
                }
                dto.setParentCourseId(course.getParentId());
                dto.setCourseId(course.getId());
                dto.setStudentId(studentId);
                dto.setUserId(userId);
                if (dto.getParentId() > 0) {
                    OrgCourse parentCourse = parentCourseMap.get(dto.getParentId());
                    if (parentCourse != null) {
                        dto.setCourseNumber(parentCourse.getNumber());
                    }
                }
                OrgStudentCourse studentCourse = studentCourseMap.get(course.getId());
                dto.setStatus(studentCourse.getStatus());
                dto.setBuyCount(studentCourse.getLessonCount());
                dto.setChargeUnit(
                        course.getChargeUnit() == null || course.getChargeUnit() == ChargeUnit.BY_OTHER.getCode() ? 1
                                : course.getChargeUnit());
                map.put(course.getId(), dto);
            }
        }
        return map;
    }

    @Override
    public List<StudentCourseInfoReponseDto> getHistoryStudnetCourseInfos(
            StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
                || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }

        List<OrgStudentCourse> courseList =
                this.orgStudentCourseDao.getOrgCourseIds(orgId, orgStudent.getUserId(), null, null);

        Map<Long, StudentCourseInfoReponseDto> map =
                reviseStudentCourseInfoDto(courseList, orgId, orgStudent.getId(), orgStudent.getUserId());

        this.studSentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, map.values(), 2);
        boolean hasPermission = permissionService.checkPermission(orgId,studentCommenRequestDto.getCasCadeId(), DeviceType.APP, TXPermissionConst.REMAINNING_FEE.getpCode());
        List<StudentCourseInfoReponseDto> retList = new ArrayList<>();
        for (StudentCourseInfoReponseDto dto : map.values()) {
            fillPresentAndTipInfo(dto);
            KexiaoStatistics statistics =kexiaoApiService.queryKexiaoStatByStudentClass(orgId,orgStudent.getUserId(),dto.getCourseId());
            log.info("KexiaoStatistics={}",statistics);
            kexiaoApiService.fillKexiaoData(dto,statistics);
            if(!hasPermission){
                dto.setRemainTuition(CommonConstants.NO_PERMISSION_SHOW);
            }
            if (dto.getStatus() == StudentCourseStatus.WITHDRAW.getCode()) {
                retList.add(dto);
            } else if (dto.getStatus() == StudentCourseStatus.TRANSFER.getCode()) {// 转班或退班
                retList.add(dto);
            } else {
                long leftClassTimesForKexiaoValue = statistics.getLeftNumber();
                long totalClassTimesForKexiaoValue = statistics.getTotalNumber();
                if ((leftClassTimesForKexiaoValue <= 0 && totalClassTimesForKexiaoValue != 0)) {
                    retList.add(dto);
                    continue;
                }
                if(statistics.getLeftNumber()<=0 && statistics.getTransferNumber()>0){
                    retList.add(dto);
                    continue;
                }
            }
        }
        map.clear();
        return retList;
    }

    /**
     * @param orgId
     * @param studentId
     * @param userId
     * @param studentCourseInfoReponseDtoList
     */
    @Deprecated
    public void setKexiaoStatistics(Long orgId, Long studentId, Long userId,
                                    List<StudentCourseInfoReponseDto> studentCourseInfoReponseDtoList) {
        if (GenericsUtils.isNullOrEmpty(studentCourseInfoReponseDtoList)) {
            return;
        }
        List<Long> courseIds = GenericsUtils.toFieldList(studentCourseInfoReponseDtoList, "courseId");
        Collection<Long> studentIds = Arrays.asList(studentId);
        List<KexiaoStatisticss> findKexiaoStatistics =
                orgStudentKexiaoRecordDao.findKexiaoStatistics(orgId, studentIds, courseIds);
        Collection<Long> userIds = Arrays.asList(userId);
        List<OrgStudentSignupStatistics> findAllOrgStudentSigupStatistics =
                this.orgSignupCourseDao.findAllOrgStudentSignupStatistics(orgId, userIds, courseIds);
        Map<Long, OrgStudentSignupStatistics> orgStudentSigupStatisticsMap =
                GenericsUtils.toFieldMap(findAllOrgStudentSigupStatistics, "courseId");

        Map<Long, KexiaoStatisticss> kexiaoStaisticsMap = GenericsUtils.toFieldMap(findKexiaoStatistics, "courseId");
        Set<Long> tempSets = Sets.newHashSetWithExpectedSize(1);
        tempSets.add(userId);
        for (StudentCourseInfoReponseDto dto : studentCourseInfoReponseDtoList) {
            Long courseId = dto.getCourseId();
            Integer totalCount = dto.getTotalClassTimes();
            Integer finishCount = dto.getFinishClassTimes();
            KexiaoStatisticss kexiaoStatisticss = kexiaoStaisticsMap.get(courseId);
            OrgStudentSignupStatistics orgStudentSigupStatistics = orgStudentSigupStatisticsMap.get(courseId);
            Map<Long, Boolean> byCourseIdsAndStudentIds =
                    this.orgSignupCourseDao.canShowTotalCount(orgId, userIds, Arrays.asList(courseId));
            boolean canSetInfo = byCourseIdsAndStudentIds.get(userId);
            if (dto.getChargeUnit() == ChargeUnit.BY_HALF_HOUR.getCode()
                    || dto.getChargeUnit() == ChargeUnit.BY_HOUR.getCode()
                    || dto.getChargeUnit() == ChargeUnit.BY_MINUTE.getCode()) {
                dto.setFinishClassTimesForKexiao(String.valueOf(kexiaoStatisticss.getKexiaoTime() / 60F));
                if (canSetInfo) {
                    dto.setTotalClassTimesForKexiao(
                            String.valueOf(StudentCourseInfoReponseDto.countClassHour(totalCount, dto.getChargeUnit())));
                    dto.setLeftClassTimesForKexiao(String.valueOf(
                            StudentCourseInfoReponseDto.countClassHour(totalCount - finishCount, dto.getChargeUnit())));
                } else {
                    dto.setTotalClassTimesForKexiao("--");
                    dto.setLeftClassTimesForKexiao("--");
                }
            } else {
                dto.setFinishClassTimesForKexiao(String.valueOf(finishCount));
                if (canSetInfo) {
                    dto.setTotalClassTimesForKexiao(String.valueOf(totalCount));
                    dto.setLeftClassTimesForKexiao((totalCount == null ? "--"
                            : String.valueOf((dto.getTotalClassTimes() - dto.getFinishClassTimes()))));
                } else {
                    dto.setTotalClassTimesForKexiao("--");
                    dto.setLeftClassTimesForKexiao("--");
                }
            }
            Long kexiaoMoney = kexiaoStatisticss.getKexiaoMoney();
            Long signupMoney = orgStudentSigupStatistics.getPayMoney();
            dto.setRemainTuition(String.valueOf((signupMoney - kexiaoMoney) / 100D));
        }
    }

    private StudentCourseInfoReponseDto setClassHour(StudentCourseInfoReponseDto dto, StudentClassHour classHour) {
        dto.setFinishClassTimes(classHour.getFinishCount());
        dto.setTotalClassTimes(classHour.getTotalCount());
        dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
        dto.setCourseType(CourseType.ORG_COURSE.getCode());
        return dto;
    }

    @Override
    public List<OrgStudentPurchaseReponseDto> getStudentPurchases(StudentCommenRequestDto studentCommenRequestDto,
                                                                  Long orgId) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
                || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        return getStudentSignupInfos(orgStudent, account.getNumber().longValue());
    }

    /**
     * 查询学生已报班级数
     */
    @Override
    public int getStudentSignupCourse(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> result = this.getCourseInfoes(po, orgNumber);

        return (result != null && !result.isEmpty()) ? result.size() : 0;
    }

    /**
     * 获取学员课次信息（3810课程）
     *
     * @param po
     * @param orgNumber
     * @return
     */
    private List<StudentCourseInfoReponseDto> getCourseInfoes(OrgStudent po, Long orgNumber) {
        List<StudentCourseInfoReponseDto> courseDtos = Lists.newArrayList();
        List<OrgSignupInfo> cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null,
                PayStatus.SUCESS.getCode(), "totalPrices", "signupPurchaseId"); // 报名订单

        List<CoursePurchase> mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), 0l,
                CourseType.ORG_COURSE.getCode(), PayStatus.SUCESS.getCode());// m站订单

        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> purchaseIds = Sets.newHashSet(); // 报名订单编号
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        List<OrgSignupCourse> sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map<Long, String> nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
        // 机构课程总课时
        Map<Long, Integer> lessonTimeMap =
                this.orgClassLessonDao.getLessonTimemap(courseIds, null, po.getOrgId(), DeleteStatus.NORMAL.getValue());

        // 机构课程已上课次
        Map<Long, Integer> finishLessonTimeMap = this.orgClassLessonDao.getLessonTimemap(courseIds, new Date(),
            po.getOrgId(), DeleteStatus.NORMAL.getValue());

        for (OrgSignupCourse purchase : sinupCourses) {
            StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getOrgCourseId());
            dto.setCourseNumber(purchase.getOrgCourseNumber().longValue());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName(nameMap.get(purchase.getOrgCourseId()));
            if (lessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setTotalClassTimes(lessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getOrgCourseId()) != null) {
                dto.setFinishClassTimes(finishLessonTimeMap.get(purchase.getOrgCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }

        for (CoursePurchase purchase : mPurchase) {
            StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
            dto.setCourseId(purchase.getCourseId());
            dto.setCourseNumber(purchase.getCourseNumber().longValue());
            dto.setCourseType(CourseType.ORG_COURSE.getCode());
            dto.setCourseName(nameMap.get(purchase.getCourseId()));
            if (lessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setTotalClassTimes(lessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setTotalClassTimes(0);
            }
            if (finishLessonTimeMap.get(purchase.getCourseId()) != null) {
                dto.setFinishClassTimes(finishLessonTimeMap.get(purchase.getCourseId()));
            } else {
                dto.setFinishClassTimes(0);
            }
            dto.setLeftClassTimes(dto.getTotalClassTimes() - dto.getFinishClassTimes());
            courseDtos.add(dto);
        }
        log.debug("course list={}", courseDtos);
        return courseDtos;
    }

    /**
     * 获取学员报名课程信息（3810课程）
     *
     * @param po
     * @param orgNumber
     * @return
     */
    private List<OrgStudentPurchaseReponseDto> getStudentSignupInfos(OrgStudent po, Long orgNumber) {
        List<OrgStudentPurchaseReponseDto> courseDtos = Lists.newArrayList();
        List<OrgSignupInfo> cashpurchase = this.orgSignupInfoDao.getPurchases(po.getUserId(), orgNumber, null,
                PayStatus.SUCESS.getCode(), "totalPrices", "signupPurchaseId"); // 报名订单

        List<CoursePurchase> mPurchase = this.coursePurchaseDao.getCoursePurchaseList(po.getOrgId(), po.getUserId(), 0l,
            CourseType.ORG_COURSE.getCode(), PayStatus.SUCESS.getCode());// m站订单

        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> purchaseIds = Sets.newHashSet(); // 报名订单编号
        for (OrgSignupInfo orgSignupInfo : cashpurchase) {
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        for (CoursePurchase coursePurchase : mPurchase) {
            courseIds.add(coursePurchase.getCourseId());
        }
        Map<Long, String> nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
        if (CollectionUtils.isNotEmpty(purchaseIds)) {
            List<OrgSignupCourse> sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds);
            for (OrgSignupCourse purchase : sinupCourses) {
                OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
                dto.setCourseNumber(purchase.getOrgCourseNumber().longValue());
                dto.setCourseName(nameMap.get(purchase.getOrgCourseId()));
                dto.setPayMoney(purchase.getPayPrice().doubleValue() / 100);
                courseDtos.add(dto);
            }
        }
        for (CoursePurchase purchase : mPurchase) {
            OrgStudentPurchaseReponseDto dto = new OrgStudentPurchaseReponseDto();
            dto.setCourseNumber(purchase.getCourseNumber().longValue());
            dto.setCourseName(nameMap.get(purchase.getCourseId()));
            dto.setPayMoney(purchase.getPayMoney().doubleValue());
            courseDtos.add(dto);
        }
        return courseDtos;
    }

    @Override
    public OrgStudentCourse getBySidAndCid(Long orgId, Long studentId, Long courseId) {

        return orgStudentCourseDao.getStudentCourse(orgId, courseId, studentId);

    }

    @Override
    public void saveOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        orgStudentCourseDao.save(orgStudentCourse);
    }

    @Override
    public void updateOrgStudentCourse(OrgStudentCourse orgStudentCourse) {
        orgStudentCourseDao.update(orgStudentCourse);
    }

    @Override
    public Map<CourseTypeEnum,Set<Long>> splitCourseIdsByCourseType(Collection<Long> allIds) {
        Map<CourseTypeEnum,Set<Long>> ret = new HashMap<>();
        List<OrgCourse> courseList = orgCourseDao.getByIds(allIds, "courseType", "id");
        for (OrgCourse course : courseList) {
            CourseTypeEnum courseType = CourseTypeEnum.getByCode(course.getCourseType());
            Set<Long> courseIds = ret.get(courseType);
            if(courseIds==null){
                courseIds = new HashSet<>();
                ret.put(courseType,courseIds);
            }
            courseIds.add(course.getId());
        }

        return ret;
    }

    @Override
    public ArrayListMultimap<Long, Long> getClassStudentIdMap(Long orgId, List<Long> classIds) {
        ArrayListMultimap<Long, Long> data = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty(classIds)) {
            List<OrgStudentCourse> orgStudentCourses = orgStudentCourseDao.getOrgCourseByOrgIdAndIds(orgId, classIds);
            if (CollectionUtils.isNotEmpty(orgStudentCourses)) {
                for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
                    data.put(orgStudentCourse.getCourseId(), orgStudentCourse.getUserId());
                }
            }
        }
        return data;
    }

    @Override
    public int changeNoRealCourseId() {
        List<OrgStudentCourse> list = orgStudentCourseDao.getNoRealCourseIdData();
        log.info("OrgStudentCourseServiceImpl  changeNoRealCourseId == {}", list);
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, OrgStudentCourse> studentCourseMap = GenericsUtils.toFieldMap(list, "courseId");
            Map<Long, OrgCourse> courseMap = orgCourseDao.getOrgCourseMap(studentCourseMap.keySet());
            for (OrgStudentCourse studentCourse : list) {
                OrgCourse orgCourse = courseMap.get(studentCourse.getCourseId());
                if (orgCourse != null) {
                    if (orgCourse.getCourseType().intValue() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                        studentCourse.setRealCourseId(orgCourse.getParentId());
                    } else {
                        studentCourse.setRealCourseId(orgCourse.getId());
                    }
                    orgStudentCourseDao.update(studentCourse, "realCourseId");
                }
            }
        }
        return list.size();
    }
}
