package com.baijia.tianxiao.sal.student.enums;

import java.util.ArrayList;
import java.util.List;

import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldSection;

/**
 * @author Rezar
 * @createDate :Jul 20, 2016 2:04:51 PM
 * @desc :
 */
public enum CustomFieldSections {

    BASE_INFO(1, "基本信息"), OTHER_INFO(2, "其它信息");

    public Integer id;
    public String sectionName;

    private CustomFieldSections(Integer id, String sectionName) {
        this.id = id;
        this.sectionName = sectionName;
    }

    public static List<CustomFieldSection> listAllSections() {
        List<CustomFieldSection> allRet = new ArrayList<>();
        for (CustomFieldSections section : CustomFieldSections.values()) {
            CustomFieldSection cfs = new CustomFieldSection(section.id, section.sectionName);
            allRet.add(cfs);
        }
        return allRet;
    }
    
    public Integer getId(){
        return this.id;
    }
    
    public String getSectionName(){
        return this.sectionName;
    }

}
