
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import lombok.Data;
import org.springframework.stereotype.Component;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Component
@Data
public class DateTimeFieldType extends AbstractCustomFieldType<DateTimeFieldType>  {

    private Long content;

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#matchFieldType()
     */

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.DAY_TIME_DATE;

    }


    @Override
    public String objToJson(DateTimeFieldType obj) {
        return super.toJson(obj);
    }

    @Override
    public DateTimeFieldType jsonToObj(String json) {
        return super.fromJson(json);

    }

    @Override
    public CustomFieldTypeInterface<DateTimeFieldType> instance() {
        return new DateTimeFieldType();
    }

}
