/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class PropertyUtils {
    public static String DATE_FORMAT = "yyyy-MM-dd";
    public static String[] TYPE_SIMPLE = new String[]{"java.lang.Integer", "int", "java.util.Date"};
    public static String TYPE_INTEGER = "java.lang.Integer,int";
    public static String TYPE_DATE = "java.util.Date";

    public static String splitSpace(String str) throws ParseException {
        if (str.contains(" ")) {
            return str.split(" ")[1];
        }
        return str;
    }

    public static boolean isSimpleType(String type) {
        for (int i = 0; i < TYPE_SIMPLE.length; ++i) {
            if (!type.equals(TYPE_SIMPLE[i])) continue;
            return true;
        }
        return false;
    }

    public static Integer parseInteger(String str) {
        if (str == null || str.equals("")) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public static Date parseDate(String str) throws ParseException {
        if (str == null || str.equals("")) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Date date = sdf.parse(str);
        return date;
    }

    public static Object parseObject(Class<?> clazz, String str) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        Object obj;
        if (str == null || str.equals("")) {
            obj = null;
        } else {
            obj = clazz.newInstance();
            Method m = clazz.getMethod("setId", str.getClass());
            m.invoke(obj, str);
        }
        return obj;
    }

    public static Object parseByType(Class<?> clazz, String str) throws ParseException, InstantiationException, IllegalAccessException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Object r = "";
        String clazzName = PropertyUtils.splitSpace(clazz.getName());
        if (PropertyUtils.isSimpleType(clazzName)) {
            if (TYPE_INTEGER.contains(clazzName)) {
                r = PropertyUtils.parseInteger(str);
            } else if (TYPE_DATE.contains(clazzName)) {
                r = PropertyUtils.parseDate(str);
            }
        } else {
            r = PropertyUtils.parseObject(clazz, str);
        }
        return r;
    }

    public static void copyProperties(Map<String, Object> map, Object obj) throws Exception {
        BeanInfo targetbean = Introspector.getBeanInfo(obj.getClass());
        PropertyDescriptor[] propertyDescriptors = targetbean.getPropertyDescriptors();
        block0: for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor pro = propertyDescriptors[i];
            Method wm = pro.getWriteMethod();
            if (wm == null) continue;
            for (String key : map.keySet()) {
                if (!key.toLowerCase().equals(pro.getName().toLowerCase())) continue;
                if (!Modifier.isPublic(wm.getDeclaringClass().getModifiers())) {
                    wm.setAccessible(true);
                }
                Object value = ((String[])map.get(key))[0];
                String pt = PropertyUtils.splitSpace(pro.getPropertyType().getName());
                if (!pt.equals(value.getClass().getName())) {
                    value = PropertyUtils.parseByType(pro.getPropertyType(), value.toString());
                }
                wm.invoke(obj, value);
                continue block0;
            }
        }
    }
}

