/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldTypeFactory
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private static final Map<CustomFieldType, CustomFieldTypeInterface> customFieldSolver = Maps.newHashMap();

    public static <T> CustomFieldTypeInterface<T> findCustomFieldSolver(CustomFieldType type) {
        CustomFieldTypeInterface customFieldTypeInterface = customFieldSolver.get((Object)type);
        if (customFieldTypeInterface != null) {
            return customFieldTypeInterface.instance();
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Map beansOfType = this.applicationContext.getBeansOfType(CustomFieldTypeInterface.class);
        if (GenericsUtils.isNullOrEmpty((Object)beansOfType)) {
            return;
        }
        Collection values = beansOfType.values();
        for (CustomFieldTypeInterface cfti : values) {
            customFieldSolver.put(cfti.matchFieldType(), cfti);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

