/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgTagListResopnseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgStudentTagServiceImpl
implements OrgStudentTagService {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentTagServiceImpl.class);
    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<TagInfoDto> addStudentTag(List<TagInfoDto> tagDtos, Integer type, Long studentId, Long orgId) {
        if (type == null || studentId == null || CollectionUtils.isEmpty(tagDtos)) {
            log.warn("add comments error: type ,studentId or tags is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = null;
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[0]);
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
        } else {
            student = new OrgStudent();
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            student.setOrgId(user.getOrgId());
        }
        if (tagDtos.size() > 30) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAGS);
        }
        List<Object> tags = Lists.newArrayList();
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            tags = this.getTagsByTagDtos(tagDtos, type, student, null);
            this.txStudentTagDao.delTags(student.getUserId(), orgId);
        } else {
            tags = this.getTagsByTagDtos(tagDtos, type, student, studentId);
            this.txStudentTagDao.delTagsByConsulterId(studentId, orgId);
        }
        log.info("tags insert param:{}", (Object)tags);
        this.txStudentTagDao.saveAll((List)tags, new String[0]);
        ArrayList result = Lists.newArrayList();
        for (TxStudentTag txStudentTag : tags) {
            TagInfoDto dto = new TagInfoDto();
            dto.setContent(txStudentTag.getContent());
            dto.setTagId(txStudentTag.getId());
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delStudentTag(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        if (studentCommenRequestDto.getTagId() == null) {
            log.warn("del tag error: tagId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        TxStudentTag tag = (TxStudentTag)this.txStudentTagDao.getById((Serializable)studentCommenRequestDto.getTagId(), new String[0]);
        if (tag == null || tag.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.TAG_NOT_EXIST);
        }
        this.txStudentTagDao.delById((Serializable)tag.getId());
    }

    private void tagDto2Po(TagInfoDto dto, TxStudentTag po, Long consultId, Integer type, OrgStudent student) {
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            po.setUserId(student.getUserId());
        } else {
            po.setConsultUserId(consultId);
        }
        po.setOrgId(student.getOrgId());
        po.setContent(dto.getContent());
    }

    @Override
    @Transactional(readOnly=true)
    public OrgTagListResopnseDto getTags(Integer type, Long studentId, Long orgId) {
        if (type == null || studentId == null) {
            log.warn("add comments error: type ,studentId is null!");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = null;
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            student = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"orgId", "userId"});
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
        } else {
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        OrgTagListResopnseDto resopnse = new OrgTagListResopnseDto();
        Long userId = studentId;
        if (student != null) {
            userId = student.getUserId();
        }
        List tags = this.txStudentTagDao.getTags(userId, orgId, type, new String[0]);
        ArrayList tagsDto = Lists.newArrayList();
        for (TxStudentTag tag : tags) {
            TagInfoDto tagDto = new TagInfoDto();
            this.tagPo2Dto(tagDto, tag);
            tagsDto.add(tagDto);
        }
        resopnse.setTags(tagsDto);
        return resopnse;
    }

    private void tagPo2Dto(TagInfoDto dto, TxStudentTag po) {
        dto.setTagId(po.getId());
        dto.setContent(po.getContent());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mergeTags(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        Map cache = this.txStudentTagDao.getAndCachedTags(destConsultUser.getId(), orgId, Integer.valueOf(StudentType.CONSULT_USER.getCode()));
        List sourceTags = this.txStudentTagDao.getTags(sourceConsultUser.getId(), orgId, Integer.valueOf(StudentType.CONSULT_USER.getCode()), new String[0]);
        if (sourceTags != null && !sourceTags.isEmpty()) {
            for (TxStudentTag tag : sourceTags) {
                if (cache != null && !cache.isEmpty()) {
                    if (cache.containsKey(tag.getContent())) {
                        log.info("delete student tag:orgId:{}, sourceConsultUser:{}, destConsultUser:{}, tag:{}", new Object[]{orgId, sourceConsultUser, destConsultUser, tag});
                        this.txStudentTagDao.delById((Serializable)tag.getId());
                        continue;
                    }
                    log.info("update tag from tag:{}", (Object)tag);
                    tag.setConsultUserId(destConsultUser.getId());
                    tag.setUserId(destConsultUser.getUserId());
                    tag.setUpdateTime(new Date());
                    log.info("to --------- tag:{}", (Object)tag);
                    this.txStudentTagDao.update((Object)tag, new String[]{"consultUserId", "userId", "updateTime"});
                    continue;
                }
                log.info("update tag from tag:{}", (Object)tag);
                tag.setConsultUserId(destConsultUser.getId());
                tag.setUserId(destConsultUser.getUserId());
                tag.setUpdateTime(new Date());
                log.info("to --------- tag:{}", (Object)tag);
                this.txStudentTagDao.update((Object)tag, new String[]{"consultUserId", "userId", "updateTime"});
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchHandleTags(Integer type, Long orgId, Long studentId, List<TagInfoDto> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return;
        }
        if (null == orgId || 0L == orgId || null == studentId || 0L == studentId) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
        }
        if (null == type || type.intValue() != StudentType.CONSULT_USER.getCode() && type.intValue() != StudentType.ORG_STUDENTS.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u5458\u7c7b\u578b\u9519\u8bef");
        }
        OrgStudent orgStudent = null;
        Long paramId = studentId;
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {
            orgStudent = (OrgStudent)this.orgStudentsDao.getById((Serializable)studentId, new String[]{"id", "userId", "delStatus", "orgId"});
            if (null == orgStudent || orgStudent.getOrgId().longValue() != orgId.longValue() || DeleteStatus.DELETED.getValue() == orgStudent.getDelStatus().intValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.STUDENT_NOT_EXIST);
            }
            paramId = orgStudent.getUserId();
        } else {
            orgStudent = new OrgStudent();
            TxConsultUser user = (TxConsultUser)this.txConsultUserDao.getById((Serializable)studentId, new String[0]);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            orgStudent.setOrgId(user.getOrgId());
        }
        for (TagInfoDto tagInfo : tags) {
            TxStudentTag tag;
            if (null != tagInfo.getTagId() && tagInfo.getTagId() > 0L) {
                tag = this.txStudentTagDao.getUniqueTag(tagInfo.getTagId(), orgId, type, paramId, new String[0]);
                if (null == tag) continue;
                if (StringUtils.isNotBlank((CharSequence)tagInfo.getContent())) {
                    tag.setContent(tagInfo.getContent());
                    tag.setUpdateTime(new Date());
                    this.txStudentTagDao.update((Object)tag, new String[]{"content", "updateTime"});
                    continue;
                }
                this.txStudentTagDao.delById((Serializable)tagInfo.getTagId());
                continue;
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{tagInfo.getContent()})) continue;
            tag = new TxStudentTag();
            this.tagDto2Po(tagInfo, tag, studentId, type, orgStudent);
            tag.setCreateTime(new Date());
            tag.setUpdateTime(new Date());
            this.txStudentTagDao.save((Object)tag, Boolean.valueOf(false), new String[0]);
        }
    }

    @Override
    public List<TagInfoDto> getHotTags(Long orgId, Integer listSize, Integer minTagTimes) {
        ArrayList<TagInfoDto> list = new ArrayList<TagInfoDto>();
        List studentTags = this.txStudentTagDao.getHotTags(orgId, listSize, minTagTimes);
        if (!CollectionUtils.isEmpty((Collection)studentTags)) {
            TagInfoDto dto = null;
            for (TxStudentTag txStudentTag : studentTags) {
                dto = new TagInfoDto();
                dto.setContent(txStudentTag.getContent());
                dto.setTagId(-1L);
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public void delTagsByConsulterId(Long consulterId, Long orgId) {
        this.txStudentTagDao.delTagsByConsulterId(consulterId, orgId);
    }

    private List<TxStudentTag> getTagsByTagDtos(List<TagInfoDto> tagDtos, int type, OrgStudent orgStudent, Long consultId) {
        ArrayList<TxStudentTag> tags = new ArrayList<TxStudentTag>();
        for (TagInfoDto tagInfoDto : tagDtos) {
            String content = tagInfoDto.getContent();
            if (content.length() > 15) {
                throw new BussinessException((UniverseErrorCode)StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
            }
            TxStudentTag tag = new TxStudentTag();
            this.tagDto2Po(tagInfoDto, tag, consultId, type, orgStudent);
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public Map<Long, String> getTagsMap(Long orgId, Collection<Long> ids, StudentType type) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        List studentTags = this.txStudentTagDao.getTags(ids, orgId, Integer.valueOf(type.getCode()), new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)studentTags)) {
            String tagsStr = null;
            for (TxStudentTag tag : studentTags) {
                Long crmId = type.getCode() == StudentType.CONSULT_USER.getCode() ? tag.getConsultUserId() : tag.getUserId();
                if (!StringUtils.isNotBlank((CharSequence)tag.getContent())) continue;
                tagsStr = (String)map.get(crmId);
                if (StringUtils.isNotBlank((CharSequence)tagsStr)) {
                    tagsStr = tagsStr + "," + tag.getContent();
                } else {
                    tagsStr = new String();
                    tagsStr = tagsStr + tag.getContent();
                }
                map.put(crmId, tagsStr);
            }
        }
        return map;
    }
}

