/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.push.constant.MessageSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.push.constant.CardType;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.push.constant.MsgUserRole;
import com.baijia.tianxiao.dal.push.dto.content.AudioMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.CardMsgContent;
import com.baijia.tianxiao.dal.push.dto.content.ImageMsgContent;
import com.baijia.tianxiao.dal.push.po.ConsultMessage;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCommentService;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.CreatorDto;
import com.baijia.tianxiao.sal.student.dto.request.RosterCommentRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.util.CommentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentCommentServiceImpl
 * @desc TODO
 * @date 2015年12月4日
 */
@Slf4j
@Service
public class OrgStudentCommentServiceImpl implements OrgStudentCommentService {

    private static int MAX_SYNC_NUM = 100;

    @Autowired
    private OrgStudentDao orgStudentsDao;

    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private CoursePurchaseDao coursePurchaseDao;

    @Autowired
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private CallServiceInfoDao callServiceInfoDao;

    @Autowired
    private OrgPushCallInfoDao orgPushCallInfoDao;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private ConsultMessageService consultMessageService;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private StorageDao storageDao;
    @Autowired
    private TxCascadeCredentialService credentialService;

    @Autowired
    private TXStudentCommentAPIService txStudentCommentAPIService;

    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
    public List<Long> addStudentComment(RosterCommentRequestDto dto, Long orgId) throws Exception {
        Date now = new Date();

        if (!dto.vaildate()) {
            log.warn("add comments error: type ,studentId or comments is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgStudent student = null;

        List<CommentInfoDto> commentDtos = new ArrayList<>();
        try {
            commentDtos = JacksonUtil.str2List(dto.getComments(), CommentInfoDto.class);
            log.info("commentDtos param:{}", commentDtos);
        } catch (Exception e) {
            log.info("json 解析失败 param:{}", e);
        }

        String preInfoFormat = "%s:%s\n";
        String type = "";
        String name = "";
        if (dto.getType().intValue() == StudentType.ORG_STUDENTS.getCode()) {// 机构学员
            student = orgStudentsDao.getById(dto.getStudentId(), "userId", "orgId", "name", "nickName", "mobile");
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
            }
            name = student.getName();
            name = GenericsUtils.isNullOrEmpty(name) ? student.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty(name) ? student.getMobile() : name;
            type = "学员";
        } else {
            student = new OrgStudent();
            TxConsultUser user = txConsultUserDao.getById(dto.getStudentId());
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            name = user.getName();
            name = GenericsUtils.isNullOrEmpty(name) ? user.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty(name) ? user.getMobile() : name;
            type = "线索";
            student.setUserId(user.getUserId());
            student.setOrgId(user.getOrgId().longValue());

            // 修改最后跟进时间
            user.setLastRemindTime(now);
            user.setUpdateTime(now);
            txConsultUserDao.update(user);
        }
        if (GenericsUtils.isNullOrEmpty(name)) {
            name = "";
        }
        String preInfoStr = String.format(preInfoFormat, type, name);

        List<TxStudentComment> comments = Lists.newArrayList();
        for (CommentInfoDto ciDto : commentDtos) {
            TxStudentComment po = new TxStudentComment();
            if (dto.getType() == StudentType.CONSULT_USER.getCode()) {
                po.setConsultUserId(dto.getStudentId());
            }
            po.setUserId(student.getUserId());
            po.setOrgId(orgId);
            po.setSeconds(ciDto.getSeconds());
            po.setSoundId(ciDto.getSoundId());
            po.setStorageIds(ciDto.getStorageIds());
            po.setContent(ciDto.getContent());

            po.setCommentType(ciDto.getCommentType());
            po.setGrowthComments(ciDto.getGrowthComments() != null ? ciDto.getGrowthComments() : Flag.FALSE.getInt());
            po.setNotifyParents(ciDto.getNotifyParents() != null ? ciDto.getNotifyParents() : Flag.FALSE.getInt());
            po.setCreatorCascadeId(dto.getCreatorCascadeId());

            ciDto.setCreatorCascadeId(dto.getCreatorCascadeId());
            if (ciDto.getCommentType() == null) {
                ciDto.setCommentType(0);
            }

            if (StringUtils.isNotBlank(ciDto.getNotifyColleague())) {
                try {
                    // 通知同事
                    sendNotifyToColleague(preInfoStr, ciDto, orgId); // 向子账号进行消息的推送
                } catch (Exception e) {
                    log.error("addStudentComment NotifyColleague error {} ", e);
                }
            }
            comments.add(po);
        }

        this.txStudentCommentDao.saveAll(comments);
        List<Long> result = Lists.newArrayList();
        for (TxStudentComment txStudentComment : comments) {
            result.add(txStudentComment.getId());
        }
        return result;
    }

    private String generateSendNotifyInfos(Long userId, Long orgId, Integer userType) {
        String preInfoFormat = "%s:%s\n";
        String type = "";
        String name = "";
        if (userType == StudentType.ORG_STUDENTS.getCode()) {// 机构学员
            OrgStudent student =
                orgStudentsDao.getStudentByUserId(orgId, userId, "userId", "orgId", "name", "nickName", "mobile");
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
            }
            name = student.getName();
            name = GenericsUtils.isNullOrEmpty(name) ? student.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty(name) ? student.getMobile() : name;
            type = "学员";
        } else {
            TxConsultUser user = txConsultUserDao.getById(userId);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            name = user.getName();
            name = GenericsUtils.isNullOrEmpty(name) ? user.getNickName() : name;
            name = GenericsUtils.isNullOrEmpty(name) ? user.getMobile() : name;
            type = "线索";

        }
        String preInfoStr = String.format(preInfoFormat, type, name);
        return preInfoStr;
    }

    private void sendNotifyToColleague(String preInfoStr, CommentInfoDto ciDto, Long orgId) {

        String notifyColleague = ciDto.getNotifyColleague();// 为 子账号id列表 逗号分隔 0代表是主账号
        log.info("notifyColleague is : {} ", notifyColleague);
        if (GenericsUtils.isNullOrEmpty(notifyColleague)) {
            return;
        }
        Integer cascadeId = (ciDto.getCreatorCascadeId() != null ? ciDto.getCreatorCascadeId() : Flag.FALSE.getInt());

        List<String> colleagues = Arrays.asList(notifyColleague.split(","));

        log.info("colleagues list is : {} ", colleagues);

        Set<Long> receiveCascadeIds = new HashSet<>();
        Long selfAccount = null;
        for (String colleagueId : colleagues) {
            if (GenericsUtils.isNullOrEmpty(colleagueId)) {
                continue;
            }
            Long receiveId = Long.parseLong(colleagueId);
            if (receiveId != 0) {
                receiveCascadeIds.add(receiveId);
            } else {
                selfAccount = 0L;
            }
        }
        log.info("all receive CascadeIDs is : {}", receiveCascadeIds);
        List<TXCascadeAccount> byIds = this.txCascadeAccountDao.getByIds(receiveCascadeIds);
        log.info(" 所有待接收通知的同事是:{}  ", byIds);
        ConsultMessage consultMessage = new ConsultMessage();
        consultMessage.setMsgType(MsgType.CARD.getValue());
        consultMessage.setSenderRole(getMsgUserType(orgId.intValue(), cascadeId));
        consultMessage.setSenderId(cascadeId);
        fillMsgInfos(preInfoStr, consultMessage, ciDto);

        if (GenericsUtils.notNullAndEmpty(byIds)) {
            for (TXCascadeAccount ta : byIds) {
                Integer accountType = ta.getAccountType();
                consultMessage.setReceiverRole(accountType);
                consultMessage.setReceiverId(ta.getId());
                try {
                    boolean sendStaffMsg = this.consultMessageService.sendStaffMsg(orgId, cascadeId, consultMessage);
                    log.info("success to send to staff :{} for message : {} and status is : {} ", cascadeId,
                        consultMessage, sendStaffMsg);
                } catch (Exception e) {
                    log.info("can not send notify to colleague whose info is : {} ", consultMessage);
                }
            }
        }

        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId.intValue());
        if (accountById == null) {
            throw new RuntimeException("can not send message to org master account cause by no exists : " + orgId);
        }
        if (selfAccount != null && 0L == selfAccount) {
            consultMessage.setReceiverRole(MsgUserRole.HEADER.getValue());
            consultMessage.setReceiverId(accountById.getNumber());
            this.consultMessageService.sendStaffMsg(orgId, cascadeId, consultMessage);
        }

    }

    private void fillMsgInfos(String preInfoStr, ConsultMessage consultMessage, CommentInfoDto ciDto) {
        consultMessage.setConsultType(MessageSource.STAFF_INFO.getValue());
        CardMsgContent cardMsgContent = new CardMsgContent();
        cardMsgContent.setTitle(CardType.FOLLOW.getDesc());
        cardMsgContent.setType(CardType.FOLLOW.getValue());
        cardMsgContent.setText(preInfoStr + ciDto.getContent());

        if (ciDto.getSeconds() != 0 && ciDto.getSoundId() != 0) {
            List<AudioMsgContent> audios = new ArrayList<>();
            OrgStorage byIdOrgStorage = this.orgStorageDao.getById(ciDto.getSoundId());
            AudioMsgContent amc = new AudioMsgContent();
            if (byIdOrgStorage != null) {
                amc.setUrl(StorageUtil.constructUrl(byIdOrgStorage.getFid(), byIdOrgStorage.getSn(),
                    byIdOrgStorage.getMimeType()));
                amc.setLen(ciDto.getSeconds());
                amc.setStorageId(ciDto.getSoundId());
                audios.add(amc);
                cardMsgContent.setAudios(audios);
            }
        }

        String storageIds = ciDto.getStorageIds();
        if (GenericsUtils.notNullAndEmpty(storageIds)) {
            List<ImageMsgContent> images = new ArrayList<>();
            List<String> storageIdList = Arrays.asList(storageIds.split(","));
            for (int i = 0; i < storageIdList.size(); i++) {
                ImageMsgContent imc = new ImageMsgContent();
                imc.setStorageId(Integer.parseInt(storageIdList.get(i)));
                OrgStorage orgStorage = this.orgStorageDao.getById(storageIdList.get(i));
                if (orgStorage != null) {
                    imc.setUrl(
                        StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType()));
                } else {
                    continue;
                }
                images.add(imc);
            }
            cardMsgContent.setImages(images);
        }
        Gson gson = new Gson();
        String text = gson.toJson(cardMsgContent);
        log.info("cardMsgContent is : {} ", text);
        consultMessage.setContent(text);
    }

    private Integer getMsgUserType(Integer orgId, Integer cascadeId) {
        OrgAccount accountById = this.orgAccountDao.getAccountById(orgId);
        Integer superRoleType = null;
        if (cascadeId != null && cascadeId != 0L) {
            TXCascadeAccount tca = this.txCascadeAccountDao.getById(cascadeId);
            if (tca == null) {
                log.info("can not find any cascade account with cadcadeId : {} ", cascadeId);
                return null;
            }
            superRoleType = tca.getAccountType();
        } else {
            OrgSubAccount osa = this.orgSubAccountDao.getByOrgId(orgId.intValue());
            if (osa == null) {
                if (accountById == null) {
                    log.info(" can not find any org account with orgId : {} ", orgId);
                    return null;
                }
                superRoleType = MsgUserRole.HEADER.getValue();
            } else {
                Integer pId = osa.getPid();
                if (0 == pId) {
                    superRoleType = MsgUserRole.HEADER.getValue();
                } else {
                    superRoleType = MsgUserRole.BRANCH_HEADER.getValue();
                }
            }
        }
        return superRoleType;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delStudentComment(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        if (studentCommenRequestDto.getCommentId() == null) {
            log.warn("del comment error: commentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = this.txStudentCommentDao.getById(studentCommenRequestDto.getCommentId());
        if (comment == null || comment.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException(StudentErrorCode.SYSTEM_COMMENT);
        }
        this.txStudentCommentDao.delById(comment.getId());
    }

    @Override
    public OrgCommentsListReponse getComments(Integer type, Long studentId, Long orgId, Integer isGrowth) {
        return getComments(type, studentId, orgId, isGrowth, null);
    }

    @Override
    public OrgCommentsListReponse getComments(Integer type, Long studentId, Long orgId, Integer isGrowth,
        PageDto pageDto) {
        if (isGrowth != null && isGrowth != Flag.TRUE.getInt()) {
            isGrowth = null;
        }
        if (type == null || studentId == null) {
            log.warn("get comments error: type ,studentId or comments is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        boolean isShow = credentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
        List<TxStudentComment> comments = Lists.newArrayList();
        Long searchId = null;
        if (type.intValue() == StudentType.ORG_STUDENTS.getCode()) {// 机构学员
            OrgStudent student = orgStudentsDao.getById(studentId, "orgId", "userId");
            if (student == null || student.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
            }
            searchId = student.getUserId();
        } else {
            // 非机构正式学院，studentId入参为咨询用户id
            TxConsultUser user = txConsultUserDao.getById(studentId);
            if (user == null || user.getOrgId().longValue() != orgId.longValue()) {
                throw new BussinessException(StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
            searchId = studentId;
        }

        if (pageDto != null) {
            Integer count = txStudentCommentDao.countComments(searchId, orgId, type, isGrowth, pageDto);
            if (count > 0) {
                comments = this.txStudentCommentDao.listComments(searchId, orgId, type, isGrowth, pageDto);
            }
            pageDto.setCount(count);
        } else {
            comments = this.txStudentCommentDao.listComments(searchId, orgId, type, isGrowth, pageDto);
        }

        OrgCommentsListReponse reponse = new OrgCommentsListReponse();
        // callIds为三方通话: CallServiceInfo表id；call400Ids为400电话: OrgPushCallInfo表id
        Set<Long> callIds = Sets.newHashSet();
        Set<Long> call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    callIds.add(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    call400Ids.add(comment.getSoundId());
                }
            }
        }
        // callMap: CallServiceInfo映射
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(callIds)) {
            List<CallServiceInfo> callInfos = this.callServiceInfoDao.getByIds(callIds);
            callMap = CollectorUtil.collectMap(callInfos, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        // call400Map: OrgPushCallInfo映射
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(call400Ids)) {
            List<OrgPushCallInfo> call400Infos = this.orgPushCallInfoDao.getByIds(call400Ids);
            call400Map = CollectorUtil.collectMap(call400Infos, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Set<Integer> storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty(comment.getStorageIds())) {
                if (comment.getStorageIds().contains(",")) {
                    String[] storageIdsStr = comment.getStorageIds().split(",");
                    for (String storageId : storageIdsStr) {
                        storageIds.add(Integer.parseInt(storageId));
                    }
                } else {
                    storageIds.add(Integer.parseInt(comment.getStorageIds()));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = call400Map.get(comment.getSoundId());
                }
                if (storageId != null && storageId.longValue() > 0) {
                    storageIds.add(storageId.intValue());
                }
            } else if (comment.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode()) {
                if (comment.getSoundId() != null && comment.getSoundId().longValue() > 0) {
                    storageIds.add(comment.getSoundId().intValue());
                }
            }
        }
        List<OrgStorage> storages = this.orgStorageDao.getByIds(storageIds);
        Map<Integer, OrgStorage> storageMap = CollectorUtil.collectMap(storages, new Function<OrgStorage, Integer>() {
            @Override
            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });

        List<CommentInfoDto> commentsDto = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(comments)) {
            Set<Integer> cascadeIds = new HashSet<Integer>();
            for (TxStudentComment comment : comments) {
                cascadeIds.add(comment.getCreatorCascadeId().intValue());
            }

            Map<Long, String> cascadeIdVSNameMap =
                txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
            OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
            cascadeIdVSNameMap.put(0L, orgInfo.getShowName());

            // txCascadeAccountDao.
            for (TxStudentComment comment : comments) {
                CommentInfoDto commentDto = new CommentInfoDto();
                commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap, cascadeIdVSNameMap);
                if (!isShow) {
                    commentDto.setContent(CommentUtil.maskMobile(comment.getContent()));
                }
                commentsDto.add(commentDto);
            }
        }
        reponse.setComments(commentsDto);
        return reponse;
    }

    /**
     * po to dto
     *
     * @param dto
     * @param po
     */
    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap,
        Map<Long, Long> call400Map, Map<Integer, OrgStorage> storageMap, Map<Long, String> cascadeIdVSNameMap) {
        dto.setCommentId(po.getId());
        dto.setContent(po.getContent());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (null != po.getIsMobile() && po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
            // 三方通话不需要来源
            dto.setOrigin(-1);
        } else {
            dto.setOrigin(po.getOrigin());
        }
        dto.setOrigin(po.getOrigin());
        if (StringUtils.isNotEmpty(dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            List<String> urls = Lists.newArrayList();
            for (String storageId : storageIdsStr) {
                OrgStorage storage = storageMap.get(Integer.parseInt(storageId));
                if (storage != null) {
                    String url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
                    urls.add(url);
                }
            }
            dto.setUrls(StringUtils.join(urls.toArray(new String[urls.size()]), ","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = callMap.get(po.getSoundId());
            } else if (po.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = call400Map.get(po.getSoundId());
            }
            if (storageId != null && storageId.longValue() > 0) {
                po.setSoundId(storageId);
                po.setDownStatus(DownLoadStatus.FINISH.getCode());
                this.txStudentCommentDao.update(po, "downStatus", "soundId");
            }
        }
        if (po.getSoundId() > 0 && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode()) {
            OrgStorage storage = storageMap.get(po.getSoundId().intValue());
            if (storage != null) {
                dto.setSeconds(po.getSeconds());
                dto.setSoundId(po.getSoundId());
                dto.setSoundUrl(StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
            }
        }
        dto.setDownLoadStatus(po.getDownStatus());
        dto.setCommentType(po.getCommentType());
        dto.setGrowthComments(po.getGrowthComments());
        dto.setNotifyParents(po.getNotifyParents());
        dto.setCreatorCascadeId(po.getCreatorCascadeId());

        CreatorDto creatorDto = new CreatorDto();
        creatorDto.setCascadeId(po.getCreatorCascadeId());

        if (po.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
            creatorDto.setName(cascadeIdVSNameMap.get(Long.parseLong(po.getCreatorCascadeId() + "")));
        } else {
            if (po.getIsSystem().intValue() == Flag.TRUE.getInt()) {
                creatorDto.setName("系统");
            } else {
                creatorDto.setName("历史用户");
            }
        }
        dto.setCreator(creatorDto);
    }

    @Override
    public boolean syncAddOrgStudent() {
        TxMsgSyncTimestamp syncInfo =
            this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.ADD_STU.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(MsgSyncType.ADD_STU.getSyncType());
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save(syncInfo, false);
        }
        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(MAX_SYNC_NUM);
        log.info("syncAddOrgStudent,syncTime={}", syncInfo.getSyncTime());

        List<OrgStudent> students = this.orgStudentsDao.getStudents(syncInfo.getSyncTime(),
            DeleteStatus.NORMAL.getValue(), page, "orgId", "userId", "createTime", "name", "nickName");

        // List<OrgStudents> students = this.orgStudentsDao.getStudents(syncInfo.getSyncTime(),
        // DeleteStatus.NORMAL.getValue(), page, "orgId", "userId", "createTime", "name", "nickName");

        if (CollectionUtils.isNotEmpty(students)) {
            if (students.get(0).getCreateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(students.get(0).getCreateTime());
            List<TxStudentComment> comments = Lists.newArrayList();
            for (OrgStudent orgStudents : students) {
                // TxStudentComment comment = new TxStudentComment();
                // if (StringUtils.isNotEmpty(orgStudents.getName())) {
                // comment.setContent("添加学员 " + orgStudents.getName());
                // } else {
                // comment.setContent("添加学员 " + orgStudents.getNickName());
                // }
                // comment.setOrgId(orgStudents.getOrgId());
                // comment.setUserId(orgStudents.getUserId());
                // comment.setCreateTime(orgStudents.getCreateTime());
                // comment.setIsSystem(AddType.SYSTEM.getCode());
                // comments.add(comment);
                txStudentCommentAPIService.saveByAddStudent(orgStudents);
            }
            this.txMsgSyncTimestampDao.update(syncInfo, "syncTime");
        }
        return true;
    }

    @Override
    public boolean syncCoursePurchase() {
        TxMsgSyncTimestamp syncInfo =
            this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.COURSE_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(MsgSyncType.COURSE_PURCHASE.getSyncType());
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save(syncInfo, false);
        }
        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(MAX_SYNC_NUM);
        List<Integer> classType = Lists.newArrayList();
        // classType.add(CourseType.CLASS.getCode());
        // classType.add(CourseType.TRIAL_COURSE.getCode());
        classType.add(CourseType.ORG_COURSE.getCode());

        log.info("syncCoursePurchase,syncTime={}", syncInfo.getSyncTime());
        List<CoursePurchase> purchases = this.coursePurchaseDao.getCoursePurchaseList(syncInfo.getSyncTime(),
            PayStatus.SUCESS.getCode(), classType, page);
        if (CollectionUtils.isNotEmpty(purchases)) {
            if (purchases.get(0).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(purchases.get(0).getUpdateTime());
            Set<Long> courseIds = Sets.newHashSet();
            for (CoursePurchase coursePurchase : purchases) {
                courseIds.add(coursePurchase.getCourseId());
            }
            // List<TeacherClassCourse> courses = this.teacherClassCourseDao.getByIds(courseIds, "name");
            // Map<Long, String> nameMap = CollectorUtil.collectMap(courses, new Function<TeacherClassCourse, Long>() {
            // @Override
            // public Long apply(TeacherClassCourse arg0) {
            // return arg0.getId();
            // }
            // }, new Function<TeacherClassCourse, String>() {
            // @Override
            // public String apply(TeacherClassCourse arg0) {
            // return arg0.getName();
            // }
            // });
            Map<Long, String> nameMap = this.orgCourseDao.getCourseNameMap(courseIds);
            List<TxStudentComment> comments = Lists.newArrayList();
            for (CoursePurchase coursePurchase : purchases) {
                // TxStudentComment comment = new TxStudentComment();
                // String name = nameMap.get(coursePurchase.getCourseId());
                // comment.setContent("报班:[" + name + "]总价:¥" + coursePurchase.getPayMoney() + "元");
                // comment.setOrgId(coursePurchase.getOrgId());
                // comment.setUserId(coursePurchase.getUserId());
                // comment.setCreateTime(coursePurchase.getUpdateTime());
                // comment.setIsSystem(AddType.SYSTEM.getCode());
                // comments.add(comment);
                txStudentCommentAPIService.saveByCoursePurchase(coursePurchase.getOrgId(), coursePurchase.getUserId(),
                    coursePurchase.getUpdateTime(), nameMap.get(coursePurchase.getCourseId()),
                    coursePurchase.getPayMoney());
            }

            this.txMsgSyncTimestampDao.update(syncInfo, "syncTime");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void modComment(CommentInfoDto dto, Long orgId) {
        Date now = new Date();

        if (dto.getCommentId() == null) {
            log.warn("mod comment error: commentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        TxStudentComment comment = this.txStudentCommentDao.getById(dto.getCommentId());
        if (comment == null || comment.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.COMMENT_NOT_EXIST);
        }
        if (comment.getIsSystem().intValue() == AddType.SYSTEM.getCode()) {
            throw new BussinessException(StudentErrorCode.SYSTEM_COMMENT);
        }
        comment.setSeconds(dto.getSeconds());
        comment.setSoundId(dto.getSoundId());
        comment.setStorageIds(dto.getStorageIds());
        comment.setContent(dto.getContent());
        comment.setCommentType(dto.getCommentType());
        comment.setGrowthComments(dto.getGrowthComments());
        comment.setNotifyParents(dto.getNotifyParents());
        comment.setCreatorCascadeId(dto.getCreatorCascadeId());
        comment.setUpdateTime(now);

        this.txStudentCommentDao.update(comment);

        // 修改最后跟进时间
        if (comment.getConsultUserId() != null && comment.getConsultUserId() > 0) {
            TxConsultUser user = txConsultUserDao.getById(comment.getConsultUserId());
            user.setLastRemindTime(now);
            user.setUpdateTime(now);
            txConsultUserDao.update(user);
        }

        if (dto.getNotifyColleague() != null && !dto.getNotifyColleague().equals("null")) {
            try {
                Long consultUserId = comment.getConsultUserId();
                Long userId = comment.getUserId();
                Integer userType = StudentType.ORG_STUDENTS.getCode();
                if (consultUserId != null && consultUserId > 0) {
                    userType = StudentType.CONSULT_USER.getCode();
                    userId = consultUserId;
                }
                log.info("comment dto={},userId={},userType={}", comment, userId, userType);
                String preInfoStr = this.generateSendNotifyInfos(userId, orgId, userType);
                // 通知同事
                sendNotifyToColleague(preInfoStr, dto, orgId); // 向子账号进行消息的推送
            } catch (Exception e) {
                log.error("modComment NotifyColleague error", e);
            }
        }
    }

    @Override
    public boolean syncSignupPurchase() {
        TxMsgSyncTimestamp syncInfo =
            this.txMsgSyncTimestampDao.getSyncTimestampByType(MsgSyncType.SIGNUP_PURCHASE.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncType(MsgSyncType.SIGNUP_PURCHASE.getSyncType());
            syncInfo.setSyncTime(new Date());
            this.txMsgSyncTimestampDao.save(syncInfo, false);
        }
        PageDto page = new PageDto();
        page.setPageNum(1);
        page.setPageSize(MAX_SYNC_NUM);
        log.info("syncSignupPurchase,syncTime={}", syncInfo.getSyncTime());
        List<OrgSignupInfo> sinupInfos =
            this.orgSignupInfoDao.getPurchases(syncInfo.getSyncTime(), PayStatus.SUCESS.getCode(), page);
        if (CollectionUtils.isNotEmpty(sinupInfos)) {
            if (sinupInfos.get(0).getUpdateTime().after(new Date())) {
                return false;
            }
            syncInfo.setSyncTime(sinupInfos.get(0).getUpdateTime());
            Set<Long> signupPurchaseIds = Sets.newHashSet();
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                signupPurchaseIds.add(orgSignupInfo.getSignupPurchaseId());
            }
            List<OrgSignupCourse> coursePurchases =
                this.orgSignupCourseDao.loadByPurchaseIds(signupPurchaseIds, "signupPurchaseId", "orgCourseId");
            Set<Long> courseIds = Sets.newHashSet();
            Map<Long, List<OrgSignupCourse>> coursePurhaseMap = Maps.newHashMap();
            for (OrgSignupCourse orgSignupCourse : coursePurchases) {
                if (!coursePurhaseMap.containsKey(orgSignupCourse.getSignupPurchaseId())) {
                    coursePurhaseMap.put(orgSignupCourse.getSignupPurchaseId(), Lists.<OrgSignupCourse> newArrayList());
                }
                coursePurhaseMap.get(orgSignupCourse.getSignupPurchaseId()).add(orgSignupCourse);
                courseIds.add(orgSignupCourse.getOrgCourseId());
            }
            List<OrgCourse> courseList =
                this.orgCourseDao.getByIds(courseIds, "id", "name", "chargeType", "chargeUnit");
            Map<Long, OrgCourse> courseMap = GenericsUtils.toFieldMap(courseList, "id");
            for (OrgSignupInfo orgSignupInfo : sinupInfos) {
                List<OrgSignupCourse> purchases = coursePurhaseMap.get(orgSignupInfo.getSignupPurchaseId());
                Map<Long, OrgSignupCourse> orgSignupCourseMap = Maps.newHashMap();
                Map<Long, OrgCourse> orgCourseMap = Maps.newHashMap();
                if (CollectionUtils.isNotEmpty(purchases)) {
                    for (OrgSignupCourse orgSignupCourse : purchases) {
                        orgCourseMap.put(orgSignupCourse.getOrgCourseId(),
                            courseMap.get(orgSignupCourse.getOrgCourseId()));
                        orgSignupCourseMap.put(orgSignupCourse.getOrgCourseId(), orgSignupCourse);
                    }
                }
                txStudentCommentAPIService.saveBySignUpPurchase(orgSignupInfo, orgSignupCourseMap, orgCourseMap);
            }

            this.txMsgSyncTimestampDao.update(syncInfo, "syncTime");
        }
        return true;
    }

    /**
     * 合并记录
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void mergeCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        txStudentCommentAPIService.saveByStudentMerge(sourceConsultUser, destConsultUser, orgId);
        // List<TxStudentComment> comments =
        // this.txStudentCommentDao.getComments(sourceConsultUser.getId(), orgId, StudentType.CONSULT_USER.getCode());
        // if (comments != null && !comments.isEmpty()) {
        // for (TxStudentComment comment : comments) {
        // comment.setConsultUserId(destConsultUser.getId());
        // comment.setUserId(destConsultUser.getUserId());
        // comment.setUpdateTime(new Date());
        // this.txStudentCommentDao.update(comment, new String[] { "consultUserId", "userId", "updateTime" });
        // }
        // }
        //
        // doAfter(sourceConsultUser, destConsultUser, orgId);
    }

    /**
     * 合并记录后需要新增一条合并记录的跟进记录
     */
    void doAfter(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId) {
        TxStudentComment addComment = new TxStudentComment();
        addComment.setCallStatus(0);
        addComment.setConsultUserId(destConsultUser.getId());
        addComment.setUserId(destConsultUser.getUserId());
        addComment.setContent(getCommentRecord(sourceConsultUser, destConsultUser));
        addComment.setOrgId(orgId);
        addComment.setCreateTime(new Date());
        addComment.setIsSystem(AddType.SYSTEM.getCode());
        log.info("orgId:{}, addComment:{}", orgId, addComment);
        this.txStudentCommentDao.save(addComment);
    }

    /**
     * 生成合并记录
     *
     * @param sourceConsultUser
     * @param destConsultUser
     * @return
     */
    private String getCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser) {
        String sourceName = sourceConsultUser.getName();
        String sourceNickName = sourceConsultUser.getNickName();
        String destName = destConsultUser.getName();
        String destNickName = destConsultUser.getNickName();

        String sourceMobile = sourceConsultUser.getMobile();
        String destMobile = destConsultUser.getMobile();
        StringBuffer sb = new StringBuffer();
        sb.append("您将学生【" + getConsulterName(sourceName, sourceNickName) + "】");
        if (StringUtils.isNotBlank(sourceMobile)) {
            sb.append("【" + sourceMobile + "】");
        }
        sb.append("和学生【" + getConsulterName(destName, destNickName) + "】");
        if (StringUtils.isNotBlank(destMobile)) {
            sb.append("【" + destMobile + "】");
        }
        sb.append("合并了");
        return sb.toString();
    }

    /**
     * 如果咨询用户没有name则取nickname，如果二者都没有，取【匿名用户】
     *
     * @param source
     * @param dest
     * @return
     */
    private String getConsulterName(String source, String dest) {
        return StringUtils.isNotBlank(source) ? source : StringUtils.isNotBlank(dest) ? dest : "匿名用户";
    }

    @Override
    public List<CommentInfoDto> listCommentsByStudentId(Long orgId, Long studentId, Integer studentType) {
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentId);
        List<TxStudentComment> comments =
            this.txStudentCommentDao.getComments(orgStudent.getUserId(), orgId, StudentType.ORG_STUDENTS.getCode());

        List<CommentInfoDto> commentsDto = Lists.newArrayList();
        // callIds为三方通话: CallServiceInfo表id；call400Ids为400电话: OrgPushCallInfo表id
        Set<Long> callIds = Sets.newHashSet();
        Set<Long> call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    callIds.add(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    call400Ids.add(comment.getSoundId());
                }
            }
        }
        // callMap: CallServiceInfo映射
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(callIds)) {
            List<CallServiceInfo> callInfos = this.callServiceInfoDao.getByIds(callIds);
            callMap = CollectorUtil.collectMap(callInfos, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        // call400Map: OrgPushCallInfo映射
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(call400Ids)) {
            List<OrgPushCallInfo> call400Infos = this.orgPushCallInfoDao.getByIds(call400Ids);
            call400Map = CollectorUtil.collectMap(call400Infos, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Set<Integer> storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty(comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = call400Map.get(comment.getSoundId());
                }
                if (storageId != null && storageId.longValue() > 0) {
                    storageIds.add(storageId.intValue());
                }
            } else if (comment.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode()) {
                if (comment.getSoundId() != null && comment.getSoundId().longValue() > 0) {
                    storageIds.add(comment.getSoundId().intValue());
                }
            }
        }
        List<OrgStorage> storages = this.orgStorageDao.getByIds(storageIds);
        Map<Integer, OrgStorage> storageMap = CollectorUtil.collectMap(storages, new Function<OrgStorage, Integer>() {
            @Override
            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });

        Set<Integer> cascadeIds = new HashSet<Integer>();
        for (TxStudentComment comment : comments) {
            cascadeIds.add(comment.getCreatorCascadeId().intValue());
        }
        Map<Long, String> cascadeIdVSNameMap = txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());

        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap, cascadeIdVSNameMap);
            commentsDto.add(commentDto);
        }

        return commentsDto;
    }

}