/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.api;

import java.util.List;

import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.request.RosterCommentRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgCommentsListReponse;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @title StudentTagService
 * @desc 学生备注相关
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */

/**   
 * @title       : OrgStudentCommentService 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年6月16日 下午5:10:16 
 */
public interface OrgStudentCommentService {

    /**
     * 添加学生备注
     * 
     * @param commentAddRequestDto
     * @param orgId
     */
    public List<Long> addStudentComment(RosterCommentRequestDto dto, Long orgId) throws Exception;

    /**
     * 删除学生备注
     * 
     * @param studentCommenRequestDto
     * @param orgId
     */
    public void delStudentComment(StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    /**
     * 查询跟进记录
     * 
     * @param type
     * @param studentId
     * @param orgId
     * @return
     */
    public OrgCommentsListReponse getComments(Integer type, Long studentId, Long orgId, Integer isGrowth);
    public OrgCommentsListReponse getComments(Integer type, Long studentId, Long orgId, Integer isGrowth, PageDto pageDto);

    /**
     * 编辑跟进记录
     * 
     * @param commentAddRequestDto
     * @param orgId
     * @return
     */
    public void modComment(CommentInfoDto dto, Long orgId);

    /**
     * 同步添加学生跟进记录（根据添加时间区同步）
     */
    public boolean syncAddOrgStudent();

    /**
     * 同步购买课程跟进记录（根据添加时间同步）
     */
    public boolean syncCoursePurchase();

    /**
     * 同步报名跟进记录（根据添加时间同步）
     */
    public boolean syncSignupPurchase();
    
    /**
     * 合并跟进记录
     * @param sourceConsultUser
     * @param destConsultUser
     * @param orgId
     */
    public void mergeCommentRecord(TxConsultUser sourceConsultUser, TxConsultUser destConsultUser, Long orgId);
    
    /**
     * 查询跟进记录列表
     * @param studentId
     * @param studentType 预留字段
     * @param orgId
     */
    public List<CommentInfoDto> listCommentsByStudentId(Long orgId, Long studentId, Integer studentType);
}
