/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.pc.impl;

import com.baijia.tianxiao.common.service.ImportDataProcessService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.dal.org.dao.AreaDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.Area;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.baidu.Location;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.OrgInfoService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentImportModel;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.baidu.BaiduMapUtils;
import com.baijia.tianxiao.util.bean.BizDateThreadLocalUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImportStudentServiceImpl
implements ImportDataProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportStudentServiceImpl.class);
    public static final String STUDENT_IMPORT_TEMPLATE_PATH = "/excel/student_import_2.xlsx";
    public static final String STUDENT_RESULT_TEMPLATE_PATH = "/excel/student_result_2.xlsx";
    private static final Map<String, Map<String, Object>> cache = Maps.newHashMap();
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_SUCCESS = ImportDataProcessService.SingleSaveErrorResult.createSuccessResult((String)"\u5bfc\u5165\u6210\u529f!");
    private static final ImportDataProcessService.SingleSaveErrorResult IMPORT_FAIL = ImportDataProcessService.SingleSaveErrorResult.createFailResult((String)"\u5bfc\u5165\u5931\u8d25");
    private static final ImportDataProcessService.SingleSaveErrorResult STUDENT_EXSIST = new ImportDataProcessService.SingleSaveErrorResult(true, "\u5b66\u5458\u6863\u6848\u5df2\u5b58\u5728");
    public static final String org_customfield_map_Key = "orgCustomfieldMap";
    public static final String org_cascade_map_Key = "orgCascadeMap";
    @Autowired
    private StudentUserService studentUserService;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private AreaDao areaDao;
    @Autowired
    private OrgInfoService orgInfoService;
    @Resource
    private CustomFieldService customFieldService;
    @Resource
    private CustomFieldValueDao customFieldValueDao;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private ConsultSourceService consultSourceService;

    public DataProcType getProcessType() {
        return DataProcType.ORG_STUDENT;
    }

    public boolean validateHeader(List<String> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        int index = 0;
        for (String header : headers) {
            if (!cache.containsKey(header.trim())) {
                return false;
            }
            Map<String, Object> item = cache.get(header);
            int sequence = (Integer)item.get("index");
            if (index != sequence) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean validateHeader(List<String> headers, Long orgId) {
        if (CollectionUtils.isEmpty(headers)) {
            return false;
        }
        Map<String, CustomFieldResponse> realCustomFields = this.getOrgRealCutomFieldMap(orgId);
        log.info("cache info ={}", cache);
        log.info("headers size={},cache size={},realCustomFields size={}", new Object[]{headers.size(), cache.size(), realCustomFields.size()});
        if (realCustomFields.size() + cache.size() != headers.size()) {
            return false;
        }
        for (String header : headers) {
            if (cache.containsKey(header) || realCustomFields.containsKey(header)) continue;
            return false;
        }
        return true;
    }

    private boolean checkisDateType(String title, Map<String, CustomFieldResponse> realCustomFields) {
        if (realCustomFields.containsKey(title)) {
            CustomFieldResponse field = realCustomFields.get(title);
            return field.getType() == 4;
        }
        return false;
    }

    private String excelValue2Str(Object value, String title, Map<String, CustomFieldResponse> realCustomFields) {
        boolean isDateType = this.checkisDateType(title, realCustomFields);
        String valueStr = "";
        if (value != null) {
            if (isDateType) {
                if (value instanceof Long) {
                    Date date = new Date((Long)value);
                    SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
                    valueStr = dateFormat2.format(date);
                } else {
                    valueStr = value.toString();
                }
            } else {
                valueStr = value.toString();
            }
        }
        return valueStr;
    }

    private void buildFieldPrompt(CustomFieldResponse field, XSSFSheet sheet, int tempColumnNum) {
        String promptTitle = "";
        String promptContent = "";
        int type = field.getType();
        boolean required = field.getIsRequired() == 1;
        promptContent = promptContent + (required ? "\u5fc5\u586b," : "\u975e\u5fc5\u586b,");
        if (type == 1) {
            promptContent = promptContent + "\u8bf7\u8f93\u5165\u4e0d\u8d85\u8fc730\u4e2a\u5b57\u7b26;";
        } else if (type == 4) {
            promptContent = promptContent + "\u65e5\u671f\u9700\u4e3a2000/1/1\u6216\u80052000-1-1\u683c\u5f0f;";
        } else if (type == 2 || type == 3) {
            ArrayList options = Lists.newArrayList();
            for (OptionDto optionDto : field.getOptionList()) {
                if (optionDto.getIsPaused() != 0) continue;
                options.add(optionDto.getLabel());
            }
            String optionStr = StringUtils.join((Iterable)options, (String)",");
            if (StringUtils.isNotBlank((CharSequence)optionStr)) {
                promptContent = promptContent + "\u8bf7\u5728\"" + optionStr + "\"\u4e2d\u9009\u62e9\u8f93\u5165;";
            }
            if (type == 3) {
                promptContent = promptContent + "\u4e0d\u540c\u9009\u9879\u7528\u9017\u53f7\u5206\u9694\u3002";
            }
        }
        ExcelUtils.setHSSFStringPrompt((XSSFSheet)sheet, (String)promptTitle, (String)promptContent, (int)2, (int)1000, (int)tempColumnNum, (int)tempColumnNum);
    }

    private Map<String, CustomFieldResponse> getOrgRealCutomFieldMap(Long orgId) {
        List<CustomFieldResponse> fields = this.customFieldService.getCustomFieldList((long)orgId);
        HashMap realCustomFields = Maps.newHashMap();
        for (CustomFieldResponse field : fields) {
            if (field.getIsSystem() != 0 || field.getIsPaused() != 0) continue;
            realCustomFields.put(field.getLabel(), field);
        }
        return realCustomFields;
    }

    private Map<String, TxCascadeCredentialDto> getOrgCascadeMapFieldMap(Long orgId) {
        List list = this.txCascadeCredentialService.getTxCascadeCredentialList(Long.valueOf(orgId));
        HashMap cascadeMap = Maps.newHashMap();
        for (TxCascadeCredentialDto cascade : list) {
            cascadeMap.put(cascade.getName(), cascade);
        }
        return cascadeMap;
    }

    public ImportDataProcessService.SingleSaveErrorResult saveSingleData(Long orgId, Long cascadeId, List<String> headers, Object[] lineData, boolean updateRepeat) {
        log.info("^************************** lineData: " + lineData);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"illegal orgId.");
        Preconditions.checkArgument((lineData != null && lineData.length > 0 ? 1 : 0) != 0, (Object)"lineData \u4e3a\u7a7a");
        try {
            StudentImportModel model = new StudentImportModel();
            this.buildOrgStudentDtoNew(model, lineData, headers, updateRepeat, orgId);
            StudentInfoResponseDto studentInfo = model.getStudentInfoResponseDto();
            if (StringUtils.isNotBlank((CharSequence)studentInfo.getTagsStr())) {
                String[] tags = studentInfo.getTagsStr().replaceAll("\uff0c", ",").split(",");
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (String t : tags) {
                    if (!StringUtils.isNotBlank((CharSequence)t)) continue;
                    map.put(t, "");
                }
                StringBuilder builder = new StringBuilder();
                for (String t : map.keySet()) {
                    builder.append(t).append(",");
                }
                studentInfo.setTagsStr(builder.toString().substring(0, builder.length() - 1));
            }
            Long l = this.studentUserService.addStudentInfo(orgId, studentInfo.getAddCascadeId() == null ? 0 : studentInfo.getAddCascadeId(), studentInfo, updateRepeat, model.getFieldsValue());
        }
        catch (BussinessException ex) {
            if (ex.getErrorCode().getSubsystemErrorCode() == CrmErrorCode.STUDENT_HAS_EXISTS.getSubsystemErrorCode()) {
                return ImportDataProcessService.SingleSaveErrorResult.createFailResult((String)"\u5b66\u5458\u5df2\u5b58\u5728");
            }
            log.warn("save clue error:{}", (Throwable)ex);
            return ImportDataProcessService.SingleSaveErrorResult.createFailResult((String)ex.getMessage());
        }
        catch (Exception ex) {
            log.warn("save clue error:{}", (Throwable)ex);
            return IMPORT_FAIL;
        }
        return IMPORT_SUCCESS;
    }

    private Map<String, CustomFieldResponse> getOrgRealCutomFieldMapFromThreadLocal(Long orgId) {
        Map customMap;
        if (BizDateThreadLocalUtil.get((String)org_customfield_map_Key) == null) {
            customMap = this.getOrgRealCutomFieldMap(orgId);
            BizDateThreadLocalUtil.set((String)org_customfield_map_Key, (Object)customMap);
        } else {
            customMap = (Map)BizDateThreadLocalUtil.get((String)org_customfield_map_Key);
        }
        return customMap;
    }

    private Map<String, TxCascadeCredentialDto> getOrgCascadeMapFromThreadLocal(Long orgId) {
        Map cascadeMap;
        if (BizDateThreadLocalUtil.get((String)org_cascade_map_Key) == null) {
            cascadeMap = this.getOrgCascadeMapFieldMap(orgId);
            BizDateThreadLocalUtil.set((String)org_cascade_map_Key, (Object)cascadeMap);
        } else {
            cascadeMap = (Map)BizDateThreadLocalUtil.get((String)org_cascade_map_Key);
        }
        return cascadeMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildOrgStudentDtoNew(StudentImportModel model, Object[] lineData, List<String> headers, boolean updateRepeat, Long orgId) {
        OrgStudent orgStudent;
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers, orgId), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        StudentInfoResponseDto dto = model.getStudentInfoResponseDto();
        SimpleDateFormat dateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat dateFormat3 = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, CustomFieldResponse> customMap = this.getOrgRealCutomFieldMapFromThreadLocal(orgId);
        Map<String, TxCascadeCredentialDto> cascadeMap = this.getOrgCascadeMapFromThreadLocal(orgId);
        for (int i = 0; i < lineData.length; ++i) {
            Object value;
            int empty;
            String head = headers.get(i);
            if (cache.containsKey(head)) {
                String fieldName = cache.get(head).get("propName").toString();
                empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
                String name = headers.get(i);
                value = lineData[i];
                if (fieldName == null) continue;
                if (fieldName.equals("birthday") && lineData[i] != null && !lineData[i].equals("")) {
                    try {
                        Date date = null;
                        if (value instanceof Date) {
                            date = (Date)value;
                        } else if (value instanceof String) {
                            if (((String)value).contains("/")) {
                                date = dateFormat2.parse(value.toString());
                            } else {
                                if (!((String)value).contains("-")) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR);
                                date = dateFormat3.parse(value.toString());
                            }
                        } else if (value instanceof Long) {
                            date = new Date((Long)value);
                        }
                        dto.setBirthdayStr(date);
                        dto.setBirthday(date.getTime());
                        lineData[i] = date.getTime();
                        continue;
                    }
                    catch (Exception e) {
                        log.error("CustomField date type format error", (Throwable)e);
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u751f\u65e5\u3011\u683c\u5f0f\u6709\u8bef\uff0c\u9700\u4e3a2001/1/1\u6216\u80052001-1-1\u6837\u5f0f");
                    }
                }
                if (empty != 0 && (value == null || "".equals(value))) {
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + name + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                try {
                    if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) continue;
                    if (value instanceof String) {
                        value = value.toString().trim();
                    }
                    BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    log.warn("set StudentListResponseDto.{} = {} failed!", (Object)fieldName, value);
                    throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR);
                }
            }
            if (!customMap.containsKey(head)) continue;
            CustomFieldResponse customField = customMap.get(head);
            empty = customField.getIsRequired() == 1 ? 1 : 0;
            int type = customField.getType();
            value = lineData[i];
            if (empty != 0 && (value == null || "".equals(value))) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + head + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String strValue = value.toString();
            HashMap map = Maps.newHashMap();
            if (type == 1) {
                if (strValue != null) {
                    int maxLength = 30;
                    if (this.orgInfoService.isOptimal(orgId)) {
                        maxLength = 500;
                    }
                    if (strValue.length() > maxLength) {
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010" + head + "\u3011\u6587\u672c\u4e0d\u80fd\u8d85\u8fc7" + maxLength + "\u4e2a\u5b57\u7b26");
                    }
                }
                map.put("content", strValue);
            } else if (type == 2) {
                if (strValue != null && !strValue.equals("")) {
                    List<OptionDto> optionList = customField.getOptionList();
                    for (OptionDto option : optionList) {
                        if (option.getIsPaused() != 0 || !StringUtils.equals((CharSequence)option.getLabel(), (CharSequence)strValue)) continue;
                        map.put("id", option.getId());
                        map.put("value", option.getLabel());
                    }
                    if (map.isEmpty()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + head + "\u3011\u6240\u586b\u5185\u5bb9\u548c\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                    }
                }
            } else if (type == 3) {
                List result = Splitter.onPattern((String)"[,|\uff0c]").trimResults().splitToList((CharSequence)strValue);
                ArrayList options = Lists.newArrayList();
                List<OptionDto> optionList = customField.getOptionList();
                if (StringUtils.isNotBlank((CharSequence)strValue) && CollectionUtils.isNotEmpty((Collection)result)) {
                    for (OptionDto optionDto : optionList) {
                        if (optionDto.getIsPaused() != 0 || !result.contains(optionDto.getLabel())) continue;
                        HashMap option = Maps.newHashMap();
                        option.put("id", optionDto.getId());
                        option.put("value", optionDto.getLabel());
                        options.add(option);
                    }
                    if (options.isEmpty()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + head + "\u3011\u6240\u586b\u5185\u5bb9\u548c\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                    }
                    if (options.size() != result.size()) {
                        throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + head + "\u3011\u6240\u586b\u5185\u5bb9\u548c\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                    }
                }
                if (options.size() > 0) {
                    map.put("options", options);
                }
            } else {
                if (type != 4) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010" + head + "\u3011\u4e0d\u652f\u6301\u7684\u81ea\u5b9a\u4e49\u6570\u636e\u7c7b\u578b");
                if (value != null && !"".equals(value)) {
                    log.info("CustomField date type format strValue:{}", value);
                    try {
                        Date date = null;
                        if (value instanceof Date) {
                            date = (Date)value;
                        } else if (value instanceof String) {
                            date = dateFormat2.parse(strValue);
                        } else if (value instanceof Long) {
                            date = new Date((Long)value);
                        }
                        if (date != null) {
                            map.put("content", date.getTime());
                        }
                    }
                    catch (Exception e) {
                        log.error("CustomField date type format error", (Throwable)e);
                        throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010" + head + "\u3011\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
                    }
                }
            }
            if (empty != 0 && MapUtils.isEmpty((Map)map)) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + head + "\u3011\u6240\u586b\u5185\u5bb9\u548c\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            CustomFieldValue cfvalue = new CustomFieldValue();
            log.debug("customField = {}", (Object)customField);
            log.debug("customField id = {}", (Object)customField.getId());
            log.debug("customField key = {}", (Object)customField.getKey());
            cfvalue.setFieldId(Long.valueOf(customField.getId()));
            cfvalue.setFieldType(customField.getType());
            cfvalue.setOrgId(orgId);
            Gson gson = new Gson();
            cfvalue.setValue(gson.toJson((Object)map));
            model.getFieldsValue().add(cfvalue);
        }
        if (!StringUtils.isBlank((CharSequence)dto.getSourceStr())) {
            if (dto.getSourceStr().length() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6765\u6e90\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
            }
            ConsultCustomSourceDto sourceDto = this.consultSourceService.getByLabel(orgId, dto.getSourceStr());
            if (sourceDto == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6765\u6e90\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            if (Flag.getBoolean((Integer)sourceDto.getIsPaused())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6765\u6e90\u3011\u8be5\u6765\u6e90\u7c7b\u578b\u5df2\u88ab\u505c\u7528");
            }
            dto.setSource(sourceDto.getId().intValue());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getAddCascadeIdStr())) {
            TxCascadeCredentialDto cascadeDto = cascadeMap.get(dto.getAddCascadeIdStr());
            if (cascadeDto == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u8bfe\u7a0b\u987e\u95ee\u3011\u6240\u586b\u5185\u5bb9\u4e0d\u662f\u5929\u6821\u5458\u5de5");
            }
            dto.setAddCascadeId(cascadeDto.getCascadeId());
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getName().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getMobile().length() != 11) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
        }
        if (!dto.getMobile().startsWith("1")) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
        }
        if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getGenderStr())) {
            if (dto.getGenderStr().equals("\u7537")) {
                dto.setGender(0L);
            } else {
                if (!dto.getGenderStr().equals("\u5973")) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6027\u522b\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                dto.setGender(1L);
            }
        } else {
            dto.setGender(-1L);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTagsStr())) {
            String[] tags = dto.getTagsStr().split("[,|\uff0c]");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String t : tags) {
                if (!StringUtils.isNotBlank((CharSequence)t)) continue;
                map.put(t, "");
            }
            if (map.keySet().size() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u6700\u591a\u8f93\u516530\u4e2a\u6807\u7b7e");
            }
            for (String tag : map.keySet()) {
                if (tag.length() <= 15) continue;
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u5355\u4e2a\u6807\u7b7e\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRelationshipStr())) {
            if (Relatives.getValue((String)dto.getRelationshipStr()) == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u4eb2\u5c5e\u5173\u7cfb\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            dto.setRelationship(Relatives.getValue((String)dto.getRelationshipStr()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentName()) && dto.getParentName().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u59d3\u540d\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentMobile())) {
            if (StringUtils.isBlank((CharSequence)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dto.getParentMobile().length() != 11) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
            }
            if (!dto.getParentMobile().startsWith("1")) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
            }
            if (!ParamValidateUtils.validateMobile((String)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSchool()) && dto.getSchool().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u516c\u7acb\u5b66\u6821\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDegreeClass()) && dto.getDegreeClass().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5e74\u7ea7\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getQq())) {
            if (dto.getQq().length() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^[0-9]*$", dto.getQq())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u9700\u586b\u5199\u6570\u5b57");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getMail())) {
            if (dto.getMail().length() > 50) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u6700\u591a\u8f93\u516550\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", dto.getMail())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        if (updateRepeat || (orgStudent = this.orgStudentDao.getStudentByMobileAndName(orgId, dto.getMobile(), dto.getName())) == null) return;
        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u3010\u51b2\u7a81\u3011\u5df2\u5b58\u5728\u540d\u79f0\u3001\u624b\u673a\u53f7\u76f8\u540c\u7684\u5b66\u5458");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildOrgStudentDtoOld(StudentListResponseDto dto, Object[] lineData, List<String> headers, boolean updateRepeat, Long orgId) {
        OrgStudent orgStudent;
        String fieldName;
        int i;
        Preconditions.checkArgument((lineData.length == headers.size() ? 1 : 0) != 0, (Object)"\u6570\u636e\u6570\u76ee\u548c\u8868\u5934\u4e0d\u5339\u914d");
        Preconditions.checkArgument((boolean)this.validateHeader(headers), (Object)("\u8868\u5934\u683c\u5f0f\u9519\u8bef:" + headers.toString()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss 'CST' yyyy", Locale.ENGLISH);
        for (i = 0; i < lineData.length; ++i) {
            fieldName = cache.get(headers.get(i)).get("propName").toString();
            if (fieldName == null || !fieldName.equals("birthday") || lineData[i] == null || lineData[i].equals("")) continue;
            try {
                Date date = dateFormat.parse(lineData[i].toString());
                dto.setBirthdayStr(dateFormat.parse(lineData[i].toString()));
                dto.setBirthday(date.getTime());
                lineData[i] = lineData[i].toString();
                break;
            }
            catch (Exception date) {
                // empty catch block
            }
        }
        for (i = 0; i < lineData.length; ++i) {
            fieldName = cache.get(headers.get(i)).get("propName").toString();
            boolean empty = Boolean.parseBoolean(cache.get(headers.get(i)).get("empty").toString());
            String name = headers.get(i);
            Object value = lineData[i];
            if (fieldName == null) continue;
            if (fieldName.equals("birthday") && lineData[i] != null && !lineData[i].equals("")) {
                try {
                    Date date = dateFormat.parse(lineData[i].toString());
                    dto.setBirthdayStr(dateFormat.parse(lineData[i].toString()));
                    dto.setBirthday(date.getTime());
                    lineData[i] = lineData[i].toString();
                    continue;
                }
                catch (Exception e) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u751f\u65e5\u3011\u683c\u5f0f\u6709\u8bef\uff0c\u9700\u4e3a2001/1/1\u6216\u80052001-1-1\u6837\u5f0f");
                }
            }
            if (empty && (value == null || "".equals(value))) {
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR, "\u3010" + name + "\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            try {
                if (value == null || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) continue;
                if (value instanceof String) {
                    value = value.toString().trim();
                }
                BeanUtils.setProperty((Object)dto, (String)fieldName, (Object)value);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.warn("set StudentListResponseDto.{} = {} failed!", (Object)fieldName, value);
                throw new BussinessException((UniverseErrorCode)CrmErrorCode.FORMAT_ERROR);
            }
        }
        if (StringUtils.isBlank((CharSequence)dto.getName())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getName().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u59d3\u540d\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isBlank((CharSequence)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getMobile().length() != 11) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
        }
        if (!dto.getMobile().startsWith("1")) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
        }
        if (!ParamValidateUtils.validateMobile((String)dto.getMobile())) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getGenderStr())) {
            if (dto.getGenderStr().equals("\u7537")) {
                dto.setGender(0L);
            } else {
                if (!dto.getGenderStr().equals("\u5973")) throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6027\u522b\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
                dto.setGender(1L);
            }
        } else {
            dto.setGender(-1L);
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getTagsStr())) {
            String[] tags = dto.getTagsStr().split("[,|\uff0c]");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            for (String t : tags) {
                if (!StringUtils.isNotBlank((CharSequence)t)) continue;
                map.put(t, "");
            }
            if (map.keySet().size() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u6700\u591a\u8f93\u516530\u4e2a\u6807\u7b7e");
            }
            for (String tag : map.keySet()) {
                if (tag.length() <= 15) continue;
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u6807\u7b7e\u3011\u5355\u4e2a\u6807\u7b7e\u6700\u591a\u8f93\u516515\u4e2a\u5b57\u7b26");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRelationshipStr())) {
            if (Relatives.getValue((String)dto.getRelationshipStr()) == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u4eb2\u5c5e\u5173\u7cfb\u3011\u6240\u586b\u5185\u5bb9\u4e0e\u7cfb\u7edf\u9009\u9879\u4e0d\u5339\u914d");
            }
            dto.setRelationship(Relatives.getValue((String)dto.getRelationshipStr()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentName()) && dto.getParentName().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u59d3\u540d\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getParentMobile())) {
            if (StringUtils.isBlank((CharSequence)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (dto.getParentMobile().length() != 11) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u9700\u4e3a11\u4f4d\u6570\u5b57");
            }
            if (!dto.getParentMobile().startsWith("1")) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u5fc5\u987b\u4ee51\u5f00\u5934");
            }
            if (!ParamValidateUtils.validateMobile((String)dto.getParentMobile())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5bb6\u957f\u624b\u673a\u53f7\u3011\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSchool()) && dto.getSchool().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u516c\u7acb\u5b66\u6821\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDegreeClass()) && dto.getDegreeClass().length() > 30) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u5e74\u7ea7\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getQq())) {
            if (dto.getQq().length() > 30) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u6700\u591a\u8f93\u516530\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^[0-9]*$", dto.getQq())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010QQ\u3011\u9700\u586b\u5199\u6570\u5b57");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getMail())) {
            if (dto.getMail().length() > 50) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u6700\u591a\u8f93\u516550\u4e2a\u5b57\u7b26");
            }
            if (!Pattern.matches("^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$", dto.getMail())) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u3010\u90ae\u7bb1\u3011\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        String province = dto.getProvince();
        String city = dto.getCity();
        String county = dto.getCounty();
        String address = dto.getAddress();
        String region = "";
        int level = 0;
        if (StringUtils.isNotBlank((CharSequence)county)) {
            region = county;
            level = AreaUtils.AreaLevel.COUNTY.ordinal();
        } else if (StringUtils.isNotBlank((CharSequence)city)) {
            region = city;
            level = AreaUtils.AreaLevel.CITY.ordinal();
        } else if (StringUtils.isNotBlank((CharSequence)province)) {
            region = province;
            level = AreaUtils.AreaLevel.PROVINCE.ordinal();
        }
        long areaId = this.getAreaId(region, level);
        try {
            Location location = BaiduMapUtils.getLngAndLat((String)address, (String)region);
            if (location != null) {
                dto.setLatitude(location.getLat());
                dto.setLongitude(location.getLng());
            }
            dto.setAreaId(areaId);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (updateRepeat || (orgStudent = this.orgStudentDao.getStudentByMobileAndName(orgId, dto.getMobile(), dto.getName())) == null) return;
        throw new BussinessException((UniverseErrorCode)CrmErrorCode.CUSTOM_HAS_EXISTS, "\u3010\u51b2\u7a81\u3011\u5df2\u5b58\u5728\u540d\u79f0\u3001\u624b\u673a\u53f7\u76f8\u540c\u7684\u5b66\u5458");
    }

    private void wrapDto(StudentListResponseDto student) throws UnsupportedEncodingException {
        String province = student.getProvince();
        String city = student.getCity();
        String county = student.getCounty();
        String address = student.getAddress();
        String region = "";
        int level = 0;
        if (StringUtils.isNotBlank((CharSequence)county)) {
            region = county;
            level = AreaUtils.AreaLevel.COUNTY.ordinal();
        } else if (StringUtils.isNotBlank((CharSequence)city)) {
            region = city;
            level = AreaUtils.AreaLevel.CITY.ordinal();
        } else if (StringUtils.isNotBlank((CharSequence)province)) {
            region = province;
            level = AreaUtils.AreaLevel.PROVINCE.ordinal();
        }
        long areaId = this.getAreaId(region, level);
        Location location = BaiduMapUtils.getLngAndLat((String)address, (String)region);
        if (location != null) {
            student.setLatitude(location.getLat());
            student.setLongitude(location.getLng());
        }
        student.setAreaId(areaId);
        if (student.getGenderStr() == null || student.getGenderStr().equals("")) {
            student.setGender(-1L);
        } else if (student.getGenderStr().equals("\u5973")) {
            student.setGender(1L);
        } else {
            student.setGender(0L);
        }
        if (student.getRelationshipStr() != null) {
            student.setRelationship(Relatives.getValue((String)student.getRelationshipStr()));
        }
    }

    private long getAreaId(String region, int level) {
        if (StringUtils.isBlank((CharSequence)region) || level == 0) {
            return 0L;
        }
        List areas = this.areaDao.getAreaByBname(region, level);
        if (CollectionUtils.isNotEmpty((Collection)areas)) {
            return ((Area)areas.get(0)).getId();
        }
        return 0L;
    }

    public ImportDataProcessService.BatchSaveResult batchImportDatas(Long orgId, Long cascadeId, List<String> headers, List<Object[]> datas, boolean updateRepeat) {
        ImportDataProcessService.BatchSaveResult batchSaveResult = new ImportDataProcessService.BatchSaveResult();
        for (int i = 0; i < datas.size(); ++i) {
            Object[] data = datas.get(i);
            try {
                ImportDataProcessService.SingleSaveErrorResult singleSaveErrorResult = this.saveSingleData(orgId, cascadeId, headers, data, updateRepeat);
                if (!singleSaveErrorResult.isRepeat()) continue;
                batchSaveResult.getRepeatIndexs().add(i);
                continue;
            }
            catch (Throwable ex) {
                batchSaveResult.getFailIndexs().add(i);
            }
        }
        return batchSaveResult;
    }

    public void afterComplete() {
        log.info("[Upload] upload complete!");
    }

    public int[] getUniqueIndex() {
        return new int[]{0, 1};
    }

    public ImportDataProcessService.SingleSaveErrorResult validate(Long orgId, Long cascadeId, List<String> headers, ImportDataProcessService.SingleSaveErrorResult result, List<ImportDataProcessService.SingleSaveErrorResult> dataList, boolean updateRepeat) {
        result.setSuccess(true);
        try {
            this.buildOrgStudentDtoNew(new StudentImportModel(), result.getLineData(), headers, updateRepeat, orgId);
        }
        catch (BussinessException e) {
            result.setSuccess(false);
            result.setErrorMsg(e.getMessage());
            log.warn(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            result.setSuccess(false);
            result.setErrorMsg(CommonErrorCode.SYSTEM_ERROR.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadValidateResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
        InputStream in = null;
        try {
            int lasterCellNum;
            int demoRowNo;
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(STUDENT_RESULT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(1);
            XSSFRow row = null;
            int rowNo = demoRowNo = 2;
            int cellNo = 0;
            XSSFRow titleRow = sheet.getRow(1);
            XSSFCell defualtTitlecell = titleRow.getCell((int)titleRow.getFirstCellNum());
            XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();
            int tempColumnNum = lasterCellNum = titleRow.getLastCellNum();
            List<CustomFieldResponse> fields = this.customFieldService.getCustomFieldList((long)orgId);
            HashMap fieldMap = Maps.newHashMap();
            for (CustomFieldResponse field : fields) {
                if (field.getIsSystem() != 0 || field.getIsPaused() != 0) continue;
                fieldMap.put(field.getLabel(), field);
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)1, (int)tempColumnNum, (CellStyle)defaultTitleCellStype, (String)field.getLabel());
                this.buildFieldPrompt(field, sheet, tempColumnNum);
                ++tempColumnNum;
            }
            Map demoFormatMap = ExcelUtils.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)0, (int)(tempColumnNum > lasterCellNum ? tempColumnNum - 1 : lasterCellNum));
            Object value = null;
            sheet.getRow(demoRowNo).createCell(0);
            XSSFCellStyle rightCellStyle = sheet.getRow(demoRowNo).getCell(0).getCellStyle();
            rightCellStyle.setWrapText(true);
            rightCellStyle.setLocked(false);
            rightCellStyle.setAlignment((short)1);
            ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)rightCellStyle, (XSSFColor)new XSSFColor(Color.WHITE), (short)1);
            ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)rightCellStyle, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
            XSSFCellStyle errorCellStyle = (XSSFCellStyle)rightCellStyle.clone();
            ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)errorCellStyle, (XSSFColor)new XSSFColor(Color.YELLOW), (short)1);
            XSSFRow newtitleRow = sheet.getRow(1);
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (result.isSuccess()) continue;
                if (sheet.getRow(rowNo) == null) {
                    row = sheet.createRow(rowNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    value = i == 0 ? result.getErrorMsg() : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    if (i == 10 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = new Date(Long.parseLong(result.getLineData()[i - 1].toString()));
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)errorCellStyle, (Map)demoFormatMap), (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception date) {
                            // empty catch block
                        }
                    }
                    String title = newtitleRow.getCell(i).getStringCellValue();
                    String valueStr = this.excelValue2Str(value, title, fieldMap);
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)errorCellStyle, (String)valueStr);
                    ++cellNo;
                }
                ++rowNo;
            }
            Object rightValue = null;
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (!result.isSuccess()) continue;
                if (sheet.getRow(rowNo) == null) {
                    row = sheet.createRow(rowNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    rightValue = i == 0 ? "" : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    if (i == 10 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = new Date(Long.parseLong(result.getLineData()[i - 1].toString()));
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)rightCellStyle, (Map)demoFormatMap), (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception date) {
                            // empty catch block
                        }
                    }
                    String title = newtitleRow.getCell(i).getStringCellValue();
                    String valueStr = this.excelValue2Str(rightValue, title, fieldMap);
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)rightCellStyle, (String)valueStr);
                    ++cellNo;
                }
                ++rowNo;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportResult(OutputStream os, Long orgId, String taskId, Collection<ImportDataProcessService.SingleSaveErrorResult> data) {
        InputStream in = null;
        try {
            int lasterCellNum;
            int demoRowNo;
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(STUDENT_RESULT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(1);
            Object row = null;
            int rowNo = demoRowNo = 2;
            int cellNo = 0;
            XSSFRow titleRow = sheet.getRow(1);
            XSSFCell defualtTitlecell = titleRow.getCell((int)titleRow.getFirstCellNum());
            XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();
            int tempColumnNum = lasterCellNum = titleRow.getLastCellNum();
            List<CustomFieldResponse> fields = this.customFieldService.getCustomFieldList((long)orgId);
            HashMap fieldMap = Maps.newHashMap();
            for (CustomFieldResponse field : fields) {
                if (field.getIsSystem() != 0 || field.getIsPaused() != 0) continue;
                fieldMap.put(field.getLabel(), field);
                ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)1, (int)tempColumnNum, (CellStyle)defaultTitleCellStype, (String)field.getLabel());
                this.buildFieldPrompt(field, sheet, tempColumnNum);
                ++tempColumnNum;
            }
            Map demoFormatMap = ExcelUtils.getCellInfoMap((XSSFSheet)sheet, (int)demoRowNo, (int)0, (int)(tempColumnNum - 1));
            Object value = null;
            sheet.getRow(demoRowNo).createCell(0);
            XSSFCellStyle errorCellStyle = sheet.getRow(demoRowNo).getCell(0).getCellStyle();
            errorCellStyle.setWrapText(true);
            errorCellStyle.setLocked(false);
            errorCellStyle.setAlignment((short)1);
            ExcelUtils.fillCellStyleWithFullBorder((XSSFCellStyle)errorCellStyle, (short)1, (short)IndexedColors.GREY_25_PERCENT.getIndex());
            ExcelUtils.fillCellStyleWithBGColor((XSSFCellStyle)errorCellStyle, (XSSFColor)new XSSFColor(Color.YELLOW), (short)1);
            XSSFRow newtitleRow = sheet.getRow(1);
            for (ImportDataProcessService.SingleSaveErrorResult result : data) {
                if (result.isSuccess()) continue;
                if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                    sheet.getRow(demoRowNo).createCell(cellNo);
                }
                cellNo = 0;
                for (int i = 0; i <= result.getLineData().length; ++i) {
                    value = i == 0 ? result.getErrorMsg() : result.getLineData()[i - 1];
                    if (sheet.getRow(demoRowNo).getCell(cellNo) == null) {
                        sheet.getRow(demoRowNo).createCell(cellNo);
                    }
                    if (i == 10 && result.getLineData()[i - 1] != null && !result.getLineData()[i - 1].toString().equals("")) {
                        try {
                            Date date = new Date(Long.parseLong(result.getLineData()[i - 1].toString()));
                            ExcelUtils.fillTheXSSFCellWithDateValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)ExcelUtils.decorateStyleWithDataFormatMap((int)cellNo, (XSSFCellStyle)errorCellStyle, (Map)demoFormatMap), (Date)date);
                            ++cellNo;
                            continue;
                        }
                        catch (Exception date) {
                            // empty catch block
                        }
                    }
                    String title = newtitleRow.getCell(i).getStringCellValue();
                    String valueStr = this.excelValue2Str(value, title, fieldMap);
                    ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)rowNo, (int)cellNo, (CellStyle)errorCellStyle, (String)valueStr);
                    ++cellNo;
                }
                ++rowNo;
            }
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportTemplate(OutputStream os) {
        InputStream in = null;
        try {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(STUDENT_IMPORT_TEMPLATE_PATH);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            Long orgId = TianxiaoPCContext.getOrgId().longValue();
            if (orgId == null || orgId == 0L) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.TOKEN_ERROR, "TOKEN\u4e0d\u6b63\u786e");
            }
            List<CustomFieldResponse> fields = this.customFieldService.getCustomFieldList((long)orgId);
            Map<String, TxCascadeCredentialDto> cascadeMap = this.getOrgCascadeMapFieldMap(orgId);
            this.buildStudentTemplate(workbook, fields, true);
            workbook.write(os);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void buildCascadeColumnPrompts(XSSFWorkbook workbook, Collection<TxCascadeCredentialDto> cascades, int cellNum) {
        XSSFSheet sheet = workbook.getSheetAt(1);
        XSSFRow titleRow = sheet.getRow(1);
        short lasterCellNum = titleRow.getLastCellNum();
        String promptTitle = "";
        String promptContent = "\u8f93\u5165\u5458\u8303\u56f4:";
        ArrayList cascadeNameList = Lists.newArrayList();
        for (TxCascadeCredentialDto dto : cascades) {
            cascadeNameList.add(dto.getName());
        }
        String cascadeStr = StringUtils.join((Iterable)cascadeNameList, (String)",");
        promptContent = promptContent + cascadeStr;
        ExcelUtils.setHSSFStringPrompt((XSSFSheet)sheet, (String)promptTitle, (String)cascadeStr, (int)2, (int)1000, (int)cellNum, (int)cellNum);
    }

    private void buildStudentTemplate(XSSFWorkbook workbook, List<CustomFieldResponse> fields, boolean needPrompts) {
        XSSFSheet sheet = workbook.getSheetAt(1);
        XSSFRow titleRow = sheet.getRow(1);
        int lasterCellNum = titleRow.getLastCellNum();
        XSSFCell defualtTitlecell = titleRow.getCell((int)titleRow.getFirstCellNum());
        XSSFCellStyle defaultTitleCellStype = defualtTitlecell.getCellStyle();
        int tempColumnNum = lasterCellNum;
        for (CustomFieldResponse field : fields) {
            if (field.getIsSystem() != 0 || field.getIsPaused() != 0) continue;
            ExcelUtils.fillTheXSSFCellWithStringValue((XSSFSheet)sheet, (int)1, (int)tempColumnNum, (CellStyle)defaultTitleCellStype, (String)field.getLabel());
            this.buildFieldPrompt(field, sheet, tempColumnNum);
            ++tempColumnNum;
        }
    }

    public String validateResult(List<ImportDataProcessService.SingleSaveErrorResult> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            HashMap<String, ImportDataProcessService.SingleSaveErrorResult> map = new HashMap<String, ImportDataProcessService.SingleSaveErrorResult>();
            String key = null;
            for (ImportDataProcessService.SingleSaveErrorResult s : list) {
                key = String.format("%s_%s", s.getLineData()[0], s.getLineData()[1]);
                if (s.isSuccess() && map.get(key) != null) {
                    s.setSuccess(false);
                    s.setErrorMsg("\u3010\u51b2\u7a81\u3011\u5df2\u5b58\u5728\u540d\u79f0\u3001\u624b\u673a\u53f7\u76f8\u540c\u7684\u5b66\u5458");
                }
                map.put(key, s);
            }
        }
        return null;
    }

    static {
        String header = "\u59d3\u540d:name:true,\u624b\u673a\u53f7:mobile:true,\u6027\u522b:genderStr:false,\u6765\u6e90:sourceStr:false,\u8bfe\u7a0b\u987e\u95ee:addCascadeIdStr:false,\u6807\u7b7e:tagsStr:false,\u4eb2\u5c5e\u5173\u7cfb:relationshipStr:false,\u5bb6\u957f\u59d3\u540d:parentName:false,\u5bb6\u957f\u624b\u673a\u53f7:parentMobile:false,\u751f\u65e5:birthday:false,\u516c\u7acb\u5b66\u6821:school:false,\u5e74\u7ea7:degreeClass:false,\u8be6\u7ec6\u5730\u5740:address:false,QQ:qq:false,\u90ae\u7bb1:mail:false";
        if (StringUtils.isNotBlank((CharSequence)header) && header.contains(":")) {
            String[] cells = header.split(",");
            int index = 0;
            HashMap subMap = null;
            for (String cell : cells) {
                subMap = Maps.newHashMap();
                String[] column = cell.split(":");
                String name = column[0].trim();
                String propName = column[1];
                boolean empty = Boolean.parseBoolean(column[2]);
                subMap.put("propName", propName);
                subMap.put("index", index);
                subMap.put("empty", empty);
                cache.put(name, subMap);
                ++index;
            }
        }
    }
}

