package com.baijia.tianxiao.sal.student.impl.customFields;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldService;
import com.baijia.tianxiao.sal.student.constant.Biz;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldRequest;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.enums.SystemFields;
import com.baijia.tianxiao.sal.student.enums.UseStatus;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Sets;

import lombok.extern.slf4j.Slf4j;

/**
 * @author Rezar
 * @createDate :Jul 20, 2016 12:46:05 PM
 * @desc : 自定义字段配置服务信息（线索和学员共用）
 */
@Service
@Slf4j
public class CustomFieldServiceImpl implements CustomFieldService {

    @Autowired(required=false)
    private FieldShowInfoService fieldShowInfoService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;

    /**
     * 初始化当前机构的基本属性字段
     */
    /*@Override
    public List<CustomField> initSystemField(Long orgId) {
        // 判断当前机构是否已经进行了初始化 PS:是否需要进行加锁?
        boolean isInit = this.customFieldDao.hasInitSystemField(orgId);
        List<CustomField> generatorCustomFields = null;
        log.info("orgId param:{}, isInit param:{}", orgId, isInit);
        if (!isInit) {
            log.info("当前机构 :{} 的系统字段没有进行初始化，进行初始化操作, isInit param:{}", orgId, isInit);
            generatorCustomFields = SystemFields.generatorCustomSystemFields(orgId);
            // 批量插入，保证请求一次成功或者失败
            this.customFieldDao.batchInsert(generatorCustomFields);
        }
        return generatorCustomFields;
    }
    */
    /**
     * 初始化当前机构的基本属性字段
     */
    @Override
    public void initSystemField(Long orgId){
        List<CustomField> orgSysCustomeFieldlist = findSystemCustomeFieldNoPaused(orgId);
        List<CustomField> generatorCustomFields = SystemFields.generatorCustomSystemFields(orgId);
        
        Map<Integer,CustomField> orgSysCustoeFieldMap = list2MapByNum(orgSysCustomeFieldlist);
        
        Map<Integer,CustomField> generatorSysCustoeFieldMap = list2MapByNum(generatorCustomFields);
        
        Set<Integer> orgSysFieldSet = orgSysCustoeFieldMap.keySet();
        
        Set<Integer> generatorSysFieldSet = generatorSysCustoeFieldMap.keySet();
        
        //boolean bool = generatorSysFieldSet.retainAll(orgSysFieldSet);
        
        Set<Integer> tempSet = Sets.newHashSet(generatorSysFieldSet);
        tempSet.retainAll(orgSysFieldSet);
        
        generatorSysFieldSet.removeAll(tempSet);
        
        orgSysFieldSet.removeAll(tempSet);
        
        if(generatorSysFieldSet.size()>0){
            for(Integer a:generatorSysFieldSet){
                CustomField field = generatorSysCustoeFieldMap.get(a);
                field.setIsPaused(0);
                customFieldDao.save(field);
            }
            
        }
        
        if(orgSysFieldSet.size()>0){
            List<CustomField> needPauseList = Lists.newArrayList();
            for(Integer a:orgSysFieldSet){
                needPauseList.add(orgSysCustoeFieldMap.get(a));
            }
            
            for(CustomField delfield:needPauseList){
                
                delfield.setIsPaused(1);
                delfield.setUpdateTime(new Date());
                customFieldDao.update(delfield, "isPaused", "updateTime");
            }
            
        }
        
        
    }
    
    private Map<Integer,CustomField> list2MapByNum(List<CustomField> list){
        Map<Integer,CustomField> map = Maps.newHashMap();
        for(CustomField field:list){
            map.put(field.getSystemFieldNum(), field);
        }
        return map;
    }
    private List<CustomField> findSystemCustomeFieldNoPaused(Long orgId){
        List<CustomField> sysCustomeFieldList = customFieldDao.getCustomFieldList(orgId, 1);
        List<CustomField> sysCustomeFieldListNoPaused = Lists.newArrayList();
        for(CustomField field:sysCustomeFieldList){
            if(field.getIsPaused()==0){
                sysCustomeFieldListNoPaused.add(field);
            }
        }
        return sysCustomeFieldListNoPaused;
    }
    
    

    @Override
    @Transactional
    public CustomFieldResponse addFieldResuest(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId) {
        //字段的初始化
        initSystemField(orgId);
        // 对字段的校验
        saveOrUpdateFieldBefore(fieldRequest, orgId, optionDtoList);

        // 进行字段配置存储
        CustomField customField = FieldRequest.getCustomField(fieldRequest);
        customField.setOrgId(orgId);

        customFieldDao.save(customField);
        // 进行该字段name的填充
        Long id = customField.getId();
        customField.setName(id + "");
        customField.setUpdateTime(new Date());
        customFieldDao.update(customField, "name", "updateTime");

        // 如果是选项，进行选项的存储
        List<OptionDto> optionList = new ArrayList<>();
        List<Integer> choiceTypes = CustomFieldType.getChoiceType();
        if (choiceTypes.contains(fieldRequest.getType())) {
            List<TXCustomOption> txCustomOptions = saveOrUpdateChoiceFields(optionDtoList, id);

            for (TXCustomOption txCustomOption : txCustomOptions) {
                OptionDto dto = customOptionPoToDto(txCustomOption);
                optionList.add(dto);
            }
        }
        CustomFieldResponse response = CustomFieldResponse.getInstanceByCustomField(customField, optionList);
        log.info("[CustomField] response:{}", response);

        // 新增自定义字段时,在FieldShowInfo表中最后一个锁定字段(手机号)后面插入,线索/学员分别处理
        this.fieldShowInfoService.addCustomField(orgId, DataProcType.CONSULT, id);
        this.fieldShowInfoService.addCustomField(orgId, DataProcType.ORG_STUDENT, id);

        return response;
    }

    @Override
    @Transactional
    public void modCustomField(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId) {
        // 对字段进行校验
        saveOrUpdateFieldBefore(fieldRequest, orgId, optionDtoList);

        // 对字段进行更新
        CustomField customFieldPo = FieldRequest.getCustomField(fieldRequest);
        customFieldPo.setUpdateTime(new Date());
        customFieldDao.update(customFieldPo);

        Long parentId = customFieldPo.getId();

        if (GenericsUtils.notNullAndEmpty(optionDtoList)) {
            saveOrUpdateChoiceFields(optionDtoList, parentId);
        }

        // 修改自定义字段名字时同步CRM的FieldShowInfo
        this.fieldShowInfoService.modCustomShowName(orgId, DataProcType.CONSULT, customFieldPo.getId());
        this.fieldShowInfoService.modCustomShowName(orgId, DataProcType.ORG_STUDENT, customFieldPo.getId());
    }

    @Override
    public List<CustomFieldResponse> getCustomFieldList(Long orgId) {
        //进行字段的初始化
        initSystemField(orgId);
        
        List<CustomField> customFields = customFieldDao.getCustomFieldList(orgId, null);
        if (customFields == null || customFields.size() == 0) {
            return Collections.emptyList();
        }

        List<CustomFieldResponse> responseList = new ArrayList<>();
        for (CustomField customFiled : customFields) {
            List<OptionDto> optionList = new ArrayList<>();
            List<Integer> choiceTypes = CustomFieldType.getChoiceType();
            if (choiceTypes.contains(customFiled.getType())) {
                Long parentId = customFiled.getId();
                List<TXCustomOption> customOptionList = txCustomOptionDao.getTXCustomOptionList(parentId);
                if (customOptionList != null && customOptionList.size() > 0) {
                    List<OptionDto> pauseOptions = new ArrayList<>();
                    for (TXCustomOption customOption : customOptionList) {
                        OptionDto optionDto = customOptionPoToDto(customOption);
                        // 要求停用的放在最后
                        if (customOption.getIsPaused() == PauseStatus.PAUSE.getStatus()) {
                            pauseOptions.add(optionDto);
                        } else {
                            optionList.add(optionDto);
                        }
                    }
                    optionList.addAll(pauseOptions);
                }
            }
            CustomFieldResponse response = CustomFieldResponse.getInstanceByCustomField(customFiled, optionList);
            responseList.add(response);
        }

        return responseList;
    }

    @Override
    @Transactional
    public void updateCustomFieldByIsPaused(Long id, Integer isPaused, Long orgId) {
        CustomField customField = customFieldDao.getCustomFieldById(orgId, id);
        if (customField != null) {
            //如果是系统字段，返回错误吗
            if(customField.getSystemFieldNum() >-1){
                log.warn("The customField is system field!");
                throw new BussinessException(StudentErrorCode.SYSTEM_FIELD);
            }
            // 停用状态和数据库不一致时，更新状态，否则不更新
            if (customField.getIsPaused() != isPaused) {
                // 更新FieldShowInfo的状态,线索/学员。与下面customFieldDao.update的逻辑顺序不可变
                if (isPaused.intValue() == BizConf.FALSE.intValue()) {
                    this.fieldShowInfoService.enableCustomField(orgId, DataProcType.CONSULT, id);
                    this.fieldShowInfoService.enableCustomField(orgId, DataProcType.ORG_STUDENT, id);
                } else {
                    this.fieldShowInfoService.pauseCustomField(orgId, DataProcType.CONSULT, id);
                    this.fieldShowInfoService.pauseCustomField(orgId, DataProcType.ORG_STUDENT, id);
                }

                customField.setIsPaused(isPaused);
                customField.setUpdateTime(new Date());
                customFieldDao.update(customField, "isPaused", "updateTime");
            }
        } else {
            log.warn("The customField is not exist!");
            throw new BussinessException(StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
        }
    }

    public void deleteCustomField(Long id, Long orgId) {
        CustomField customField = customFieldDao.getCustomFieldById(orgId, id);
        if (customField != null) {
            //判断是否是系统字段
            if(customField.getSystemFieldNum() > -1){
                log.warn("The customField is system field!");
                throw new BussinessException(StudentErrorCode.SYSTEM_FIELD);
            }
            
            Integer isUsed = customField.getIsUsed();
            if (isUsed == UseStatus.IS_USED.getStatus()) {
                log.warn("The customField is used, the id is param:{}", customField.getId());
                throw new BussinessException(StudentErrorCode.CUSTOM_FIELD_NOT_DELETE);
            } else {
                Integer type = customField.getType();
                List<Integer> choiceTypes = CustomFieldType.getChoiceType();
                if (choiceTypes.contains(type)) {
                    // 删除该字段所有子选项
                    txCustomOptionDao.deleteOptionsByParentId(id);
                }
                // 删除FieldShowInfo表对应的字段,线索/学员,与下面customFieldDao.delById逻辑顺序不可变
                this.fieldShowInfoService.deleteCustomField(orgId, DataProcType.CONSULT, id);
                this.fieldShowInfoService.deleteCustomField(orgId, DataProcType.ORG_STUDENT, id);

                // 进行该字段的删除
                customFieldDao.delById(id);
            }
        } else {
            log.warn("The customfield is not exist");
            throw new BussinessException(StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
        }
    }

    /**
     * 判断字段名称是否重复
     * 
     * @param customFields
     * @return
     */
    private Boolean checkoutFieldLabelDouble(List<CustomField> customFields, FieldRequest fieldRequest) {
        Boolean isDouble = false;
        String label = fieldRequest.getLabel();
        Long id = fieldRequest.getId();
        log.info("[CustomField] id:{}", id);
        List<String> labels = new ArrayList<>();
        for (CustomField customField : customFields) {
            String label1 = customField.getLabel();
            if (id != null && id.equals(customField.getId()) && label.equals(label1)) {
                return false;
            }
            labels.add(label1);
        }
        if (labels.contains(label)) {
            isDouble = true;
        }
        return isDouble;
    }

    /**
     * 选项是否重复 返回重复选项名称
     */
    private String checkoutChoiceRepeat(List<OptionDto> optionDtoList) {
        Map<String, Integer> choiceCountMap = new HashMap<>();
        for (OptionDto optionDto : optionDtoList) {
            if(optionDto.getIsDel() == DeleteStatus.DELETED.getValue()){
                continue;
            }
            String label = optionDto.getLabel();
            // 判断名称长度是否超过10
            if (StringUtils.isNotBlank(label)) {
                if (label.length() > Biz.MAX_CHOICE_LABEL_LENGTH) {
                    throw new BussinessException(StudentErrorCode.MAX_CHOICE_LABEL_LENGTH);
                }
            } else {
                throw new BussinessException(StudentErrorCode.CHOICE_LABEL_NULL);
            }
            
            if (choiceCountMap.get(label) == null) {
                choiceCountMap.put(label, 1);
            } else {
                choiceCountMap.put(label, choiceCountMap.get(label) + 1);
            }
        }

        StringBuilder sb = new StringBuilder("");

        for (Map.Entry<String, Integer> entry : choiceCountMap.entrySet()) {
            if (entry.getValue() > 1) {
                sb.append(entry.getKey()).append(",");
            }
        }

        if (GenericsUtils.notNullAndEmpty(sb.toString().trim())) {
            sb.deleteCharAt(sb.length() - 1);
            sb.insert(0, "【");
            sb.insert(sb.length(), "】");
            sb.append("选项已经存在");
        }
        return sb.toString();
    }

    private OptionDto customOptionPoToDto(TXCustomOption po) {
        OptionDto dto = new OptionDto();
        BeanUtils.copyProperties(po, dto);
        return dto;
    }

    /**
     * 对字段进行保存前的校验
     */
    private void saveOrUpdateFieldBefore(FieldRequest fieldRequest, Long orgId, List<OptionDto> optionDtoList) {
        //更新字段时判断字段是否存在，是否是系统字段，字段类型不可更改
        if (fieldRequest.getId() != null) {
            CustomField customField = customFieldDao.getCustomFieldById(orgId, fieldRequest.getId());
            // 判断该字段是否存在
            if (customField == null) {
                log.warn("The customfield is not exist, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.CUSTOM_FIELD_NOT_EXIST);
            }else if (customField.getSystemFieldNum() > -1){
                log.warn("The customField is system field!");
                throw new BussinessException(StudentErrorCode.SYSTEM_FIELD);
            }else if (customField.getType() != fieldRequest.getType()){
                // 更新字段时，字段类型不允许更改
                log.warn("The customfield is exist, type cannot change, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.CUSTOM_FIELD_TYPE_CHANGE);
            }
            
        }else{//添加时需要校验字段个数
            // 判断自定义字段的个数不能超过20
            List<CustomField> customFields = customFieldDao.getCustomFieldList(orgId, AddType.NOT_SYSTEM.getCode());
            if (customFields != null && customFields.size() >= Biz.MAX_FIELDS) {
                log.warn("The number of customfield is number more than 20, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.MAX_CUSTOM_FIELD_NUMBER);
            }
        }

        // 字段label长度不能超过15个字
        if (StringUtils.isBlank(fieldRequest.getLabel())) {
            log.warn("The label is null");
            throw new BussinessException(StudentErrorCode.LABEL_NULL);
        } else {
            if (fieldRequest.getLabel().length() > Biz.MAX_LABEL_LENGTH) {
                log.warn("The label's length is more 15, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.MAX_LABEL_LENGTH);
            }
        }

        // 获取所有字段
        List<CustomField> customFieldAll = customFieldDao.getCustomFieldList(orgId, null);
        // 判断字段label是否重复
        if (customFieldAll != null) {
            Boolean isDouble = checkoutFieldLabelDouble(customFieldAll, fieldRequest);
            if (isDouble) {
                log.warn("The label is repeat, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.LABEL_REPEAT);
            }
        }

        // 当类型是选项时
        List<Integer> choiceTypes = CustomFieldType.getChoiceType();
        if (choiceTypes.contains(fieldRequest.getType())) {
            // 判断选项个数
            if (optionDtoList == null || optionDtoList.size() == 0) {
                log.warn("The number of option is 0, fieldId param:{}", fieldRequest.getId());
                throw new BussinessException(StudentErrorCode.MIN_CHOICE_NUMBER);
            } else {
                int normalOptionCount = 0;
                for(OptionDto optionDto : optionDtoList){
                    if(optionDto.getIsDel() == DeleteStatus.NORMAL.getValue()){
                        normalOptionCount ++;
                    }
                }
                
                if(normalOptionCount > Biz.MAX_CHOICE){
                    log.warn("The number of option is more 8, fieldId param:{}", fieldRequest.getId());
                    throw new BussinessException(StudentErrorCode.MAX_CHOICE_NUMBER);
                }
            }

            // 判断子选项名称是否有重复的
            String repeatChoices = checkoutChoiceRepeat(optionDtoList);
            if (GenericsUtils.notNullAndEmpty(repeatChoices)) {
                log.warn("The option label is repeat, fieldId param:{}", fieldRequest.getId());
                BussinessException repeateChoiceException =
                    new BussinessException(StudentErrorCode.CHOICE_REPEAT, repeatChoices);
                throw repeateChoiceException;
            }
        }

    }

    /**
     * 选项的存储
     * 
     * @param optionDtoList
     * @return 返回save后的List<TXCustomOption>
     */
    private List<TXCustomOption> saveOrUpdateChoiceFields(List<OptionDto> optionDtoList, Long parentId) {
        // 被删除选项
        List<Long> delIds = new ArrayList<>();
        // 新创建子选项
        List<TXCustomOption> newCustomOption = new ArrayList<>();

        for (OptionDto optionDto : optionDtoList) {
            TXCustomOption customOption = OptionDto.buildTXCustomOption(optionDto);
            Long id = optionDto.getId();
            Integer isDel = optionDto.getIsDel();
            if (id != null) {
                if (isDel == DeleteStatus.DELETED.getValue()) {
                    delIds.add(id);
                } else {
                    customOption.setUpdateTime(new Date());
                    txCustomOptionDao.update(customOption);
                }
            } else {
                customOption.setParentId(parentId);
                newCustomOption.add(customOption);
            }
        }

        // 批量删除选项
        if (GenericsUtils.notNullAndEmpty(delIds)) {
            batchDeleteChoiceFields(delIds);
        }

        // 批量保存子选项
        if (GenericsUtils.notNullAndEmpty(newCustomOption)) {
            txCustomOptionDao.saveAll(newCustomOption);
        }

        return newCustomOption;
    }

    // 批量删除子选项
    private void batchDeleteChoiceFields(List<Long> delIds) {
        List<TXCustomOption> customOptionList = txCustomOptionDao.getByIds(delIds);
        if (customOptionList != null && customOptionList.size() > 0) {
            StringBuffer sb = new StringBuffer("");
            for (TXCustomOption customChoiceField : customOptionList) {
                if (customChoiceField.getIsUsed() == 1) {
                    sb.append(customChoiceField.getLabel() + ",");
                }
            }
            if (GenericsUtils.notNullAndEmpty(sb.toString().trim())) {
                sb.deleteCharAt(sb.length() - 1);
                sb.insert(0, "【");
                sb.insert(sb.length(), "】");
                sb.append("选项已被使用，无法删除，您可选择停用");
                // 抛出异常
                BussinessException deleteChoiceException =
                    new BussinessException(StudentErrorCode.CHOICE_NOT_DELETE, sb.toString());
                throw deleteChoiceException;
            }
        }

        txCustomOptionDao.batchDeleteOptions(delIds);
    }
    
    @Override
    public void modCustomFieldsSorted(List<FieldRequest> fieldRequestList) {
        if(GenericsUtils.isNullOrEmpty(fieldRequestList)){
            return;
        }
        for(FieldRequest request : fieldRequestList){
            CustomField customField = FieldRequest.getCustomField(request);
            customField.setUpdateTime(new Date());
            customFieldDao.update(customField, "sorted", "sectionId", "updateTime");
        }
        return;
    }
    
    
}

