package com.baijia.tianxiao.sal.student.enums;

import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;

import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Rezar
 * @createDate :Jul 19, 2016 10:26:19 PM
 * @desc :
 */
public enum CustomFieldType {

    TEXT(1, "文本"),
    SINGLE_CHOICE(2, "单选"),
    MULTI_CHOICE(3, "多选"),
    DAY_DATE(4, "日期"),
    DAY_TIME_DATE(5, "日期时间"),
    INTEGER(6, "整数"),
    FLOAT(7, "浮点数"),
    PICTURE(8, "图片"),
    POSITION(9, "地理位置"),
    TAGS(10, "标签");

    public Integer type;
    public String desc;

    private static Map<Integer, CustomFieldType> enumMap = new HashMap<>();

    static {
        for (CustomFieldType fieldType : CustomFieldType.values()) {
            enumMap.put(fieldType.type, fieldType);
        }
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustomFieldType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CustomFieldType getCustomFieldType(Integer fieldType) {
        return enumMap.get(fieldType);
    }
    
    public static List<Integer> getChoiceType(){
        List<Integer> choiceTypes = new ArrayList<>();
        choiceTypes.add(CustomFieldType.SINGLE_CHOICE.getType());
        choiceTypes.add(CustomFieldType.MULTI_CHOICE.getType());
        return choiceTypes;
    }

    @SuppressWarnings("unchecked")
    public static <V extends Object> V retValue(Object value) {
        return (V) value;
    }

    public static void buildSearchValue(CustomFieldValue fieldValue ) throws JsonParseException, JsonMappingException, IOException{
        
        Map<String, Object> valueMap = JacksonUtil.str2Obj(fieldValue.getValue(),
            new TypeReference<Map<String, Object>>() {
            });
        
        
        String value = buildCustomSearchValue(fieldValue.getFieldId(),fieldValue.getFieldType(),valueMap);
        if(StringUtils.isNotBlank(value)){
            fieldValue.setSearchValue(value);
        }else{
            fieldValue.setSearchValue(null);
        }
        return ;
    }
    
    public static String buildCustomSearchValue(Long fieldId,Integer fieldType,Map<String,Object> valueMap ) throws JsonParseException, JsonMappingException, IOException{
        
        
        CustomFieldType type =
            CustomFieldType.getCustomFieldType(fieldType);
        
        if (type != null) {
            String value = "";
            switch (type) {
                case TEXT: {
                    if (valueMap.get("content") != null && StringUtils.isNotBlank(valueMap.get("content").toString())) {
                        
                        value = fieldId+"#"+valueMap.get("content").toString();
                    }
                    break;
                }
                case SINGLE_CHOICE: {
                    if (valueMap.get("value") != null) {
                        value = fieldId+"#"+valueMap.get("id").toString();
                    }
                    break;
                }
                case MULTI_CHOICE: {
                    List<Map<Long, Object>> multi =
                        (List<Map<Long, Object>>) valueMap.get("options");
                    if (org.apache.commons.collections4.CollectionUtils.isNotEmpty(multi)) {
                        for (Map<Long, Object> item : multi) {
                            if (StringUtils.isBlank(value)) {
                                value += fieldId+"#"+item.get("id");
                            } else {
                                value += (" " + fieldId+"#"+item.get("id"));
                            }
                        }
                    }
                    break;
                }
                case DAY_DATE: {
                    if (valueMap.get("content") != null) {
                        value = valueMap.get("content").toString();
                        if (StringUtils.isNotBlank(value)) {
                            value = fieldId+"#"+DateUtil.getStrByDate(new Date(Long.parseLong(value)));
                        }
                    }
                    break;
                }
                default:
                    break;
            }
            
            return value;
        }
        return null;
    }
}
