/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.dto.response;

import java.io.Serializable;
import java.math.BigDecimal;

import com.baijia.commons.lang.utils.PropertiesReader;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentCourseInfoReponseDto
 * @desc 学生报名课程信息接口
 * @date 2015年12月4日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class StudentCourseInfoReponseDto extends KexiaoStatisticsSuper implements Serializable {

    private static final long serialVersionUID = 7214823104479601699L;

    private Long courseId;

    private Long courseNumber;

    private String courseName;

    private String url;

    public void setCourseNumber(Long courseNumber) {
        this.courseNumber = courseNumber;
        this.url = PropertiesReader.getProperties("rest.properties").getProperty("org_class_course.url") + courseNumber;
    }
    
    public void setCourseType(Integer courseType){
        this.courseType = courseType;
    }
    
    public void setTxCourseType(Integer txCourseType){
        this.txCourseType = txCourseType;
    }

    // 课程类型
    private Integer courseType;

    // 天校课程类型
    private Integer txCourseType;

    // 总课次
    @Deprecated
    private Integer totalClassTimes = 0;

    // 完成课次
    @Deprecated
    private Integer finishClassTimes = 0;

    // 剩余课次
    @Deprecated
    private Integer leftClassTimes = 0;

    private int isDel;

    private int status;//// 0在读 1:退班 2:转班

    private long parentId;

    private int isClass;

    // 可笑2.0新数据 begin---
    private Integer chargeType;
    private Integer chargeUnit;
    private Integer buyCount;
    private String headTeacher;

    private String tipInfo = "";
    private String tipInfoUrl = "";
    private Integer finishPercent = 0; // 进度
    // 可笑2.0新数据 end---
    
    public int getStatus(){
        return this.status;
    }

    /**
     * @param course
     * @param osc
     * @return
     */
    public static StudentCourseInfoReponseDto getInstance(OrgCourse course) {
        StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
        dto.setCourseName(course.getName());
        dto.setCourseId(course.getId());
        dto.setCourseNumber(course.getNumber());
        dto.setIsDel(course.getIsDel());
        Integer courseType = course.getCourseType();
        if (courseType != null && courseType == 3) {
            courseType = 2;
        }
        dto.setCourseType(courseType);
        dto.setTxCourseType(courseType);
        dto.setIsClass(course.getIsClass());
        dto.setParentId(course.getParentId());
        dto.setChargeType(course.getChargeType());
        dto.setChargeUnit(course.getChargeUnit());
        return dto;
    }

    /**
     * @param count
     * @param chargeUnit
     * @return
     */
    public static float countClassHour(int count, int chargeUnit) {
        if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
            BigDecimal b1 = new BigDecimal(Float.toString(count * 5));
            BigDecimal b2 = new BigDecimal(Float.toString(10));
            return b1.divide(b2, 1, BigDecimal.ROUND_HALF_UP).floatValue();
        }
        return count;
    }

    // private static String SHOW_STR_OF_CLASS_HOUR = "剩余%s小时";
    // private static String SHOW_STR_OF_TIMES = "剩余%s次";

    /**
     * @return
     */
    // public String getClassHourInfo() {
    // String format = SHOW_STR_OF_TIMES;
    // if (chargeUnit == ChargeUnit.BY_HALF_HOUR.getCode()) {
    // format = SHOW_STR_OF_CLASS_HOUR;
    // }
    // String showInfo = "";
    // if (this.leftClassTimes != null) {
    // showInfo = String.valueOf(countClassHour(this.leftClassTimes, this.chargeUnit));
    // } else {
    // showInfo = "-";
    // }
    // return String.format(format, showInfo);
    // }

}
