package com.baijia.tianxiao.sal.student.api.customFields;

import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;
import com.baijia.tianxiao.sal.student.dto.customFields.CustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldRequest;

import java.util.List;

/**
 * @author Rezar
 * @createDate :Jul 20, 2016 12:36:18 PM
 * @desc : 自定义字段业务层接口
 */
public interface CustomFieldService {
    
    
    
    //public List<CustomField> initSystemField(Long orgId);
    
    
    public void initSystemField(Long orgId);

    /**
     * 添加自定义字段
     * @param fieldRequest
     * @param optionDtoList
     * @param orgId
     * @return
     */
    public CustomFieldResponse addFieldResuest(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId);
    
    /**
     * 查看机构所有字段
     * @param orgId
     * @return
     */
    public List<CustomFieldResponse> getCustomFieldList(Long orgId);
    
    /**
     * 根据停用状态进行字段状态值的修改
     * @param id
     * @param isPaused
     */
    public void updateCustomFieldByIsPaused(Long id, Integer isPaused, Long orgId);
    
    /**
     * 删除字段，需要把其响应的的子选项字段删除。
     * 做法：直接删
     * @param id
     */
    public void deleteCustomField(Long id, Long orgId);
    
    /**
     * 修改字段
     */
    public void modCustomField(FieldRequest fieldRequest, List<OptionDto> optionDtoList, Long orgId);
    
    /**
     * 修改字段顺序
     */
    public void modCustomFieldsSorted(List<FieldRequest> fieldRequestList);


}
