/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.StudentCustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.request.MobileCheckInfoRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.BatchAddStudentResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.MobileCheckReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.SignupStudentTypeResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.TwoTuple;
import com.google.common.collect.ArrayListMultimap;

/**
 * @title StudentService
 * @desc 机构学生相关业务
 * @author shanyu
 * @date 2015年12月4日
 * @version 1.0
 */

public interface OrgStudentService {

    /**
     * 添加机构学员
     * 
     * @param studentInfoDto
     * @param orgId 机构id
     */
    public OrgStudentAddresponseDto addStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> comments,
        List<TagInfoDto> tags, Long orgId) throws BussinessException;

    /**
     * 删除机构学员
     * 
     * @param studentCommenRequestDto
     * @param orgId 机构id
     */
    public void delStudent(StudentCommenRequestDto studentCommenRequestDto, Long orgId);

    /**
     * 编辑机构学生信息
     * 
     * @param studentInfoDto
     * @param orgId
     */
    public void modStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos,
        Long orgId);

    /**
     * 获取机构学员的详细信息
     * 
     * @param studentCommenRequestDto
     * @param orgId
     * @return
     */
    public StudentInfoDto getStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId,
        Integer cascadeId);

    /**
     * 获取机构学员的基础信息
     * 
     * @param studentCommenRequestDto
     * @param orgId
     * @param hideMobile 是否隐藏手机号
     * @return
     */
    public StudentInfoDto getBasicStudentInfo(Long studentId, Long orgId, boolean hideMobile);

    /**
     * 获取学员列表
     * 
     * @param studentListRequestDto
     * @param orgId
     * @param pageDto
     * @return
     */
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, Long orgId,
        PageDto pageDto);

    /**
     * 学员筛选
     * 
     * @param studentListRequestDto
     * @param orgId
     * @param pageDto
     * @return
     */
    public List<StudentDto> searchStudentList(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto);

    /**
     * 校验手机号对应联系人是否已经是机构学员
     * 
     * @param orgId
     * @param request
     * @return
     */
    public MobileCheckReponseDto checkmobile(Long orgId, List<MobileCheckInfoRequestDto> mobiles);

    /**
     * 批量添加学员
     * 
     * @param studentInfoDtos
     * @param orgId
     * @return
     */
    public List<BatchAddStudentResponseDto> batchAddStudent(List<? extends StudentInfoDto> studentInfoDtos, Long orgId);

    /**
     * 根据studentIds 查 userIds
     */
    Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds);

    /**
     * 根据studentIds 查 学生名
     */
    Map<Long, String> getStudentNameMap(Collection<Long> studentIds);

    /**
     * 根据userIds 查 studentIds
     */
    Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId);

    /**
     * 根据userIds 查 StudentInfoDtos
     */
    Map<Long, StudentInfoReponseDto> getUserIdStudentDtoMap(Collection<Long> userIds, Long orgId);

    /**
     * 根据学生手机号码查询学生信息
     * 
     * @param orgId
     * @param mobile
     * @return
     */
    public StudentInfoDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId)
        throws BussinessException;

    public StudentInfoDto getOrgStudentByMobile(Long orgId, String mobile);

    /**
     * 根据微信openId查询学生信息
     * 
     * @param orgId
     * @param weixinOpenId
     * @return
     */
    public List<StudentInfoDto> getAndUpdateOrgStudentByOpenId(Long orgId, String weixinOpenId);

    /**
     * 分组查询学生
     * 
     * @param pageDto
     * @param format
     * @param value
     * @return
     */
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value);

    /**
     * 根据学员转态统计学员数量
     * 
     * @param orgId
     * @return
     */
    public List<StudentStatusStatistics> getStudentStatusStatisticsByOrgId(Long orgId);

    public int syncStudent(PageDto pageDto);

    public List<StudentInfoDto> listOrgStudentByMobile(Long orgId, String mobile);

    public void updateStudentNextRemindTime(Integer orgId, Long studentId, Long nextRemindTime);

    public List<Long> getStudentidsByCourseIds(Long orgId, List<Long> courseIds);

    /**
     * @param studentListRequestDto
     * @param studentids
     * @param orgId
     * @param pageDto
     * @return
     */

    StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, List<Long> studentids,
        Long orgId, PageDto pageDto);

    /**
     * @param studentInfoDto
     * @param commentDtos
     * @param tagDtos
     * @param orgId
     * @return
     * @throws BussinessException
     */

    OrgStudentAddresponseDto addStudentIgnoreExistMobile(StudentInfoDto studentInfoDto,
        List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) throws BussinessException;

    /**
     * 更新线索或者学员的下次跟进时间后，</br>
     * 更新今日待办中线索或者学员的待办提醒时间
     * 
     * @param orgId
     * @param student
     * @param consulterId
     */
    void updateSysBacklog(Long orgId, OrgStudent student, Long consulterId);

    /**
     * 判断某个账号能不能访问某个学员的信息
     * 
     * @param userId
     * @param orgNumber
     * @param cascadeId
     * @param orgId
     * @return
     */
    boolean checkCanVisit(Long userId, Integer orgNumber, Integer cascadeId, Long orgId);

    /**
     * 获取某个学员的基本信息
     * 
     * @param studentCommenRequestDto
     * @param orgId
     * @return
     */
    StudentCustomFieldResponse getSimpleStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId,
        Integer cascadeId);

    public List<StudentInfoDto> listOrgStudentByMobiles(Long orgId, List<String> mobile);

    public void updateSysBacklogForConsulter(Long orgId, TxConsultUser consultUser);

    void updateSolr(Long id);

    /**
     * @param userIds :学员的Ids
     * @param orgId
     * @return
     */
    List<StudentDto> searchStudentClassInfo(Set<Long> studentIds, Long orgId);

    /**
     * @param userId
     * @param orgNumber
     * @param orgId
     * @param dto
     */
    void setPayMoneyAndTimes(Long userId, Long orgNumber, Long orgId, StudentInfoDto dto);

    /**
     * @param userId
     * @param orgId
     * @param dto
     */
    void setClassHour(Long userId, Long orgId, StudentInfoDto dto);

    /**
     * @param orgId
     * @param dto
     */
    void setFansInfo(Long studentId, Long orgId, StudentInfoDto dto);

    /**
     * @param orgId
     * @param isShowMobile
     * @param userId
     * @param dto
     */
    void setStudentComment(Long userId, Long orgId, Boolean isShowMobile, StudentInfoDto dto);

    /**
     * 根据一些删选类型进行跟进记录/成长记录的获取
     * 
     * @param userId
     * @param orgId
     * @param isShowMobile
     * @param growthStatus
     * @param lastCommentId
     * @param pageDto
     * @param dto
     */
    void setStudentComment(Long userId, Long orgId, Boolean isShowMobile, Integer growthStatus, Integer lastCommentId,
        PageDto pageDto, StudentInfoDto dto);

    /**
     * @param cascadeId
     * @param orgId
     * @param userId
     * @param dto
     */
    void setHeaderAndClassNum(Long userId, Long orgId, Integer cascadeId, Integer applicationType, StudentInfoDto dto);

    /**
     * @param orgId
     * @param userId
     * @param dto
     */
    void setStudentTags(Long userId, Long orgId, StudentInfoDto dto);

    public ArrayListMultimap<String, StudentInfoDto> getStudentMap(Long orgId, List<String> mobiles);

    /**
     * @param orgId
     * @param cascadeId
     * @return
     */
    boolean isShowMobileForStudentInfo(Long orgId, Integer cascadeId);

    /**
     * @param studentId
     * @param orgId
     * @param cascadeId
     * @param dto
     */
    void setStudentBaseInfo(Long studentId, Long orgId, Integer cascadeId, StudentInfoDto dto);

    /**
     * 学员转交给同事
     * 
     * @param orgId
     * @param studentId
     * @return
     */
    boolean passTo(long orgId, long studentId, Integer cascadeId, Integer loginId);

    public SignupStudentTypeResponseDto isOldSignupStudent(Long orgId, String mobile, String name);

    /**
     * @param userIds
     * @param orgId
     * @return
     */
        
    TwoTuple<Map<String, StudentClass>, Map<String, StudentClassHour>> findStudentClassAndStudentClassHour(
        Set<Long> userIds, Long orgId);


}
