/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.student.enums;

import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public enum CustomFieldType {
    TEXT(1, "\u6587\u672c"),
    SINGLE_CHOICE(2, "\u5355\u9009"),
    MULTI_CHOICE(3, "\u591a\u9009"),
    DAY_DATE(4, "\u65e5\u671f"),
    DAY_TIME_DATE(5, "\u65e5\u671f\u65f6\u95f4"),
    INTEGER(6, "\u6574\u6570"),
    FLOAT(7, "\u6d6e\u70b9\u6570"),
    PICTURE(8, "\u56fe\u7247"),
    POSITION(9, "\u5730\u7406\u4f4d\u7f6e"),
    TAGS(10, "\u6807\u7b7e");

    public Integer type;
    public String desc;
    private static Map<Integer, CustomFieldType> enumMap;

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    private CustomFieldType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CustomFieldType getCustomFieldType(Integer fieldType) {
        return enumMap.get(fieldType);
    }

    public static List<Integer> getChoiceType() {
        ArrayList<Integer> choiceTypes = new ArrayList<Integer>();
        choiceTypes.add(SINGLE_CHOICE.getType());
        choiceTypes.add(MULTI_CHOICE.getType());
        return choiceTypes;
    }

    public static <V> V retValue(Object value) {
        return (V)value;
    }

    public static void buildSearchValue(CustomFieldValue fieldValue) throws JsonParseException, JsonMappingException, IOException {
        Map valueMap = (Map)JacksonUtil.str2Obj((String)fieldValue.getValue(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        String value = CustomFieldType.buildCustomSearchValue(fieldValue.getFieldId(), fieldValue.getFieldType(), valueMap);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            fieldValue.setSearchValue(value);
        } else {
            fieldValue.setSearchValue(null);
        }
    }

    public static String buildCustomSearchValue(Long fieldId, Integer fieldType, Map<String, Object> valueMap) throws JsonParseException, JsonMappingException, IOException {
        CustomFieldType type = CustomFieldType.getCustomFieldType(fieldType);
        if (type != null) {
            String value = "";
            switch (type) {
                case TEXT: {
                    if (valueMap.get("content") == null || !StringUtils.isNotBlank((CharSequence)valueMap.get("content").toString())) break;
                    value = fieldId + "#" + valueMap.get("content").toString();
                    break;
                }
                case SINGLE_CHOICE: {
                    if (valueMap.get("value") == null) break;
                    value = fieldId + "#" + valueMap.get("id").toString();
                    break;
                }
                case MULTI_CHOICE: {
                    List multi = (List)valueMap.get("options");
                    if (!CollectionUtils.isNotEmpty((Collection)multi)) break;
                    for (Map item : multi) {
                        if (StringUtils.isBlank((CharSequence)value)) {
                            value = value + fieldId + "#" + item.get("id");
                            continue;
                        }
                        value = value + " " + fieldId + "#" + item.get("id");
                    }
                    break;
                }
                case DAY_DATE: {
                    if (valueMap.get("content") == null || !StringUtils.isNotBlank((CharSequence)(value = valueMap.get("content").toString()))) break;
                    value = fieldId + "#" + DateUtil.getStrByDate((Date)new Date(Long.parseLong(value)));
                    break;
                }
            }
            return value;
        }
        return null;
    }

    static {
        enumMap = new HashMap<Integer, CustomFieldType>();
        for (CustomFieldType fieldType : CustomFieldType.values()) {
            enumMap.put(fieldType.type, fieldType);
        }
    }
}

