package com.baijia.tianxiao.sal.student.util;

import com.baijia.tianxiao.util.mobile.MaskUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by liuxp on 16/6/17.
 */
@Slf4j
public class CommentUtil {

    public static String maskMobile(String text) {
        Pattern pattern = Pattern.compile("【([0-9]+)】");
        log.info("[Mobile] mask,source string="+text);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String mobile = matcher.group(1);
            String maskMobile = MaskUtil.maskMobile(mobile);
            text = text.replace(mobile,maskMobile);
        }
        pattern = Pattern.compile("来电号码：([0-9]+)");
        matcher = pattern.matcher(text);
        while (matcher.find()) {
            String mobile = matcher.group(1);
            String maskMobile = MaskUtil.maskMobile(mobile);
            text = text.replace(mobile,maskMobile);
        }

        log.info("[Mobile] mask,target string="+text);
        return text;
    }

    public static void main(String[] args) {
        System.out.println(maskMobile(" 2016-03-23 19:43 将手机号【19900080100】修改为【19900080099】，活动名称：Huodong\\n姓名：波兹南市\\n来电号码：15118099999"));
    }

}
