package com.baijia.tianxiao.sal.student.pc.impl;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.constants.DataProcType;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.pcAuthority.constant.ApplicationType;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.field.FieldOption;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.consult.dto.ConsultCustomSourceDto;
import com.baijia.tianxiao.sal.consult.service.ConsultSourceService;
import com.baijia.tianxiao.sal.display.dto.response.crm.DefaultStudentField;
import com.baijia.tianxiao.sal.display.service.FieldShowInfoService;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.dto.TxCascadeCredentialDto;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.api.OrgStudentTagService;
import com.baijia.tianxiao.sal.student.api.customFields.CustomFieldValueService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.sal.student.pc.StudentUserService;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectorUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;

import com.beust.jcommander.internal.Maps;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @author wangsixia
 * @version 1.0
 * @title StudentUserServiceImpl
 * @desc 学员档案
 * @date 2016年3月17日
 */
@Service
@Slf4j
public class StudentUserServiceImpl implements StudentUserService {

    // 班主任
    private static final String CASCADE_ID_STR = "cascadeIdStr";
    // 课程顾问
    private static final String ADD_CASCADE_ID_STR = "addCascadeIdStr";
    // 来源
    private static final String SOURCES_TR = "sourceStr";
    // 标签
    private static final String TAGS_STR = "tagsStr";

    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private TxStudentCommentDao txStudentCommentDao;
    @Autowired
    private TxStudentTagDao txStudentTagDao;
    @Autowired
    private TxAccountPermissionService txAccountPermissionService;
    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private OrgStudentService orgStudentService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private OrgCourseDao orgCourseDao;
    @Autowired
    private CrmStudentQuery crmStudentQuery;
    @Autowired
    private FieldShowInfoService fieldShowInfoService;
    @Autowired
    private ConsultSourceService consultSourceService;
    @Autowired
    private CustomFieldValueService customFieldValueService;
    @Autowired
    private OrgStudentTagService orgStudentTagService;
    @Autowired
    private CustomFieldValueDao customFieldValueDao;
    
    @Override
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(CrmErrorCode.ORG_NOT_EXIST);
        }
        OrgStudent orgStudent = this.orgStudentDao.getById(studentId);
        if (null == orgStudent || orgStudent.getDelStatus() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.CONSULTER_NOT_EXISTS);
        }
        StudentInfoResponseDto baseInfoDto = new StudentInfoResponseDto();
        this.studentPo2Dto(orgStudent, baseInfoDto);
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());
        if (!isShowMobile) {
            baseInfoDto.setMobile(MaskUtil.maskMobile(baseInfoDto.getMobile()));
            baseInfoDto.setParentMobile(MaskUtil.maskMobile(baseInfoDto.getParentMobile()));
        }

        log.info("getBaseInfo---------baseInfoDto={}", baseInfoDto);
        return baseInfoDto;
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        this.doSaveBefore(orgId, studentInfo);

        Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
        Long userId = userInfoMap.get("id");

        OrgStudent orgStudent = new OrgStudent();
        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        orgStudent.setAddCascadeId(cascadeId == null ? 0 : cascadeId);
        this.orgStudentDao.save(orgStudent, false);
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        // 更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat)
        throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", orgId, studentInfo, updateRepeat);
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent =
                this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal(orgStudent);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save(orgStudent, false);
        }
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        if (StringUtils.isNotBlank(studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            List<TxStudentTag> tagList = new ArrayList<>();
            for (String tagStr : tags) {
                if (StringUtils.isNotBlank("tagStr")) {
                    TxStudentTag tag = new TxStudentTag();
                    tag.setOrgId(orgStudent.getOrgId());
                    tag.setUserId(orgStudent.getUserId());
                    tag.setContent(tagStr);
                    tagList.add(tag);
                }
            }
            this.txStudentTagDao.saveAll(tagList, "consultUserId", "userId", "orgId", "content");
        }

        // 更新solr
        updateSolr(orgStudent);
        return orgStudent.getId();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception {
        if (null == orgId || orgId <= 0 || null == studentInfo || null == studentInfo.getId()
            || studentInfo.getId() <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        OrgStudent orgStudent = this.orgStudentDao.getById(studentInfo.getId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
        }

        this.doSaveBefore(orgId, studentInfo);

        this.checkAndCreateComment(studentInfo, orgStudent);

        this.cascadeUpdateTxConsulter(orgId, orgStudent, studentInfo);

        if (studentInfo.getMobile().contains("****")) {
            studentInfo.setMobile(orgStudent.getMobile());
        }
        if (studentInfo.getParentMobile().contains("****")) {
            studentInfo.setParentMobile(orgStudent.getParentMobile());
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, null);
        this.orgStudentDao.update(orgStudent, false);
        log.info("editStudentInfo---------orgStudent={}", orgStudent);

        // 更新solr
        updateSolr(orgStudent);
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public void BatchDelStudent(Long orgId, Set<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        List<OrgStudent> list = this.orgStudentDao.getStudentByIds(orgId, studentIds);
        if (CollectionUtils.isNotEmpty(list)) {
            for (OrgStudent orgStudent : list) {
                if (orgStudent.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                    List<TxConsultUser> consultUserList = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
                    log.info("delStudent--------consultUserList={}", consultUserList);

                    if (null != consultUserList && !consultUserList.isEmpty()) {
                        this.delSysBacklog(orgId, orgStudent, consultUserList.get(0));

                        for (TxConsultUser consulterUser : consultUserList) {
                            consulterUser.setStudentId(0L);
                            this.txConsultUserDao.update(consulterUser, "studentId");
                        }
                    } else {
                        this.delSysBacklog(orgId, orgStudent, null);
                    }

                    orgStudent.setDelStatus(DeleteStatus.DELETED.getValue());
                    TxStudentComment comment = new TxStudentComment();
                    comment.setContent("机构删除学员");
                    comment.setUserId(orgStudent.getUserId());
                    comment.setOrgId(orgStudent.getOrgId());
                    comment.setIsSystem(AddType.SYSTEM.getCode());
                    this.txStudentCommentDao.save(comment);
                    this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
                    this.orgStudentDao.update(orgStudent, "delStatus");

                    // 更新solr
                    updateSolr(orgStudent);
                }
            }
        }
    }

    private void studentPo2Dto(OrgStudent po, StudentInfoResponseDto dto)
        throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(dto, po);
        log.info("StudentPo2Dto---------po={},dto={}", ToStringBuilder.reflectionToString(po), dto);
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }

        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
            dto.setNextRemindTimeStr(po.getNextRemindTime());
        }

        if (dto.getGender() == null || dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(po.getGender() == 1 ? "女" : "男");
        }
        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));

        if (null != po.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }
    }

    private void studentDto2Po(StudentListResponseDto dto, OrgStudent po, Long orgId, Long userId)
        throws IllegalAccessException, InvocationTargetException {
        BeanUtils.copyProperties(po, dto);
        log.info("studentDto2Po---------dto={},po:{}", dto, ToStringBuilder.reflectionToString(po));

        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            po.setNextRemindTime(null);
        }

        if (null == po.getId() || 0 == po.getId()) {
            // 新增
            po.setOrgId(orgId);
            po.setCreateTime(new Date());
            po.setUserId(userId);
        }

        if (null != dto.getBirthday()) {
            po.setBirthday(new Date(dto.getBirthday()));
        }
        po.setUpdateTime(new Date());
    }

    private void doSaveBefore(Long orgId, StudentListResponseDto studentInfo) {
        OrgStudent student = null;
        if (studentInfo.getId() != null && studentInfo.getId() > 0) {
            student = this.orgStudentDao.getById(studentInfo.getId());
            if (student != null && student.getOrgId() == orgId.longValue()
                && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                String mobile = student.getMobile();
                String name = student.getName();
                log.debug("mobile={},stMobile={},name={},stuName={}", mobile, studentInfo.getMobile(), name,
                    studentInfo.getName());
                if (mobile.equals(studentInfo.getMobile()) && studentInfo.getName().equals(name)) {
                    return;
                } else {
                    procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
                }
            } else {
                throw new BussinessException(CrmErrorCode.STUDENT_NOT_EXISTS);
            }
        } else {
            procSameMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
        }
    }

    /**
     * 处理学员手机号、姓名相同的情况
     *
     * @param orgId
     * @param mobile
     * @param name
     */
    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException(CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    /**
     * 学员档案分页查询、排序、搜索
     */
    @Override
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId, Integer cascadeId,
        CommonSearchRequestDto request, PageDto pageDto) throws Exception {
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentListRequestDto={},orgId={},pagedto={},solrStudnets = {}", studentListRequestDto, orgId,
            pageDto, solrStudents == null ? 0 : solrStudents.size());
        if (solrStudents.isEmpty()) {
            return GenericsUtils.emptyList();
        }
        final List<Long> userIds = new ArrayList<>(pageDto.getPageSize());
        Map<Long, StudentDto> studentDtoMap = CollectorUtil.collectMap(solrStudents, new Function<StudentDto, Long>() {
            @Override
            public Long apply(StudentDto studentDto) {
                userIds.add(studentDto.getUserId());
                return studentDto.getStudentId();
            }
        });
        Map<Long, String> searchTeacherNames = searchTeacherNames(new HashSet<>(userIds), orgId, cascadeId);

        log.info("headTeacherNames {} ", searchTeacherNames);

        List<OrgStudent> students = this.orgStudentDao.getByIds(studentDtoMap.keySet());

        Map<Long, OrgStudent> orgStudentMap = CollectorUtil.collectMap(students, new Function<OrgStudent, Long>() {
            @Override
            public Long apply(OrgStudent student) {
                return student.getId();
            }
        });

        // 是否显示手机号
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());

        List<TxStudentTag> studentTags = txStudentTagDao.getTags(userIds, orgId, StudentType.ORG_STUDENTS.getCode());
        Map<Long, List<TxStudentTag>> tagMap = new HashMap<>();
        if (studentTags != null && studentTags.size() > 0) {
            for (TxStudentTag tag : studentTags) {
                List<TxStudentTag> tagList = tagMap.get(tag.getUserId());
                if (tagList == null) {
                    tagList = new ArrayList<>();
                    tagMap.put(tag.getUserId(), tagList);
                }
                tagList.add(tag);
            }
        }

        List<StudentListResponseDto> result = Lists.newArrayList();
        for (StudentDto sd : solrStudents) {
            OrgStudent student = orgStudentMap.get(sd.getStudentId());
            if (student == null) {
                continue;
            }
            List<TxStudentTag> tags = tagMap.get(student.getUserId());
            StudentListResponseDto dto = StudentListResponseDto.convertToDto(student, tags);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            StudentDto studentDto = studentDtoMap.get(student.getId());
            dto.setHasLesson(studentDto.isHasLesson() ? "是" : "否");
            dto.setCascadeIdStr(searchTeacherNames.get(student.getUserId()));
            dto.setLessonNum(studentDto.getFinishClassHour() + "/"
                + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
            result.add(dto);
        }

        // for (OrgStudent student : students) {
        // List<TxStudentTag> tags = tagMap.get(student.getUserId());
        // StudentListResponseDto dto = StudentListResponseDto.convertToDto(student, tags);
        // if (!isShowMobile) {
        // dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
        // dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
        // }
        // StudentDto studentDto = studentDtoMap.get(student.getId());
        // // String className = studentDto.getClassName();
        // dto.setHasLesson(studentDto.isHasLesson() ? "是" : "否");
        // dto.setCascadeIdStr(searchTeacherNames.get(student.getUserId()));
        // dto.setLessonNum(studentDto.getFinishClassHour() + "/"
        // + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
        // result.add(dto);
        // }

        return result;
    }

    @Override
    public Map<String, Object> getPcStudentList (Long orgId,Integer cascadeId,CommonSearchRequestDto request, PageDto pageDto) {
        List<FieldOption> header = this.fieldShowInfoService.getHeader(orgId, DataProcType.ORG_STUDENT, null);
        if (CollectionUtils.isEmpty(header)) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "获取列表显示属性失败");
        }

        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(request.getStatus());
        studentListRequestDto.setQueryStr(request.getName());
        studentListRequestDto.setQueryValue(request.getQuery());
        studentListRequestDto.setCascadeId(cascadeId);
        studentListRequestDto.setOrderName(request.getOrderName());
        studentListRequestDto.setOrderType(request.getOrderType());
        studentListRequestDto.setNeedAvatar(false);

        if (StringUtils.isNotBlank(request.getQuery())) {
            studentListRequestDto.setQueryStr(request.getName());
            studentListRequestDto.setQueryValue(request.getQuery());
        }
        List<StudentDto> solrStudents = orgStudentService.searchStudentList(studentListRequestDto, orgId, pageDto);

        List<Map<String, Object>> result = new ArrayList<>();
        Map<String, Object> data = new HashMap<>();
        data.put("header", header);
        data.put("result", result);

        if (CollectionUtils.isEmpty(solrStudents)) {
            return data;
        }
        // 是否显示手机号
        boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoPCContext.getTXCascadeId());

        Set<Long> studentIds = new HashSet<>();
        Set<Long> userIds = new HashSet<>();
        for (StudentDto studentDto : solrStudents) {
            studentIds.add(studentDto.getStudentId());
            userIds.add(studentDto.getUserId());
        }

        Map<Long, String> addCasCadeMaps = new HashMap<>();    // map<课程顾问id, 课程顾问姓名>
        Map<Long, ConsultCustomSourceDto> sourceMap = new HashMap<>();  // map<来源id, 来源信息>
        Map<Long, String> tagsMap = new HashMap<>();    // map<学员userId, "标签1,标签2...">
        Map<Long, Map<Long, String>> studentFieldMap = new HashMap<>();    // map <学员id, <自定义id, 自定义值>> : 自定义值为文本、单选值、多选值等类型
        Map<Long, String> searchTeacherNames = new HashMap<>();//map<学员userId, 班主任姓名>

        // 系统字段属性名
        Set<String> sysNames = new HashSet<>();
        // 自定义字段id
        Set<Long> customIds = new HashSet<>();
        for (FieldOption option : header) {
            if (option.getCustomId() != null && option.getCustomId() > 0) {
                customIds.add(option.getCustomId());
            } else {
                sysNames.add(option.getName());
            }
        }

        // 如果需要展示班主任,则缓存班主任信息
        if (sysNames.contains(CASCADE_ID_STR)) {
            searchTeacherNames = searchTeacherNames(new HashSet<>(userIds), orgId, cascadeId);
        }
        // 如果需要展示课程顾问,则缓存课程顾问信息
        if (sysNames.contains(ADD_CASCADE_ID_STR)) {
            addCasCadeMaps = txCascadeCredentialService.getByTxCasCadeIds(orgId);
        }
        // 如果需要展示来源,则缓存来源信息
        if (sysNames.contains(SOURCES_TR)) {
            sourceMap = consultSourceService.mapConsultSourceDto(orgId, null);
        }
        // 如果需要展示标签,则缓存标签信息
        if (sysNames.contains(TAGS_STR)) {
            tagsMap = this.orgStudentTagService.getTagsMap(orgId, userIds, StudentType.ORG_STUDENTS);
        }
        // 如果需要展示自定义字段,则缓存自定义字段信息
        if (CollectionUtils.isNotEmpty(customIds)) {
            studentFieldMap = this.customFieldValueService.batchGetFieldValue(orgId, true, studentIds, customIds);
        }

        List<OrgStudent> students = this.orgStudentDao.getByIds(studentIds);
        Map<Long, OrgStudent> studentMap = BaseUtils.listToMap(students, "id");

        for (StudentDto studentDto : solrStudents) {
            Long userId = studentDto.getUserId();
            OrgStudent orgStudent = studentMap.get(studentDto.getStudentId());
            DefaultStudentField dto = this.getFromStudentInfo(studentDto, orgStudent);
            if (!isShowMobile) {
                dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
            }
            if (searchTeacherNames.containsKey(userId)) {
                dto.setCascadeIdStr(searchTeacherNames.get(userId));
            } else {
                dto.setCascadeIdStr("");
            }
            if (tagsMap.containsKey(userId)) {
                dto.setTagsStr(tagsMap.get(userId));
            } else {
                dto.setTagsStr("");
            }
            if (addCasCadeMaps.containsKey(orgStudent.getAddCascadeId().longValue())) {
                dto.setAddCascadeIdStr(addCasCadeMaps.get(orgStudent.getAddCascadeId().longValue()));
            } else {
                dto.setAddCascadeIdStr("");
            }
            if (sourceMap.containsKey(orgStudent.getSource().longValue())) {
                ConsultCustomSourceDto sourceDto = sourceMap.get(orgStudent.getSource().longValue());
                dto.setSourceStr(sourceDto != null ? sourceDto.getLabel() : "");
            } else {
                dto.setSourceStr("");
            }

            Map<String, Object> item = this.getItemMap(header, dto, studentFieldMap.get(dto.getId()));
            result.add(item);
        }
        return data;
    }

    private<T> Map<String, Object> getItemMap(List<FieldOption> header, T t, Map<Long, String> customMap) {
        Map<String, Object> map = new HashMap<>();
        // 系统字段
        Field[] fields = t.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Map<String, Field> sysFieldMap = BaseUtils.listToMap(Lists.newArrayList(fields), "name");
            for (FieldOption option : header) {
                if (option.getCustomId() != null && option.getCustomId() > 0) {
                    if (customMap != null && customMap.containsKey(option.getCustomId())) {
                        map.put(option.getName(), customMap.get(option.getCustomId()));
                    }
                } else {
                    Field field = sysFieldMap.get(option.getName());
                    if (field != null) {
                        Object ret = null;
                        try {
                            field.setAccessible(true);
                            ret = field.get(t);
                        } catch (Exception e) {
                            e.printStackTrace();
                            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                        }
                        map.put(option.getName(), ret);
                    }
                }
            }
        }
        return map;
    }

    private DefaultStudentField getFromStudentInfo(StudentDto studentDto, OrgStudent orgStudent) {
        DefaultStudentField dto = new DefaultStudentField();
        try {
            BeanUtils.copyProperties(dto, orgStudent);
        } catch (Exception e) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "copy properties failed!");
        }

        if (orgStudent.getBirthday() != null) {
            dto.setBirthdayStr(DateUtil.getStrByDate(orgStudent.getBirthday()));
        }

        if (dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1 ? "女" : "男");
        }

        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));
        dto.setHasLesson(studentDto.isHasLesson() ? "是" : "否");
        dto.setLessonNum(studentDto.getFinishClassHour() + "/" + (studentDto.getLeftClassHour() + studentDto.getFinishClassHour()));
        return dto;
    }

    /**
     * @param userIds
     * @param orgId
     * @param cascadeId
     * @return
     */
    private Map<Long, String> searchTeacherNames(Set<Long> userIds, Long orgId, Integer cascadeId) {

        boolean isStaffAccount = false;
        if (cascadeId != null) {
            boolean hasPermission = this.txAccountPermissionService.hasPermission(cascadeId.longValue(),
                ApplicationType.PC, TXPermissionConst.SEE_ALL_ORG_STUDENTS);
            if (!hasPermission) {
                isStaffAccount = true;
            }
        }

        log.info("isStaffAccount : {} , cascadeId : {} , orgId : {} ", isStaffAccount, cascadeId, orgId);

        Map<Long, String> byTxCasCadeIds = Maps.newHashMap();
        // 如果当前用户为子账号，说明只能看属于自己的班级
        if (isStaffAccount) {
            TxCascadeCredentialDto byTxCasCade = this.txCascadeCredentialService.getByTxCasCade(orgId, cascadeId);
            if (byTxCasCade != null) {
                byTxCasCadeIds.put(cascadeId.longValue(), byTxCasCade.getName());
            }
        } else {
            byTxCasCadeIds.putAll(this.txCascadeCredentialService.getByTxCasCadeIds(orgId));
        }

        Map<Long, String> headTeacherNameMap = Maps.newHashMap();
        Map<Long, List<Long>> orgStudentCourseIds = this.orgStudentCourseDao.getOrgCourseIdMap(orgId, userIds);
        Set<Long> courseIdSet = Sets.newHashSet();
        for (List<Long> courses : orgStudentCourseIds.values()) {
            courseIdSet.addAll(courses);
        }

        List<OrgCourse> allCourse = this.orgCourseDao.getByIds(courseIdSet, "id", "cascadeId");

        Map<Long, String> courseCascadeNameMap = Maps.newHashMap();
        for (OrgCourse orgCourse : allCourse) {
            Long courseId = orgCourse.getId();
            Integer courseCascadeId = orgCourse.getCascadeId();
            String headTeacherName = byTxCasCadeIds.get(courseCascadeId.longValue());
            if (GenericsUtils.notNullAndEmpty(headTeacherName)) {
                courseCascadeNameMap.put(courseId, headTeacherName);
            }
        }

        for (Long userId : userIds) {
            Set<String> names = new HashSet<>();
            List<Long> courseIds = orgStudentCourseIds.get(userId);
            if (GenericsUtils.isNullOrEmpty(courseIds)) {
                continue;
            }
            StringBuilder sb = new StringBuilder();
            for (Long courseId : courseIds) {
                String headTeacherName = courseCascadeNameMap.get(courseId);
                if (GenericsUtils.notNullAndEmpty(headTeacherName) && !names.contains(headTeacherName)) {
                    sb.append(headTeacherName).append("、");
                }
                names.add(headTeacherName);
            }
            String headTeacherNames = GenericsUtils.deleteLastCharToString(sb);
            headTeacherNameMap.put(userId, headTeacherNames);
        }
        return headTeacherNameMap;
    }

    /**
     * 添加系统待办事项(正式学员)
     * <p>
     * <<<<<<< HEAD
     *
     * @param orgId 机构id
     * @param orgId 机构id =======
     * @param orgId 机构id >>>>>>> yingxiao_1_6
     * @param consultUserId 线索id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("addSysBacklog---------orgId={}, student={}, consultUserId={}", orgId, student, consultUserId);
        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
            && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(studentId, orgId, false, "id");
            if (CollectionUtils.isNotEmpty(list)) {
                throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "已存在未过期的学员档案系统待办事项");
            }
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            txBacklog.setContent("跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            if (null != consultUserId && consultUserId > 0) {
                txBacklog.setConsultUserId(consultUserId);
            }
            this.txBacklogDao.save(txBacklog, false);
            log.info("addSysBacklog--------txBacklog={}", txBacklog);
        }
    }

    /**
     * 更新系统待办事项:编辑正式学员
     * <p/>
     * <<<<<<< HEAD
     * <p>
     * <<<<<<< HEAD
     *
     * @param orgId 机构id ======= <<<<<<< HEAD <<<<<<< HEAD
     * @param orgId 机构id =======
     * @param orgId 机构id >>>>>>> a9ef5790d09369978d27d492ee8c236e0a9057de =======
     * @param orgId 机构id >>>>>>> yingxiao_1_6 =======
     * @param orgId 机构id <<<<<<< HEAD >>>>>>> dev ======= >>>>>>> refs/remotes/origin/caoliang >>>>>>> dev <<<<<<< HEAD
     *            ======= >>>>>>> push_lxp >>>>>>> yingxiao_1_6
     * @param studentId 正式学员id
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSysBacklog(Long orgId, Long studentId) {
        if (null == orgId || orgId <= 0 || null == studentId || studentId <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent student = this.orgStudentDao.getById(studentId);
        log.info("updateSysBacklog---------orgId={}, student={}", orgId, student);

        if (null != student && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()
            && student.getOrgId().longValue() == orgId.longValue()) {
            List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, false);
            if (CollectionUtils.isNotEmpty(list)) {
                TxBacklog txBacklog = list.get(0);
                if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    // 正式学员下次跟进时间改变
                    txBacklog.setContent(
                        "跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update(txBacklog, false);
                }
            } else {
                // 系统待办事项已过期需要新建，若同时还是咨询学员，则在此处添加consulterId
                Long consulterId = null;
                List<TxConsultUser> consultUserList =
                    this.txConsultUserDao.lookByStudentId(orgId, student.getId(), "id");
                if (CollectionUtils.isNotEmpty(consultUserList)) {
                    consulterId = consultUserList.get(0).getId();
                }
                this.addSysBacklog(orgId, student.getId(), consulterId);
            }
        }
    }

    /**
     * 删除系统待办事项: 若同时还是咨询学员，则重置studentId为0; 若仅是正式学员，则直接删除
     *
     * @param orgId 机构id
     * @param consulterUser 咨询学员
     * @return
     */
    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        log.info("delSysBacklog-------orgId={},student={},consulterUser={}", orgId, student, consulterUser);
        List<TxBacklog> list = null;
        if (null != consulterUser) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog && txBacklog.getStudentId().longValue() == student.getId().longValue()) {
                        txBacklog.setStudentId(0l);
                        if (!txBacklog.getEndTime().before(new Date())) {
                            // 未过期系统待办事项才作同步
                            txBacklog.setContent("跟进客户: "
                                + (StringUtils.isNotBlank(consulterUser.getName()) ? consulterUser.getName() : "匿名学生"));
                            txBacklog.setEndTime(consulterUser.getNextRemindTime());
                            txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                        }
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog) {
                        txBacklog.setStudentId(0l);
                        txBacklog.setDelStatus(BizConf.TRUE.intValue());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        }
    }

    /**
     * 机构修改了手机号码和姓名都会生成一条跟进记录
     *
     * @param dto
     * @param po
     */
    private void checkAndCreateComment(StudentListResponseDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();

        String destName = dto.getName();
        String destMobile = dto.getMobile();

        List<TxStudentComment> comments = Lists.newArrayList();
        String formatTime = BaseUtils.getFormatDate("yyyy-MM-dd HH:mm", 0, Calendar.DAY_OF_MONTH);
        if (!destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将姓名【").append(sourceName).append("】").append("修改为【").append(destName)
                .append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!destMobile.equals(sourceMobile)) {
            StringBuffer content = new StringBuffer();
            content.append(formatTime).append(" 将手机号【").append(sourceMobile).append("】").append("修改为【")
                .append(destMobile).append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll(comments);
        }
    }

    /**
     * 生成跟进记录
     *
     * @param orgId
     * @param content
     * @param userId
     * @return
     */
    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(orgId);
        comment.setOrigin(0);
        comment.setUserId(userId);
        return comment;
    }

    /**
     * 学员名字与招生线索同步
     *
     * @param orgId
     * @param orgStudent
     * @param studentInfo
     * @return
     */
    private void cascadeUpdateTxConsulter(long orgId, OrgStudent orgStudent, StudentListResponseDto studentInfo) {
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if (updateName || updateMobile) {
            List<TxConsultUser> consultUsers = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
            if (consultUsers != null && !consultUsers.isEmpty()) {
                for (TxConsultUser consultUser : consultUsers) {
                    consultUser.setName(updateName ? studentInfo.getName() : null);
                    consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                    consultUser.setUpdateTime(new Date());
                    txConsultUserDao.update(consultUser, false);
                }
            }
        }
    }

    void updateSolr(OrgStudent orgStudent) {
        if (orgStudent == null) {
            return;
        }
        try {
            crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", orgStudent);
        } catch (Exception e) {
            log.error("solr - student - update - exception", e);
        }
    }
    
    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public Long addStudentInfo(Long orgId, Integer cascadeId, StudentListResponseDto studentInfo, boolean updateRepeat,
        List<CustomFieldValue> valueList) throws Exception {
        
        if (null == orgId || orgId <= 0 || null == studentInfo) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        log.info("orgId:{}, studentInfo:{}, updateRepeat:{}", orgId, studentInfo, updateRepeat);
        Long userId = null;
        OrgStudent orgStudent = null;
        if (updateRepeat) {
            orgStudent =
                this.orgStudentDao.getStudentByMobileAndName(orgId, studentInfo.getMobile(), studentInfo.getName());
            if (orgStudent == null) {
                Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
                userId = userInfoMap.get("id");
                orgStudent = new OrgStudent();
            } else {
                userId = orgStudent.getUserId();
                studentInfo.setId(orgStudent.getId());
            }
        } else {
            this.doSaveBefore(orgId, studentInfo);
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfo.getName());
            userId = userInfoMap.get("id");
            orgStudent = new OrgStudent();
        }

        this.studentDto2Po(studentInfo, orgStudent, orgId, userId);
        if (orgStudent.getId() != null && orgStudent.getId() > 0) {
            orgStudent.nullToEmpty();
            this.orgStudentDao.updateWithDefaultVal(orgStudent);
        } else {
            orgStudent.setAddCascadeId(cascadeId);
            this.orgStudentDao.save(orgStudent, false);
        }
        log.info("addStudentInfo---------orgStudent={}", orgStudent);

        if (StringUtils.isNotBlank(studentInfo.getTagsStr())) {
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
            String[] tags = studentInfo.getTagsStr().split(",");
            List<TxStudentTag> tagList = new ArrayList<>();
            for (String tagStr : tags) {
                if (StringUtils.isNotBlank("tagStr")) {
                    TxStudentTag tag = new TxStudentTag();
                    tag.setOrgId(orgStudent.getOrgId());
                    tag.setUserId(orgStudent.getUserId());
                    tag.setContent(tagStr);
                    tagList.add(tag);
                }
            }
            this.txStudentTagDao.saveAll(tagList, "consultUserId", "userId", "orgId", "content");
        }
        Long studentId = orgStudent.getId();
        
        String customSearchValue = this.buildCustomSearchValue(valueList, true, true, orgId, studentId, true);
        if(StringUtils.isBlank(customSearchValue)){
            customSearchValue = null;
        }
        orgStudent.setCustomSearchValue(customSearchValue);
        this.orgStudentDao.update(orgStudent, true,"customSearchValue");
        
        // 更新solr
        updateSolr(orgStudent);
        return studentId;
    }
    
    /**
     * 自定义属性的搜索苏醒冗余处理逻辑，累加获取学员的所有自定义属性的组装的搜索值
     * 
    
     * @param fieldValueList  
     * @param needBuildSearchValue  为true，会重新计算,false不从新计算，只累加
     * @param saveSearchValue  为true，会更新自定义属性的searchValue，则需要后面几个参数
     * @param orgId 机构id
     * @param studentId   学员id
     * @param isStudent  是否是学员，false表示是个线索
     * @return 组装好的自定义搜索对象
     */
        
    public String buildCustomSearchValue(List<CustomFieldValue> fieldValueList,boolean needBuildSearchValue,boolean saveSearchValue,Long orgId,Long studentId,Boolean isStudent){
        
        List<String> searchValueList = Lists.newArrayList();
        for(CustomFieldValue fieldValue:fieldValueList){
            if(needBuildSearchValue){
                try {
                    CustomFieldType.buildSearchValue(fieldValue);
                } catch (Exception e) {
                    log.warn("CustomFieldType.buildSearchValue error,fileValue={},error={}",fieldValue,e);
                }
            }
            
            if(StringUtils.isNotBlank(fieldValue.getSearchValue())){
                searchValueList.add(fieldValue.getSearchValue());
            }
            
        }
        String customSearchValue = null;
        if(searchValueList.size()>0){
            customSearchValue = Joiner.on(" ").join(searchValueList);
        }
        
        if(!saveSearchValue){
            return customSearchValue;
        }
        
        List<Long> customFieldIds = Lists.newArrayList();
        for(CustomFieldValue value:fieldValueList){
            customFieldIds.add(value.getFieldId());
        }
        List<CustomFieldValue> exitFieldValueList = Lists.newArrayList();
        if(!customFieldIds.isEmpty()){
            if(isStudent == null){
                isStudent = true;
            }
            exitFieldValueList = customFieldValueDao.searchValuesByConfig(orgId, isStudent, studentId, customFieldIds);
        }
            
        Map<Long,CustomFieldValue> exitFieldValueMap = Maps.newHashMap();
        for(CustomFieldValue value:exitFieldValueList){
            exitFieldValueMap.put(value.getFieldId(), value);
        }
        
        for(CustomFieldValue value:fieldValueList){
            CustomFieldValue exitValue = exitFieldValueMap.get(value.getFieldId());
            Date now = new Date();
            if(exitValue!=null){
                exitValue.setUpdateTime(now);
                exitValue.setValue(value.getValue());
                exitValue.setFieldType(value.getFieldType());
                customFieldValueDao.update(exitValue, true,"fieldType","value", "searchValue","updateTime");
                
            }else{
                if(isStudent){
                    value.setConsultUserId(0L);
                    value.setStudentId(studentId);
                }else{
                    value.setConsultUserId(studentId);
                    value.setStudentId(0L);
                }
                
                value.setCreateTime(now);
                value.setUpdateTime(now);
                customFieldValueDao.save(value,true);
            }
            
        }
        return customSearchValue; 
    }
    
    
}
