/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.impl;

import com.baijia.tianxiao.constant.AvatarConstants;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.constants.CourseType;
import com.baijia.tianxiao.constants.PayStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.callservice.dao.CallServiceInfoDao;
import com.baijia.tianxiao.dal.callservice.dao.OrgPushCallInfoDao;
import com.baijia.tianxiao.dal.callservice.po.CallServiceInfo;
import com.baijia.tianxiao.dal.callservice.po.OrgPushCallInfo;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.StudentType;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeCredentialDao;
import com.baijia.tianxiao.dal.org.dto.StudentClasHourDocument;
import com.baijia.tianxiao.dal.org.dto.StudentClassHourStatusDocument;
import com.baijia.tianxiao.dal.org.po.AccountRoleType;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.pcAuthority.constant.RoleType;
import com.baijia.tianxiao.dal.push.constant.MessageSource;
import com.baijia.tianxiao.dal.push.constant.NoticeType;
import com.baijia.tianxiao.dal.push.dto.content.NoticeMsgContent;
import com.baijia.tianxiao.dal.push.utils.ActionUtil;
import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.constant.DownLoadStatus;
import com.baijia.tianxiao.dal.roster.constant.MobileStatus;
import com.baijia.tianxiao.dal.roster.constant.PauseStatus;
import com.baijia.tianxiao.dal.roster.dao.CustomFieldDao;
import com.baijia.tianxiao.dal.roster.dao.TXCustomOptionDao;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentCommentDao;
import com.baijia.tianxiao.dal.roster.dao.TxStudentTagDao;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.dal.roster.po.TXCustomOption;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.roster.po.TxStudentComment;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.dto.StudentQueryParam;
import com.baijia.tianxiao.dal.solr.enums.OpType;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.solr.enums.TimeType;
import com.baijia.tianxiao.dal.solr.po.StudentClass;
import com.baijia.tianxiao.dal.solr.po.StudentClassHour;
import com.baijia.tianxiao.dal.solr.po.StudentStatusStatistics;
import com.baijia.tianxiao.dal.solr.query.CrmStudentQuery;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogDao;
import com.baijia.tianxiao.dal.todo.dao.TxBacklogParticipantDao;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.dal.todo.po.TxbacklogParticipant;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.dao.UserDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dal.user.po.User;
import com.baijia.tianxiao.dal.util.AreaUtils;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.CrmErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.PermissionException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.AccountApiService;
import com.baijia.tianxiao.sal.common.api.ConsulterAPIService;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.TXStudentCommentAPIService;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountHelpService;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.organization.org.service.impl.RequestSourceDesc;
import com.baijia.tianxiao.sal.organization.utils.DataAuthority;
import com.baijia.tianxiao.sal.push.service.ConsultMessageService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.constant.Biz;
import com.baijia.tianxiao.sal.student.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.student.dto.CreatorDto;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.dto.customFields.StudentCustomFieldResponse;
import com.baijia.tianxiao.sal.student.dto.request.MobileCheckInfoRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentCommenRequestDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.BatchAddStudentResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.MobileCheckReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StarEnum;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.student.util.CommentUtil;
import com.baijia.tianxiao.sal.student.util.OrgStudentUtil;
import com.baijia.tianxiao.sal.student.util.WechatProperties;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.baijia.tianxiao.validation.ParamValidateUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentServiceImpl
 * @desc TODO
 * @date 2015年12月4日
 */
@Slf4j
@Service
public class OrgStudentServiceImpl implements OrgStudentService {

    @Autowired
    private OrgStudentDao orgStudentsDao;
    @Autowired

    private StudentDao studentDao;

    @Autowired
    private TxStudentTagDao txStudentTagDao;

    @Autowired
    private TxConsultUserDao txConsultUserDao;

    @Autowired
    private TxStudentCommentDao txStudentCommentDao;

    @Autowired
    private UserDao userDao;

    @Autowired
    private OrgStorageDao orgStorageDao;

    @Autowired
    private StorageDao storageDao;

    @Autowired
    private CoursePurchaseDao coursePurchaseDao;

    @Autowired
    private OrgStudentCourseDao orgStudentCourseDao;

    @Autowired
    private OrgCourseDao orgCourseDao;

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Autowired
    private OrgSignupInfoDao orgSignupInfoDao;

    @Autowired
    private OrgSignupCourseDao orgSignupCourseDao;

    @Autowired
    private CallServiceInfoDao callServiceInfoDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxBacklogDao txBacklogDao;
    @Autowired
    private OrgPushCallInfoDao orgPushCallInfoDao;
    @Autowired
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired(required = false)
    private CrmStudentQuery solrStudentQuery;
    @Autowired
    private TXCascadeCredentialDao txCascadeCredentialDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private TxAccountHelpService txAccountHelpService;
    @Autowired
    private TxCascadeCredentialService txCascadeCredentialService;
    @Autowired
    private CrmStudentQuery crmStudentQuery;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrgStudentLessonDao orgStudentLessonDao;
    @Autowired
    private ConsulterAPIService apiService;
    @Autowired
    protected ConsultMessageService consultMessageService;
    @Autowired
    private TXStudentCommentAPIService commentAPIService;
    @Autowired
    private AccountApiService accountApiService;
    @Autowired
    private CustomFieldDao customFieldDao;
    @Autowired
    private TXCustomOptionDao txCustomOptionDao;
    @Autowired
    private OrgStudentApiService studentApiService;
    @Autowired
    private ConsulterAPIService consulterAPIService;
    @Autowired
    private TxBacklogParticipantDao txBacklogParticipantDao;
    
    private LoadingCache<Long, Long> orgInfoCache = CacheBuilder.newBuilder().maximumSize(1000)
        .expireAfterAccess(1, TimeUnit.DAYS).build(new CacheLoader<Long, Long>() {
            @Override
            public Long load(Long orgId) throws Exception {
                OrgAccount byId = orgAccountDao.getById(orgId, "number");
                if (byId != null) {
                    return byId.getNumber().longValue();
                }
                return null;
            }
        });

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public int syncStudent(PageDto pageDto) {
        log.info("############### start======");
        List<OrgStudent> students = orgStudentsDao.getStudentsByPage(pageDto);
        if (students != null) {
            for (OrgStudent student : students) {
                if (student.getMobile() == null || student.getName() == null) {
                    continue;
                }
                List<OrgStudent> stuList = orgStudentsDao.getStudentsByMobileAndName(student.getOrgId(),
                    student.getMobile(), student.getName());
                log.info("############### ====== size=" + stuList.size());
                if (stuList == null || stuList.size() <= 1) {
                    continue;
                }
                for (int i = 0; i < stuList.size(); i++) {
                    OrgStudent orgStudent = stuList.get(i);
                    orgStudent.setName(orgStudent.getName() + "(" + (i + 1) + ")");
                    log.info("############### ====== name=" + orgStudent.getName());
                    orgStudentsDao.saveOrUpdate(orgStudent);
                }
            }
        }
        log.info("############### end======");
        return students.size();
    }

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public OrgStudentAddresponseDto addStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos,
        List<TagInfoDto> tagDtos, Long orgId) throws BussinessException {
        log.debug("add student studentInfo={}, orgId={}", studentInfoDto, orgId);
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        if (StringUtils.isBlank(studentInfoDto.getMobile()) || StringUtils.isBlank(studentInfoDto.getName())) {
            log.warn("add student error: mobile or name is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        // 会出现183-9288-1285这样的手机号，需要将手机格式换一下18392881285
        String mobile = studentInfoDto.getMobile();
        mobile = mobile.replaceAll("-", "");
        studentInfoDto.setMobile(mobile);
        if (StringUtils.isNoneBlank(studentInfoDto.getParentMobile())) {
            String parentMobile = studentInfoDto.getParentMobile();
            parentMobile = parentMobile.replaceAll("-", "");
            studentInfoDto.setParentMobile(parentMobile);
        }
        if (!ParamValidateUtils.validateMobile(studentInfoDto.getMobile())) {
            throw new BussinessException(StudentErrorCode.MOBILE_WRONG);
        }

        // 前置条件检查
        this.saveBefore(studentInfoDto, orgId);

        if (StringUtils.isBlank(studentInfoDto.getWeixin())) {
            List<OrgStudent> orgStudents =
                orgStudentsDao.getStudentByMobileAndOrgId(orgId, studentInfoDto.getMobile(), 100);
            if (orgStudents != null) {
                for (OrgStudent orgStudent : orgStudents) {
                    if (StringUtils.isNotBlank(orgStudent.getWeixin())) {
                        studentInfoDto.setWeixin(orgStudent.getWeixin());
                        break;
                    }
                }
            }
        }

        OrgStudentAddresponseDto response = new OrgStudentAddresponseDto();

        // 学员已存在，取cdb.user表的id、number，否则通过浅注册获取,并更新tx_consult_user的user_id和user_number
        Long userId = null;
        Long userNumber = null;
        if (null != studentInfoDto.getStudentNumber() && studentInfoDto.getStudentNumber() > 0) {
            User user = userDao.getByNumber(studentInfoDto.getStudentNumber(), "id", "number");
            if (null != user) {
                userId = user.getId();
                userNumber = user.getNumber();
            }
        }
        if (null == userId) {
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfoDto.getName());
            userId = userInfoMap.get("id");
            userNumber = userInfoMap.get("number");
        }
        response.setUserId(userId);
        response.setUserNumber(userNumber);

        OrgStudent student = this.orgStudentsDao.getStudent(orgId, userId, null);

        if (student != null && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {// 如果学员已经存在
            throw new BussinessException(StudentErrorCode.MOBILE_REGISTERED);
        } else if (student != null && student.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {// 如果学员已经被删除
            student.setDelStatus(DeleteStatus.NORMAL.getValue());
            response.setStudentId(student.getId());
            studentDto2Po(studentInfoDto, student, orgId, userId);
            student.setCreateTime(new Date()); // 更新添加时间未当前时间，目的是要在任务中添加一条跟进纪录
            this.orgStudentsDao.updateWithDefaultVal(student);
            if (studentInfoDto.getConsultUserId() == null) {// 如果学员已经被删除，但是机构再次把学员加上（直接添加）
                saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);// 保存备注和标签
                this.addSysBacklog(orgId, student, null);
            } else {// 如果是咨询本学员转过来的，需要更新跟进纪录和标签
                this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
                this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
                // 如果是咨询本转学员
                this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
            }
            return response;
        }
        if (studentInfoDto.getConsultUserId() != null) {// 如果是咨询本转学员
            log.info("add orgStudent from consult_user");
            TxConsultUser consultUser = this.txConsultUserDao.getById(studentInfoDto.getConsultUserId(), "orgId");
            if (consultUser == null) {
                throw new BussinessException(StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        student = new OrgStudent();
        studentDto2Po(studentInfoDto, student, orgId, userId);

        student.setAddCascadeId(studentInfoDto.getAddCascadeId() == null ? 0 : studentInfoDto.getAddCascadeId());
        this.orgStudentsDao.save(student, false);
        saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);// 保存备注和标签
        if (studentInfoDto.getConsultUserId() != null) {
            this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
            this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
            // 如果是咨询本转学员
            this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
        } else {
            this.addSysBacklog(orgId, student, null);
        }

        log.info("addStudent success!");
        response.setStudentId(student.getId());

        return response;
    }
    
    

    @Override
    @Transactional(rollbackFor = { Exception.class, BussinessException.class })
    public OrgStudentAddresponseDto addStudentIgnoreExistMobile(StudentInfoDto studentInfoDto,
        List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos, Long orgId) throws BussinessException {
        log.debug("add student studentInfo={}, orgId={}", studentInfoDto, orgId);
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        if (StringUtils.isBlank(studentInfoDto.getMobile()) || StringUtils.isBlank(studentInfoDto.getName())) {
            log.warn("add student error: mobile or name is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        if (!ParamValidateUtils.validateMobile(studentInfoDto.getMobile())) {
            throw new BussinessException(StudentErrorCode.MOBILE_WRONG);
        }

        // 前置条件检查
        // this.saveBefore(studentInfoDto, orgId);

        if (StringUtils.isBlank(studentInfoDto.getWeixin())) {
            List<OrgStudent> orgStudents =
                orgStudentsDao.getStudentByMobileAndOrgId(orgId, studentInfoDto.getMobile(), 100);
            if (orgStudents != null) {
                for (OrgStudent orgStudent : orgStudents) {
                    if (StringUtils.isNotBlank(orgStudent.getWeixin())) {
                        studentInfoDto.setWeixin(orgStudent.getWeixin());
                        break;
                    }
                }
            }
        }

        OrgStudentAddresponseDto response = new OrgStudentAddresponseDto();

        // 学员已存在，取cdb.user表的id、number，否则通过浅注册获取,并更新tx_consult_user的user_id和user_number
        Long userId = null;
        Long userNumber = null;
        if (null != studentInfoDto.getStudentNumber() && studentInfoDto.getStudentNumber() > 0) {
            User user = userDao.getByNumber(studentInfoDto.getStudentNumber(), "id", "number");
            if (null != user) {
                userId = user.getId();
                userNumber = user.getNumber();
            }
        }
        if (null == userId) {
            Map<String, Long> userInfoMap = OrgStudentUtil.getUserIdAndNumber(studentInfoDto.getName());
            userId = userInfoMap.get("id");
            userNumber = userInfoMap.get("number");
        }
        response.setUserId(userId);
        response.setUserNumber(userNumber);

        OrgStudent student = this.orgStudentsDao.getStudent(orgId, userId, null);

        if (student != null && student.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {// 如果学员已经存在
            throw new BussinessException(StudentErrorCode.MOBILE_REGISTERED);
        } else if (student != null && student.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {// 如果学员已经被删除
            student.setDelStatus(DeleteStatus.NORMAL.getValue());
            response.setStudentId(student.getId());
            studentDto2Po(studentInfoDto, student, orgId, userId);
            student.setCreateTime(new Date()); // 更新添加时间未当前时间，目的是要在任务中添加一条跟进纪录
            this.orgStudentsDao.update(student, false);
            if (studentInfoDto.getConsultUserId() == null) {// 如果学员已经被删除，但是机构再次把学员加上（直接添加）
                saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);// 保存备注和标签
                this.addSysBacklog(orgId, student, null);
            } else {// 如果是咨询本学员转过来的，需要更新跟进纪录和标签
                this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
                this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
                // 如果是咨询本转学员
                this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
            }
            return response;
        }
        if (studentInfoDto.getConsultUserId() != null) {// 如果是咨询本转学员
            log.info("add orgStudent from consult_user");
            TxConsultUser consultUser = this.txConsultUserDao.getById(studentInfoDto.getConsultUserId(), "orgId");
            if (consultUser == null) {
                throw new BussinessException(StudentErrorCode.CONSULT_USER_NOT_EXIST);
            }
        }
        Date now = new Date();
        student = new OrgStudent();
        student.setCreateTime(now);
        student.setUpdateTime(now);
        log.info("%%%%%%%@@  studentInfoDto:{}", studentInfoDto);
        student.setAddCascadeId(studentInfoDto.getAddCascadeId() == null ? 0 : studentInfoDto.getAddCascadeId());
        studentDto2Po(studentInfoDto, student, orgId, userId);
        log.info("%%%%%%%@@  student:{}", student);
        this.orgStudentsDao.save(student, false);
        saveCommentsAndTags(studentInfoDto, commentDtos, tagDtos, orgId, student);// 保存备注和标签
        if (studentInfoDto.getConsultUserId() != null) {
            this.txStudentCommentDao.updateComment(studentInfoDto.getConsultUserId(), userId);
            this.txStudentTagDao.updateTag(studentInfoDto.getConsultUserId(), userId);
            // 如果是咨询本转学员
            this.updateSysBacklog(orgId, student, studentInfoDto.getConsultUserId());
        } else {
            this.addSysBacklog(orgId, student, null);
        }

        log.info("addStudent success!");
        response.setStudentId(student.getId());

        return response;
    }

    /**
     * 1.StudentId=cdb.user.id表明是编辑，判断手机号码和姓名是否有更改，如果没有更改不处理，有更改再查询yunying.org_students 表中是否还有对应的手机号码和姓名的学生，如果有提示无法编辑
     * 2.studentId为空，则是新增，判断该机构下是否有对应姓名和手机号的学生，有则提示不能添加
     *
     * @param studentInfoDto
     * @param orgId
     */
    private void saveBefore(StudentInfoDto studentInfoDto, Long orgId) throws BussinessException {

        log.debug("saveBefore.studentInfoDto:{}", studentInfoDto);
        // 检测时间是否超过最大范围
        if (studentInfoDto.getNextRemindTime() != null) {
            if (studentInfoDto.getNextRemindTime() > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "下次提醒时间超过最大范围(2037-1-1)了");
            }
        }
        if (studentInfoDto.getBirthday() != null && studentInfoDto.getBirthday() > System.currentTimeMillis()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "未来的您还未出生吧");
        }
        if (studentInfoDto.getConfirm() == null || studentInfoDto.getConfirm() == BizConf.FALSE.intValue()) {
            OrgStudent student = null;
            if (studentInfoDto.getStudentId() != null && studentInfoDto.getStudentId() > 0) {
                student = this.orgStudentsDao.getById(studentInfoDto.getStudentId());
                if (student != null && student.getOrgId() == orgId.longValue()
                    && student.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
                    String mobile = student.getMobile();
                    String name = student.getName();

                    String paramMobile = studentInfoDto.getMobile();
                    String paramName = student.getName();
                    if (paramMobile.contains("****")) {
                        paramMobile = mobile;
                    }

                    // 对家长手机进行相同复制处理
                    // TODO
                    String requestParentMobile = studentInfoDto.getParentMobile();
                    String oldParentMobile = student.getParentMobile();
                    if (GenericsUtils.notNullAndEmpty(requestParentMobile) && requestParentMobile.contains("****")) {
                        studentInfoDto.setParentMobile(oldParentMobile);
                    }

                    if (mobile.equals(paramMobile) && name.equals(paramName)) {// 手机号和名字不变
                        return;
                    } else if (mobile.equals(paramMobile) && !name.equals(paramName)) {// 名称变了，需要校验名称和手机号
                        procSameMobileAndName(orgId, paramMobile, paramName);
                    } else {// 如果手机号变了，就需要校验名称和手机号以及单独校验手机号
                        procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
                        procSameMobile(orgId, paramMobile);
                    }
                } else {
                    throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
                }
            } else {
                procSameMobileAndName(orgId, studentInfoDto.getMobile(), studentInfoDto.getName());
                procSameMobile(orgId, studentInfoDto.getMobile());
            }
        }
    }

    /**
     * 处理学员手机号、姓名相同的情况，报错不能添加
     *
     * @param orgId
     * @param mobile
     * @param name
     */
    private void procSameMobileAndName(Long orgId, String mobile, String name) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndName(orgId, mobile, name);
        if (student != null) {
            throw new BussinessException(CrmErrorCode.STUDENT_HAS_EXISTS);
        }
    }

    /**
     * 处理学员手机号相同的情况，点击确认可继续添加
     *
     * @param orgId
     * @param mobile
     */
    private void procSameMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile);
        if (student != null) {
            throw new BussinessException(CrmErrorCode.CUSTOM_HAS_EXISTS);
        }

    }

    /**
     * 保存备注和标签
     *
     * @param studentInfoDto
     * @param commentDtos
     * @param tagDtos
     * @param orgId
     * @param student
     */
    private void saveCommentsAndTags(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos,
        List<TagInfoDto> tagDtos, Long orgId, OrgStudent student) {
        List<TxStudentComment> comments = Lists.newArrayList();
        List<TxStudentTag> tags = Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commentDtos)) {
            for (CommentInfoDto commentInfoDto : commentDtos) {
                TxStudentComment comment = new TxStudentComment();
                if (studentInfoDto.getConsultUserId() != null) {
                    comment.setConsultUserId(studentInfoDto.getConsultUserId());
                }
                commentDto2Po(commentInfoDto, comment, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                comments.add(comment);
            }
            this.txStudentCommentDao.saveAll(comments);
            log.info("add comments success!");
        }
        if (CollectionUtils.isNotEmpty(tagDtos)) {

            // 该学生已有的所有标签 最多可以添加30个标签
            if (tagDtos.size() > Biz.MAX_TAGS) {
                throw new BussinessException(StudentErrorCode.MAX_TAGS);
            }
            for (TagInfoDto tagDto : tagDtos) {
                String content = tagDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException(StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                // 去除是空字符串的情况
                if (StringUtils.isNotBlank(content)) {
                    tagDto2Po(tagDto, tag, student.getId(), StudentType.ORG_STUDENTS.getCode(), student);
                }
                tags.add(tag);
            }
            this.txStudentTagDao.saveAll(tags, "consultUserId", "userId", "orgId", "content");
            log.info("add tags success!");
        }
    }

    /**
     * dto to po
     */
    private void studentDto2Po(StudentInfoDto dto, OrgStudent po, Long orgId, Long userId) {
        if (StringUtils.isNotBlank(dto.getMobile()) && !dto.getMobile().contains("****")) {
            if (!ParamValidateUtils.validateMobile(dto.getMobile())) {
                throw new BussinessException(StudentErrorCode.MOBILE_WRONG);
            }
            po.setShowMobile(dto.getMobile());
            po.setMobile(dto.getMobile());
        }
        String mail = dto.getMail();
        if (GenericsUtils.notNullAndEmpty(mail)) {
            if (mail.length() > 96) {
                throw new BussinessException(StudentErrorCode.TOO_LONG_MAIL);
            }
        }

        po.setAddress(dto.getAddress());
        if (dto.getBirthday() != null && dto.getBirthday() > 0) {
            po.setBirthday(new Date(dto.getBirthday()));
        } else {
            po.setBirthday(null);
        }
        po.setDegreeClass(dto.getDegreeClass());
        po.setFatherOccupation(dto.getFatherOccupation());
        po.setMail(dto.getMail());
        po.setMatherOccupation(dto.getMatherOccupation());
        // if (dto.getSource() != null && dto.getSource().intValue() == SourceStatus.PLATFORM.getCode()) {
        // po.setShowMobile(MaskUtil.maskMobile(dto.getMobile()));
        // } else {
        // po.setShowMobile(dto.getMobile());
        // }
        po.setName(dto.getName());
        po.setNickName(dto.getName());
        if (dto.getNextRemindTime() != null && dto.getNextRemindTime() > 0) {
            po.setNextRemindTime(new Date(dto.getNextRemindTime()));
        } else {
            // 如果用户清除下次跟进时间，设置下次跟进时间为Null
            po.setNextRemindTime(null);
        }
        po.setOrgId(orgId);
        po.setParentName(dto.getParentName());
        po.setParentMobile(dto.getParentMobile());
        po.setQq(dto.getQq());
        if (null != dto.getSource()) {
            po.setSource(dto.getSource());
        }

        // 0：跟谁学用户、1：非跟谁学用户
        if (po.getId() == null || po.getId() == 0) {
            if (po.getSource() != null && po.getSource() == MessageSource.ONLINE_IM.getValue()) {
                po.setOrigin(0);
            } else {
                po.setOrigin(1);
            }
        }
        po.setRemark(dto.getRemark());
        po.setGender(dto.getGender());
        po.setUserId(userId);
        po.setWeixin(dto.getWeixin());
        po.setSchool(dto.getSchool());
        po.setBranchId(dto.getBranchId());
        po.setRelationship(dto.getRelationship());
        po.setAvatar(dto.getStorageId());
        po.setAreaId(dto.getAreaId());
        po.setLatitude(dto.getLatitude());
        po.setLongitude(dto.getLongitude());
        if (dto.getAddCascadeId() != null) {
            po.setAddCascadeId(dto.getAddCascadeId());
        }
        po.setCustomSearchValue(dto.getCustomSearchValue());
    }

    /**
     * 机构修改了手机号码和姓名都会生成一条跟进记录
     *
     * @param dto
     * @param po
     */
    private void checkAndCreateComment(StudentInfoDto dto, OrgStudent po) {
        String sourceName = po.getName();
        String sourceMobile = po.getMobile();

        String destName = dto.getName();
        String destMobile = dto.getMobile();

        List<TxStudentComment> comments = Lists.newArrayList();
        // String formatTim = BaseUtils.getFormatDate("yyyy-MM-dd HH:mm", 0, Calendar.DAY_OF_MONTH);

        if (destName != null && !destName.equals(sourceName)) {
            StringBuffer content = new StringBuffer();
            content.append(" 将姓名【").append(sourceName).append("】").append("修改为【").append(destName).append("】");
            comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
        }

        log.info("destMobile param:{}, sourceMobile param:{}", destMobile, sourceMobile);
        // 判断手机号书否是打码手机号
        boolean isdozenMobile = false;
        String dozen = "****";
        if (destMobile.contains(dozen)) {
            isdozenMobile = true;
        }
        if (!isdozenMobile) {
            if (destMobile != null && !destMobile.equals(sourceMobile)) {
                StringBuffer content = new StringBuffer();
                content.append(" 将手机号【").append(sourceMobile).append("】").append("修改为【").append(destMobile).append("】");
                comments.add(generateComment(po.getOrgId(), content.toString(), po.getUserId()));
            }
        }

        if (!comments.isEmpty()) {
            this.txStudentCommentDao.saveAll(comments);
        }
    }

    /**
     * 生成跟进记录
     *
     * @param orgId
     * @param content
     * @param userId
     * @return
     */
    private TxStudentComment generateComment(long orgId, String content, long userId) {
        TxStudentComment comment = new TxStudentComment();
        comment.setContent(content);
        comment.setCreateTime(new Date());
        comment.setIsSystem(BizConf.TRUE);
        comment.setOrgId(orgId);
        comment.setOrigin(0);
        comment.setUserId(userId);
        return comment;
    }

    /**
     * dto to po
     *
     * @param dto
     * @param po
     */
    private void commentDto2Po(CommentInfoDto dto, TxStudentComment po, Long studentId, Integer type,
        OrgStudent student) {
        if (type == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        }
        po.setSeconds(dto.getSeconds());
        po.setDownStatus(DownLoadStatus.FINISH.getCode());
        po.setSoundId(dto.getSoundId());
        po.setStorageIds(dto.getStorageIds());
        po.setContent(dto.getContent());
    }

    /**
     * dto to po
     *
     * @param dto
     * @param po
     */
    private void tagDto2Po(TagInfoDto dto, TxStudentTag po, Long studentId, Integer type, OrgStudent student) {
        if (type == StudentType.ORG_STUDENTS.getCode()) {
            po.setOrgId(student.getOrgId());
            po.setUserId(student.getUserId());
        } else {
            po.setConsultUserId(studentId);
        }
        po.setContent(dto.getContent());
    }

    /**
     * po转换为dto
     */
    private void studentPo2Dto(OrgStudent po, StudentInfoDto dto, Long orgNumber) {
        dto.setOrigin(po.getOrigin());
        dto.setStudentId(po.getId());
        dto.setAddress(po.getAddress());
        if (po.getBirthday() != null) {
            dto.setBirthday(po.getBirthday().getTime());
        }
        dto.setDegreeClass(po.getDegreeClass());
        dto.setFatherOccupation(po.getFatherOccupation());
        dto.setMail(po.getMail());
        dto.setMatherOccupation(po.getMatherOccupation());
        // if (StringUtils.isBlank(po.getShowMobile())) {
        // dto.setMobile(MaskUtil.maskMobile(po.getMobile()));
        // } else {
        // dto.setMobile(po.getShowMobile());
        // }
        dto.setMobile(po.getMobile());
        dto.setName(po.getName());
        if (StringUtils.isBlank(po.getName())) {
            if (StringUtils.isNotEmpty(po.getNickName())) {
                dto.setName(po.getNickName());
            } else {
                dto.setName(MaskUtil.maskMobile(po.getMobile()));
            }
        }
        if (po.getNextRemindTime() != null) {
            dto.setNextRemindTime(po.getNextRemindTime().getTime());
        }
        dto.setParentMobile(po.getParentMobile());
        dto.setParentName(po.getParentName());
        dto.setGender(po.getGender());
        dto.setBranchId(po.getBranchId());
        dto.setRelationship(po.getRelationship());
        dto.setQq(po.getQq());
        dto.setSchool(po.getSchool());
        dto.setSource(po.getSource());
        dto.setLatitude(po.getLatitude());
        dto.setLongitude(po.getLongitude());
        dto.setAreaId(po.getAreaId());
        dto.setWeixin(
                StringUtils.isNotBlank(po.getWeixin()) ? po.getWeixin() : this.getWeixinOpenId(dto.getConsultUserId()));
        if (po.getAvatar() != null) {
            OrgStorage storage = orgStorageDao.getById(po.getAvatar().intValue());
            if (storage != null) {
                dto.setStorageId(storage.getId().longValue());
                String url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
                dto.setAvatarUrl(url);
            }
        }
        if (po.getAddCascadeId() != null) {
            dto.setAddCascadeId(po.getAddCascadeId());
        }
    }

    /**
     * 获取微信openId
     *
     * @param consultId
     * @return
     */
    /**
     * @Description :
     * @Author : zhenyujian
     * @Date : 2016年7月4日 上午10:55:59
     *
     * @Return : String
     */
    private String getWeixinOpenId(Long consultId) {
        String weixinOpenId = "";
        if (consultId != null && consultId > 0) {
            TxConsultUser consulter = this.txConsultUserDao.getById(consultId);
            if (consulter != null) {
                weixinOpenId = consulter.getWeixinOpenId();
            }
        }
        return weixinOpenId;
    }

    /**
     * 获取学员课次信息和消费信息
     * <p/>
     * 消费信息，来源：(仅3810课程)
     * <p/>
     * 课次信息
     *
     * @param dto
     * @param orgNumber
     */
    @Override
    public void setPayMoneyAndTimes(Long userId, Long orgNumber, Long orgId, StudentInfoDto dto) {
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }
        if (orgNumber == null) {
            try {
                orgNumber = orgInfoCache.get(orgId);
            } catch (ExecutionException e) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, orgId + "对应的机构不存在!");
            }
        }
        List<OrgSignupInfo> signupPurchase = this.orgSignupInfoDao.getPurchases(userId, orgNumber, null,
            PayStatus.SUCESS.getCode(), "totalPrices", "signupPurchaseId"); // 报名订单
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> purchaseIds = Sets.newHashSet();
        double payMoney = 0;
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes--------signupPurchase{}", signupPurchase);
        for (OrgSignupInfo orgSignupInfo : signupPurchase) {
            payMoney += orgSignupInfo.getTotalPrices().doubleValue() / 100;// 以分为单位
            purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
        }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------purchaseIds{}", purchaseIds);
        List<OrgSignupCourse> sinupCourses = this.orgSignupCourseDao.loadByPurchaseIds(purchaseIds, "orgCourseId");
        for (OrgSignupCourse orgSignupCourse : sinupCourses) {
            courseIds.add(orgSignupCourse.getOrgCourseId());
        }
        // log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------sinupCourses{}", sinupCourses);
        // List<CoursePurchase> mPurchase = this.coursePurchaseDao.getCoursePurchaseList(orgId, userId, 0l,
        // CourseType.ORG_COURSE.getCode(), PayStatus.SUCESS.getCode());
        // for (CoursePurchase coursePurchase : mPurchase) {
        // payMoney += coursePurchase.getPayMoney();
        // courseIds.add(coursePurchase.getCourseId());
        // }
        log.info("OrgStudentServiceImpl:getPayMoneyAndTimes---------courseIds{}", courseIds);
        dto.setStar(StarEnum.getStarByPrice(payMoney).getCode());
        dto.setPayMoney(payMoney);// com.baijia.tianxiao.util.StringUtils.formatNumber(new BigDecimal(payMoney))
        log.info("studentId ={}, payMoney={}", orgId, payMoney);
    }

    @SuppressWarnings("unused")
    @Override
    public void setClassHour(Long userId, Long orgId, StudentInfoDto dto) {
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }

        List<OrgStudentCourse> courseList =
            this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, StudentCourseStatus.NORMAL.getCode(), null);
        int finishCount = 0;
        int leftCount = 0;
        int totalCount = 0;
        try {
            List<StudentClassHour> list = solrStudentQuery.queryStudentClassHourList(userId, orgId);
            Map<Long, StudentClassHour> classHourMap =
                com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(list,
                    new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, StudentClassHour>() {
                        @Override
                        public Long extract(StudentClassHour classHour) {
                            return classHour.getCourseId();
                        }
                    });

            for (OrgStudentCourse course : courseList) {
                StudentClassHour classHour = classHourMap.get(course.getCourseId());
                int tmp = 0;
                if (course.getStatus() == StudentCourseStatus.NORMAL.getCode()) {
                    if (classHour != null) {
                        log.info("[ClassHour] classHour={},courseId={}", classHour, classHour.getCourseId());
                        leftCount += classHour.getLeftCount();
                        finishCount += classHour.getFinishCount();
                        tmp = classHour.getLeftCount() + classHour.getFinishCount();
                    }
                    tmp = Math.max(tmp, course.getLessonCount());
                    log.info("[ClassHour] classHour={},tmp={}", classHour, tmp);
                    totalCount += tmp;
                } else {
                    if (classHour != null) {
                        log.info("[ClassHour] classHour={},courseId={}", classHour, classHour.getCourseId());
                        finishCount += classHour.getFinishCount();
                        totalCount += classHour.getFinishCount();
                    }
                }
            }
        } catch (Exception e) {
            log.error("[Solr] Query exception", e);
        }
        dto.setTotalClassTime(totalCount);
        dto.setFinishClassTime(finishCount);
    }

    /**
     *
     * 获取到学员他的UserId
     *
     * @param studentId
     * @return
     */
    private Long getUserId(Long studentId) {
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentId, "userId");
        if (orgStudent == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, String.format("id%s对应的学员不存在!", studentId));
        }
        User user = this.userDao.getById(orgStudent.getUserId());
        if (user == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, String.format("id%s对应的用户不存在!", studentId));
        }
        return orgStudent.getUserId();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delStudent(StudentCommenRequestDto studentCommenRequestDto, Long orgId) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        if (studentCommenRequestDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentCommenRequestDto.getStudentId());
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        studentCommenRequestDto.setUserId(orgStudent.getUserId());
        List<TxConsultUser> consultUserList =
            txConsultUserDao.lookByStudentId(orgId, studentCommenRequestDto.getStudentId());
        log.info("OrgStudentServiceImpl:delStudent--------consultUserList={}", consultUserList);

        if (null != consultUserList && !consultUserList.isEmpty()) {
            this.delSysBacklog(orgId, orgStudent, consultUserList.get(0));

            for (TxConsultUser consulterUser : consultUserList) {
                consulterUser.setStudentId(0L);
                consulterUser.setIsConsulter(0);
                this.txConsultUserDao.update(consulterUser, "studentId", "isConsulter");
            }
        } else {
            this.delSysBacklog(orgId, orgStudent, null);
        }

        orgStudent.setDelStatus(DeleteStatus.DELETED.getValue());
        TxStudentComment comment = new TxStudentComment();
        comment.setContent("机构删除学员");
        comment.setUserId(orgStudent.getUserId());
        comment.setOrgId(orgStudent.getOrgId());
        comment.setIsSystem(AddType.SYSTEM.getCode());
        this.txStudentCommentDao.save(comment);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        this.orgStudentsDao.update(orgStudent, "delStatus");

        // 更新solr
        updateSolr(orgStudent);

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void modStudent(StudentInfoDto studentInfoDto, List<CommentInfoDto> commentDtos, List<TagInfoDto> tagDtos,
        Long orgId) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        if (studentInfoDto.getStudentId() == null) {
            log.warn("mod student error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }

        // 前置条件检查
        this.saveBefore(studentInfoDto, orgId);

        OrgStudent orgStudent = this.orgStudentsDao.getById(studentInfoDto.getStudentId());
        log.info("orgStudent param:{}", orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }

        // 生成跟进记录
        checkAndCreateComment(studentInfoDto, orgStudent);

        cascadeUpdateTxConsultName(orgId, orgStudent, studentInfoDto);

        studentDto2Po(studentInfoDto, orgStudent, orgId, orgStudent.getUserId());

        log.info("studentId param:{}, orgId param:{}", orgStudent.getUserId(), orgId);
        this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        // 修改标签
        if (GenericsUtils.notNullAndEmpty(tagDtos)) {
            // 该学生已有的所有标签 最多可以添加30个标签
            if (tagDtos.size() > Biz.MAX_TAGS) {
                throw new BussinessException(StudentErrorCode.MAX_TAGS);
            }

            List<TxStudentTag> tags = new ArrayList<>();
            for (TagInfoDto tagInfoDto : tagDtos) {
                String content = tagInfoDto.getContent();
                if (content.length() > 15) {
                    throw new BussinessException(StudentErrorCode.MAX_TAG_CONTENT_LENGTH);
                }
                TxStudentTag tag = new TxStudentTag();
                tagDto2Po(tagInfoDto, tag, orgStudent.getId(), StudentType.ORG_STUDENTS.getCode(), orgStudent);
                tags.add(tag);
            }
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);

            this.txStudentTagDao.saveAll(tags, "consultUserId", "userId", "orgId", "content");
            log.info("add tags success!");

        } else {// tagDtos为null时，删除所有已有标签
            this.txStudentTagDao.delTags(orgStudent.getUserId(), orgId);
        }
        orgStudent.setUpdateTime(new Date());
        this.orgStudentsDao.updateWithDefaultVal(orgStudent);
        this.updateSysBacklog(orgId, orgStudent, null);
    }

    private void cascadeUpdateTxConsultName(long orgId, OrgStudent orgStudent, StudentInfoDto studentInfo) {
        boolean updateName = !studentInfo.getName().equals(orgStudent.getName());
        boolean updateMobile = !studentInfo.getMobile().equals(orgStudent.getMobile());
        if (updateName || updateMobile) {
            List<TxConsultUser> consultUsers = txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
            if (consultUsers != null && !consultUsers.isEmpty()) {
                for (TxConsultUser consultUser : consultUsers) {
                    consultUser.setName(updateName ? studentInfo.getName() : null);
                    consultUser.setMobile(updateMobile ? studentInfo.getMobile() : null);
                    consultUser.setUpdateTime(new Date());
                    txConsultUserDao.update(consultUser, false);
                }
            }
        }
    }

    @SuppressWarnings("unused")
    private void cascadeUpdateTxConsultName(long orgId, long studentId, String sourceName, String destName) {
        if (!destName.equals(sourceName)) {
            List<TxConsultUser> consultUsers = txConsultUserDao.lookByStudentId(orgId, studentId);
            if (consultUsers != null && !consultUsers.isEmpty()) {
                for (TxConsultUser consultUser : consultUsers) {
                    consultUser.setName(destName);
                    consultUser.setUpdateTime(new Date());

                    txConsultUserDao.update(consultUser, "name", "updateTime");
                }
            }
        }
    }

    @Override
    @Transactional(readOnly = true)
    public StudentInfoDto getStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId,
        Integer cascadeId) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");

        Long studentId = studentCommenRequestDto.getStudentId();
        Integer applicationType = studentCommenRequestDto.getApplicationType();

        StudentInfoDto dto = new StudentInfoDto();
        setStudentBaseInfo(studentId, orgId, cascadeId, dto);
        Long userId = dto.getUserId();
        Long orgNumber = dto.getOrgNumber();
        Boolean isShowMobile = dto.getIsShowMobile();
        dto.setCascadeId(cascadeId);
        // 设置收费金额记录
        setPayMoneyAndTimes(userId, orgNumber, orgId, dto);
        // 设置课时消费记录
        setClassHour(userId, orgId, dto);
        // 设置跟进记录
        setStudentComment(userId, orgId, isShowMobile, dto);
        // 设置学员标签信息
        setStudentTags(userId, orgId, dto);
        // 设置班主任及班级数量
        setHeaderAndClassNum(userId, orgId, cascadeId, applicationType, dto);
        // 机构是否可以与学员进行微信聊天
        setFansInfo(studentId, orgId, dto);

        return dto;
    }

    /**
     * @param orgId
     * @param cascadeId
     * @param dto
     */
    @Override
    public void setStudentBaseInfo(Long studentId, Long orgId, Integer cascadeId, StudentInfoDto dto) {
        OrgAccount account = this.orgAccountDao.getById(orgId);
        Long orgNumber = null;
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        orgNumber = account.getNumber().longValue();
        if (studentId == null) {
            log.warn("get student info error: studentId is null!");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentId);
        log.debug("query result------student:{}", orgStudent);
        if (orgStudent == null || orgStudent.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()
            || orgStudent.getOrgId().longValue() != orgId) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }

        AccountRoleType findAccountRoleType = this.txAccountHelpService.findAccountRoleType(orgId, cascadeId);
        //FIXME
//        if (findAccountRoleType.getRoleType() == RoleType.EMPLOYEE) {
//            boolean canVisit = false;
//            if (orgStudent.getAddCascadeId().equals(cascadeId)) {
//                canVisit = true;
//            } else {
//                canVisit = checkCanVisit(orgStudent.getUserId(), orgNumber.intValue(), cascadeId, orgId);
//            }
//            if (!canVisit) {
//                // 当前的账号没有权限访问当前的学员信息
//                throw new BussinessException(StudentErrorCode.STUDENT_NOT_BELONG);
//            }
//        }
        User user = this.userDao.getById(orgStudent.getUserId());
        if (user == null) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        boolean isShowMobile = isShowMobileForStudentInfo(orgId, cascadeId);
        dto.setUserId(user.getId());
        dto.setOrgNumber(orgNumber);
        dto.setIsShowMobile(isShowMobile);

        List<TxConsultUser> consults = this.txConsultUserDao.lookByStudentId(orgId, orgStudent.getId());
        if (CollectionUtils.isNotEmpty(consults)) {
            Set<Long> consultUserIds = Sets.newHashSet();
            for (TxConsultUser txConsultUser : consults) {
                consultUserIds.add(txConsultUser.getId());
            }
            dto.setConsultUserIds(StringUtils.join(consultUserIds.toArray(), ','));
            dto.setConsultUserId(consults.get(0).getId());
        }
        dto.setStudentNumber(user.getNumber());
        studentPo2Dto(orgStudent, dto, orgNumber);

        // 获取学生头像 自己上传头像、微信头像、主站头像
        // Long userId = orgStudent.getUserId();
        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(Lists.newArrayList(orgStudent));
        String avatarUrl = studentAvatarUrlMap.get(orgStudent.getId());
        log.info("avatarUrl param:{}", avatarUrl);
        dto.setAvatarUrl(avatarUrl);

        if (!isShowMobile) {
            dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
        }

        if (null != dto.getAreaId() && dto.getAreaId() > 0) {
            Map<String, String> areaMap = AreaUtils.getAreaNameByCode(dto.getAreaId());
            log.debug("区域信息areaMap {}", areaMap);
            dto.setProvince(areaMap.get("province"));
            dto.setCity(areaMap.get("city"));
            dto.setCounty(areaMap.get("county"));
        }
    }

    /**
     * @param orgId
     * @param cascadeId
     * @return
     */
    @Override
    public boolean isShowMobileForStudentInfo(Long orgId, Integer cascadeId) {
        if (orgId == null) {
            throw new BussinessException(CommonErrorCode.NO_LOGIN, "organization does not exists");
        }
        return txCascadeCredentialService.isShowMobile(orgId, cascadeId);
    }


    /**
     * @param orgId
     * @param dto
     */
    @Override
    public void setHeaderAndClassNum(Long userId, Long orgId, Integer cascadeId, Integer applicationType,
        StudentInfoDto dto) {
        // boolean isStaffAccount = false;
        // if (cascadeId != null) {
        // boolean hasPermission = this.txAccountPermissionService.hasPermission(cascadeId.longValue(),
        // ApplicationType.getApplicationType(applicationType), TXPermissionConst.SEE_ALL_ORG_STUDENTS);
        // if (!hasPermission) {
        // isStaffAccount = true;
        // }
        // }
        if (dto == null) {
            dto = new StudentInfoDto();
        }
        if (dto.getUserId() != null) {
            userId = dto.getUserId();
        }
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = getUserId(dto.getStudentId());
            dto.setUserId(userId);
        }
        Set<Integer> casCadeIds = new HashSet<>();
        List<OrgStudentCourse> orgCourseIds = this.orgStudentCourseDao.getOrgCourseIds(orgId, userId, null);
        List<Long> courseIds = ListUtil.toKeyList(orgCourseIds, "courseId", OrgStudentCourse.class);
        List<OrgCourse> courses = this.orgCourseDao.getByIds(new HashSet<>(courseIds), "id", "cascadeId");
        List<Integer> retCascadeIds = ListUtil.<Integer, OrgCourse> toKeyList(courses, "cascadeId", OrgCourse.class);
        casCadeIds.addAll(retCascadeIds);
        // if (!isStaffAccount) {
        // casCadeIds.addAll(retCascadeIds);
        // } else if (cascadeId != null) {
        // if (retCascadeIds.contains(cascadeId)) {
        // casCadeIds.add(cascadeId);
        // }
        // }

        Map<Long, String> txCascadCredentialListByCascdeIds =
            this.txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(casCadeIds);
        StringBuilder sb = new StringBuilder();
        if (casCadeIds.contains(0)) {
            OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId.intValue());
            txCascadCredentialListByCascdeIds.put(0l, orginfo.getContacts());
        }
        Set<String> headTeacherNameCollections = new HashSet<>(txCascadCredentialListByCascdeIds.values());
        for (String name : headTeacherNameCollections) {
            sb.append(name).append("、");
        }
        String headTeacherNames = GenericsUtils.deleteLastCharToString(sb);
        dto.setHeadTeacher(headTeacherNames);

        Integer sumClasses = GenericsUtils.isNullOrEmpty(courses) ? 0 : courses.size();
        // 已报班级数
        dto.setSumClasses(sumClasses);
        log.info("sumOfCourse is : {} ", sumClasses);
    }


    /**
     * @param orgId
     * @param dto
     */
    @Override
    public void setStudentTags(Long userId, Long orgId, StudentInfoDto dto) {
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = getUserId(dto.getStudentId());
        }
        List<TxStudentTag> tags = this.txStudentTagDao.getTags(userId, orgId, StudentType.ORG_STUDENTS.getCode());
        List<TagInfoDto> tagsDto = Lists.newArrayList();

        for (TxStudentTag tag : tags) {
            TagInfoDto tagDto = new TagInfoDto();
            tagPo2Dto(tagDto, tag);
            tagsDto.add(tagDto);
        }
        dto.setTagsResp(tagsDto);
    }


    /**
     * @param orgId
     * @param isShowMobile
     * @param dto
     */
    @Override
    public void setStudentComment(Long userId, Long orgId, Boolean isShowMobile, StudentInfoDto dto) {
        this.setStudentComment(userId, orgId, isShowMobile, null, null, null, dto);
    }


    /**
     * @param orgId
     * @param isShowMobile
     * @param
     * @param dto
     */
    @Override
    public void setStudentComment(Long userId, Long orgId, Boolean isShowMobile, Integer growthStatus,
        Integer lastCommentId, PageDto pageDto, StudentInfoDto dto) {
        if (userId == null && dto != null && dto.getStudentId() != null) {
            userId = getUserId(dto.getStudentId());
        }
        if (isShowMobile == null) {
            isShowMobile = txCascadeCredentialService.isShowMobile(orgId, dto.getCascadeId());
        }
        List<TxStudentComment> comments = this.txStudentCommentDao.getCommentList(userId, orgId,
            StudentType.ORG_STUDENTS.getCode(), growthStatus, lastCommentId, pageDto);
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<TxStudentComment> comments={}", comments);
        List<CommentInfoDto> commentsDto = Lists.newArrayList();
        // callIds为三方通话: CallServiceInfo表id；call400Ids为400电话: OrgPushCallInfo表id
        Set<Long> callIds = Sets.newHashSet();
        Set<Long> call400Ids = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    callIds.add(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    call400Ids.add(comment.getSoundId());
                }
            }
        }
        // callMap: CallServiceInfo映射
        Map<Long, Long> callMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(callIds)) {
            List<CallServiceInfo> callInfos = this.callServiceInfoDao.getByIds(callIds);
            callMap = CollectorUtil.collectMap(callInfos, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<CallServiceInfo, Long>() {
                @Override
                public Long apply(CallServiceInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        // call400Map: OrgPushCallInfo映射
        Map<Long, Long> call400Map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(call400Ids)) {
            List<OrgPushCallInfo> call400Infos = this.orgPushCallInfoDao.getByIds(call400Ids);
            call400Map = CollectorUtil.collectMap(call400Infos, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getId();
                }
            }, new Function<OrgPushCallInfo, Long>() {
                @Override
                public Long apply(OrgPushCallInfo arg0) {
                    return arg0.getStorageId();
                }
            });
        }
        Set<Integer> storageIds = Sets.newHashSet();
        for (TxStudentComment comment : comments) {
            if (StringUtils.isNotEmpty(comment.getStorageIds())) {
                String[] storageIdsStr = comment.getStorageIds().split(",");
                for (String storageId : storageIdsStr) {
                    storageIds.add(Integer.parseInt(storageId));
                }
            }
            if (comment.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
                Long storageId = null;
                if (comment.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                    storageId = callMap.get(comment.getSoundId());
                } else if (comment.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                    storageId = call400Map.get(comment.getSoundId());
                }
                if (storageId != null && storageId.longValue() > 0) {
                    storageIds.add(storageId.intValue());
                }
            } else if (comment.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode()) {
                if (comment.getSoundId() != null && comment.getSoundId().longValue() > 0) {
                    storageIds.add(comment.getSoundId().intValue());
                }
            }
        }
        List<OrgStorage> storages = this.orgStorageDao.getByIds(storageIds);
        Map<Integer, OrgStorage> storageMap = CollectorUtil.collectMap(storages, new Function<OrgStorage, Integer>() {
            @Override
            public Integer apply(OrgStorage arg0) {
                return arg0.getId();
            }
        });

        Set<Integer> cascadeIds = new HashSet<Integer>();
        for (TxStudentComment comment : comments) {
            cascadeIds.add(comment.getCreatorCascadeId().intValue());
        }
        Map<Long, String> cascadeIdVSNameMap = txCascadeCredentialDao.getTxCascadCredentialListByCascdeIds(cascadeIds);
        OrgInfo orgInfo = orgInfoDao.getOrgInfo(orgId.intValue());
        cascadeIdVSNameMap.put(0L, orgInfo.getShowName());

        for (TxStudentComment comment : comments) {
            CommentInfoDto commentDto = new CommentInfoDto();
            commentPo2Dto(commentDto, comment, callMap, call400Map, storageMap, cascadeIdVSNameMap);
            if (!isShowMobile) {
                commentDto.setContent(CommentUtil.maskMobile(comment.getContent()));
            }
            commentsDto.add(commentDto);
        }
        log.info("OrgStudentServiceImpl:getStudentInfo--------List<CommentInfoDto> commentsDto={}", commentsDto);
        dto.setCommentsResp(commentsDto);
    }

    public static void main(String[] args) {
        Map<String, String> areaMap = AreaUtils.getAreaNameByCode(285741056l);
        Gson gson = new Gson();

        System.out.println(gson.toJson(areaMap));
    }

    @Override
    public StudentCustomFieldResponse getSimpleStudentInfo(StudentCommenRequestDto studentCommenRequestDto, Long orgId,
        Integer cascadeId) {
        StudentInfoDto dto = new StudentInfoDto();
        if (studentCommenRequestDto.getStudentId() != null && studentCommenRequestDto.getStudentId() > 0) {
            dto = this.getStudentInfo(studentCommenRequestDto, orgId, cascadeId);
        }
        StudentCustomFieldResponse response = new StudentCustomFieldResponse();
        BeanUtils.copyProperties(dto, response);
        return response;
    }

    /**
     * 判断当前的账号是否能访问当前的学员
     *
     * @param orgId
     * @return
     */
    @Override
    public boolean checkCanVisit(Long userId, Integer orgNumber, Integer cascadeId, Long orgId) {
        List<OrgCourse> courseByCasCadeIds = this.orgCourseDao.getCourseByCasCadeIds(orgNumber,
            Arrays.asList(cascadeId), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, "id");
        if (GenericsUtils.isNullOrEmpty(courseByCasCadeIds)) {
            return false;
        }
        List<Long> courseIds = ListUtil.toKeyList(courseByCasCadeIds, "id", OrgCourse.class);
        for (Long courseId : courseIds) {
            OrgStudentCourse studentCourse = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, userId);
            if (studentCourse != null) {
                return true;
            }
        }
        return false;
    }

    @SuppressWarnings("unused")
    private int sumClasses(long orgId, long userId) {
        Set<Long> ret = new HashSet<>();
        List<Long> courseIds = orgStudentCourseDao.getStudentCourseIds(orgId, userId, 0);
        ret.addAll(courseIds);
        try {
            List<StudentClassHour> classHourList = solrStudentQuery.queryStudentClassHourList(userId, orgId);
            for (StudentClassHour classHour : classHourList) {
                ret.add(classHour.getCourseId());
            }
        } catch (Exception e) {
            log.error("[Solr] Query exception.", e);
        }
        return ret.size();
    }

    @SuppressWarnings("unused")
    private Integer getSignupClassCount(OrgStudent po, long orgNumber) {
        return orgStudentCourseService.getStudentSignupCourse(po, orgNumber);
    }

    /**
     * 机构是否可以与学生聊天
     *
     * @param dto
     */
    @Override
    public void setFansInfo(Long studentId, Long orgId, StudentInfoDto dto) {
        log.info("this.authorizationInfoDao is null : {} ", this.authorizationInfoDao == null);
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(orgId.intValue());
        OrgWechatOpenIdRecord record = null;

        if (authorizationInfo == null
            || authorizationInfo.getAuthorizerAppId().equals(WechatProperties.getWechatAppidForFreeVersion())) {
            // 免费版 或 普通版但没绑定公众号
            record = orgWechatOpenIdRecordDao.getBy(WechatProperties.getWechatAppidForFreeVersion(), orgId, studentId,
                WechatOpenIdEntityType.STUDENT);
        } else {
            // 普通版绑定了公众号
            record = orgWechatOpenIdRecordDao.getBy(authorizationInfo.getAuthorizerAppId(), orgId, studentId,
                WechatOpenIdEntityType.STUDENT);
        }
        log.info("record is :{} ", record);

        dto.setChat(BizConf.FALSE.intValue());
        if (record != null) {
            Fans fans = fansDao.getByOpenId(record.getOpenId());
            log.info("fans is :{} ", fans);
            if (fans != null && fans.isSubscribed()) {
                dto.setChat(BizConf.TRUE.intValue());
                dto.setLastCommunicationTime(
                    fans.getLastCommunicationTime() == null ? null : fans.getLastCommunicationTime().getTime());
            }
        }
    }

    /**
     * po to dto
     *
     * @param dto
     * @param po
     */
    private void commentPo2Dto(CommentInfoDto dto, TxStudentComment po, Map<Long, Long> callMap,
        Map<Long, Long> call400Map, Map<Integer, OrgStorage> storageMap, Map<Long, String> cascadeIdVSNameMap) {
        dto.setCommentId(po.getId());
        dto.setContent(po.getContent());
        dto.setStorageIds(po.getStorageIds());
        dto.setCreateTime(po.getCreateTime());
        dto.setCallStatus(po.getCallStatus());
        dto.setIsMobile(po.getIsMobile());
        dto.setIsSystem(po.getIsSystem());
        if (null != po.getIsMobile() && po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
            // 三方通话不需要来源
            dto.setOrigin(-1);
        } else {
            dto.setOrigin(po.getOrigin());
        }

        if (StringUtils.isNotEmpty(dto.getStorageIds())) {
            String[] storageIdsStr = dto.getStorageIds().split(",");
            List<String> urls = Lists.newArrayList();
            for (String storageId : storageIdsStr) {
                OrgStorage storage = storageMap.get(Integer.parseInt(storageId));
                if (storage != null) {
                    String url = StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType());
                    urls.add(url);
                }
            }
            dto.setUrls(StringUtils.join(urls.toArray(new String[urls.size()]), ","));
        }
        if (po.getDownStatus().intValue() == DownLoadStatus.UNFINISH.getCode()) {
            Long storageId = null;
            if (po.getIsMobile().intValue() == MobileStatus.IS_CALL.getCode()) {
                storageId = callMap.get(po.getSoundId());
            } else if (po.getIsMobile().intValue() == MobileStatus.IS_400_CALL.getCode()) {
                storageId = call400Map.get(po.getSoundId());
            }
            if (storageId != null && storageId.longValue() > 0) {
                po.setSoundId(storageId);
                po.setDownStatus(DownLoadStatus.FINISH.getCode());
                this.txStudentCommentDao.update(po, "downStatus", "soundId");
            }
        }
        if (po.getSoundId() > 0 && po.getDownStatus().intValue() == DownLoadStatus.FINISH.getCode()) {
            OrgStorage storage = storageMap.get(po.getSoundId().intValue());
            if (storage != null) {
                dto.setSeconds(po.getSeconds());
                dto.setSoundId(po.getSoundId());
                dto.setSoundUrl(StorageUtil.constructUrl(storage.getFid(), storage.getSn(), storage.getMimeType()));
            }
        }
        dto.setDownLoadStatus(po.getDownStatus());

        dto.setCommentType(po.getCommentType());
        dto.setGrowthComments(po.getGrowthComments());
        dto.setNotifyParents(po.getNotifyParents());
        dto.setCreatorCascadeId(po.getCreatorCascadeId());

        CreatorDto creatorDto = new CreatorDto();
        creatorDto.setCascadeId(po.getCreatorCascadeId());

        if (po.getCreatorCascadeId().intValue() != Flag.NULL.getInt()) {
            creatorDto.setName(cascadeIdVSNameMap.get(Long.parseLong(po.getCreatorCascadeId() + "")));
        } else {
            if (po.getIsSystem().intValue() == Flag.TRUE.getInt()) {
                creatorDto.setName("系统");
            } else {
                creatorDto.setName("历史用户");
            }
        }
        dto.setCreator(creatorDto);
    }

    /**
     * po to dto
     *
     * @param dto
     * @param po
     */
    private void tagPo2Dto(TagInfoDto dto, TxStudentTag po) {
        dto.setTagId(po.getId());
        dto.setContent(po.getContent());
    }

    @Override
    @Transactional(readOnly = true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, Long orgId,
        PageDto pageDto) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        List<OrgStudent> list = Lists.newArrayList();
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseType() != null) {// 查询课程学员
            if (studentListRequestDto.getCourseType().intValue() == CourseType.CLASS.getCode()
                || studentListRequestDto.getCourseType().intValue() == CourseType.TRIAL_COURSE.getCode()) {// 班课和试听课
                List<CoursePurchase> purchases = Lists.newArrayList();
                Set<Long> userIds = Sets.newHashSet();
                for (CoursePurchase coursePurchase : purchases) {
                    userIds.add(coursePurchase.getUserId());
                }
                list = this.orgStudentsDao.getStudents(orgId, userIds, DeleteStatus.NORMAL.getValue(), pageDto, "id",
                    "name", "mobile", "weixin", "createTime");
            } else {
                OrgCourse course = this.orgCourseDao.getCourseByCourseNumberAndOrgNumber(account.getId().longValue(),
                    studentListRequestDto.getCourseNumber(), "id");
                if (course != null) {
                    List<Long> studentIds = this.orgStudentCourseDao.getStudents(orgId, course.getId());
                    list = this.orgStudentsDao.getByIdsAndOrderByParam(studentIds, "createTime",
                        new String[] { "id", "name", "mobile", "weixin", "createTime"});
                }
            }
        } else {
            if (pageDto == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR);
            }
            list = this.orgStudentsDao.getStudents(orgId, studentListRequestDto.getSearchKey(),
                DeleteStatus.NORMAL.getValue(), pageDto, "id", "name", "mobile", "weixin", "createTime");
        }
        responseDto.setList(buidStudentInfoReponseDto(list));
        return responseDto;
    }

    @Override
    @Transactional(readOnly = true)
    public StudentInfoListReponseDto getStudentList(StudentListRequestDto studentListRequestDto, List<Long> studentids,
        Long orgId, PageDto pageDto) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }
        StudentInfoListReponseDto responseDto = new StudentInfoListReponseDto();
        if (pageDto == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR);
        }
        List<OrgStudent> list = this.orgStudentsDao.getStudents(orgId, studentids, studentListRequestDto.getSearchKey(),
            DeleteStatus.NORMAL.getValue(), pageDto, "id", "name", "mobile", "weixin", "createTime");
        responseDto.setList(buidStudentInfoReponseDto(list));
        return responseDto;
    }

    @Transactional(readOnly = true)
    @Override
    public List<StudentDto> searchStudentClassInfo(Set<Long> studnetIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studnetIds)) {
            return GenericsUtils.emptyList();
        }
        List<OrgStudent> dtos = this.orgStudentsDao.getByIds(studnetIds, "id", "userId");

        List<StudentDto> retDtos = Lists.newArrayListWithCapacity(dtos.size());
        for (OrgStudent student : dtos) {
            StudentDto dto = new StudentDto();
            dto.setUserId(student.getUserId());
            dto.setStudentId(student.getId());
            retDtos.add(dto);
        }
        this.setStudentClassInfos(retDtos, orgId, null);
        return retDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public List<StudentDto> searchStudentList(StudentListRequestDto studentListRequestDto, Long orgId,
        PageDto pageDto) {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }

        boolean needFilterWithSolr = studentListRequestDto.needFilter();
        final StudentQueryParam param = buildByStudentListRequestDto(studentListRequestDto);
        param.setOrgId(orgId);
        if(StringUtils.isNotBlank(param.getQueryStr())&&param.getQueryStr().startsWith("customField")){

            String idStr = param.getQueryStr().replace("customField", "");
            Long fieldId = Long.parseLong(idStr);
            CustomField field = this.customFieldDao.getCustomFieldById(orgId, fieldId);
            String queryValue = "";
            if(field!=null){

                if(field.getType()==1){
                    if(StringUtils.isNotBlank(param.getQueryValue())){
                        queryValue = idStr+"#*"+param.getQueryValue()+"*";
                    }
                }else if(field.getType()==4){
                    queryValue = idStr+"#"+param.getQueryValue()+"*";
                }else if(field.getType()==2 ||field.getType()==3){
                    List<TXCustomOption> customOptionList = txCustomOptionDao.getTXCustomOptionList(fieldId);
                    if (customOptionList != null && customOptionList.size() > 0) {
                        Long optionId = null;
                        for (TXCustomOption customOption : customOptionList) {
                            if(StringUtils.equals(customOption.getLabel(),param.getQueryValue())){
                                optionId = customOption.getId();
                                break;
                            }
                        }
                        if(optionId!=null&&optionId>0L){
                            queryValue = idStr+"#"+optionId;
                        }
                    }
                }

            }
            //自定义属性查询不匹配直接返回空集合
            if(StringUtils.isNotBlank(queryValue)){
                param.setQueryStr("customSearchValue");
                param.setQueryValue(queryValue);
            }else{
                return Lists.newArrayList();
            }

        }
        if (studentListRequestDto.getCourseNumber() != null && studentListRequestDto.getCourseNumber() > 0) {
            OrgCourse course = orgCourseDao.getOrgCourse(account.getNumber(), studentListRequestDto.getCourseNumber());
            if (course == null) {
                return Collections.emptyList();
            }
            List<Long> userIds = orgStudentCourseDao.getStudents(orgId, course.getId());
            if (userIds == null || userIds.size() < 1) {
                return Collections.emptyList();
            } else {
                param.setStudentIds(new HashSet<Long>(userIds));
            }
        }

        log.info("[studnetQueryParam] is : {} ", param);

        AccountRoleType roleType =
            txAccountHelpService.findAccountRoleType(orgId, studentListRequestDto.getCascadeId());
        final boolean isShow = txCascadeCredentialService.isShowMobile(orgId, studentListRequestDto.getCascadeId());
        log.info("show mark mobile : {}  for orgId :{} and cascadeId :{}", isShow, orgId,
            studentListRequestDto.getCascadeId());
        List<StudentDto> studentDtos = null;
        if (roleType.needDataAuthority()) {
            log.info("当前角色 orgId : {} , cascadeId : {}没有获取学员列表的权限，进行数据控制", orgId, roleType.getCascadeId());
            param.setNeedQueryByAuthority(true);
            List<Long> ownCourseIds =
                orgCourseDao.getCourseIdsByCascadeId(studentListRequestDto.getCascadeId(), null, null, null);
            // 班主任是当前用户的学生
            Set<Long> ids = solrStudentQuery.queryCourseStudentUserIds(ownCourseIds, param.getOrgId());
            // 添加人是当前的学生
            List<Long> addedUserIds =
                orgStudentsDao.getStudentIdsByAdder(studentListRequestDto.getCascadeId(), param.getOrgId());
            ids.addAll(addedUserIds);
            if (ids.isEmpty()) {
                log.info("[OrgStudentList] no users!,orgId={},cascadeId={}", param.getOrgId(),
                    studentListRequestDto.getCascadeId());
                return Collections.emptyList();
            }
            Set<Long> preStudentIds = param.getStudentIds();
            if (GenericsUtils.notNullAndEmpty(preStudentIds)) {
                ids.retainAll(preStudentIds);
            }
            param.setStudentIds(ids);
        }
        studentDtos = Lists.newArrayList();
        try {
            if (needFilterWithSolr) {
                log.info("need query with solr ");
                // 当前requestPageSize 代表上层调用者希望单次查询的数据量,
                // 因为solr每次查询数据的上限为1000，所以这里做了个循环获取的操作.
                if (pageDto.getPageSize() > 1000) {
                    int requestPageSize = pageDto.getPageSize();
                    int totalPageNum = requestPageSize / 1000;
                    int pageNumCount = (requestPageSize % 1000) == 0 ? (totalPageNum) : totalPageNum + 1;
                    for (int i = 1; i <= pageNumCount; i++) {
                        pageDto.setPageNum(i);
                        pageDto.setPageSize(1000);
                        studentDtos.addAll(solrStudentQuery.queryStudent(param, pageDto));
                    }
                } else {
                    studentDtos.addAll(solrStudentQuery.queryStudent(param, pageDto));
                }
                if (param.isNeedClassInfo()) {
                    // 设置学员课次信息
                    this.setStudentClassInfos(studentDtos, orgId, null);
                }
            } else {
                log.info(" query with db ");
                studentDtos.addAll(searchStudentListFromDB(orgId, pageDto, param, roleType, param.isNeedClassInfo()));
            }
        } catch (Exception e) {
            log.error("[searchStudentList ] list:{}", e);
            studentDtos.addAll(searchStudentListFromDB(orgId, pageDto, param, roleType, param.isNeedClassInfo()));
        }

        if (GenericsUtils.isNullOrEmpty(studentDtos)) {
            return GenericsUtils.emptyList();
        }

        log.info("searchStudentList params={},page={},result={}", param, pageDto, studentDtos.size());
        final Set<Long> courseIds = new HashSet<>();
        final Set<OrgStudent> students = new HashSet<>();

        for (StudentDto studentDto:studentDtos){
            String pinyin = studentDto.getPinyin();
            if (StringUtils.isBlank(pinyin)) {
                if (StringUtils.isNotBlank(studentDto.getName())) {
                    pinyin = HanZiPinYinUtils.getLowerCasePinYin(studentDto.getName());
                } else {
                    pinyin = HanZiPinYinUtils.getLowerCasePinYin(studentDto.getMobile());
                }
            }
            String str = "#";
            if (StringUtils.isNotBlank(pinyin)) {
                char init = pinyin.charAt(0);
                str = String.valueOf(init);
            }
            // Solr中将数字开头的名称都使用“~”代替了，因为PM要求数字开头的要排在最后，显示为#，ASCII中比字母大的符号只有~
            if (str.equals("~")) {
                str = "#";
            }
            studentDto.setInitial(str.toUpperCase());
            if (!isShow) {
                studentDto.setMobile(MaskUtil.maskMobile(studentDto.getMobile()));
            }
            courseIds.add(studentDto.getCourseId());
            studentDto.setTypeMark(StudentLessonStatus.getStatus(studentDto.getStuLessonStatus()).getName());
            OrgStudent student = new OrgStudent();
            student.setId(studentDto.getStudentId());
            student.setAvatar(studentDto.getAvatar());
            student.setWeixin(studentDto.getWeixin());
            students.add(student);
        }

        Map<Long, String> studentAvatarUrlMap = Maps.newHashMap();
        if (studentListRequestDto.isNeedAvatar()) {
            studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(students);
        }
        log.info("studentAvatarUrlMap param:{}", studentAvatarUrlMap);

        for (StudentDto student : studentDtos) {
            String url = studentAvatarUrlMap.get(student.getStudentId());
            student.setAvatarUrl(url);
        }
        return studentDtos;
    }

    /**
     * @param orgId
     * @param pageDto
     * @param param
     * @param roleType
     * @return
     */
    private List<StudentDto> searchStudentListFromDB(Long orgId, PageDto pageDto, StudentQueryParam param,
        AccountRoleType roleType, boolean needClassInfo) {
        log.info("[searchStudentListFromDB] params is : {} ", param);
        List<StudentDto> studentDtos = null;
        List<Integer> lessonStatus = Lists.newArrayList();
        if ((param.getStatus() != null && param.getStatus() != StudentLessonStatus.ALL)) {
            if (StudentLessonStatus.STUDYING == param.getStatus()) {
                lessonStatus.add(StudentLessonStatus.STUDYING.getStatus());
                lessonStatus.add(StudentLessonStatus.TO_CHARGE.getStatus());
            } else if (StudentLessonStatus.CURRENT_STU == param.getStatus()) {
                lessonStatus.add(StudentLessonStatus.STUDYING.getStatus());
                lessonStatus.add(StudentLessonStatus.NOT_ENROLL.getStatus());
                lessonStatus.add(StudentLessonStatus.TO_CHARGE.getStatus());
            } else if (StudentLessonStatus.BACKLOG_STU == param.getStatus()) {
            	lessonStatus.add(StudentLessonStatus.STUDYING.getStatus());
                lessonStatus.add(StudentLessonStatus.NOT_ENROLL.getStatus());
                lessonStatus.add(StudentLessonStatus.TO_CHARGE.getStatus());
                lessonStatus.add(StudentLessonStatus.PAST.getStatus());
            }else if (StudentLessonStatus.ALL != param.getStatus()) {
                lessonStatus.add(param.getStatus().getStatus());
            }
        } else {
            lessonStatus.addAll(StudentLessonStatus.listAllStatus());
        }
        List<Long> addCascadeIds = param.getAddCascadeIds();
        List<OrgStudent> students = orgStudentsDao.getStudentList(orgId.intValue(), lessonStatus, addCascadeIds,
            param.getStudentIds(), param.getOrderType() == 0 ? true : false, pageDto);
        log.info("find all studnets are : {} ", students.size());
        if (students != null) {
            studentDtos = new ArrayList<>(students.size());
            for (OrgStudent stu : students) {
                studentDtos.add(buildStudentDto(stu));
            }
        }
        if (needClassInfo) {
            log.info(" needSetClassInfo with db : {}", orgId);
            setClassInfofromDB(studentDtos, orgId);
            this.setStudentClassName(studentDtos);
        }
        return studentDtos;
    }

    public void setClassInfofromDB(List<StudentDto> studentDtos, Long orgId) {
        long begin = System.currentTimeMillis();
        Map<String, StudentClassHour> map = new HashMap<>();
        try {
            if (studentDtos == null || studentDtos.size() < 1) {
                return;
            }
            final Map<Long, StudentDto> studentIdMap =
                com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(studentDtos,
                    new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, StudentDto>() {
                        @Override
                        public Long extract(StudentDto studentDto) {
                            return studentDto.getUserId();
                        }
                    });

            List<StudentClasHourDocument> list = searchStudentClasHourDocuments(studentIdMap.keySet(), orgId);
            log.info("query all StudnetClassHourDocument's size are : {} ", list.size());
            List<StudentClassHourStatusDocument> StudentClassHourStatusDocumentLists =
                searchStudentClassHourStatusDocuments(studentIdMap.keySet(), orgId);
            log.info("searchStudentClassHourStatusDocuments's size are : {} ",
                StudentClassHourStatusDocumentLists.size());
            Map<String, StudentClass> statusMap = createStatusMap(StudentClassHourStatusDocumentLists);
            Map<Long, List<StudentClassHour>> sscCache = new HashMap<>();
            for (Iterator<StudentClasHourDocument> iterator = list.iterator(); iterator.hasNext();) {
                StudentClasHourDocument document = iterator.next();
                StudentClassHour classHour = buildStudentClassHour(document);
                Long userId = classHour.getUserId();
                Long courseId = classHour.getCourseId();
                String key = userId + "_" + courseId;
                log.info("key : {} and before :{} ", key, classHour);
                StudentClass studentClass = statusMap.get(key);
                if (studentClass != null) {
                    if (studentClass.getStatus() != 0) {
                        classHour.setTotalCount(classHour.getFinishCount());
                    } else {
                        classHour.setTotalCount(Math.max(studentClass.getContractCount(), classHour.getTotalCount()));
                    }
                }
                log.info("key :{} and after :{} ", key, classHour);
                if (map.get(key) == null) {
                    map.put(key, classHour);
                } else {
                    classHour = map.get(key);
                }
                List<StudentClassHour> courseList = sscCache.get(userId);
                if (courseList == null) {
                    courseList = new ArrayList<>();
                    sscCache.put(userId, courseList);
                }
                courseList.add(classHour);
            }

            Map<Long, StudentClassHour> retMap = new HashMap<>();

            // 计算剩余课时最少的（如果剩余课时相同显示最新创建的）
            for (String stuCourseId : map.keySet()) {
                StudentClassHour tempClassHour = map.get(stuCourseId);
                log.info("tempClassHour : {} ", tempClassHour);
                StudentClassHour retClassHour = retMap.get(tempClassHour.getUserId());
                log.info("retClassHour : {} ", retClassHour);
                if (retClassHour == null) {
                    retMap.put(tempClassHour.getUserId(), tempClassHour);
                } else {
                    if (tempClassHour.getLeftCount() > 0) {
                        if (retClassHour.getLeftCount() <= 0) {
                            // 显示有剩余课时
                            retMap.put(tempClassHour.getUserId(), tempClassHour);
                        } else if (retClassHour.getLeftCount() > tempClassHour.getLeftCount()) {
                            // 显示剩余课时最小的
                            retMap.put(tempClassHour.getUserId(), tempClassHour);
                        } else if (retClassHour.getLeftCount() == tempClassHour.getLeftCount()) {
                            // 最小的剩余课时一样的话，展示最近一次排课的
                            if (retClassHour.getCourseId() < tempClassHour.getCourseId()) {
                                retMap.put(tempClassHour.getUserId(), tempClassHour);
                            }
                        }
                    } else {
                        // 如果没有剩余课时，显示最近一次排课的课时
                        if (retClassHour.getLeftCount() <= 0) {
                            if (retClassHour.getCourseId() < tempClassHour.getCourseId()) {
                                retMap.put(tempClassHour.getUserId(), tempClassHour);
                            }
                        }
                    }
                }
                log.info("after : retClassHour : {} ", retMap.get(tempClassHour.getUserId()));
            }

            log.info("retMap : {} ", retMap);

            for (StudentDto dto : studentDtos) {
                StudentClassHour studentClassHour = retMap.get(dto.getUserId());
                log.info("studentClassHour : {} ", studentClassHour);
                if (studentClassHour != null) {
                    dto.setLeftClassHour(studentClassHour.getLeftCount());
                    dto.setFinishClassHour(studentClassHour.getFinishCount());
                    dto.setCourseId(studentClassHour.getCourseId());
                    dto.setHasLesson(true);
                }
            }

        } catch (Exception e) {
            log.error("[Solr replace with DB] IOException ", e);
        }
        log.info("[Solr replace with DB] Query course info cost={},orgId={}", (System.currentTimeMillis() - begin),
            orgId);
    }


    /**
     * @param orgId
     * @return
     */

    private List<StudentClassHourStatusDocument> searchStudentClassHourStatusDocuments(Set<Long> studentIds,
        Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        return this.orgStudentCourseDao.searchStudentClassHourStatus(studentIds, orgId);
    }

    /**
     * @param studentIds
     * @param orgId
     * @return
     */
    private List<StudentClasHourDocument> searchStudentClasHourDocuments(Set<Long> studentIds, Long orgId) {
        if (GenericsUtils.isNullOrEmpty(studentIds)) {
            return GenericsUtils.emptyList();
        }
        List<StudentClasHourDocument> ret = this.orgStudentLessonDao.queryStudentClassHours(studentIds, orgId);
        return ret;
    }

    /**
     * @param studentClassHourStatusDocumentLists
     * @return
     */
    private Map<String, StudentClass> createStatusMap(
        List<StudentClassHourStatusDocument> studentClassHourStatusDocumentLists) {
        Map<String, StudentClass> statusMap = Maps.newHashMap();
        Iterator<StudentClassHourStatusDocument> iterator = studentClassHourStatusDocumentLists.iterator();
        while (iterator.hasNext()) {
            StudentClassHourStatusDocument next = iterator.next();
            Long userId = next.getUserId();
            Long courseId = next.getCourseId();
            Integer lessonCount = next.getLessonCount();
            StudentClass studentClass = new StudentClass();
            String key = userId + "_" + courseId;
            Integer status = next.getStatus();
            studentClass.setStatus(status);
            studentClass.setContractCount(lessonCount == null ? 0 : lessonCount);
            studentClass.setUserId(userId);
            studentClass.setCourseId(courseId);
            statusMap.put(key, studentClass);
        }
        log.info("statusMap is :{}", statusMap);
        return statusMap;
    }

    private StudentClassHour buildStudentClassHour(StudentClasHourDocument document) {
        Long studentId = document.getUserId();
        Long courseId = document.getCourseId();
        Long totalCount = document.getTotal();
        Long finishCount = document.getFinished();
        totalCount = (totalCount == null ? 0L : totalCount);
        finishCount = (finishCount == null ? 0L : finishCount);
        StudentClassHour classHour = new StudentClassHour();
        classHour.setUserId(studentId);
        classHour.setCourseId(courseId);
        classHour.setFinishCount(finishCount.intValue());
        classHour.setTotalCount(totalCount.intValue());
        return classHour;
    }

    /**
     * @param studentDtos
     * @param orgId
     * @param object
     */
    private void setStudentClassInfos(List<StudentDto> studentDtos, Long orgId, Object object) {
        try {
            solrStudentQuery.setClassInfo(studentDtos, orgId, null);
        } catch (Exception e) {
            log.error("error is : {} ", e);
            this.setClassInfofromDB(studentDtos, orgId);
        }
        log.info("after solrSetClassInfo : {} ", studentDtos);
        setStudentClassName(studentDtos);
    }

    /**
     * @param studentDtos
     */
    private void setStudentClassName(List<StudentDto> studentDtos) {
        Set<Long> courseIds =
            new HashSet<>(com.baijia.commons.lang.utils.collection.CollectionUtils.extractList(studentDtos,
                new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, StudentDto>() {
                    @Override
                    public Long extract(StudentDto arg0) {
                        return arg0.getCourseId();
                    }
                }));
        List<OrgCourse> courses = orgCourseDao.getByIds(courseIds, "id", "name");
        Map<Long, OrgCourse> courseMap = com.baijia.commons.lang.utils.collection.CollectionUtils.extractMap(courses,
            new com.baijia.commons.lang.utils.collection.CollectionUtils.Extracter<Long, OrgCourse>() {
                @Override
                public Long extract(OrgCourse orgCourse) {
                    return orgCourse.getId();
                }
            });
        for (StudentDto dto : studentDtos) {
            OrgCourse course = courseMap.get(dto.getCourseId());
            if (course != null) {
                dto.setClassName(course.getName());
            }
        }
    }

    private StudentDto buildStudentDto(OrgStudent orgStudent) {
        StudentDto stu = new StudentDto();
        stu.setName(orgStudent.getName());
        stu.setMobile(orgStudent.getMobile());
        stu.setWeixin(orgStudent.getWeixin());
        stu.setStudentId(orgStudent.getId());
        stu.setStuLessonStatus(orgStudent.getLessonStatus());
        stu.setUserId(orgStudent.getUserId());
        stu.setPinyin(orgStudent.getPinyin());
        stu.setAvatar(orgStudent.getAvatar());
        return stu;
    }

    private StudentQueryParam buildByStudentListRequestDto(StudentListRequestDto dto) {
        StudentQueryParam param = new StudentQueryParam();
        param.setLessonStatus(dto.getIsSchedule());
        param.setLeftMinClassHour(dto.getLeftMinClassHour());
        param.setLeftMaxClassHour(dto.getLeftMaxClassHour());
        param.setEnrollTime(TimeType.getTimeTypeByCode(dto.getEnrollDate()));
        param.setFollowTime(TimeType.getTimeTypeByCode(dto.getFollowDate()));
        param.setCreateTime(TimeType.getTimeTypeByCode(dto.getCreateDate()));
        param.setStatus(StudentLessonStatus.getStatus(dto.getStudentStatus()));
        param.setOpType(OpType.getOpType(dto.getOpType()));
        param.setSearchKey(dto.getSearchKey());
        param.setGender(dto.getSex());
        param.setQueryStr(dto.getQueryStr());
        param.setQueryValue(dto.getQueryValue());

        param.setCascadeId(dto.getCascadeId());
        if (GenericsUtils.notNullAndEmpty(dto.getCascadeIds())) {
            List<Long> addCascadeIds = new ArrayList<>(GenericsUtils.stringToNumber(dto.getCascadeIds(), Long.class));
            param.setAddCascadeIds(addCascadeIds);
        }
        param.setOrderName(dto.getOrderName());
        param.setOrderType(dto.getOrderType());
        param.setNeedClassInfo(dto.isNeedClassInfo());
        return param;
    }

    private List<StudentInfoReponseDto> buidStudentInfoReponseDto(List<OrgStudent> students) {
        Map<Long, String> studentAvatarUrlMap = studentApiService.batchGetStudentAvatarUrl(students);
        List<StudentInfoReponseDto> result = Lists.newArrayList();
        for(OrgStudent student : students){
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            dto.setName(student.getName());
            dto.setStudentId(student.getId());
            if (StringUtils.isBlank(student.getShowMobile())) {
                dto.setMobile(MaskUtil.maskMobile(student.getMobile()));
            } else {
                dto.setMobile(student.getShowMobile());
            }
            dto.setWeixin(student.getWeixin());
            if (StringUtils.isBlank(student.getName())) {
                if (StringUtils.isNotEmpty(student.getNickName())) {
                    dto.setName(student.getNickName());
                } else {
                    dto.setName(dto.getMobile());
                }
            }
            if (StringUtils.isNotBlank(student.getPinyin())) {
                char init = student.getPinyin().charAt(0);
                String str = String.valueOf(init);
                dto.setInitial(str.toLowerCase());
            }
            dto.setAvatarUrl(studentAvatarUrlMap.get(student.getId()));
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public MobileCheckReponseDto checkmobile(Long orgId, List<MobileCheckInfoRequestDto> mobiles) {
        MobileCheckReponseDto reponse = new MobileCheckReponseDto();
        List<Integer> failds = Lists.newArrayList();
        reponse.setFailds(failds);
        if (CollectionUtils.isNotEmpty(mobiles)) {
            Set<String> mobileSet = Sets.newHashSet();
            for (MobileCheckInfoRequestDto dto : mobiles) {
                mobileSet.add(dto.getMobile());
            }
            List<OrgStudent> students =
                this.orgStudentsDao.getStudents(orgId, mobileSet, DeleteStatus.NORMAL.getValue(), "mobile");
            Set<String> existMobile = Sets.newHashSet();
            for (OrgStudent student : students) {
                existMobile.add(student.getMobile());
            }
            for (MobileCheckInfoRequestDto dto : mobiles) {
                if (existMobile.contains(dto.getMobile())) {
                    failds.add(dto.getId());
                }
            }
        }
        return reponse;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<BatchAddStudentResponseDto> batchAddStudent(List<? extends StudentInfoDto> studentInfoDtos,
        Long orgId) {
        for (StudentInfoDto studentInfoDto : studentInfoDtos) {
            if (!ParamValidateUtils.validateMobile(studentInfoDto.getMobile())) {
                throw new BussinessException(StudentErrorCode.MOBILE_WRONG);
            }
        }
        List<BatchAddStudentResponseDto> addStudentResponseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(studentInfoDtos)) {
            Map<String, StudentInfoDto> mobileMap =
                CollectorUtil.collectMap(new ArrayList<>(studentInfoDtos), new Function<StudentInfoDto, String>() {
                    @Override
                    public String apply(StudentInfoDto input) {
                        return input.getMobile();
                    }
                });
            List<OrgStudent> students =
                this.orgStudentsDao.getStudents(orgId, mobileMap.keySet(), DeleteStatus.NORMAL.getValue(), "mobile");
            Set<String> mobiles = Sets.newHashSet();// 已经存在的学员
            for (OrgStudent student : students) {
                mobiles.add(student.getMobile());
            }
            for (StudentInfoDto dto : studentInfoDtos) {
                if (!mobiles.contains(dto.getMobile())) {
                    OrgStudentAddresponseDto result = this.addStudent(dto, null, null, orgId);
                    if (result != null) {
                        BatchAddStudentResponseDto responseDto = new BatchAddStudentResponseDto();
                        responseDto.setMobile(dto.getMobile());
                        responseDto.setStudentId(result.getStudentId());
                        addStudentResponseDtos.add(responseDto);
                    }
                }
            }
        }
        return addStudentResponseDtos;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentIdUserIdMap(studentIds);
    }

    @Override
    // @Transactional(readOnly = true)
    public Map<Long, String> getStudentNameMap(Collection<Long> studentIds) {
        return this.orgStudentsDao.getStudentNameMap(studentIds);
    }

    @Override
    // @Transactional(readOnly = true)
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId) {
        return this.orgStudentsDao.getUserIdStudentIdMap(userIds, orgId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public StudentInfoDto getAndUpdateOrgStudentByMobile(Long orgId, String mobile, String name, String weinOpenId)
        throws BussinessException {
        List<OrgStudent> students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, 0);
        StudentInfoDto result = null;
        if (students != null && !students.isEmpty()) {
            result = this.getResult(students.get(0));
            for (OrgStudent student : students) {
                String weixin = student.getWeixin();
                if (!weinOpenId.equals(weixin)) {
                    student.setWeixin(weinOpenId);
                    student.setUpdateTime(new Date());
                    this.orgStudentsDao.update(student, "name", "weixin", "updateTime");
                }
            }
        } else {
            throw new BussinessException(CommonErrorCode.NOT_FOUND, "绑定失败，您所填写的手机号不是学员手机号");
        }
        return result;
    }

    private StudentInfoDto getResult(OrgStudent student) {
        StudentInfoDto result = new StudentInfoDto();
        org.springframework.beans.BeanUtils.copyProperties(student, result);
        result.setStudentId(student.getId());

        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public StudentInfoDto getOrgStudentByMobile(Long orgId, String mobile) {
        OrgStudent student = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile);
        StudentInfoDto result = null;
        if (student != null) {
            result = new StudentInfoDto();
            org.springframework.beans.BeanUtils.copyProperties(student, result);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<StudentInfoDto> getAndUpdateOrgStudentByOpenId(Long orgId, String weixinOpenId) {
        List<OrgStudent> students = this.orgStudentsDao.getStudentByOpenIdAndOrgId(orgId, weixinOpenId);

        List<StudentInfoDto> result = Lists.newArrayList();
        if (students != null && !students.isEmpty()) {
            StudentInfoDto item = null;
            for (OrgStudent student : students) {
                item = new StudentInfoDto();
                org.springframework.beans.BeanUtils.copyProperties(student, item);
                item.setStudentId(student.getId());
                item.setClassName(this.getClassName(orgId, student.getUserId()));

                result.add(item);
                // 将openId与student绑定
                if (!weixinOpenId.equals(student.getWeixin())) {
                    student.setWeixin(weixinOpenId);
                    student.setUpdateTime(new Date());
                    orgStudentsDao.update(student, "weixin", "updateTime");
                }
            }

        }
        return result;
    }

    /**
     * 获取学生所在班级名称
     *
     * @param orgId
     * @param studentId
     * @return
     */
    private String getClassName(Long orgId, Long studentId) {
        List<OrgStudentCourse> courses = orgStudentCourseDao.getOrgCourseIds(orgId, studentId, 0, null);

        String name = "";

        if (courses != null && !courses.isEmpty()) {
            Collection<Long> courseIds = Lists.newArrayList();
            for (OrgStudentCourse course : courses) {
                courseIds.add(course.getCourseId());
            }
            List<OrgCourse> courseList = this.orgCourseDao.getByIds(courseIds, "id", "name");

            if (CollectionUtils.isNotEmpty(courseList)) {
                List<String> courseNameList = Lists.newArrayList();
                for (OrgCourse orgCourse : courseList) {
                    courseNameList.add(orgCourse.getName());
                }
                if (courseNameList.size() > 0) {
                    name = StringUtils.join(courseNameList, ",");
                }
            }
        }
        return StringUtils.isNotBlank(name) ? name : "未报班";
    }

    @Override
    @Transactional(readOnly = true)
    public StudentInfoDto getBasicStudentInfo(Long studentId, Long orgId, boolean hideMobile) {
        Preconditions.checkArgument(studentId != null, "studentId is null");
        OrgStudent orgStudent = this.orgStudentsDao.getById(studentId);
        if (orgStudent == null || orgStudent.getOrgId().longValue() != orgId.longValue()) {
            throw new BussinessException(StudentErrorCode.STUDENT_NOT_EXIST);
        }
        StudentInfoDto dto = new StudentInfoDto();
        // 获取头像，先获取学员上传头像，然后微信头像，然后机构头像，最后学员默认头像
        dto.setAvatarUrl(getAvtarUrl(orgStudent));
        dto.setStudentId(studentId);
        if (StringUtils.isBlank(orgStudent.getName())) {
            if (StringUtils.isBlank(orgStudent.getNickName())) {
                dto.setName(MaskUtil.maskMobile(orgStudent.getMobile()));
            } else {
                dto.setName(orgStudent.getNickName());
            }
        } else {
            dto.setName(orgStudent.getName());
        }
        if (hideMobile) {// 隐藏手机号
            if (StringUtils.isNotBlank(orgStudent.getShowMobile())) {
                if (orgStudent.getShowMobile().contains("*")) {
                    dto.setMobile(orgStudent.getShowMobile());
                } else {
                    dto.setMobile(MaskUtil.maskMobile(orgStudent.getMobile()));
                }
            } else {
                dto.setMobile(MaskUtil.maskMobile(orgStudent.getMobile()));
            }
        } else {
            if (StringUtils.isNotBlank(orgStudent.getShowMobile())) {
                if (orgStudent.getShowMobile().contains("*")) {
                    dto.setMobile(orgStudent.getMobile());
                } else {
                    dto.setMobile(orgStudent.getShowMobile());
                }
            } else {
                dto.setMobile(orgStudent.getMobile());
            }
        }
        if (!txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId())) {
            dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
            dto.setParentMobile(MaskUtil.maskMobile(dto.getParentMobile()));
        }
        return dto;
    }

    // 获取学员自己上传头像
    private String getAvtarUrl(OrgStudent orgStudent) {
        String avatarUrl = null;
        Long avatarId = orgStudent.getAvatar();
        String openId = orgStudent.getWeixin();
        // 优先获取学生自己上传头像
        if (avatarId != null && avatarId > 0) {
            OrgStorage orgStorage = this.orgStorageDao.getById(avatarId);
            if (orgStorage != null) {
                avatarUrl = StorageUtil.constructUrl(orgStorage.getFid(), orgStorage.getSn(), orgStorage.getMimeType());
            }
        }
        // 其次获取学生微信头像
        if (StringUtils.isBlank(avatarUrl) && StringUtils.isNotBlank(openId)) {
            Fans fans = this.fansDao.getByOpenId(openId);
            if (fans != null) {
                avatarUrl = fans.getHeadImgUrl();
            }
        }

        // 获取学生默认头像
        if (StringUtils.isBlank(avatarUrl)) {
            Student student = this.studentDao.getByUserId(orgStudent.getUserId());
            if (student != null) {
                Integer stuAvatarId = student.getAvatar();
                if (stuAvatarId != null && stuAvatarId > 0) {
                    Storage storage = this.storageDao.getStorageById(stuAvatarId.longValue());
                    if (storage != null) {
                        avatarUrl = StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn());
                    }
                }
            }
        }
        // 获取默认头像
        if (StringUtils.isBlank(avatarUrl)) {
            avatarUrl = AvatarConstants.CONSULT_AVATAR_URL;
        }
        return avatarUrl;
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        List<OrgStudent> students = this.orgStudentsDao.searchHasMobileConsulter(pageDto, format, value);
        log.debug("students:{}", students);
        return students;
    }

    @Override
    @Transactional(readOnly = true)
    public Map<Long, StudentInfoReponseDto> getUserIdStudentDtoMap(Collection<Long> userIds, Long orgId) {
        Map<Long, OrgStudent> studentMap = this.orgStudentsDao.getStudentMap(userIds, orgId);
        log.debug("studentMap={}", studentMap);
        Map<Long, Integer> storageMap = studentDao.getAvatarsMap(studentMap.keySet());
        Set<Long> aratarIds = Sets.newHashSet();
        for (Integer avatar : storageMap.values()) {
            aratarIds.add(avatar.longValue());
        }
        Map<Long, Storage> avatarMap = this.storageDao.getStorageMapByIds(aratarIds);
        Map<Long, StudentInfoReponseDto> response = Maps.newHashMap();
        for (Long userId : studentMap.keySet()) {
            StudentInfoReponseDto dto = new StudentInfoReponseDto();
            OrgStudent student = studentMap.get(userId);
            if (student != null) {
                dto.setStudentId(student.getId());
                dto.setMobile(getMobile(student, false));
                dto.setName(getName(student));
                Integer avatar = storageMap.get(userId);
                if (avatar != null) {
                    Storage storage = avatarMap.get(avatar.longValue());
                    if (storage != null) {
                        dto.setAvatarUrl(
                            StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
                    }
                }

            }
            response.put(userId, dto);
        }
        return response;
    }

    @DataAuthority(resourceTypes = { RequestSourceDesc.STUDENT_LIST })
    @Override
    public List<StudentStatusStatistics> getStudentStatusStatisticsByOrgId(Long orgId) {
        boolean needDataAuthority = false;
        Integer cascadeId = null;
        List<Long> studentIds = null;
        boolean canAccess = RequestSourceDesc.STUDENT_LIST.canAccess("getStudentStatusStatisticsByOrgId",
            this.getClass(), new Class<?>[] { Long.class });
        if (!canAccess) {
            AccountRoleType accountRoleType = RequestSourceDesc.STUDENT_LIST.getAccountRoleType();
            log.info(" can not access in getStudentStatusStatisticsByOrgId and accountRoleType is : {} ",
                accountRoleType);
            cascadeId = accountRoleType.getCascadeId();
            List<Long> courseIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, null, null);
            studentIds = orgStudentCourseDao.getStudentIdsByCourseIds(orgId, courseIds);
            needDataAuthority = true;
        }
        List<StudentStatusStatistics> statisticses = null;
        try {
            statisticses = solrStudentQuery.queryCountByStatus(orgId, needDataAuthority, studentIds, cascadeId);
            return statisticses;
        } catch (Exception e) {
            // 如果solr出错从数据库查询
            log.error("[Solr] query exception.", e);
            statisticses = StudentStatusStatistics.getDefaut();
            Map<Integer, Integer> ret =
                orgStudentsDao.getStatisticsByLessonStatus(orgId.intValue(), needDataAuthority, studentIds, cascadeId);
            for (StudentStatusStatistics stat : statisticses) {
                List<Integer> status = StudentLessonStatus.findSubStatus(stat.getStatus());
                log.info("status :{} and statusList are :{} ", status);
                stat.setNumberFromMap(ret, status);
            }
            log.info("Success==={}", statisticses);
            return statisticses;
        }
    }

    /**
     * 获取学生名
     *
     * @param student
     * @return
     */
    private String getName(OrgStudent student) {
        if (StringUtils.isNoneBlank(student.getName())) {
            return student.getName();
        } else if (StringUtils.isNoneBlank(student.getNickName())) {
            return student.getNickName();
        } else {
            return MaskUtil.maskMobile(student.getMobile());
        }
    }

    /**
     * 获取学生手机号
     *
     * @param student
     * @return
     */
    private String getMobile(OrgStudent student, boolean mask) {
        if (StringUtils.isNoneBlank(student.getShowMobile()) && student.getShowMobile().contains("*")) {
            return mask ? MaskUtil.maskMobile(student.getMobile()) : student.getMobile();
        } else {
            return mask ? MaskUtil.maskMobile(student.getShowMobile()) : student.getShowMobile();
        }
    }

    /**
     * 添加系统待办事项(正式学员)
     *
     * @param orgId 机构id
     * @param student 正式学员
     * @param consultUserId 咨询学员id
     * @return
     */
    private void addSysBacklog(Long orgId, OrgStudent student, Long consultUserId) {
        log.info("addSysBacklog---------orgId={}, student={}，consultUserId={}", orgId, student, consultUserId);
        List<TxBacklog> list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, false, "id");
        if (CollectionUtils.isNotEmpty(list)) {
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "已存在未过期的正式学员系统待办事项");
        }
        if (student.getNextRemindTime() != null && student.getNextRemindTime().getTime() > 0) {
            TxBacklog txBacklog = new TxBacklog();
            txBacklog.setOrgId(orgId);
            txBacklog.setStudentId(student.getId());
            if (null != consultUserId && consultUserId > 0) {
                txBacklog.setConsultUserId(consultUserId);
            }
            txBacklog.setContent("跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
            txBacklog.setCreateTime(new Date());
            txBacklog.setUpdateTime(new Date());
            txBacklog.setIsSys(BizConf.TRUE.intValue());
            txBacklog.setCascadeId(student.getAddCascadeId());
            txBacklog.setEndTime(student.getNextRemindTime());
            txBacklog.setRemindTime(student.getNextRemindTime());
            this.txBacklogDao.save(txBacklog, false);
            
            TxbacklogParticipant txbacklogParticipan = new TxbacklogParticipant(txBacklog.getId(), orgId, TianxiaoMContext.getTXCascadeIdLongZeroFill());
            txBacklogParticipantDao.save(txbacklogParticipan);
            log.info("addSysBacklog--------txBacklog={}", txBacklog);
        }
    }

    /**
     * 更新系统待办事项: 编辑咨询学员时勾选转正式学员; 新增咨询学员时勾选转正式学员; 编辑正式学员
     *
     * @param orgId 机构id
     * @param consulterId 咨询学员id
     * @return
     */
    @Override
    public void updateSysBacklog(Long orgId, OrgStudent student, Long consulterId) {
        log.info("updateSysBacklog-------orgId={},student={},consulterId={}", orgId, student, consulterId);
        List<TxBacklog> list = null;
        if (null != consulterId && consulterId > 0) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterId, orgId, false);
            if (CollectionUtils.isNotEmpty(list)) {
                // 编辑咨询学员勾选转正式学员
                TxBacklog txBacklog = list.get(0);
                if (student.getNextRemindTime() == null) {
                    // 删除今日代办
                    txBacklogDao.delById(txBacklog.getId());
                } else {
                    txBacklog.setStudentId(student.getId());
                    txBacklog.setContent(
                        "跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update(txBacklog, false);
                }

            } else {
                // 新增咨询学员时勾选转正式学员;系统待办事项已过期/已删除
                if (student.getNextRemindTime() != null) {
                    this.addSysBacklog(orgId, student, consulterId);
                }
            }
        } else {
            // 编辑正式学员
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, false);
            if (CollectionUtils.isNotEmpty(list)) {
                TxBacklog txBacklog = list.get(0);
                log.info("[TxBackLogList] txBacklog param:{}, student nextRemindTime param:{}", txBacklog,
                    student.getNextRemindTime());
                if (student.getNextRemindTime() == null) {
                    // 删除今日代办
                    txBacklogDao.delById(txBacklog.getId());
                } else if (txBacklog.getEndTime().getTime() != student.getNextRemindTime().getTime()) {
                    // 正式学员下次跟进时间改变
                    txBacklog.setContent(
                        "跟进客户: " + (StringUtils.isNotBlank(student.getName()) ? student.getName() : "匿名学生"));
                    txBacklog.setEndTime(student.getNextRemindTime());
                    txBacklog.setRemindTime(student.getNextRemindTime());
                    txBacklog.setUpdateTime(new Date());
                    this.txBacklogDao.update(txBacklog, false);
                }
            } else {
                if (student.getNextRemindTime() != null) {
                    // 系统待办事项已过期需要新建，若同时还是咨询学员，则在此处添加consulterId
                    List<TxConsultUser> consultUserList =
                        this.txConsultUserDao.lookByStudentId(orgId, student.getId(), "id");
                    if (CollectionUtils.isNotEmpty(consultUserList)) {
                        consulterId = consultUserList.get(0).getId();
                    }
                    this.addSysBacklog(orgId, student, consulterId);
                }
            }
        }
    }

    /**
     * 更新线索的今日代办数据
     */
    @Override
    public void updateSysBacklogForConsulter(Long orgId, TxConsultUser consultUser) {
        TxBacklog txBacklog = null;
        List<TxBacklog> backlogByConsulterIdAndOrgId =
            this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consultUser.getId(), orgId, false);
        log.info("[TxBackLogList] txBacklog param:{}, consultUser nextRemindTime param:{}",
            backlogByConsulterIdAndOrgId, consultUser.getNextRemindTime());
        if (GenericsUtils.notNullAndEmpty(backlogByConsulterIdAndOrgId)) {
            txBacklog = backlogByConsulterIdAndOrgId.get(0);
            if (consultUser.getNextRemindTime() == null) {
                txBacklogDao.delById(txBacklog.getId());
            } else if (txBacklog.getEndTime().getTime() != consultUser.getNextRemindTime().getTime()) {
                // 更新跟进记录
                addOrUpdateSysBackForConsult(consultUser, txBacklog);
            }

        } else {
            log.info("not have record ");
            if (consultUser.getNextRemindTime() != null) {
                txBacklog = new TxBacklog();
                addOrUpdateSysBackForConsult(consultUser, txBacklog);
            }
        }
    }

    public void addOrUpdateSysBackForConsult(TxConsultUser consultUser, TxBacklog txBacklog) {
    	boolean isSave = false;
    	if(txBacklog.getId()==null){
    		isSave = true;
    	}
        txBacklog.setConsultUserId(consultUser.getId());
        txBacklog.setContent("跟进线索: " + (StringUtils.isNotBlank(consultUser.getName()) ? consultUser.getName() : "匿名线索"));
        txBacklog.setEndTime(consultUser.getNextRemindTime());
        txBacklog.setIsSys(BizConf.TRUE.intValue());
        txBacklog.setCascadeId(consultUser.getCascadeId() == null ? 0 : consultUser.getCascadeId().intValue());
        txBacklog.setOrgId(consultUser.getOrgId());
        txBacklog.setEndTime(consultUser.getNextRemindTime());
        if (txBacklog.getId() == null) {
            txBacklog.setCreateTime(new Date());
        }
        txBacklog.setRemindTime(consultUser.getNextRemindTime());
        txBacklog.setUpdateTime(new Date());
        this.txBacklogDao.saveOrUpdate(txBacklog);
        
        if(isSave){
        	TxbacklogParticipant txbacklogParticipan = new TxbacklogParticipant(txBacklog.getId(), consultUser.getOrgId(), TianxiaoMContext.getTXCascadeIdLongZeroFill());
        	txBacklogParticipantDao.save(txbacklogParticipan);
        }
        
        log.info("add backlog : {} ", txBacklog);

    }

    /**
     * 删除系统待办事项: 若同时还是咨询学员，则重置studentId为0; 若仅是正式学员，则直接删除
     *
     * @param orgId 机构id
     * @return
     */
    private void delSysBacklog(Long orgId, OrgStudent student, TxConsultUser consulterUser) {
        log.info("delSysBacklog-------orgId={},student={},consulterUser={}", orgId, student, consulterUser);
        List<TxBacklog> list = null;
        if (null != consulterUser) {
            list = this.txBacklogDao.getBacklogByConsulterIdAndOrgId(consulterUser.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog && txBacklog.getStudentId().longValue() == student.getId().longValue()) {
                        txBacklog.setStudentId(0l);
                        if (!txBacklog.getEndTime().before(new Date())) {
                            // 未过期系统待办事项才作同步
                            txBacklog.setContent("跟进客户: "
                                + (StringUtils.isNotBlank(consulterUser.getName()) ? consulterUser.getName() : "匿名学生"));
                            txBacklog.setEndTime(consulterUser.getNextRemindTime());
                            txBacklog.setRemindTime(consulterUser.getNextRemindTime());
                        }
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        } else {
            list = this.txBacklogDao.getBacklogByStudentIdAndOrgId(student.getId(), orgId, null);
            if (CollectionUtils.isNotEmpty(list)) {
                for (TxBacklog txBacklog : list) {
                    if (null != txBacklog) {
                        txBacklog.setStudentId(0l);
                        txBacklog.setDelStatus(BizConf.TRUE.intValue());
                        txBacklog.setUpdateTime(new Date());
                        this.txBacklogDao.update(txBacklog, false);
                    }
                }
            }
        }
    }

    @Override
    public List<StudentInfoDto> listOrgStudentByMobile(Long orgId, String mobile) {
        List<OrgStudent> students = this.orgStudentsDao.getStudentByMobileAndOrgId(orgId, mobile, 9999);
        List<StudentInfoDto> result = new ArrayList<StudentInfoDto>();
        if (students != null) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                org.springframework.beans.BeanUtils.copyProperties(stu, dto);
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.add(dto);

            }
        }
        return result;
    }

    @Override
    public void updateStudentNextRemindTime(Integer orgId, Long studentId, Long nextRemindTime) {
        if (nextRemindTime != null) {
            if (nextRemindTime > TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime().getTime()) {
                throw new ParameterException(CommonErrorCode.PARAM_ERROR, "下次提醒时间超过最大范围(2037-1-1)了");
            }
        }
        OrgStudent student = this.orgStudentsDao.getById(studentId);
        if (student == null || student.getOrgId().intValue() != orgId.intValue()) {
            throw new PermissionException();
        }
        if (nextRemindTime != null && nextRemindTime > 0) {
            student.setNextRemindTime(new Date(nextRemindTime));
        } else {
            student.setNextRemindTime(null);
        }
        // 更新下次跟进时间
        this.orgStudentsDao.updateWithDefaultVal(student, "nextRemindTime");
        this.updateSysBacklog(orgId.longValue(), student, null);
    }

    @Override
    public List<Long> getStudentidsByCourseIds(Long orgId, List<Long> courseIds) {
        return orgStudentCourseDao.getStudentIdsByCourseIds(orgId.longValue(), courseIds);
    }

    @Override
    public List<StudentInfoDto> listOrgStudentByMobiles(Long orgId, List<String> mobile) {
        List<OrgStudent> students = this.orgStudentsDao.getOrgStudents(orgId, mobile);
        List<StudentInfoDto> result = new ArrayList<StudentInfoDto>();
        if (students != null) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                org.springframework.beans.BeanUtils.copyProperties(stu, dto);
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.add(dto);

            }
        }
        return result;
    }

    @Override
    public void updateSolr(Long id) {
        OrgStudent stu = orgStudentsDao.getById(id);
        updateSolr(stu);
    }

    void updateSolr(OrgStudent orgStudent) {
        if (orgStudent == null) {
            return;
        }
        try {
            crmStudentQuery.updateOldRow(orgStudent.toSolrMap());
            log.info("solr - student - update - end - orgStudent:{}", orgStudent);
        } catch (Exception e) {
            log.error("solr - student - update - exception", e);
        }
    }

    @Override
    public ArrayListMultimap<String, StudentInfoDto> getStudentMap(Long orgId, List<String> mobiles) {
        List<OrgStudent> students = this.orgStudentsDao.getOrgStudents(orgId, mobiles);
        ArrayListMultimap<String, StudentInfoDto> result = ArrayListMultimap.create();
        if (CollectionUtils.isNotEmpty(students)) {
            for (OrgStudent stu : students) {
                StudentInfoDto dto = new StudentInfoDto();
                org.springframework.beans.BeanUtils.copyProperties(stu, dto);
                dto.setStudentId(stu.getUserId());
                dto.setName(stu.getName());
                result.put(dto.getMobile(), dto);

            }
        }
        return result;
    }

    @Override
    public boolean passTo(long orgId, long studentId, Integer cascadeId,Integer loginId) {
        cascadeId = cascadeId == null ? 0 : cascadeId;
        loginId = loginId == null ? 0 : loginId;
        OrgStudent student = orgStudentsDao.getById(studentId);
        if (student == null || !student.getOrgId().equals(orgId)
            || student.getDelStatus() != DeleteStatus.NORMAL.getValue()) {
            throw new ParameterException("学员不存在或已被删除");
        }

        AccountRoleType roleType = txAccountHelpService.findAccountRoleType(orgId, loginId);
        if(roleType.needDataAuthority() && !loginId.equals(student.getAddCascadeId())){//员工，非课程顾问不能转
            throw new ParameterException("您没有该操作的权限");
        }

        try {
            int origin = student.getAddCascadeId();
            student.setAddCascadeId(cascadeId);
            log.info("Org={} Pass student={} from cascadeId={} to cascadeId={}", orgId, studentId,
                student.getAddCascadeId(), cascadeId);
            // 生成咨询用户
            TxConsultUser consultUser = apiService.getConsultUserByStudent(student);
            if (consultUser == null) {
                consultUser = new TxConsultUser();
                consultUser.setStudentId(studentId);
                consultUser.setOrgId(orgId);
                consultUser.setWeixinOpenId(student.getWeixin());
                consultUser.setMobile(student.getMobile());
                consultUser.setCascadeId((long) cascadeId);
                apiService.saveConsultUser(consultUser);
            }else {
                consultUser.setCascadeId((long) cascadeId);
                apiService.updateConsultUser(consultUser,false);
            }
            orgStudentsDao.update(student);
            // 添加跟进记录
            commentAPIService.saveByStudentPassTo(student, accountApiService.getAccountName(orgId, (long) loginId),
                accountApiService.getAccountName(orgId, (long) cascadeId));

            // 发送通知
            log.info("[Notice] Pass student notice,orgId={},studentId={}", orgId, studentId);
            Map<String, Object> param = new HashMap<>();
            param.put("student_id", studentId);
            consultMessageService.sendNotice(orgId, cascadeId,
                NoticeMsgContent.createNoticeContent(NoticeType.RECEIVE_STUDENT,
                    ActionUtil.getAction(ActionUtil.ACTION_TO_CRM_STUDENT_DETAIL, param)));
        } catch (Exception e) {
            log.info("can not send notify to user:{} ", cascadeId);
            log.error("error : {} ", e);
            return false;
        }
        return true;
    }
}
