
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;

import org.springframework.stereotype.Component;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Data
@EqualsAndHashCode(callSuper=false)
@Component
public class PictureFieldType extends AbstractCustomFieldType<PictureFieldType> {
    
    
    private String url ; //"http://img.genshuixue.com/2/abc.jpg",
    private Double width ; //:100,
    private Double height ; // :100,
    private Long storageId ; //:100;

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#objToJson(java.lang.Object)
     */

    @Override
    public String objToJson(PictureFieldType obj) {
        return super.toJson(obj);

    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#jsonToObj(java.lang.String)
     */

    @Override
    public PictureFieldType jsonToObj(String json) {
        return super.fromJson(json);

    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#matchFieldType()
     */

    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.PICTURE;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<PictureFieldType> instance() {
        return new PictureFieldType();
    }

}
