/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.dto.customFields;

import com.baijia.tianxiao.dal.roster.constant.AddType;
import com.baijia.tianxiao.dal.roster.po.CustomField;
import com.baijia.tianxiao.sal.student.dto.customChoiceField.OptionDto;

import org.springframework.beans.BeanUtils;

import java.util.List;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年7月22日
* @desc 
 */
@Data
public class CustomFieldResponse extends CustomFieldBase{
    List<OptionDto> optionList;
    
    public static CustomFieldResponse getInstance(FieldRequest request, List<OptionDto> optionList){
        CustomFieldResponse response = new CustomFieldResponse();
        BeanUtils.copyProperties(request, response, "optionList");
        response.setOptionList(optionList);
        return response;
    }
    
    public static CustomFieldResponse getInstanceByCustomField(CustomField customField, List<OptionDto> optionList){
        CustomFieldResponse response = new CustomFieldResponse();
        BeanUtils.copyProperties(customField, response, "optionList");
        response.setOptionList(optionList);
        if(customField.getSystemFieldNum()== -1){
            response.setIsSystem(AddType.NOT_SYSTEM.getCode());
        }else{
            response.setIsSystem(AddType.SYSTEM.getCode());
        }
        return response;
    }
    
    
}
