package com.baijia.tianxiao.sal.student.util;

import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.sal.student.dto.customFields.FieldOption;
import com.baijia.tianxiao.sal.student.enums.SexEnum;
import com.baijia.tianxiao.sal.student.enums.SystemFields;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by liuxp on 16/7/27.
 */
public class SystemFieldOptionFactory {
    public static List<FieldOption> getOptions(SystemFields fields){
        List<FieldOption> ret = new ArrayList<>();
        switch (fields){
            case SEX:
                SexEnum[] enums = SexEnum.values();
                for (SexEnum sexEnum:enums){
                    ret.add(new FieldOption((long)sexEnum.getId(),sexEnum.getLabel()));
                }
                break;
            case RELATIONSHIP:
                Relatives[] relatives = Relatives.values();
                for (Relatives relation:relatives){
                    ret.add(new FieldOption((long)relation.getValue(), relation.getLabel()));
                }
                break;
            default:
                return ret;
        }
        return ret;
    }
}
