package com.baijia.tianxiao.sal.student.pc;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.baijia.tianxiao.dto.query.CommonSearchRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentInfoResponseDto;
import com.baijia.tianxiao.sal.student.dto.response.pc.StudentListResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import javax.servlet.http.HttpServletResponse;

/**
 * @author wangsixia
 * @version 1.0
 * @title StudentUserService
 * @desc 学员档案
 * @date 2016年3月17日
 */
public interface StudentUserService {

    /**
     * 获取学员档案情(不包含标签和跟进记录)
     *
     * @param orgId     机构id
     * @param studentId 学员档案id
     * @return
     */
    public StudentInfoResponseDto getBaseInfo(Long orgId, Long studentId) throws Exception;

    /**
     * 新增学员档案
     *
     * @param orgId       机构id
     * @param studentInfo 学员档案信息
     * @return
     */
    public Long addStudentInfo(Long orgId,Integer cascadeId,StudentListResponseDto studentInfo) throws Exception;

    /**
     * 新增学员档案
     *
     * @param
     * @param orgId       机构id
     * @param studentInfo 学员档案信息
     * @return
     */
    public Long addStudentInfo(Long orgId, Integer cascadeId,StudentListResponseDto studentInfo, boolean updateRepeat) throws Exception;

    /**
     * 编辑学员档案
     *
     * @param orgId       机构id
     * @param studentInfo 学员档案信息
     * @return
     */
    public void editStudentInfo(Long orgId, StudentListResponseDto studentInfo) throws Exception;

    /**
     * 批量删除学员档案
     *
     * @param orgId      机构id
     * @param studentIds 学员档案id集合
     * @return
     */
    public void BatchDelStudent(Long orgId, Set<Long> studentIds);

    /**
     * pc学员档案查询、分页、排序,已弃用
     *
     * @param orgId
     * @param request
     * @return
     */
    @Deprecated
    public List<StudentListResponseDto> searchStudentByCustomParams(long orgId,Integer cascadeId,CommonSearchRequestDto request, PageDto pageDto) throws Exception;

    /**
     * pc学员档案查询、分页、排序(新增自定义字段和标签、来源、课程顾问)
     * @param orgId
     * @param cascadeId
     * @param request
     * @param pageDto
     * @return
     */
    public Map<String, Object> getPcStudentList (Long orgId,Integer cascadeId,CommonSearchRequestDto request, PageDto pageDto);

    /**
     * 添加系统待办事项(正式学员)
     *
     * @param orgId         机构id
     * @param studentId     正式学员id
     * @param consultUserId 线索id
     */
    public void addSysBacklog(Long orgId, Long studentId, Long consultUserId);

    /**
     * 更新系统待办事项(正式学员)
     *
     * @param orgId     机构id
     * @param studentId 正式学员id
     */
    public void updateSysBacklog(Long orgId, Long studentId);

}
