/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.enums;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentErrorCode
 * @desc TODO
 * @date 2015年12月5日
 */

public enum StudentErrorCode implements UniverseErrorCode {

    UNKNOW(1, "未知类型错误"),

    STUDENT_REGISTER_FAILD(1001, "注册失败"),

    MOBILE_REGISTERED(1002, "该手机号已经被注册为机构学员"),

    STUDENT_NOT_EXIST(1003, "学员不存在或者已经被删除"),

    CONSULT_USER_NOT_EXIST(1004, "联系人不存在或者已经被删除"),

    COMMENT_NOT_EXIST(1005, "备注不存在或者已经被删除"),

    TAG_NOT_EXIST(1006, "标签不存在或者已经被删除"),

    ORG_NOT_EXIST(1007, "机构不存在或者已经被删除"),

    MOBILE_WRONG(1008, "手机号格式错误"),

    MAX_TAGS(1009, "标签数最多为30个"),

    TAGS_REPEAT(1010, "标签重复"),

    SYSTEM_COMMENT(1011, "系统纪录，不可编辑或者删除"),

    MAX_TAG_CONTENT_LENGTH(1012, "每个标签最多输入15个字"),

    STUDENT_NOT_BELONG(1013, "抱歉,学员详情仅班主任可查看"),
    
    MAX_CUSTOM_FIELD_NUMBER(1014, "最多可定义20个字段"),
    
    MAX_LABEL_LENGTH(1015, "字段名称不超过15个字"),
    
    MIN_CHOICE_NUMBER(1016, "需至少设置一个选项"),
    
    MAX_CHOICE_NUMBER(1017, "最多可设置8个选项"),
    
    LABEL_NULL(1018, "请填写字段名称"),
    
    LABEL_REPEAT(1019, "该字段已经存在"),
    
    CHOICE_REPEAT(1020, "选项已经存在，无法保存"),
    
    CHOICE_NOT_DELETE(1021, "选项已被使用，无法删除，您可选择停用"),
    
    MAX_CHOICE_LABEL_LENGTH(1022, "选项名称不超过10个字"),
    
    CUSTOM_FIELD_NOT_EXIST(1023, "该字段不存在或者已经被删除"),
    
    CUSTOM_FIELD_NOT_DELETE(1024, "该字段已经被使用，无法删除，您可以选择停用"),
    
    CUSTOM_FIELD_TYPE_CHANGE(1025, "字段已经存在，类型无法更改"),
    
    CHOICE_LABEL_NULL(1026, "请填写选项名称"),
    
    SYSTEM_FIELD(1027, "该字段是系统预设字段，无法更改活删除"),
    
    REQUIRE_VALUE(1028, "该字段是必填项"),
    
    TOO_LONG_MAIL(1029, "邮箱地址过长");
    
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;

    private StudentErrorCode(int code, String msg) {
        this.errorSide = ErrorSide.SERVER;
        this.subsystem = Subsystem.STUDENT;
        this.platform = Platform.PC;
        this.code = code;
        this.message = msg;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /*
     * (non-Javadoc)
     * 
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode() {
        return code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public StudentErrorCode fromCode(int code) {
        for (StudentErrorCode errorCode : values()) {
            if (errorCode.getSubsystemErrorCode() == code) {
                return errorCode;
            }
        }
        return StudentErrorCode.UNKNOW;
    }

}
