/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.enums;

import com.beust.jcommander.internal.Lists;
import com.google.common.collect.Maps;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author gaodan
 * @createdate 2016年8月4日
 * @desc 线索四个系统字段
 */
public enum SpecialFieldEnum {

    // 线索特殊字段
    CONSULT_STATUS("consultStatus", 0, "跟进状态", CustomFieldSections.BASE_INFO.getId()), 
    CONSULT_SOURCE("consultSource",
        0, "来源", CustomFieldSections.BASE_INFO.getId()), 
    INTENSION_LEVEL("intensionLevel", 0, "意向级别",
            CustomFieldSections.BASE_INFO.getId()), 
    CASCADE_ID("cascadeId", 0, "课程顾问",
                CustomFieldSections.BASE_INFO.getId()),
    // 学员特殊字段
    STU_ADD_CASCADE_ID("addCascadeId", 1, "课程顾问", CustomFieldSections.BASE_INFO.getId()),
    STU_SOURCE("source", 1, "来源",
        CustomFieldSections.BASE_INFO.getId());

    private SpecialFieldEnum(String key, int type, String label, Integer sectionId) {
        this.key = key; 
        this.type = type;
        this.label = label;
        this.sectionId = sectionId;
    }

    private String key; //对应于某些DB字段,对dto中的字段
    private int type; // 0:线索 1:学员
    private String label;
    public Integer sectionId;

    public int getType() {
        return this.type;
    }

    public String getKey() {
        return key;
    }

    public String getLabel() {
        return label;
    }

    public Integer getSectionId() {
        return sectionId;
    }

    private static Map<String, SpecialFieldEnum> map = Maps.newHashMap();

    static {
        for (SpecialFieldEnum p : values()) {
            map.put(p.getKey(), p);
        }
    }

    /**
     * 根据特殊字段的类型来获取特殊属性
     * 
     * @param type 0:线索 1:学员
     * @return
     */
    public static List<SpecialFieldEnum> listSpecialFieldEnum(int type) {
        List<SpecialFieldEnum> retEnums = Lists.newArrayList();
        for (SpecialFieldEnum sf : SpecialFieldEnum.values()) {
            retEnums.add(sf);
        }
        return retEnums;
    }

    public static SpecialFieldEnum getSpecialFieldEnum(String key) {
        SpecialFieldEnum consultFieldEnum = map.get(key);
        return consultFieldEnum;
    }

    public static List<String> getLabels() {
        List<String> labels = new ArrayList<>();
        for (SpecialFieldEnum p : values()) {
            labels.add(p.getKey());
        }
        return labels;
    }

}
