
/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.student.dto.response.pc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import com.baijia.tianxiao.annotation.Option;
import com.baijia.tianxiao.constant.Relatives;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.roster.po.TxStudentTag;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.enums.PropertiesType;
import com.baijia.tianxiao.enums.QueryPolicy;

import lombok.Data;

/**
 * 学员档案response
 *
 * @author zhangbing
 * @version 1.0
 * @title StudentListResponseDto
 * @desc TODO
 * @date 2016年3月15日
 */
@Data
public class StudentListResponseDto {

    @Option(hidden = true, name = "id", showName = "id", defaultProp = true, type = PropertiesType.DIGITAL)
    private Long id;

    @Option(lock = true, name = "name", showName = "姓名", defaultProp = true, type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String name;

    //学员手机号码
    @Option(lock = true, name = "mobile", showName = "手机号", defaultProp = true, type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String mobile;

    //性别
    @Option(hidden = true, name = "gender", showName = "性别", type = PropertiesType.DIGITAL)
    private Long gender;

    //性别
    @Option(name = "genderStr", showName = "性别", defaultProp = true, type = PropertiesType.STRING, queryProp = "gender")
    private String genderStr;

    //家长姓名
    @Option(name = "parentName", showName = "家长姓名", type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String parentName;

    //家长手机
    @Option(name = "parentMobile", showName = "家长手机号", type = PropertiesType.STRING, policy = QueryPolicy.LIKE)
    private String parentMobile;

    @Option(hidden = true, name = "nextRemindTime", showName = "下次跟进时间", type = PropertiesType.DIGITAL)
    private Long nextRemindTime;

    @Option(name = "nextRemindTimeStr", showName = "下次跟进时间", defaultProp = true, type = PropertiesType.DATETIME, queryProp = "nextRemindTime")
    private Date nextRemindTimeStr;


    @Option(hidden = true, name = "createTime", showName = "添加时间", type = PropertiesType.DATE)
    private Long createTime;

    //学校
    @Option(name = "school", showName = "公立学校", type = PropertiesType.STRING)
    private String school;

    //生日
    @Option(hidden = true, name = "birthday", showName = "生日", type = PropertiesType.DIGITAL)
    private Long birthday;

    @Option(name = "birthdayStr", showName = "生日", type = PropertiesType.DATE)
    private Date birthdayStr;
    
    @Option(hidden = true,name = "birthdayString", showName = "生日", type = PropertiesType.STRING)
    private String birthdayString;

    //班级
    @Option(name = "degreeClass", showName = "年级", type = PropertiesType.STRING)
    private String degreeClass;

    //班主任
    @Option(name = "cascadeIdStr", showName = "班主任", defaultProp = true, type = PropertiesType.STRING, queryProp = "createTime")
    private String cascadeIdStr;

    //是否排课
    @Option(name = "hasLesson", showName = "是否排课", defaultProp = true, type = PropertiesType.STRING, queryProp = "createTime")
    private String hasLesson;

    //已上课次
    @Option(name = "lessonNum", showName = "已上课次/总课次", defaultProp = true, type = PropertiesType.STRING, queryProp = "createTime")
    private String lessonNum;

    //亲属关系
    @Option(name = "relationshipStr", showName = "亲属关系", type = PropertiesType.STRING, queryProp = "relationship")
    private String relationshipStr;

    //亲属关系
    @Option(hidden = true, name = "relationship", showName = "亲属关系", type = PropertiesType.DIGITAL)
    private Integer relationship;

    //居住地址
    @Option(name = "address", showName = "详细地址", type = PropertiesType.STRING)
    private String address;

    //父亲职业
    @Option(hidden = true, name = "fatherOccupation", showName = "父亲职业", type = PropertiesType.STRING)
    private String fatherOccupation;

    //母亲职业
    @Option(hidden = true, name = "matherOccupation", showName = "母亲职业", type = PropertiesType.STRING)
    private String matherOccupation;

    //花名册用户来源，只有当studentId不为空的时候有效
    //0:跟谁学用户、1:非跟谁学用户
    @Option(hidden = true, name = "origin", showName = "学员来源渠道", type = PropertiesType.DIGITAL)
    private Integer origin;

    @Option(hidden = true, name = "latitude", showName = "纬度", type = PropertiesType.DIGITAL, sort = 0)
    private Double latitude;

    @Option(hidden = true, name = "longitude", showName = "经度", type = PropertiesType.DIGITAL, sort = 0)
    private Double longitude;

    @Option(hidden = true, name = "areaId", showName = "地域id", type = PropertiesType.DIGITAL, sort = 0)
    private Integer areaId;

    @Option(hidden = false, name = "qq", showName = "QQ", type = PropertiesType.STRING)
    private String qq;

    @Option(hidden = true, name = "weixin", showName = "微信", type = PropertiesType.STRING)
    private String weixin;

    @Option(hidden = false, name = "mail", showName = "邮箱", type = PropertiesType.STRING)
    private String mail;

    @Option(hidden = true, name = "province", showName = "省", type = PropertiesType.STRING, sort = 0)
    private String province;

    @Option(hidden = true, name = "city", showName = "市", type = PropertiesType.STRING, sort = 0)
    private String city;

    @Option(hidden = true, name = "county", showName = "区", type = PropertiesType.STRING, sort = 0)
    private String county;

    @Option(hidden = true, name = "studentRemark", showName = "备注", type = PropertiesType.STRING)
    private String studentRemark;

    @Option(hidden = true, name = "标签", showName = "标签", type = PropertiesType.STRING)
    private String studentTags;

    @Option(hidden = true, name = "tagsStr", showName = "标签", type = PropertiesType.STRING)
    private String tagsStr;

    @Option(hidden = true, name = "sourceStr", showName = "来源", type = PropertiesType.STRING)
    private String sourceStr;
    
    private Integer source;
    @Option(hidden = true, name = "addCascadeIdStr", showName = "课程顾问", type = PropertiesType.STRING)
    private String addCascadeIdStr;
    private Integer addCascadeId;
    
    
    public static StudentListResponseDto convertToDto(OrgStudent student, List<TxStudentTag> tagList) throws IllegalAccessException, InvocationTargetException {
        StudentListResponseDto dto = new StudentListResponseDto();
        BeanUtils.copyProperties(dto, student);
        dto.setStudentRemark(student.getRemark());
        if (student.getNextRemindTime() != null) {
            dto.setNextRemindTime(student.getNextRemindTime().getTime());
        }
        if (student.getBirthday() != null) {
            dto.setBirthday(student.getBirthday().getTime());
            dto.setBirthdayStr(student.getBirthday());
        }

        if (dto.getGender() == null || dto.getGender() == -1) {
            dto.setGenderStr("");
        } else {
            dto.setGenderStr(dto.getGender() == 1 ? "女" : "男");
        }
        StringBuilder tagStr = new StringBuilder("");
        if(tagList!=null) {
            for (int i = 0; i < tagList.size(); i++) {
                TxStudentTag txStudentTag = tagList.get(i);
                if (i < 5) {
                    tagStr.append(txStudentTag.getContent()).append(" ");
                }
            }
        }
        dto.setStudentTags(tagStr.toString());
        if(dto.getNextRemindTime() != null && dto.getNextRemindTime() >0){
            dto.setNextRemindTimeStr(new Date(dto.getNextRemindTime()));
        }
        dto.setId(student.getId());
        dto.setRelationshipStr(Relatives.getLabel(dto.getRelationship()));

        return dto;
    }
    

    public static void main(String args[]) {
        Field fields[] = StudentListResponseDto.class.getDeclaredFields();
        for (Field field : fields) {
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                System.out.println(option.name() + "---" + option.showName() + "---" + option.hidden() + "---" + option.lock() + "---" + option.type() + "---" + option.defaultProp());
            }
        }
    }
}

    