/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.student.dto.response;

import java.io.Serializable;

import com.baijia.tianxiao.dal.org.po.OrgCourse;
import lombok.Data;

import com.baijia.commons.lang.utils.PropertiesReader;

/**
 * @author shanyu
 * @version 1.0
 * @title StudentCourseInfoReponseDto
 * @desc 学生报名课程信息接口
 * @date 2015年12月4日
 */
@Data
public class StudentCourseInfoReponseDto implements Serializable {

    private static final long serialVersionUID = 7214823104479601699L;

    private Long courseId;

    private Long courseNumber;

    private String courseName;

    private String url;

    public void setCourseNumber(Long courseNumber) {
        this.courseNumber = courseNumber;
        this.url = PropertiesReader.getProperties("rest.properties").getProperty("org_class_course.url") + courseNumber;
    }

    // 课程类型
    private Integer courseType;
    
    // 天校课程类型
    private Integer txCourseType;

    // 总课次
    private Integer totalClassTimes = 0;

    // 完成课次
    private Integer finishClassTimes = 0;

    // 剩余课次
    private Integer leftClassTimes = 0;

    private int isDel;

    private int status;

    private long parentId;

    private int isClass;

    public static StudentCourseInfoReponseDto getInstance(OrgCourse course) {
        StudentCourseInfoReponseDto dto = new StudentCourseInfoReponseDto();
        dto.setCourseName(course.getName());
        dto.setCourseId(course.getId());
        dto.setCourseNumber(course.getNumber());
        dto.setIsDel(course.getIsDel());
        dto.setTxCourseType(course.getCourseType());
        dto.setIsClass(course.getIsClass());
        dto.setParentId(course.getParentId());
        return dto;
    }

}
