
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.dto.TagInfoDto;
import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.util.GenericsUtils;


import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

import lombok.Getter;
import lombok.Setter;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 *  little Boy
 *  Tell me, where do you dream?
 *  Rezar
 *  Jul 25, 2016
 */
@Component
public class TagsCustomFieldType extends AbstractCustomFieldType<List<TagInfoDto>> {

    /**
     * JSON template: {"tags":["12","23","34"]}
     */

    private String tagsKey = "tags";
    
    @Getter
    @Setter
    private String[] tags;

    @Override
    public String objToJson(List<TagInfoDto> obj) {
        if (GenericsUtils.isNullOrEmpty(obj)) {
            return "";
        }
        List<String> ids = GenericsUtils.toKeyList(obj, "content");
        return super.createJsonWithKeyValue(tagsKey, ids);
    }

    @Override
    public List<TagInfoDto> jsonToObj(String json) {
        JSONObject jsonObj = JSONObject.fromObject(json);
        JSONArray object = jsonObj.getJSONArray(tagsKey);
        String[] tmpArray = new String[object.size()];
        object.toArray(tmpArray);
        List<TagInfoDto> tagInfoDtos = new ArrayList<TagInfoDto>(tmpArray.length);
        for (String content : tmpArray) {
            TagInfoDto tid = new TagInfoDto();
            tid.setTagId(0L);
            tid.setContent(content);
            tagInfoDtos.add(tid);
        }
        return tagInfoDtos;
    }
    
    @Override
    public CustomFieldType matchFieldType() {
        return CustomFieldType.TAGS;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes.CustomFieldTypeInterface#instance()
     */
        
    @Override
    public CustomFieldTypeInterface<List<TagInfoDto>> instance() {
        return new TagsCustomFieldType();
    }

}
