
package com.baijia.tianxiao.sal.student.dto.customFields.fieldTypes;

import com.baijia.tianxiao.sal.student.enums.CustomFieldType;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Maps;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Map;

/**
 * little Boy Tell me, where do you dream? Rezar Jul 25, 2016
 */
@Component
public class CustomFieldTypeFactory implements ApplicationContextAware, InitializingBean {

    private ApplicationContext applicationContext;

    private final static Map<CustomFieldType, CustomFieldTypeInterface> customFieldSolver = Maps.newHashMap();

    @SuppressWarnings("unchecked")
    public static <T> CustomFieldTypeInterface<T> findCustomFieldSolver(CustomFieldType type) {
        CustomFieldTypeInterface customFieldTypeInterface = customFieldSolver.get(type);
        if (customFieldTypeInterface != null) {
            return customFieldTypeInterface.instance();
        }
        return null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Map<String, CustomFieldTypeInterface> beansOfType =
            this.applicationContext.getBeansOfType(CustomFieldTypeInterface.class);
        if (GenericsUtils.isNullOrEmpty(beansOfType)) {
            return;
        }
        Collection<CustomFieldTypeInterface> values = beansOfType.values();
        for (CustomFieldTypeInterface cfti : values) {
            customFieldSolver.put(cfti.matchFieldType(), cfti);
        }
    }
    
    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

}
